/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style.string;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringTransformationFixFactoryKt;
import org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringTransformationFixFactoryKt$WhenMappings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.StringKind;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"FIXES", "", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "Lorg/jetbrains/plugins/groovy/codeInspection/GroovyFix;", "createStringTransformationFix", "targetKind", "getCurrentKind", "quote", "", "getQuoteByKind", "kind", "getStringTransformationFix", "intellij.groovy.psi"})
public final class GrStringTransformationFixFactoryKt {
    private static final Map<StringKind, GroovyFix> FIXES;

    @NotNull
    public static final GroovyFix getStringTransformationFix(@NotNull StringKind targetKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetKind), (String)"targetKind");
        GroovyFix groovyFix = FIXES.get((Object)targetKind);
        Intrinsics.checkNotNull((Object)groovyFix);
        return groovyFix;
    }

    private static final StringKind getCurrentKind(String quote) {
        StringKind stringKind;
        switch (quote) {
            case "$/": {
                stringKind = StringKind.DOLLAR_SLASHY;
                break;
            }
            case "/": {
                stringKind = StringKind.SLASHY;
                break;
            }
            case "\"": {
                stringKind = StringKind.DOUBLE_QUOTED;
                break;
            }
            case "'''": {
                stringKind = StringKind.TRIPLE_SINGLE_QUOTED;
                break;
            }
            case "\"\"\"": {
                stringKind = StringKind.TRIPLE_DOUBLE_QUOTED;
                break;
            }
            case "'": {
                stringKind = StringKind.SINGLE_QUOTED;
                break;
            }
            default: {
                stringKind = null;
            }
        }
        return stringKind;
    }

    private static final String getQuoteByKind(StringKind kind) {
        String string;
        switch (GrStringTransformationFixFactoryKt$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                string = "'";
                break;
            }
            case 2: {
                string = "'''";
                break;
            }
            case 3: {
                string = "\"";
                break;
            }
            case 4: {
                string = "\"\"\"";
                break;
            }
            case 5: {
                string = "/";
                break;
            }
            case 6: {
                string = "$/";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final GroovyFix createStringTransformationFix(StringKind targetKind) {
        return new GroovyFix(targetKind){
            final /* synthetic */ StringKind $targetKind;

            @NotNull
            public String getFamilyName() {
                String string = GroovyBundle.message("intention.family.name.fix.quotation", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"in\u2026mily.name.fix.quotation\")");
                return string;
            }

            @NotNull
            public String getName() {
                String string;
                switch (GrStringTransformationFixFactoryKt$WhenMappings.$EnumSwitchMapping$1[this.$targetKind.ordinal()]) {
                    case 1: {
                        String string2 = GroovyBundle.message("intention.name.convert.to.single.quoted.string", new Object[0]);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GroovyBundle.message(\"in\u2026to.single.quoted.string\")");
                        break;
                    }
                    case 2: {
                        String string3 = GroovyBundle.message("intention.name.change.quotes.to.triple.single.quotes", new Object[0]);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GroovyBundle.message(\"in\u2026to.triple.single.quotes\")");
                        break;
                    }
                    case 3: {
                        String string4 = GroovyBundle.message("intention.name.convert.to.double.quoted.string", new Object[0]);
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"GroovyBundle.message(\"in\u2026to.double.quoted.string\")");
                        break;
                    }
                    case 4: {
                        String string5 = GroovyBundle.message("intention.name.change.quotes.to.triple.double.quotes", new Object[0]);
                        string = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"GroovyBundle.message(\"in\u2026to.triple.double.quotes\")");
                        break;
                    }
                    case 5: {
                        String string6 = GroovyBundle.message("intention.name.convert.to.slashy.string", new Object[0]);
                        string = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"GroovyBundle.message(\"in\u2026onvert.to.slashy.string\")");
                        break;
                    }
                    case 6: {
                        String string7 = GroovyBundle.message("intention.name.convert.to.dollar.slashy.string", new Object[0]);
                        string = string7;
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"GroovyBundle.message(\"in\u2026to.dollar.slashy.string\")");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }

            private final String escapeTextPart(StringKind innerKind, String text) {
                return this.$targetKind.escape(innerKind.unescape(text));
            }

            private final String getNewText(GrLiteral literal) {
                String string;
                String quote;
                String literalText = literal.getText();
                String string2 = quote = GrStringUtil.getStartQuote(literalText);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"quote");
                StringKind stringKind = GrStringTransformationFixFactoryKt.access$getCurrentKind(string2);
                if (stringKind == null) {
                    String string3 = literalText;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"literalText");
                    return string3;
                }
                StringKind kind = stringKind;
                if (literal instanceof GrString) {
                    Object[] objectArray = ((GrString)literal).getAllContentParts();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"literal.allContentParts");
                    string = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<GroovyPsiElement, CharSequence>(this, kind){
                        final /* synthetic */ createStringTransformationFix.1 this$0;
                        final /* synthetic */ StringKind $kind;

                        @NotNull
                        public final CharSequence invoke(GroovyPsiElement it) {
                            CharSequence charSequence;
                            if (it instanceof GrStringContent) {
                                String string = ((GrStringContent)it).getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                                charSequence = createStringTransformationFix.1.access$escapeTextPart(this.this$0, this.$kind, string);
                            } else {
                                GroovyPsiElement groovyPsiElement = it;
                                Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElement, (String)"it");
                                String string = groovyPsiElement.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                                charSequence = string;
                            }
                            return charSequence;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$kind = stringKind;
                            super(1);
                        }
                    }), (int)30, null);
                } else {
                    String string4 = GrStringUtil.removeQuotes(literalText);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"GrStringUtil.removeQuotes(literalText)");
                    string = this.escapeTextPart(kind, string4);
                }
                return string;
            }

            /*
             * WARNING - void declaration
             */
            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                void $this$parentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                PsiElement psiElement = descriptor.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"descriptor.psiElement");
                PsiElement psiElement2 = psiElement;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                GrLiteral grLiteral = (GrLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrLiteral.class, (boolean)false);
                if (grLiteral == null) {
                    return;
                }
                GrLiteral literal = grLiteral;
                String newText = this.getNewText(literal);
                String newQuote = GrStringTransformationFixFactoryKt.access$getQuoteByKind(this.$targetKind);
                String endQuote = Intrinsics.areEqual((Object)newQuote, (Object)"$/") ? "/$" : newQuote;
                GrExpression grExpression = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(newQuote + newText + endQuote);
                Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"GroovyPsiElementFactory.\u2026wQuote$newText$endQuote\")");
                GrExpression newExpression = grExpression;
                literal.replaceWithExpression(newExpression, true);
            }
            {
                this.$targetKind = $captured_local_variable$0;
            }

            public static final /* synthetic */ String access$escapeTextPart(createStringTransformationFix.1 $this, StringKind innerKind, String text) {
                return $this.escapeTextPart(innerKind, text);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        StringKind[] $this$map$iv = StringKind.values();
        boolean $i$f$map = false;
        StringKind[] stringKindArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var5_5 = $this$mapTo$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = var5_5[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)GrStringTransformationFixFactoryKt.createStringTransformationFix((StringKind)it));
            collection.add(pair);
        }
        FIXES = MapsKt.toMap((Iterable)((List)var3_3));
    }

    public static final /* synthetic */ StringKind access$getCurrentKind(String quote) {
        return GrStringTransformationFixFactoryKt.getCurrentKind(quote);
    }

    public static final /* synthetic */ String access$getQuoteByKind(StringKind kind) {
        return GrStringTransformationFixFactoryKt.getQuoteByKind(kind);
    }
}

