/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentsInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.FunctionalExpressionFlowUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"getLeastUpperBoundByAllWrites", "Lcom/intellij/psi/PsiType;", "block", "Lorg/jetbrains/plugins/groovy/lang/psi/GrControlFlowOwner;", "initialTypes", "", "Lorg/jetbrains/plugins/groovy/lang/psi/controlFlow/VariableDescriptor;", "Lorg/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAType;", "descriptor", "intellij.groovy.psi"})
public final class TypeDfaInstanceUtilKt {
    @NotNull
    public static final PsiType getLeastUpperBoundByAllWrites(@NotNull GrControlFlowOwner block, @NotNull Map<VariableDescriptor, DFAType> initialTypes, @NotNull VariableDescriptor descriptor) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(initialTypes, (String)"initialTypes");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Instruction[] instructionArray = block.getControlFlow();
        Intrinsics.checkNotNullExpressionValue((Object)instructionArray, (String)"block.controlFlow");
        Instruction[] flow = instructionArray;
        boolean bl = false;
        Set types = new LinkedHashSet();
        InferenceCache inferenceCache = TypeInferenceHelper.getInferenceCache(block);
        Intrinsics.checkNotNullExpressionValue((Object)inferenceCache, (String)"TypeInferenceHelper.getInferenceCache(block)");
        InferenceCache cache2 = inferenceCache;
        for (Instruction instruction : flow) {
            if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).isWrite() && Intrinsics.areEqual((Object)((ReadWriteVariableInstruction)instruction).getDescriptor(), (Object)descriptor)) {
                PsiType inferredType;
                if (cache2.getInferredType(((ReadWriteVariableInstruction)instruction).getDescriptor(), instruction, false, initialTypes) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)inferredType, (String)"cache.getInferredType(in\u2026initialTypes) ?: continue");
                types.add(inferredType);
                continue;
            }
            if (instruction instanceof ReadWriteVariableInstruction || instruction instanceof ArgumentsInstruction || !(instruction.getElement() instanceof GrFunctionalExpression)) continue;
            PsiElement psiElement = instruction.getElement();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression");
            }
            GrControlFlowOwner nestedFlowOwner = FunctionalExpressionFlowUtil.getControlFlowOwner((GrFunctionalExpression)psiElement);
            if (nestedFlowOwner == null) continue;
            Set<ResolvedVariableDescriptor> set = ControlFlowUtils.getOverwrittenForeignVariableDescriptors(nestedFlowOwner);
            Intrinsics.checkNotNullExpressionValue(set, (String)"ControlFlowUtils.getOver\u2026criptors(nestedFlowOwner)");
            if (!CollectionsKt.contains((Iterable)set, (Object)descriptor)) continue;
            types.add(TypeDfaInstanceUtilKt.getLeastUpperBoundByAllWrites(nestedFlowOwner, initialTypes, descriptor));
        }
        if (types.isEmpty()) {
            PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.NULL");
            psiType = (PsiType)psiPrimitiveType;
        } else {
            Collection $this$toTypedArray$iv = types;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[0]);
            if (psiTypeArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PsiType psiType2 = TypesUtil.getLeastUpperBound(psiTypeArray, block.getManager());
            psiType = psiType2;
            Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"TypesUtil.getLeastUpperB\u2026edArray(), block.manager)");
        }
        return psiType;
    }
}

