/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.DfaCacheConsistencyKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;

public class TypesSemilattice
implements Semilattice<TypeDfaState> {
    private final PsiManager myManager;
    private final Map<VariableDescriptor, Integer> varIndexes;
    private final TypeDfaState initialState;

    public TypesSemilattice(@NotNull PsiManager manager, @NotNull TypeDfaState initialState, Map<VariableDescriptor, Integer> varIndexes) {
        if (manager == null) {
            TypesSemilattice.$$$reportNull$$$0(0);
        }
        if (initialState == null) {
            TypesSemilattice.$$$reportNull$$$0(1);
        }
        this.myManager = manager;
        this.initialState = initialState;
        this.varIndexes = varIndexes;
    }

    @Override
    @NotNull
    public TypeDfaState initial() {
        return new TypeDfaState(this.initialState);
    }

    @Override
    @NotNull
    public TypeDfaState join(@NotNull List<? extends TypeDfaState> ins) {
        if (ins == null) {
            TypesSemilattice.$$$reportNull$$$0(2);
        }
        if (ins.isEmpty()) {
            TypeDfaState typeDfaState = this.initial();
            if (typeDfaState == null) {
                TypesSemilattice.$$$reportNull$$$0(3);
            }
            return typeDfaState;
        }
        TypeDfaState result2 = new TypeDfaState(ins.get(0));
        if (ins.size() == 1) {
            TypeDfaState typeDfaState = result2;
            if (typeDfaState == null) {
                TypesSemilattice.$$$reportNull$$$0(4);
            }
            return typeDfaState;
        }
        for (int i = 1; i < ins.size(); ++i) {
            result2.joinState(ins.get(i), this.myManager, this.varIndexes);
        }
        TypeDfaState typeDfaState = result2;
        if (typeDfaState == null) {
            TypesSemilattice.$$$reportNull$$$0(5);
        }
        return typeDfaState;
    }

    @Override
    public boolean eq(@NotNull TypeDfaState e1, @NotNull TypeDfaState e2) {
        if (e1 == null) {
            TypesSemilattice.$$$reportNull$$$0(6);
        }
        if (e2 == null) {
            TypesSemilattice.$$$reportNull$$$0(7);
        }
        return e1.contentsEqual(e2);
    }

    public static Map<VariableDescriptor, DFAType> mergeForCaching(Map<VariableDescriptor, DFAType> cached, TypeDfaState another, Map<VariableDescriptor, Integer> varIndexes) {
        if (another.getVarTypes().isEmpty()) {
            return cached;
        }
        Map<VariableDescriptor, DFAType> mapToPublish = TypesSemilattice.getMapToPublish(another, varIndexes);
        TypesSemilattice.checkDfaStatesConsistency(cached, mapToPublish);
        HashMap<VariableDescriptor, DFAType> newState = new HashMap<VariableDescriptor, DFAType>(cached);
        newState.putAll(mapToPublish);
        return newState;
    }

    private static Map<VariableDescriptor, DFAType> getMapToPublish(TypeDfaState another, Map<VariableDescriptor, Integer> varIndexes) {
        return ContainerUtil.filter(another.getVarTypes(), descriptor -> !another.getProhibitedCachingVars().get(varIndexes.getOrDefault(descriptor, 0)));
    }

    private static void checkDfaStatesConsistency(@NotNull Map<VariableDescriptor, DFAType> cached, @NotNull Map<VariableDescriptor, DFAType> incoming) {
        if (cached == null) {
            TypesSemilattice.$$$reportNull$$$0(8);
        }
        if (incoming == null) {
            TypesSemilattice.$$$reportNull$$$0(9);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() || ApplicationManagerEx.isInStressTest() || DfaCacheConsistencyKt.mustSkipConsistencyCheck()) {
            return;
        }
        Collection commonDescriptors = ContainerUtil.intersection(cached.keySet(), incoming.keySet());
        Map differingEntries = ContainerUtil.filter((Map)ContainerUtil.diff(cached, incoming), commonDescriptors::contains);
        if (!differingEntries.isEmpty()) {
            throw new IllegalStateException("Attempt to cache different types: " + differingEntries);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ins";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypesSemilattice";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cached";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incoming";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypesSemilattice";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "eq";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkDfaStatesConsistency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

