/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.runner.GroovyRunnerUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfigurationType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/runner/ScriptRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lorg/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration;", "()V", "checkAndExtractData", "Lorg/jetbrains/plugins/groovy/runner/ScriptRunConfigurationProducer$Data;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "isConfigurationFromContext", "", "configuration", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "setupFromClass", "", "aClass", "Lcom/intellij/psi/PsiClass;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Data", "intellij.groovy"})
public final class ScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<GroovyScriptRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        GroovyScriptRunConfigurationType groovyScriptRunConfigurationType = GroovyScriptRunConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)groovyScriptRunConfigurationType, (String)"GroovyScriptRunConfigurationType.getInstance()");
        ConfigurationFactory configurationFactory = groovyScriptRunConfigurationType.getConfigurationFactory();
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"GroovyScriptRunConfigura\u2026ce().configurationFactory");
        return configurationFactory;
    }

    private final Data checkAndExtractData(ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"context.location ?: return null");
        Location location2 = location;
        PsiElement psiElement = location2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"location.psiElement");
        PsiElement element = psiElement;
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof GroovyFile)) {
            psiFile = null;
        }
        GroovyFile groovyFile = (GroovyFile)psiFile;
        if (groovyFile == null) {
            return null;
        }
        GroovyFile file = groovyFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        GroovyRunnableScriptType groovyRunnableScriptType = GroovyScriptUtil.getScriptType(file);
        Intrinsics.checkNotNullExpressionValue((Object)groovyRunnableScriptType, (String)"GroovyScriptUtil.getScriptType(file)");
        GroovyRunnableScriptType scriptType = groovyRunnableScriptType;
        if (scriptType.getRunner() == null) {
            return null;
        }
        Project project = location2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"location.project");
        if (GroovyConsoleStateService.Companion.getInstance(project).isProjectConsole(virtualFile2)) {
            return null;
        }
        PsiClass psiClass = GroovyRunnerPsiUtil.getRunningClass(element);
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"GroovyRunnerPsiUtil.getR\u2026s(element) ?: return null");
        PsiClass clazz = psiClass;
        if (!(clazz instanceof GroovyScriptClass) && !GroovyRunnerPsiUtil.isRunnable(clazz)) {
            return null;
        }
        return new Data((Location<PsiElement>)location2, element, clazz, file, virtualFile2, scriptType);
    }

    protected boolean setupConfigurationFromContext(@NotNull GroovyScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Data data = this.checkAndExtractData(context);
        if (data == null) {
            return false;
        }
        Data data2 = data;
        sourceElement.set((Object)data2.getElement());
        this.setupFromClass(configuration, data2.getClazz(), data2.getVirtualFile());
        data2.getScriptType().tuneConfiguration(data2.getFile(), configuration, data2.getLocation());
        return true;
    }

    private final void setupFromClass(GroovyScriptRunConfiguration $this$setupFromClass, PsiClass aClass, VirtualFile virtualFile) {
        VirtualFile virtualFile2 = virtualFile.getParent();
        $this$setupFromClass.setWorkingDirectory(virtualFile2 != null ? virtualFile2.getPath() : null);
        $this$setupFromClass.setScriptPath(ScriptFileUtil.getScriptFilePath((VirtualFile)virtualFile));
        String string = StringKt.nullize$default((String)GroovyRunnerUtil.getConfigurationName(aClass, $this$setupFromClass.getConfigurationModule()), (boolean)false, (int)1, null);
        if (string == null) {
            String string2 = virtualFile.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"virtualFile.name");
        }
        $this$setupFromClass.setName(string);
        $this$setupFromClass.setModule(JavaExecutionUtil.findModule((PsiClass)aClass));
    }

    public boolean isConfigurationFromContext(@NotNull GroovyScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Data data = this.checkAndExtractData(context);
        if (data == null) {
            return false;
        }
        Data data2 = data;
        return Intrinsics.areEqual((Object)configuration.getScriptPath(), (Object)ScriptFileUtil.getScriptFilePath((VirtualFile)data2.getVirtualFile())) && data2.getScriptType().isConfigurationByLocation(configuration, data2.getLocation());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/runner/ScriptRunConfigurationProducer$Data;", "", "location", "Lcom/intellij/execution/Location;", "Lcom/intellij/psi/PsiElement;", "element", "clazz", "Lcom/intellij/psi/PsiClass;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptType", "Lorg/jetbrains/plugins/groovy/extensions/GroovyRunnableScriptType;", "(Lcom/intellij/execution/Location;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiClass;Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/plugins/groovy/extensions/GroovyRunnableScriptType;)V", "getClazz", "()Lcom/intellij/psi/PsiClass;", "getElement", "()Lcom/intellij/psi/PsiElement;", "getFile", "()Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "getLocation", "()Lcom/intellij/execution/Location;", "getScriptType", "()Lorg/jetbrains/plugins/groovy/extensions/GroovyRunnableScriptType;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.groovy"})
    private static final class Data {
        @NotNull
        private final Location<PsiElement> location;
        @NotNull
        private final PsiElement element;
        @NotNull
        private final PsiClass clazz;
        @NotNull
        private final GroovyFile file;
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final GroovyRunnableScriptType scriptType;

        @NotNull
        public final Location<PsiElement> getLocation() {
            return this.location;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @NotNull
        public final PsiClass getClazz() {
            return this.clazz;
        }

        @NotNull
        public final GroovyFile getFile() {
            return this.file;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final GroovyRunnableScriptType getScriptType() {
            return this.scriptType;
        }

        public Data(@NotNull Location<PsiElement> location, @NotNull PsiElement element, @NotNull PsiClass clazz, @NotNull GroovyFile file, @NotNull VirtualFile virtualFile, @NotNull GroovyRunnableScriptType scriptType) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)scriptType, (String)"scriptType");
            this.location = location;
            this.element = element;
            this.clazz = clazz;
            this.file = file;
            this.virtualFile = virtualFile;
            this.scriptType = scriptType;
        }
    }
}

