/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ArrayReferenceImpl;
import com.jetbrains.jdi.ArrayTypeImpl;
import com.jetbrains.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.jdi.ClassObjectReferenceImpl;
import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.InterfaceTypeImpl;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.ModuleReferenceImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.StringReferenceImpl;
import com.jetbrains.jdi.ThreadGroupReferenceImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.Location;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class JDWP {
    JDWP() {
    }

    static class InvokeOptions {
        static final int INVOKE_SINGLE_THREADED = 1;
        static final int INVOKE_NONVIRTUAL = 2;

        InvokeOptions() {
        }
    }

    static class SuspendPolicy {
        static final int NONE = 0;
        static final int EVENT_THREAD = 1;
        static final int ALL = 2;

        SuspendPolicy() {
        }
    }

    static class StepSize {
        static final int MIN = 0;
        static final int LINE = 1;

        StepSize() {
        }
    }

    static class StepDepth {
        static final int INTO = 0;
        static final int OVER = 1;
        static final int OUT = 2;

        StepDepth() {
        }
    }

    static class Tag {
        static final int ARRAY = 91;
        static final int BYTE = 66;
        static final int CHAR = 67;
        static final int OBJECT = 76;
        static final int FLOAT = 70;
        static final int DOUBLE = 68;
        static final int INT = 73;
        static final int LONG = 74;
        static final int SHORT = 83;
        static final int VOID = 86;
        static final int BOOLEAN = 90;
        static final int STRING = 115;
        static final int THREAD = 116;
        static final int THREAD_GROUP = 103;
        static final int CLASS_LOADER = 108;
        static final int CLASS_OBJECT = 99;

        Tag() {
        }
    }

    static class TypeTag {
        static final int CLASS = 1;
        static final int INTERFACE = 2;
        static final int ARRAY = 3;

        TypeTag() {
        }
    }

    static class ClassStatus {
        static final int VERIFIED = 1;
        static final int PREPARED = 2;
        static final int INITIALIZED = 4;
        static final int ERROR = 8;

        ClassStatus() {
        }
    }

    static class SuspendStatus {
        static final int SUSPEND_STATUS_SUSPENDED = 1;

        SuspendStatus() {
        }
    }

    static class ThreadStatus {
        static final int ZOMBIE = 0;
        static final int RUNNING = 1;
        static final int SLEEPING = 2;
        static final int MONITOR = 3;
        static final int WAIT = 4;

        ThreadStatus() {
        }
    }

    static class EventKind {
        static final int SINGLE_STEP = 1;
        static final int BREAKPOINT = 2;
        static final int FRAME_POP = 3;
        static final int EXCEPTION = 4;
        static final int USER_DEFINED = 5;
        static final int THREAD_START = 6;
        static final int THREAD_DEATH = 7;
        static final int THREAD_END = 7;
        static final int CLASS_PREPARE = 8;
        static final int CLASS_UNLOAD = 9;
        static final int CLASS_LOAD = 10;
        static final int FIELD_ACCESS = 20;
        static final int FIELD_MODIFICATION = 21;
        static final int EXCEPTION_CATCH = 30;
        static final int METHOD_ENTRY = 40;
        static final int METHOD_EXIT = 41;
        static final int METHOD_EXIT_WITH_RETURN_VALUE = 42;
        static final int MONITOR_CONTENDED_ENTER = 43;
        static final int MONITOR_CONTENDED_ENTERED = 44;
        static final int MONITOR_WAIT = 45;
        static final int MONITOR_WAITED = 46;
        static final int VM_START = 90;
        static final int VM_INIT = 90;
        static final int VM_DEATH = 99;
        static final int VM_DISCONNECTED = 100;

        EventKind() {
        }
    }

    static class Error {
        static final int NONE = 0;
        static final int INVALID_THREAD = 10;
        static final int INVALID_THREAD_GROUP = 11;
        static final int INVALID_PRIORITY = 12;
        static final int THREAD_NOT_SUSPENDED = 13;
        static final int THREAD_SUSPENDED = 14;
        static final int THREAD_NOT_ALIVE = 15;
        static final int INVALID_OBJECT = 20;
        static final int INVALID_CLASS = 21;
        static final int CLASS_NOT_PREPARED = 22;
        static final int INVALID_METHODID = 23;
        static final int INVALID_LOCATION = 24;
        static final int INVALID_FIELDID = 25;
        static final int INVALID_FRAMEID = 30;
        static final int NO_MORE_FRAMES = 31;
        static final int OPAQUE_FRAME = 32;
        static final int NOT_CURRENT_FRAME = 33;
        static final int TYPE_MISMATCH = 34;
        static final int INVALID_SLOT = 35;
        static final int DUPLICATE = 40;
        static final int NOT_FOUND = 41;
        static final int INVALID_MODULE = 42;
        static final int INVALID_MONITOR = 50;
        static final int NOT_MONITOR_OWNER = 51;
        static final int INTERRUPT = 52;
        static final int INVALID_CLASS_FORMAT = 60;
        static final int CIRCULAR_CLASS_DEFINITION = 61;
        static final int FAILS_VERIFICATION = 62;
        static final int ADD_METHOD_NOT_IMPLEMENTED = 63;
        static final int SCHEMA_CHANGE_NOT_IMPLEMENTED = 64;
        static final int INVALID_TYPESTATE = 65;
        static final int HIERARCHY_CHANGE_NOT_IMPLEMENTED = 66;
        static final int DELETE_METHOD_NOT_IMPLEMENTED = 67;
        static final int UNSUPPORTED_VERSION = 68;
        static final int NAMES_DONT_MATCH = 69;
        static final int CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 70;
        static final int METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 71;
        static final int CLASS_ATTRIBUTE_CHANGE_NOT_IMPLEMENTED = 72;
        static final int NOT_IMPLEMENTED = 99;
        static final int NULL_POINTER = 100;
        static final int ABSENT_INFORMATION = 101;
        static final int INVALID_EVENT_TYPE = 102;
        static final int ILLEGAL_ARGUMENT = 103;
        static final int OUT_OF_MEMORY = 110;
        static final int ACCESS_DENIED = 111;
        static final int VM_DEAD = 112;
        static final int INTERNAL = 113;
        static final int UNATTACHED_THREAD = 115;
        static final int INVALID_TAG = 500;
        static final int ALREADY_INVOKING = 502;
        static final int INVALID_INDEX = 503;
        static final int INVALID_LENGTH = 504;
        static final int INVALID_STRING = 506;
        static final int INVALID_CLASS_LOADER = 507;
        static final int INVALID_ARRAY = 508;
        static final int TRANSPORT_LOAD = 509;
        static final int TRANSPORT_INIT = 510;
        static final int NATIVE_METHOD = 511;
        static final int INVALID_COUNT = 512;

        Error() {
        }
    }

    static class Event {
        static final int COMMAND_SET = 64;

        private Event() {
        }

        static class Composite {
            static final int COMMAND = 100;
            final byte suspendPolicy;
            final Events[] events;

            Composite(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.Event.Composite" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.suspendPolicy = ps.readByte();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "suspendPolicy(byte): " + this.suspendPolicy);
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "events(Events[]): ");
                }
                int eventsCount = ps.readInt();
                this.events = new Events[eventsCount];
                for (int i = 0; i < eventsCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "events[i](Events): ");
                    }
                    this.events[i] = new Events(vm, ps);
                }
            }

            static class Events {
                final byte eventKind;
                EventsCommon aEventsCommon;

                Events(VirtualMachineImpl vm, PacketStream ps) {
                    this.eventKind = ps.readByte();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "eventKind(byte): " + this.eventKind);
                    }
                    switch (this.eventKind) {
                        case 90: {
                            this.aEventsCommon = new VMStart(vm, ps);
                            break;
                        }
                        case 1: {
                            this.aEventsCommon = new SingleStep(vm, ps);
                            break;
                        }
                        case 2: {
                            this.aEventsCommon = new Breakpoint(vm, ps);
                            break;
                        }
                        case 40: {
                            this.aEventsCommon = new MethodEntry(vm, ps);
                            break;
                        }
                        case 41: {
                            this.aEventsCommon = new MethodExit(vm, ps);
                            break;
                        }
                        case 42: {
                            this.aEventsCommon = new MethodExitWithReturnValue(vm, ps);
                            break;
                        }
                        case 43: {
                            this.aEventsCommon = new MonitorContendedEnter(vm, ps);
                            break;
                        }
                        case 44: {
                            this.aEventsCommon = new MonitorContendedEntered(vm, ps);
                            break;
                        }
                        case 45: {
                            this.aEventsCommon = new MonitorWait(vm, ps);
                            break;
                        }
                        case 46: {
                            this.aEventsCommon = new MonitorWaited(vm, ps);
                            break;
                        }
                        case 4: {
                            this.aEventsCommon = new Exception(vm, ps);
                            break;
                        }
                        case 6: {
                            this.aEventsCommon = new ThreadStart(vm, ps);
                            break;
                        }
                        case 7: {
                            this.aEventsCommon = new ThreadDeath(vm, ps);
                            break;
                        }
                        case 8: {
                            this.aEventsCommon = new ClassPrepare(vm, ps);
                            break;
                        }
                        case 9: {
                            this.aEventsCommon = new ClassUnload(vm, ps);
                            break;
                        }
                        case 20: {
                            this.aEventsCommon = new FieldAccess(vm, ps);
                            break;
                        }
                        case 21: {
                            this.aEventsCommon = new FieldModification(vm, ps);
                            break;
                        }
                        case 99: {
                            this.aEventsCommon = new VMDeath(vm, ps);
                        }
                    }
                }

                static class VMDeath
                extends EventsCommon {
                    static final byte ALT_ID = 99;
                    final int requestID;

                    @Override
                    byte eventKind() {
                        return 99;
                    }

                    VMDeath(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                    }
                }

                static class FieldModification
                extends EventsCommon {
                    static final byte ALT_ID = 21;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final byte refTypeTag;
                    final long typeID;
                    final long fieldID;
                    final ObjectReferenceImpl object;
                    final ValueImpl valueToBe;

                    @Override
                    byte eventKind() {
                        return 21;
                    }

                    FieldModification(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.refTypeTag = ps.readByte();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = ps.readClassRef();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.fieldID = ps.readFieldRef();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "fieldID(long): " + this.fieldID);
                        }
                        this.object = ps.readTaggedObjectReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (String)(this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                        this.valueToBe = ps.readValue();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "valueToBe(ValueImpl): " + this.valueToBe);
                        }
                    }
                }

                static class FieldAccess
                extends EventsCommon {
                    static final byte ALT_ID = 20;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final byte refTypeTag;
                    final long typeID;
                    final long fieldID;
                    final ObjectReferenceImpl object;

                    @Override
                    byte eventKind() {
                        return 20;
                    }

                    FieldAccess(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.refTypeTag = ps.readByte();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = ps.readClassRef();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.fieldID = ps.readFieldRef();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "fieldID(long): " + this.fieldID);
                        }
                        this.object = ps.readTaggedObjectReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (String)(this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                    }
                }

                static class ClassUnload
                extends EventsCommon {
                    static final byte ALT_ID = 9;
                    final int requestID;
                    final String signature;

                    @Override
                    byte eventKind() {
                        return 9;
                    }

                    ClassUnload(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.signature = ps.readString();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "signature(String): " + this.signature);
                        }
                    }
                }

                static class ClassPrepare
                extends EventsCommon {
                    static final byte ALT_ID = 8;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final byte refTypeTag;
                    final long typeID;
                    final String signature;
                    final int status;

                    @Override
                    byte eventKind() {
                        return 8;
                    }

                    ClassPrepare(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.refTypeTag = ps.readByte();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = ps.readClassRef();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.signature = ps.readString();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "signature(String): " + this.signature);
                        }
                        this.status = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "status(int): " + this.status);
                        }
                    }
                }

                static class ThreadDeath
                extends EventsCommon {
                    static final byte ALT_ID = 7;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    @Override
                    byte eventKind() {
                        return 7;
                    }

                    ThreadDeath(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }
                }

                static class ThreadStart
                extends EventsCommon {
                    static final byte ALT_ID = 6;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    @Override
                    byte eventKind() {
                        return 6;
                    }

                    ThreadStart(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }
                }

                static class Exception
                extends EventsCommon {
                    static final byte ALT_ID = 4;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final ObjectReferenceImpl exception;
                    final Location catchLocation;

                    @Override
                    byte eventKind() {
                        return 4;
                    }

                    Exception(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.exception = ps.readTaggedObjectReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "exception(ObjectReferenceImpl): " + (String)(this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                        }
                        this.catchLocation = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "catchLocation(Location): " + this.catchLocation);
                        }
                    }
                }

                static class MonitorWaited
                extends EventsCommon {
                    static final byte ALT_ID = 46;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final ObjectReferenceImpl object;
                    final Location location;
                    final boolean timed_out;

                    @Override
                    byte eventKind() {
                        return 46;
                    }

                    MonitorWaited(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.object = ps.readTaggedObjectReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (String)(this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.timed_out = ps.readBoolean();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "timed_out(boolean): " + this.timed_out);
                        }
                    }
                }

                static class MonitorWait
                extends EventsCommon {
                    static final byte ALT_ID = 45;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final ObjectReferenceImpl object;
                    final Location location;
                    final long timeout;

                    @Override
                    byte eventKind() {
                        return 45;
                    }

                    MonitorWait(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.object = ps.readTaggedObjectReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (String)(this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.timeout = ps.readLong();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "timeout(long): " + this.timeout);
                        }
                    }
                }

                static class MonitorContendedEntered
                extends EventsCommon {
                    static final byte ALT_ID = 44;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final ObjectReferenceImpl object;
                    final Location location;

                    @Override
                    byte eventKind() {
                        return 44;
                    }

                    MonitorContendedEntered(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.object = ps.readTaggedObjectReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (String)(this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class MonitorContendedEnter
                extends EventsCommon {
                    static final byte ALT_ID = 43;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final ObjectReferenceImpl object;
                    final Location location;

                    @Override
                    byte eventKind() {
                        return 43;
                    }

                    MonitorContendedEnter(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.object = ps.readTaggedObjectReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (String)(this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class MethodExitWithReturnValue
                extends EventsCommon {
                    static final byte ALT_ID = 42;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final ValueImpl value;

                    @Override
                    byte eventKind() {
                        return 42;
                    }

                    MethodExitWithReturnValue(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.value = ps.readValue();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "value(ValueImpl): " + this.value);
                        }
                    }
                }

                static class MethodExit
                extends EventsCommon {
                    static final byte ALT_ID = 41;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    @Override
                    byte eventKind() {
                        return 41;
                    }

                    MethodExit(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class MethodEntry
                extends EventsCommon {
                    static final byte ALT_ID = 40;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    @Override
                    byte eventKind() {
                        return 40;
                    }

                    MethodEntry(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class Breakpoint
                extends EventsCommon {
                    static final byte ALT_ID = 2;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    @Override
                    byte eventKind() {
                        return 2;
                    }

                    Breakpoint(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class SingleStep
                extends EventsCommon {
                    static final byte ALT_ID = 1;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    @Override
                    byte eventKind() {
                        return 1;
                    }

                    SingleStep(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = ps.readLocation();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class VMStart
                extends EventsCommon {
                    static final byte ALT_ID = 90;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    @Override
                    byte eventKind() {
                        return 90;
                    }

                    VMStart(VirtualMachineImpl vm, PacketStream ps) {
                        this.requestID = ps.readInt();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = ps.readThreadReference();
                        if (vm.traceReceives) {
                            vm.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }
                }

                static abstract class EventsCommon {
                    EventsCommon() {
                    }

                    abstract byte eventKind();
                }
            }
        }
    }

    static class ModuleReference {
        static final int COMMAND_SET = 18;

        private ModuleReference() {
        }

        static class ClassLoader {
            static final int COMMAND = 2;
            final ClassLoaderReferenceImpl classLoader;

            static ClassLoader process(VirtualMachineImpl vm, ModuleReferenceImpl module) throws JDWPException {
                PacketStream ps = ClassLoader.enqueueCommand(vm, module);
                return ClassLoader.waitForReply(vm, ps);
            }

            static CompletableFuture<ClassLoader> processAsync(VirtualMachineImpl vm, ModuleReferenceImpl module) {
                PacketStream ps = ClassLoader.enqueueCommand(vm, module);
                return ps.readReply(p -> new ClassLoader(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ModuleReferenceImpl module) {
                PacketStream ps = new PacketStream(vm, 18, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ModuleReference.ClassLoader" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 module(ModuleReferenceImpl): " + (String)(module == null ? "NULL" : "ref=" + module.ref()));
                }
                ps.writeModuleRef(module.ref());
                ps.send();
                return ps;
            }

            static ClassLoader waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ClassLoader(vm, ps);
            }

            private ClassLoader(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ModuleReference.ClassLoader" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.classLoader = ps.readClassLoaderReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classLoader(ClassLoaderReferenceImpl): " + (String)(this.classLoader == null ? "NULL" : "ref=" + this.classLoader.ref()));
                }
            }
        }

        static class Name {
            static final int COMMAND = 1;
            final String name;

            static Name process(VirtualMachineImpl vm, ModuleReferenceImpl module) throws JDWPException {
                PacketStream ps = Name.enqueueCommand(vm, module);
                return Name.waitForReply(vm, ps);
            }

            static CompletableFuture<Name> processAsync(VirtualMachineImpl vm, ModuleReferenceImpl module) {
                PacketStream ps = Name.enqueueCommand(vm, module);
                return ps.readReply(p -> new Name(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ModuleReferenceImpl module) {
                PacketStream ps = new PacketStream(vm, 18, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ModuleReference.Name" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 module(ModuleReferenceImpl): " + (String)(module == null ? "NULL" : "ref=" + module.ref()));
                }
                ps.writeModuleRef(module.ref());
                ps.send();
                return ps;
            }

            static Name waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Name(vm, ps);
            }

            private Name(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ModuleReference.Name" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.name = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "name(String): " + this.name);
                }
            }
        }
    }

    static class ClassObjectReference {
        static final int COMMAND_SET = 17;

        private ClassObjectReference() {
        }

        static class ReflectedType {
            static final int COMMAND = 1;
            final byte refTypeTag;
            final long typeID;

            static ReflectedType process(VirtualMachineImpl vm, ClassObjectReferenceImpl classObject) throws JDWPException {
                PacketStream ps = ReflectedType.enqueueCommand(vm, classObject);
                return ReflectedType.waitForReply(vm, ps);
            }

            static CompletableFuture<ReflectedType> processAsync(VirtualMachineImpl vm, ClassObjectReferenceImpl classObject) {
                PacketStream ps = ReflectedType.enqueueCommand(vm, classObject);
                return ps.readReply(p -> new ReflectedType(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ClassObjectReferenceImpl classObject) {
                PacketStream ps = new PacketStream(vm, 17, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ClassObjectReference.ReflectedType" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 classObject(ClassObjectReferenceImpl): " + (String)(classObject == null ? "NULL" : "ref=" + classObject.ref()));
                }
                ps.writeObjectRef(classObject.ref());
                ps.send();
                return ps;
            }

            static ReflectedType waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ReflectedType(vm, ps);
            }

            private ReflectedType(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ClassObjectReference.ReflectedType" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.refTypeTag = ps.readByte();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "refTypeTag(byte): " + this.refTypeTag);
                }
                this.typeID = ps.readClassRef();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "typeID(long): ref=" + this.typeID);
                }
            }
        }
    }

    static class StackFrame {
        static final int COMMAND_SET = 16;

        private StackFrame() {
        }

        static class PopFrames {
            static final int COMMAND = 4;

            static PopFrames process(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame) throws JDWPException {
                PacketStream ps = PopFrames.enqueueCommand(vm, thread, frame);
                return PopFrames.waitForReply(vm, ps);
            }

            static CompletableFuture<PopFrames> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame) {
                PacketStream ps = PopFrames.enqueueCommand(vm, thread, frame);
                return ps.readReply(p -> new PopFrames(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame) {
                PacketStream ps = new PacketStream(vm, 16, 4);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.StackFrame.PopFrames" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 frame(long): " + frame);
                }
                ps.writeFrameRef(frame);
                ps.send();
                return ps;
            }

            static PopFrames waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new PopFrames(vm, ps);
            }

            private PopFrames(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.StackFrame.PopFrames" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class ThisObject {
            static final int COMMAND = 3;
            final ObjectReferenceImpl objectThis;

            static ThisObject process(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame) throws JDWPException {
                PacketStream ps = ThisObject.enqueueCommand(vm, thread, frame);
                return ThisObject.waitForReply(vm, ps);
            }

            static CompletableFuture<ThisObject> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame) {
                PacketStream ps = ThisObject.enqueueCommand(vm, thread, frame);
                return ps.readReply(p -> new ThisObject(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame) {
                PacketStream ps = new PacketStream(vm, 16, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.StackFrame.ThisObject" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 frame(long): " + frame);
                }
                ps.writeFrameRef(frame);
                ps.send();
                return ps;
            }

            static ThisObject waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ThisObject(vm, ps);
            }

            private ThisObject(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.StackFrame.ThisObject" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.objectThis = ps.readTaggedObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "objectThis(ObjectReferenceImpl): " + (String)(this.objectThis == null ? "NULL" : "ref=" + this.objectThis.ref()));
                }
            }
        }

        static class SetValues {
            static final int COMMAND = 2;

            static SetValues process(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame, SlotInfo[] slotValues) throws JDWPException {
                PacketStream ps = SetValues.enqueueCommand(vm, thread, frame, slotValues);
                return SetValues.waitForReply(vm, ps);
            }

            static CompletableFuture<SetValues> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame, SlotInfo[] slotValues) {
                PacketStream ps = SetValues.enqueueCommand(vm, thread, frame, slotValues);
                return ps.readReply(p -> new SetValues(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame, SlotInfo[] slotValues) {
                PacketStream ps = new PacketStream(vm, 16, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.StackFrame.SetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 frame(long): " + frame);
                }
                ps.writeFrameRef(frame);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 slotValues(SlotInfo[]): ");
                }
                ps.writeInt(slotValues.length);
                for (int i = 0; i < slotValues.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     slotValues[i](SlotInfo): ");
                    }
                    slotValues[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static SetValues waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SetValues(vm, ps);
            }

            private SetValues(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.StackFrame.SetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }

            static class SlotInfo {
                final int slot;
                final ValueImpl slotValue;

                SlotInfo(int slot, ValueImpl slotValue) {
                    this.slot = slot;
                    this.slotValue = slotValue;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     slot(int): " + this.slot);
                    }
                    ps.writeInt(this.slot);
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     slotValue(ValueImpl): " + this.slotValue);
                    }
                    ps.writeValue(this.slotValue);
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 1;
            final ValueImpl[] values;

            static GetValues process(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame, SlotInfo[] slots) throws JDWPException {
                PacketStream ps = GetValues.enqueueCommand(vm, thread, frame, slots);
                return GetValues.waitForReply(vm, ps);
            }

            static CompletableFuture<GetValues> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame, SlotInfo[] slots) {
                PacketStream ps = GetValues.enqueueCommand(vm, thread, frame, slots);
                return ps.readReply(p -> new GetValues(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread, long frame, SlotInfo[] slots) {
                PacketStream ps = new PacketStream(vm, 16, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.StackFrame.GetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 frame(long): " + frame);
                }
                ps.writeFrameRef(frame);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 slots(SlotInfo[]): ");
                }
                ps.writeInt(slots.length);
                for (int i = 0; i < slots.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     slots[i](SlotInfo): ");
                    }
                    slots[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static GetValues waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new GetValues(vm, ps);
            }

            private GetValues(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.StackFrame.GetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int valuesCount = ps.readInt();
                this.values = new ValueImpl[valuesCount];
                for (int i = 0; i < valuesCount; ++i) {
                    this.values[i] = ps.readValue();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "values[i](ValueImpl): " + this.values[i]);
                }
            }

            static class SlotInfo {
                final int slot;
                final byte sigbyte;

                SlotInfo(int slot, byte sigbyte) {
                    this.slot = slot;
                    this.sigbyte = sigbyte;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     slot(int): " + this.slot);
                    }
                    ps.writeInt(this.slot);
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     sigbyte(byte): " + this.sigbyte);
                    }
                    ps.writeByte(this.sigbyte);
                }
            }
        }
    }

    static class EventRequest {
        static final int COMMAND_SET = 15;

        private EventRequest() {
        }

        static class ClearAllBreakpoints {
            static final int COMMAND = 3;

            static ClearAllBreakpoints process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = ClearAllBreakpoints.enqueueCommand(vm);
                return ClearAllBreakpoints.waitForReply(vm, ps);
            }

            static CompletableFuture<ClearAllBreakpoints> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = ClearAllBreakpoints.enqueueCommand(vm);
                return ps.readReply(p -> new ClearAllBreakpoints(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 15, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.EventRequest.ClearAllBreakpoints" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static ClearAllBreakpoints waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ClearAllBreakpoints(vm, ps);
            }

            private ClearAllBreakpoints(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.EventRequest.ClearAllBreakpoints" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class Clear {
            static final int COMMAND = 2;

            static Clear process(VirtualMachineImpl vm, byte eventKind, int requestID) throws JDWPException {
                PacketStream ps = Clear.enqueueCommand(vm, eventKind, requestID);
                return Clear.waitForReply(vm, ps);
            }

            static CompletableFuture<Clear> processAsync(VirtualMachineImpl vm, byte eventKind, int requestID) {
                PacketStream ps = Clear.enqueueCommand(vm, eventKind, requestID);
                return ps.readReply(p -> new Clear(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, byte eventKind, int requestID) {
                PacketStream ps = new PacketStream(vm, 15, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.EventRequest.Clear" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 eventKind(byte): " + eventKind);
                }
                ps.writeByte(eventKind);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 requestID(int): " + requestID);
                }
                ps.writeInt(requestID);
                ps.send();
                return ps;
            }

            static Clear waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Clear(vm, ps);
            }

            private Clear(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.EventRequest.Clear" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class Set {
            static final int COMMAND = 1;
            final int requestID;

            static Set process(VirtualMachineImpl vm, byte eventKind, byte suspendPolicy, Modifier[] modifiers) throws JDWPException {
                PacketStream ps = Set.enqueueCommand(vm, eventKind, suspendPolicy, modifiers);
                return Set.waitForReply(vm, ps);
            }

            static CompletableFuture<Set> processAsync(VirtualMachineImpl vm, byte eventKind, byte suspendPolicy, Modifier[] modifiers) {
                PacketStream ps = Set.enqueueCommand(vm, eventKind, suspendPolicy, modifiers);
                return ps.readReply(p -> new Set(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, byte eventKind, byte suspendPolicy, Modifier[] modifiers) {
                PacketStream ps = new PacketStream(vm, 15, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.EventRequest.Set" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 eventKind(byte): " + eventKind);
                }
                ps.writeByte(eventKind);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 suspendPolicy(byte): " + suspendPolicy);
                }
                ps.writeByte(suspendPolicy);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 modifiers(Modifier[]): ");
                }
                ps.writeInt(modifiers.length);
                for (int i = 0; i < modifiers.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     modifiers[i](Modifier): ");
                    }
                    modifiers[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static Set waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Set(vm, ps);
            }

            private Set(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.EventRequest.Set" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.requestID = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "requestID(int): " + this.requestID);
                }
            }

            static class Modifier {
                final byte modKind;
                ModifierCommon aModifierCommon;

                Modifier(byte modKind, ModifierCommon aModifierCommon) {
                    this.modKind = modKind;
                    this.aModifierCommon = aModifierCommon;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     modKind(byte): " + this.modKind);
                    }
                    ps.writeByte(this.modKind);
                    this.aModifierCommon.write(ps);
                }

                static class SourceNameMatch
                extends ModifierCommon {
                    static final byte ALT_ID = 12;
                    final String sourceNamePattern;

                    static Modifier create(String sourceNamePattern) {
                        return new Modifier(12, new SourceNameMatch(sourceNamePattern));
                    }

                    SourceNameMatch(String sourceNamePattern) {
                        this.sourceNamePattern = sourceNamePattern;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         sourceNamePattern(String): " + this.sourceNamePattern);
                        }
                        ps.writeString(this.sourceNamePattern);
                    }
                }

                static class InstanceOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 11;
                    final ObjectReferenceImpl instance;

                    static Modifier create(ObjectReferenceImpl instance) {
                        return new Modifier(11, new InstanceOnly(instance));
                    }

                    InstanceOnly(ObjectReferenceImpl instance) {
                        this.instance = instance;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         instance(ObjectReferenceImpl): " + (String)(this.instance == null ? "NULL" : "ref=" + this.instance.ref()));
                        }
                        ps.writeObjectRef(this.instance.ref());
                    }
                }

                static class Step
                extends ModifierCommon {
                    static final byte ALT_ID = 10;
                    final ThreadReferenceImpl thread;
                    final int size;
                    final int depth;

                    static Modifier create(ThreadReferenceImpl thread, int size, int depth) {
                        return new Modifier(10, new Step(thread, size, depth));
                    }

                    Step(ThreadReferenceImpl thread, int size, int depth) {
                        this.thread = thread;
                        this.size = size;
                        this.depth = depth;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        ps.writeObjectRef(this.thread.ref());
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         size(int): " + this.size);
                        }
                        ps.writeInt(this.size);
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         depth(int): " + this.depth);
                        }
                        ps.writeInt(this.depth);
                    }
                }

                static class FieldOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 9;
                    final ReferenceTypeImpl declaring;
                    final long fieldID;

                    static Modifier create(ReferenceTypeImpl declaring, long fieldID) {
                        return new Modifier(9, new FieldOnly(declaring, fieldID));
                    }

                    FieldOnly(ReferenceTypeImpl declaring, long fieldID) {
                        this.declaring = declaring;
                        this.fieldID = fieldID;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         declaring(ReferenceTypeImpl): " + (String)(this.declaring == null ? "NULL" : "ref=" + this.declaring.ref()));
                        }
                        ps.writeClassRef(this.declaring.ref());
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         fieldID(long): " + this.fieldID);
                        }
                        ps.writeFieldRef(this.fieldID);
                    }
                }

                static class ExceptionOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 8;
                    final ReferenceTypeImpl exceptionOrNull;
                    final boolean caught;
                    final boolean uncaught;

                    static Modifier create(ReferenceTypeImpl exceptionOrNull, boolean caught, boolean uncaught) {
                        return new Modifier(8, new ExceptionOnly(exceptionOrNull, caught, uncaught));
                    }

                    ExceptionOnly(ReferenceTypeImpl exceptionOrNull, boolean caught, boolean uncaught) {
                        this.exceptionOrNull = exceptionOrNull;
                        this.caught = caught;
                        this.uncaught = uncaught;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         exceptionOrNull(ReferenceTypeImpl): " + (String)(this.exceptionOrNull == null ? "NULL" : "ref=" + this.exceptionOrNull.ref()));
                        }
                        ps.writeClassRef(this.exceptionOrNull.ref());
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         caught(boolean): " + this.caught);
                        }
                        ps.writeBoolean(this.caught);
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         uncaught(boolean): " + this.uncaught);
                        }
                        ps.writeBoolean(this.uncaught);
                    }
                }

                static class LocationOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 7;
                    final Location loc;

                    static Modifier create(Location loc) {
                        return new Modifier(7, new LocationOnly(loc));
                    }

                    LocationOnly(Location loc) {
                        this.loc = loc;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         loc(Location): " + this.loc);
                        }
                        ps.writeLocation(this.loc);
                    }
                }

                static class ClassExclude
                extends ModifierCommon {
                    static final byte ALT_ID = 6;
                    final String classPattern;

                    static Modifier create(String classPattern) {
                        return new Modifier(6, new ClassExclude(classPattern));
                    }

                    ClassExclude(String classPattern) {
                        this.classPattern = classPattern;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         classPattern(String): " + this.classPattern);
                        }
                        ps.writeString(this.classPattern);
                    }
                }

                static class ClassMatch
                extends ModifierCommon {
                    static final byte ALT_ID = 5;
                    final String classPattern;

                    static Modifier create(String classPattern) {
                        return new Modifier(5, new ClassMatch(classPattern));
                    }

                    ClassMatch(String classPattern) {
                        this.classPattern = classPattern;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         classPattern(String): " + this.classPattern);
                        }
                        ps.writeString(this.classPattern);
                    }
                }

                static class ClassOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 4;
                    final ReferenceTypeImpl clazz;

                    static Modifier create(ReferenceTypeImpl clazz) {
                        return new Modifier(4, new ClassOnly(clazz));
                    }

                    ClassOnly(ReferenceTypeImpl clazz) {
                        this.clazz = clazz;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         clazz(ReferenceTypeImpl): " + (String)(this.clazz == null ? "NULL" : "ref=" + this.clazz.ref()));
                        }
                        ps.writeClassRef(this.clazz.ref());
                    }
                }

                static class ThreadOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 3;
                    final ThreadReferenceImpl thread;

                    static Modifier create(ThreadReferenceImpl thread) {
                        return new Modifier(3, new ThreadOnly(thread));
                    }

                    ThreadOnly(ThreadReferenceImpl thread) {
                        this.thread = thread;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         thread(ThreadReferenceImpl): " + (String)(this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        ps.writeObjectRef(this.thread.ref());
                    }
                }

                static class Conditional
                extends ModifierCommon {
                    static final byte ALT_ID = 2;
                    final int exprID;

                    static Modifier create(int exprID) {
                        return new Modifier(2, new Conditional(exprID));
                    }

                    Conditional(int exprID) {
                        this.exprID = exprID;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         exprID(int): " + this.exprID);
                        }
                        ps.writeInt(this.exprID);
                    }
                }

                static class Count
                extends ModifierCommon {
                    static final byte ALT_ID = 1;
                    final int count;

                    static Modifier create(int count) {
                        return new Modifier(1, new Count(count));
                    }

                    Count(int count) {
                        this.count = count;
                    }

                    @Override
                    void write(PacketStream ps) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         count(int): " + this.count);
                        }
                        ps.writeInt(this.count);
                    }
                }

                static abstract class ModifierCommon {
                    ModifierCommon() {
                    }

                    abstract void write(PacketStream var1);
                }
            }
        }
    }

    static class ClassLoaderReference {
        static final int COMMAND_SET = 14;

        private ClassLoaderReference() {
        }

        static class VisibleClasses {
            static final int COMMAND = 1;
            final ClassInfo[] classes;

            static VisibleClasses process(VirtualMachineImpl vm, ClassLoaderReferenceImpl classLoaderObject) throws JDWPException {
                PacketStream ps = VisibleClasses.enqueueCommand(vm, classLoaderObject);
                return VisibleClasses.waitForReply(vm, ps);
            }

            static CompletableFuture<VisibleClasses> processAsync(VirtualMachineImpl vm, ClassLoaderReferenceImpl classLoaderObject) {
                PacketStream ps = VisibleClasses.enqueueCommand(vm, classLoaderObject);
                return ps.readReply(p -> new VisibleClasses(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ClassLoaderReferenceImpl classLoaderObject) {
                PacketStream ps = new PacketStream(vm, 14, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ClassLoaderReference.VisibleClasses" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 classLoaderObject(ClassLoaderReferenceImpl): " + (String)(classLoaderObject == null ? "NULL" : "ref=" + classLoaderObject.ref()));
                }
                ps.writeObjectRef(classLoaderObject.ref());
                ps.send();
                return ps;
            }

            static VisibleClasses waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new VisibleClasses(vm, ps);
            }

            private VisibleClasses(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ClassLoaderReference.VisibleClasses" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int classesCount = ps.readInt();
                this.classes = new ClassInfo[classesCount];
                for (int i = 0; i < classesCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "classes[i](ClassInfo): ");
                    }
                    this.classes[i] = new ClassInfo(vm, ps);
                }
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;

                private ClassInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.refTypeTag = ps.readByte();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = ps.readClassRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                }
            }
        }
    }

    static class ArrayReference {
        static final int COMMAND_SET = 13;

        private ArrayReference() {
        }

        static class SetValues {
            static final int COMMAND = 3;

            static SetValues process(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject, int firstIndex, ValueImpl[] values) throws JDWPException {
                PacketStream ps = SetValues.enqueueCommand(vm, arrayObject, firstIndex, values);
                return SetValues.waitForReply(vm, ps);
            }

            static CompletableFuture<SetValues> processAsync(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject, int firstIndex, ValueImpl[] values) {
                PacketStream ps = SetValues.enqueueCommand(vm, arrayObject, firstIndex, values);
                return ps.readReply(p -> new SetValues(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject, int firstIndex, ValueImpl[] values) {
                PacketStream ps = new PacketStream(vm, 13, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ArrayReference.SetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (String)(arrayObject == null ? "NULL" : "ref=" + arrayObject.ref()));
                }
                ps.writeObjectRef(arrayObject.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 firstIndex(int): " + firstIndex);
                }
                ps.writeInt(firstIndex);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 values(ValueImpl[]): ");
                }
                ps.writeInt(values.length);
                for (int i = 0; i < values.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     values[i](ValueImpl): " + values[i]);
                    }
                    ps.writeUntaggedValue(values[i]);
                }
                ps.send();
                return ps;
            }

            static SetValues waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SetValues(vm, ps);
            }

            private SetValues(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ArrayReference.SetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 2;
            final List<?> values;

            static GetValues process(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject, int firstIndex, int length) throws JDWPException {
                PacketStream ps = GetValues.enqueueCommand(vm, arrayObject, firstIndex, length);
                return GetValues.waitForReply(vm, ps);
            }

            static CompletableFuture<GetValues> processAsync(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject, int firstIndex, int length) {
                PacketStream ps = GetValues.enqueueCommand(vm, arrayObject, firstIndex, length);
                return ps.readReply(p -> new GetValues(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject, int firstIndex, int length) {
                PacketStream ps = new PacketStream(vm, 13, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ArrayReference.GetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (String)(arrayObject == null ? "NULL" : "ref=" + arrayObject.ref()));
                }
                ps.writeObjectRef(arrayObject.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 firstIndex(int): " + firstIndex);
                }
                ps.writeInt(firstIndex);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 length(int): " + length);
                }
                ps.writeInt(length);
                ps.send();
                return ps;
            }

            static GetValues waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new GetValues(vm, ps);
            }

            private GetValues(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ArrayReference.GetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.values = ps.readArrayRegion();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "values(List<?>): " + this.values);
                }
            }
        }

        static class Length {
            static final int COMMAND = 1;
            final int arrayLength;

            static Length process(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject) throws JDWPException {
                PacketStream ps = Length.enqueueCommand(vm, arrayObject);
                return Length.waitForReply(vm, ps);
            }

            static CompletableFuture<Length> processAsync(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject) {
                PacketStream ps = Length.enqueueCommand(vm, arrayObject);
                return ps.readReply(p -> new Length(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ArrayReferenceImpl arrayObject) {
                PacketStream ps = new PacketStream(vm, 13, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ArrayReference.Length" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (String)(arrayObject == null ? "NULL" : "ref=" + arrayObject.ref()));
                }
                ps.writeObjectRef(arrayObject.ref());
                ps.send();
                return ps;
            }

            static Length waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Length(vm, ps);
            }

            private Length(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ArrayReference.Length" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.arrayLength = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "arrayLength(int): " + this.arrayLength);
                }
            }
        }
    }

    static class ThreadGroupReference {
        static final int COMMAND_SET = 12;

        private ThreadGroupReference() {
        }

        static class Children {
            static final int COMMAND = 3;
            final ThreadReferenceImpl[] childThreads;
            final ThreadGroupReferenceImpl[] childGroups;

            static Children process(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) throws JDWPException {
                PacketStream ps = Children.enqueueCommand(vm, group);
                return Children.waitForReply(vm, ps);
            }

            static CompletableFuture<Children> processAsync(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) {
                PacketStream ps = Children.enqueueCommand(vm, group);
                return ps.readReply(p -> new Children(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) {
                PacketStream ps = new PacketStream(vm, 12, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadGroupReference.Children" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (String)(group == null ? "NULL" : "ref=" + group.ref()));
                }
                ps.writeObjectRef(group.ref());
                ps.send();
                return ps;
            }

            static Children waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Children(vm, ps);
            }

            private Children(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadGroupReference.Children" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "childThreads(ThreadReferenceImpl[]): ");
                }
                int childThreadsCount = ps.readInt();
                this.childThreads = new ThreadReferenceImpl[childThreadsCount];
                for (int i = 0; i < childThreadsCount; ++i) {
                    this.childThreads[i] = ps.readThreadReference();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "childThreads[i](ThreadReferenceImpl): " + (String)(this.childThreads[i] == null ? "NULL" : "ref=" + this.childThreads[i].ref()));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "childGroups(ThreadGroupReferenceImpl[]): ");
                }
                int childGroupsCount = ps.readInt();
                this.childGroups = new ThreadGroupReferenceImpl[childGroupsCount];
                for (int i = 0; i < childGroupsCount; ++i) {
                    this.childGroups[i] = ps.readThreadGroupReference();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "childGroups[i](ThreadGroupReferenceImpl): " + (String)(this.childGroups[i] == null ? "NULL" : "ref=" + this.childGroups[i].ref()));
                }
            }
        }

        static class Parent {
            static final int COMMAND = 2;
            final ThreadGroupReferenceImpl parentGroup;

            static Parent process(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) throws JDWPException {
                PacketStream ps = Parent.enqueueCommand(vm, group);
                return Parent.waitForReply(vm, ps);
            }

            static CompletableFuture<Parent> processAsync(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) {
                PacketStream ps = Parent.enqueueCommand(vm, group);
                return ps.readReply(p -> new Parent(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) {
                PacketStream ps = new PacketStream(vm, 12, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadGroupReference.Parent" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (String)(group == null ? "NULL" : "ref=" + group.ref()));
                }
                ps.writeObjectRef(group.ref());
                ps.send();
                return ps;
            }

            static Parent waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Parent(vm, ps);
            }

            private Parent(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadGroupReference.Parent" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.parentGroup = ps.readThreadGroupReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "parentGroup(ThreadGroupReferenceImpl): " + (String)(this.parentGroup == null ? "NULL" : "ref=" + this.parentGroup.ref()));
                }
            }
        }

        static class Name {
            static final int COMMAND = 1;
            final String groupName;

            static Name process(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) throws JDWPException {
                PacketStream ps = Name.enqueueCommand(vm, group);
                return Name.waitForReply(vm, ps);
            }

            static CompletableFuture<Name> processAsync(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) {
                PacketStream ps = Name.enqueueCommand(vm, group);
                return ps.readReply(p -> new Name(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadGroupReferenceImpl group) {
                PacketStream ps = new PacketStream(vm, 12, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadGroupReference.Name" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (String)(group == null ? "NULL" : "ref=" + group.ref()));
                }
                ps.writeObjectRef(group.ref());
                ps.send();
                return ps;
            }

            static Name waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Name(vm, ps);
            }

            private Name(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadGroupReference.Name" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.groupName = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "groupName(String): " + this.groupName);
                }
            }
        }
    }

    static class ThreadReference {
        static final int COMMAND_SET = 11;

        private ThreadReference() {
        }

        static class ForceEarlyReturn {
            static final int COMMAND = 14;

            static ForceEarlyReturn process(VirtualMachineImpl vm, ThreadReferenceImpl thread, ValueImpl value) throws JDWPException {
                PacketStream ps = ForceEarlyReturn.enqueueCommand(vm, thread, value);
                return ForceEarlyReturn.waitForReply(vm, ps);
            }

            static CompletableFuture<ForceEarlyReturn> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread, ValueImpl value) {
                PacketStream ps = ForceEarlyReturn.enqueueCommand(vm, thread, value);
                return ps.readReply(p -> new ForceEarlyReturn(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread, ValueImpl value) {
                PacketStream ps = new PacketStream(vm, 11, 14);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.ForceEarlyReturn" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 value(ValueImpl): " + value);
                }
                ps.writeValue(value);
                ps.send();
                return ps;
            }

            static ForceEarlyReturn waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ForceEarlyReturn(vm, ps);
            }

            private ForceEarlyReturn(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.ForceEarlyReturn" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class OwnedMonitorsStackDepthInfo {
            static final int COMMAND = 13;
            final monitor[] owned;

            static OwnedMonitorsStackDepthInfo process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = OwnedMonitorsStackDepthInfo.enqueueCommand(vm, thread);
                return OwnedMonitorsStackDepthInfo.waitForReply(vm, ps);
            }

            static CompletableFuture<OwnedMonitorsStackDepthInfo> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = OwnedMonitorsStackDepthInfo.enqueueCommand(vm, thread);
                return ps.readReply(p -> new OwnedMonitorsStackDepthInfo(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 13);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.OwnedMonitorsStackDepthInfo" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static OwnedMonitorsStackDepthInfo waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new OwnedMonitorsStackDepthInfo(vm, ps);
            }

            private OwnedMonitorsStackDepthInfo(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.OwnedMonitorsStackDepthInfo" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "owned(monitor[]): ");
                }
                int ownedCount = ps.readInt();
                this.owned = new monitor[ownedCount];
                for (int i = 0; i < ownedCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "owned[i](monitor): ");
                    }
                    this.owned[i] = new monitor(vm, ps);
                }
            }

            static class monitor {
                final ObjectReferenceImpl monitor;
                final int stack_depth;

                private monitor(VirtualMachineImpl vm, PacketStream ps) {
                    this.monitor = ps.readTaggedObjectReference();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "monitor(ObjectReferenceImpl): " + (String)(this.monitor == null ? "NULL" : "ref=" + this.monitor.ref()));
                    }
                    this.stack_depth = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "stack_depth(int): " + this.stack_depth);
                    }
                }
            }
        }

        static class SuspendCount {
            static final int COMMAND = 12;
            final int suspendCount;

            static SuspendCount process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = SuspendCount.enqueueCommand(vm, thread);
                return SuspendCount.waitForReply(vm, ps);
            }

            static CompletableFuture<SuspendCount> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = SuspendCount.enqueueCommand(vm, thread);
                return ps.readReply(p -> new SuspendCount(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 12);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.SuspendCount" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static SuspendCount waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SuspendCount(vm, ps);
            }

            private SuspendCount(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.SuspendCount" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.suspendCount = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "suspendCount(int): " + this.suspendCount);
                }
            }
        }

        static class Interrupt {
            static final int COMMAND = 11;

            static Interrupt process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = Interrupt.enqueueCommand(vm, thread);
                return Interrupt.waitForReply(vm, ps);
            }

            static CompletableFuture<Interrupt> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = Interrupt.enqueueCommand(vm, thread);
                return ps.readReply(p -> new Interrupt(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 11);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Interrupt" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static Interrupt waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Interrupt(vm, ps);
            }

            private Interrupt(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Interrupt" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class Stop {
            static final int COMMAND = 10;

            static Stop process(VirtualMachineImpl vm, ThreadReferenceImpl thread, ObjectReferenceImpl throwable) throws JDWPException {
                PacketStream ps = Stop.enqueueCommand(vm, thread, throwable);
                return Stop.waitForReply(vm, ps);
            }

            static CompletableFuture<Stop> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread, ObjectReferenceImpl throwable) {
                PacketStream ps = Stop.enqueueCommand(vm, thread, throwable);
                return ps.readReply(p -> new Stop(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread, ObjectReferenceImpl throwable) {
                PacketStream ps = new PacketStream(vm, 11, 10);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Stop" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 throwable(ObjectReferenceImpl): " + (String)(throwable == null ? "NULL" : "ref=" + throwable.ref()));
                }
                ps.writeObjectRef(throwable.ref());
                ps.send();
                return ps;
            }

            static Stop waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Stop(vm, ps);
            }

            private Stop(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Stop" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class CurrentContendedMonitor {
            static final int COMMAND = 9;
            final ObjectReferenceImpl monitor;

            static CurrentContendedMonitor process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = CurrentContendedMonitor.enqueueCommand(vm, thread);
                return CurrentContendedMonitor.waitForReply(vm, ps);
            }

            static CompletableFuture<CurrentContendedMonitor> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = CurrentContendedMonitor.enqueueCommand(vm, thread);
                return ps.readReply(p -> new CurrentContendedMonitor(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 9);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.CurrentContendedMonitor" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static CurrentContendedMonitor waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new CurrentContendedMonitor(vm, ps);
            }

            private CurrentContendedMonitor(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.CurrentContendedMonitor" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.monitor = ps.readTaggedObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "monitor(ObjectReferenceImpl): " + (String)(this.monitor == null ? "NULL" : "ref=" + this.monitor.ref()));
                }
            }
        }

        static class OwnedMonitors {
            static final int COMMAND = 8;
            final ObjectReferenceImpl[] owned;

            static OwnedMonitors process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = OwnedMonitors.enqueueCommand(vm, thread);
                return OwnedMonitors.waitForReply(vm, ps);
            }

            static CompletableFuture<OwnedMonitors> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = OwnedMonitors.enqueueCommand(vm, thread);
                return ps.readReply(p -> new OwnedMonitors(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 8);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.OwnedMonitors" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static OwnedMonitors waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new OwnedMonitors(vm, ps);
            }

            private OwnedMonitors(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.OwnedMonitors" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "owned(ObjectReferenceImpl[]): ");
                }
                int ownedCount = ps.readInt();
                this.owned = new ObjectReferenceImpl[ownedCount];
                for (int i = 0; i < ownedCount; ++i) {
                    this.owned[i] = ps.readTaggedObjectReference();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "owned[i](ObjectReferenceImpl): " + (String)(this.owned[i] == null ? "NULL" : "ref=" + this.owned[i].ref()));
                }
            }
        }

        static class FrameCount {
            static final int COMMAND = 7;
            final int frameCount;

            static FrameCount process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = FrameCount.enqueueCommand(vm, thread);
                return FrameCount.waitForReply(vm, ps);
            }

            static CompletableFuture<FrameCount> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = FrameCount.enqueueCommand(vm, thread);
                return ps.readReply(p -> new FrameCount(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 7);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.FrameCount" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static FrameCount waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new FrameCount(vm, ps);
            }

            private FrameCount(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.FrameCount" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.frameCount = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "frameCount(int): " + this.frameCount);
                }
            }
        }

        static class Frames {
            static final int COMMAND = 6;
            final Frame[] frames;

            static Frames process(VirtualMachineImpl vm, ThreadReferenceImpl thread, int startFrame, int length) throws JDWPException {
                PacketStream ps = Frames.enqueueCommand(vm, thread, startFrame, length);
                return Frames.waitForReply(vm, ps);
            }

            static CompletableFuture<Frames> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread, int startFrame, int length) {
                PacketStream ps = Frames.enqueueCommand(vm, thread, startFrame, length);
                return ps.readReply(p -> new Frames(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread, int startFrame, int length) {
                PacketStream ps = new PacketStream(vm, 11, 6);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Frames" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 startFrame(int): " + startFrame);
                }
                ps.writeInt(startFrame);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 length(int): " + length);
                }
                ps.writeInt(length);
                ps.send();
                return ps;
            }

            static Frames waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Frames(vm, ps);
            }

            private Frames(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Frames" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "frames(Frame[]): ");
                }
                int framesCount = ps.readInt();
                this.frames = new Frame[framesCount];
                for (int i = 0; i < framesCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "frames[i](Frame): ");
                    }
                    this.frames[i] = new Frame(vm, ps);
                }
            }

            static class Frame {
                final long frameID;
                final Location location;

                private Frame(VirtualMachineImpl vm, PacketStream ps) {
                    this.frameID = ps.readFrameRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "frameID(long): " + this.frameID);
                    }
                    this.location = ps.readLocation();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "location(Location): " + this.location);
                    }
                }
            }
        }

        static class ThreadGroup {
            static final int COMMAND = 5;
            final ThreadGroupReferenceImpl group;

            static ThreadGroup process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = ThreadGroup.enqueueCommand(vm, thread);
                return ThreadGroup.waitForReply(vm, ps);
            }

            static CompletableFuture<ThreadGroup> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = ThreadGroup.enqueueCommand(vm, thread);
                return ps.readReply(p -> new ThreadGroup(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 5);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.ThreadGroup" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static ThreadGroup waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ThreadGroup(vm, ps);
            }

            private ThreadGroup(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.ThreadGroup" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.group = ps.readThreadGroupReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "group(ThreadGroupReferenceImpl): " + (String)(this.group == null ? "NULL" : "ref=" + this.group.ref()));
                }
            }
        }

        static class Status {
            static final int COMMAND = 4;
            final int threadStatus;
            final int suspendStatus;

            static Status process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = Status.enqueueCommand(vm, thread);
                return Status.waitForReply(vm, ps);
            }

            static CompletableFuture<Status> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = Status.enqueueCommand(vm, thread);
                return ps.readReply(p -> new Status(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 4);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Status" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static Status waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Status(vm, ps);
            }

            private Status(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Status" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.threadStatus = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "threadStatus(int): " + this.threadStatus);
                }
                this.suspendStatus = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "suspendStatus(int): " + this.suspendStatus);
                }
            }
        }

        static class Resume {
            static final int COMMAND = 3;

            static Resume process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = Resume.enqueueCommand(vm, thread);
                return Resume.waitForReply(vm, ps);
            }

            static CompletableFuture<Resume> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = Resume.enqueueCommand(vm, thread);
                return ps.readReply(p -> new Resume(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Resume" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static Resume waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Resume(vm, ps);
            }

            Resume(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Resume" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class Suspend {
            static final int COMMAND = 2;

            static Suspend process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = Suspend.enqueueCommand(vm, thread);
                return Suspend.waitForReply(vm, ps);
            }

            static CompletableFuture<Suspend> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = Suspend.enqueueCommand(vm, thread);
                return ps.readReply(p -> new Suspend(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Suspend" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static Suspend waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Suspend(vm, ps);
            }

            private Suspend(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Suspend" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class Name {
            static final int COMMAND = 1;
            final String threadName;

            static Name process(VirtualMachineImpl vm, ThreadReferenceImpl thread) throws JDWPException {
                PacketStream ps = Name.enqueueCommand(vm, thread);
                return Name.waitForReply(vm, ps);
            }

            static CompletableFuture<Name> processAsync(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = Name.enqueueCommand(vm, thread);
                return ps.readReply(p -> new Name(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ThreadReferenceImpl thread) {
                PacketStream ps = new PacketStream(vm, 11, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Name" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                ps.send();
                return ps;
            }

            static Name waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Name(vm, ps);
            }

            private Name(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ThreadReference.Name" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.threadName = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "threadName(String): " + this.threadName);
                }
            }
        }
    }

    static class StringReference {
        static final int COMMAND_SET = 10;

        private StringReference() {
        }

        static class Value {
            static final int COMMAND = 1;
            final String stringValue;

            static Value process(VirtualMachineImpl vm, ObjectReferenceImpl stringObject) throws JDWPException {
                PacketStream ps = Value.enqueueCommand(vm, stringObject);
                return Value.waitForReply(vm, ps);
            }

            static CompletableFuture<Value> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl stringObject) {
                PacketStream ps = Value.enqueueCommand(vm, stringObject);
                return ps.readReply(p -> new Value(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl stringObject) {
                PacketStream ps = new PacketStream(vm, 10, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.StringReference.Value" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 stringObject(ObjectReferenceImpl): " + (String)(stringObject == null ? "NULL" : "ref=" + stringObject.ref()));
                }
                ps.writeObjectRef(stringObject.ref());
                ps.send();
                return ps;
            }

            static Value waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Value(vm, ps);
            }

            private Value(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.StringReference.Value" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.stringValue = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "stringValue(String): " + this.stringValue);
                }
            }
        }
    }

    static class ObjectReference {
        static final int COMMAND_SET = 9;

        private ObjectReference() {
        }

        static class ReferringObjects {
            static final int COMMAND = 10;
            final ObjectReferenceImpl[] referringObjects;

            static ReferringObjects process(VirtualMachineImpl vm, ObjectReferenceImpl object, int maxReferrers) throws JDWPException {
                PacketStream ps = ReferringObjects.enqueueCommand(vm, object, maxReferrers);
                return ReferringObjects.waitForReply(vm, ps);
            }

            static CompletableFuture<ReferringObjects> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object, int maxReferrers) {
                PacketStream ps = ReferringObjects.enqueueCommand(vm, object, maxReferrers);
                return ps.readReply(p -> new ReferringObjects(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object, int maxReferrers) {
                PacketStream ps = new PacketStream(vm, 9, 10);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.ReferringObjects" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 maxReferrers(int): " + maxReferrers);
                }
                ps.writeInt(maxReferrers);
                ps.send();
                return ps;
            }

            static ReferringObjects waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ReferringObjects(vm, ps);
            }

            private ReferringObjects(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.ReferringObjects" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "referringObjects(ObjectReferenceImpl[]): ");
                }
                int referringObjectsCount = ps.readInt();
                this.referringObjects = new ObjectReferenceImpl[referringObjectsCount];
                for (int i = 0; i < referringObjectsCount; ++i) {
                    this.referringObjects[i] = ps.readTaggedObjectReference();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "referringObjects[i](ObjectReferenceImpl): " + (String)(this.referringObjects[i] == null ? "NULL" : "ref=" + this.referringObjects[i].ref()));
                }
            }
        }

        static class IsCollected {
            static final int COMMAND = 9;
            final boolean isCollected;

            static IsCollected process(VirtualMachineImpl vm, ObjectReferenceImpl object) throws JDWPException {
                PacketStream ps = IsCollected.enqueueCommand(vm, object);
                return IsCollected.waitForReply(vm, ps);
            }

            static CompletableFuture<IsCollected> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = IsCollected.enqueueCommand(vm, object);
                return ps.readReply(p -> new IsCollected(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = new PacketStream(vm, 9, 9);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.IsCollected" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                ps.send();
                return ps;
            }

            static IsCollected waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new IsCollected(vm, ps);
            }

            private IsCollected(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.IsCollected" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.isCollected = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "isCollected(boolean): " + this.isCollected);
                }
            }
        }

        static class EnableCollection {
            static final int COMMAND = 8;

            static EnableCollection process(VirtualMachineImpl vm, ObjectReferenceImpl object) throws JDWPException {
                PacketStream ps = EnableCollection.enqueueCommand(vm, object);
                return EnableCollection.waitForReply(vm, ps);
            }

            static CompletableFuture<EnableCollection> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = EnableCollection.enqueueCommand(vm, object);
                return ps.readReply(p -> new EnableCollection(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = new PacketStream(vm, 9, 8);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.EnableCollection" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                ps.send();
                return ps;
            }

            static EnableCollection waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new EnableCollection(vm, ps);
            }

            private EnableCollection(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.EnableCollection" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class DisableCollection {
            static final int COMMAND = 7;

            static DisableCollection process(VirtualMachineImpl vm, ObjectReferenceImpl object) throws JDWPException {
                PacketStream ps = DisableCollection.enqueueCommand(vm, object);
                return DisableCollection.waitForReply(vm, ps);
            }

            static CompletableFuture<DisableCollection> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = DisableCollection.enqueueCommand(vm, object);
                return ps.readReply(p -> new DisableCollection(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = new PacketStream(vm, 9, 7);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.DisableCollection" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                ps.send();
                return ps;
            }

            static DisableCollection waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new DisableCollection(vm, ps);
            }

            private DisableCollection(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.DisableCollection" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class InvokeMethod {
            static final int COMMAND = 6;
            final ValueImpl returnValue;
            final ObjectReferenceImpl exception;

            static InvokeMethod process(VirtualMachineImpl vm, ObjectReferenceImpl object, ThreadReferenceImpl thread, ClassTypeImpl clazz, long methodID, ValueImpl[] arguments, int options) throws JDWPException {
                PacketStream ps = InvokeMethod.enqueueCommand(vm, object, thread, clazz, methodID, arguments, options);
                return InvokeMethod.waitForReply(vm, ps);
            }

            static CompletableFuture<InvokeMethod> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object, ThreadReferenceImpl thread, ClassTypeImpl clazz, long methodID, ValueImpl[] arguments, int options) {
                PacketStream ps = InvokeMethod.enqueueCommand(vm, object, thread, clazz, methodID, arguments, options);
                return ps.readReply(p -> new InvokeMethod(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object, ThreadReferenceImpl thread, ClassTypeImpl clazz, long methodID, ValueImpl[] arguments, int options) {
                PacketStream ps = new PacketStream(vm, 9, 6);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.InvokeMethod" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (String)(clazz == null ? "NULL" : "ref=" + clazz.ref()));
                }
                ps.writeClassRef(clazz.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                ps.writeInt(arguments.length);
                for (int i = 0; i < arguments.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + arguments[i]);
                    }
                    ps.writeValue(arguments[i]);
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 options(int): " + options);
                }
                ps.writeInt(options);
                ps.send();
                return ps;
            }

            static InvokeMethod waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new InvokeMethod(vm, ps);
            }

            InvokeMethod(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.InvokeMethod" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.returnValue = ps.readValue();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "returnValue(ValueImpl): " + this.returnValue);
                }
                this.exception = ps.readTaggedObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (String)(this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }
        }

        static class MonitorInfo {
            static final int COMMAND = 5;
            final ThreadReferenceImpl owner;
            final int entryCount;
            final ThreadReferenceImpl[] waiters;

            static MonitorInfo process(VirtualMachineImpl vm, ObjectReferenceImpl object) throws JDWPException {
                PacketStream ps = MonitorInfo.enqueueCommand(vm, object);
                return MonitorInfo.waitForReply(vm, ps);
            }

            static CompletableFuture<MonitorInfo> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = MonitorInfo.enqueueCommand(vm, object);
                return ps.readReply(p -> new MonitorInfo(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = new PacketStream(vm, 9, 5);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.MonitorInfo" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                ps.send();
                return ps;
            }

            static MonitorInfo waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new MonitorInfo(vm, ps);
            }

            private MonitorInfo(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.MonitorInfo" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.owner = ps.readThreadReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "owner(ThreadReferenceImpl): " + (String)(this.owner == null ? "NULL" : "ref=" + this.owner.ref()));
                }
                this.entryCount = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "entryCount(int): " + this.entryCount);
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "waiters(ThreadReferenceImpl[]): ");
                }
                int waitersCount = ps.readInt();
                this.waiters = new ThreadReferenceImpl[waitersCount];
                for (int i = 0; i < waitersCount; ++i) {
                    this.waiters[i] = ps.readThreadReference();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "waiters[i](ThreadReferenceImpl): " + (String)(this.waiters[i] == null ? "NULL" : "ref=" + this.waiters[i].ref()));
                }
            }
        }

        static class SetValues {
            static final int COMMAND = 3;

            static SetValues process(VirtualMachineImpl vm, ObjectReferenceImpl object, FieldValue[] values) throws JDWPException {
                PacketStream ps = SetValues.enqueueCommand(vm, object, values);
                return SetValues.waitForReply(vm, ps);
            }

            static CompletableFuture<SetValues> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object, FieldValue[] values) {
                PacketStream ps = SetValues.enqueueCommand(vm, object, values);
                return ps.readReply(p -> new SetValues(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object, FieldValue[] values) {
                PacketStream ps = new PacketStream(vm, 9, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.SetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 values(FieldValue[]): ");
                }
                ps.writeInt(values.length);
                for (int i = 0; i < values.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     values[i](FieldValue): ");
                    }
                    values[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static SetValues waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SetValues(vm, ps);
            }

            private SetValues(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.SetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }

            static class FieldValue {
                final long fieldID;
                final ValueImpl value;

                FieldValue(long fieldID, ValueImpl value) {
                    this.fieldID = fieldID;
                    this.value = value;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    ps.writeFieldRef(this.fieldID);
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     value(ValueImpl): " + this.value);
                    }
                    ps.writeUntaggedValue(this.value);
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 2;
            final ValueImpl[] values;

            static GetValues process(VirtualMachineImpl vm, ObjectReferenceImpl object, Field[] fields) throws JDWPException {
                PacketStream ps = GetValues.enqueueCommand(vm, object, fields);
                return GetValues.waitForReply(vm, ps);
            }

            static CompletableFuture<GetValues> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object, Field[] fields) {
                PacketStream ps = GetValues.enqueueCommand(vm, object, fields);
                return ps.readReply(p -> new GetValues(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object, Field[] fields) {
                PacketStream ps = new PacketStream(vm, 9, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.GetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 fields(Field[]): ");
                }
                ps.writeInt(fields.length);
                for (int i = 0; i < fields.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     fields[i](Field): ");
                    }
                    fields[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static GetValues waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new GetValues(vm, ps);
            }

            private GetValues(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.GetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int valuesCount = ps.readInt();
                this.values = new ValueImpl[valuesCount];
                for (int i = 0; i < valuesCount; ++i) {
                    this.values[i] = ps.readValue();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "values[i](ValueImpl): " + this.values[i]);
                }
            }

            static class Field {
                final long fieldID;

                Field(long fieldID) {
                    this.fieldID = fieldID;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    ps.writeFieldRef(this.fieldID);
                }
            }
        }

        static class ReferenceType {
            static final int COMMAND = 1;
            final byte refTypeTag;
            final long typeID;

            static ReferenceType process(VirtualMachineImpl vm, ObjectReferenceImpl object) throws JDWPException {
                PacketStream ps = ReferenceType.enqueueCommand(vm, object);
                return ReferenceType.waitForReply(vm, ps);
            }

            static CompletableFuture<ReferenceType> processAsync(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = ReferenceType.enqueueCommand(vm, object);
                return ps.readReply(p -> new ReferenceType(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ObjectReferenceImpl object) {
                PacketStream ps = new PacketStream(vm, 9, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.ReferenceType" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (String)(object == null ? "NULL" : "ref=" + object.ref()));
                }
                ps.writeObjectRef(object.ref());
                ps.send();
                return ps;
            }

            static ReferenceType waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ReferenceType(vm, ps);
            }

            private ReferenceType(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ObjectReference.ReferenceType" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.refTypeTag = ps.readByte();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "refTypeTag(byte): " + this.refTypeTag);
                }
                this.typeID = ps.readClassRef();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "typeID(long): ref=" + this.typeID);
                }
            }
        }
    }

    static class Field {
        static final int COMMAND_SET = 8;

        private Field() {
        }
    }

    static class Method {
        static final int COMMAND_SET = 6;

        private Method() {
        }

        static class VariableTableWithGeneric {
            static final int COMMAND = 5;
            final int argCnt;
            final SlotInfo[] slots;

            static VariableTableWithGeneric process(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) throws JDWPException {
                PacketStream ps = VariableTableWithGeneric.enqueueCommand(vm, refType, methodID);
                return VariableTableWithGeneric.waitForReply(vm, ps);
            }

            static CompletableFuture<VariableTableWithGeneric> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = VariableTableWithGeneric.enqueueCommand(vm, refType, methodID);
                return ps.readReply(p -> new VariableTableWithGeneric(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = new PacketStream(vm, 6, 5);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.Method.VariableTableWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                ps.send();
                return ps;
            }

            static VariableTableWithGeneric waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new VariableTableWithGeneric(vm, ps);
            }

            private VariableTableWithGeneric(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.Method.VariableTableWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.argCnt = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "argCnt(int): " + this.argCnt);
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "slots(SlotInfo[]): ");
                }
                int slotsCount = ps.readInt();
                this.slots = new SlotInfo[slotsCount];
                for (int i = 0; i < slotsCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "slots[i](SlotInfo): ");
                    }
                    this.slots[i] = new SlotInfo(vm, ps);
                }
            }

            static class SlotInfo {
                final long codeIndex;
                final String name;
                final String signature;
                final String genericSignature;
                final int length;
                final int slot;

                private SlotInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.codeIndex = ps.readLong();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "codeIndex(long): " + this.codeIndex);
                    }
                    this.name = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.genericSignature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "genericSignature(String): " + this.genericSignature);
                    }
                    this.length = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "length(int): " + this.length);
                    }
                    this.slot = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "slot(int): " + this.slot);
                    }
                }
            }
        }

        static class IsObsolete {
            static final int COMMAND = 4;
            final boolean isObsolete;

            static IsObsolete process(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) throws JDWPException {
                PacketStream ps = IsObsolete.enqueueCommand(vm, refType, methodID);
                return IsObsolete.waitForReply(vm, ps);
            }

            static CompletableFuture<IsObsolete> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = IsObsolete.enqueueCommand(vm, refType, methodID);
                return ps.readReply(p -> new IsObsolete(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = new PacketStream(vm, 6, 4);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.Method.IsObsolete" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                ps.send();
                return ps;
            }

            static IsObsolete waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new IsObsolete(vm, ps);
            }

            private IsObsolete(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.Method.IsObsolete" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.isObsolete = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "isObsolete(boolean): " + this.isObsolete);
                }
            }
        }

        static class Bytecodes {
            static final int COMMAND = 3;
            final byte[] bytes;

            static Bytecodes process(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) throws JDWPException {
                PacketStream ps = Bytecodes.enqueueCommand(vm, refType, methodID);
                return Bytecodes.waitForReply(vm, ps);
            }

            static CompletableFuture<Bytecodes> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = Bytecodes.enqueueCommand(vm, refType, methodID);
                return ps.readReply(p -> new Bytecodes(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = new PacketStream(vm, 6, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.Method.Bytecodes" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                ps.send();
                return ps;
            }

            static Bytecodes waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Bytecodes(vm, ps);
            }

            private Bytecodes(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.Method.Bytecodes" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "bytes(byte[]): ");
                }
                int bytesCount = ps.readInt();
                this.bytes = new byte[bytesCount];
                for (int i = 0; i < bytesCount; ++i) {
                    this.bytes[i] = ps.readByte();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "bytes[i](byte): " + this.bytes[i]);
                }
            }
        }

        static class VariableTable {
            static final int COMMAND = 2;
            final int argCnt;
            final SlotInfo[] slots;

            static VariableTable process(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) throws JDWPException {
                PacketStream ps = VariableTable.enqueueCommand(vm, refType, methodID);
                return VariableTable.waitForReply(vm, ps);
            }

            static CompletableFuture<VariableTable> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = VariableTable.enqueueCommand(vm, refType, methodID);
                return ps.readReply(p -> new VariableTable(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = new PacketStream(vm, 6, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.Method.VariableTable" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                ps.send();
                return ps;
            }

            static VariableTable waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new VariableTable(vm, ps);
            }

            private VariableTable(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.Method.VariableTable" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.argCnt = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "argCnt(int): " + this.argCnt);
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "slots(SlotInfo[]): ");
                }
                int slotsCount = ps.readInt();
                this.slots = new SlotInfo[slotsCount];
                for (int i = 0; i < slotsCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "slots[i](SlotInfo): ");
                    }
                    this.slots[i] = new SlotInfo(vm, ps);
                }
            }

            static class SlotInfo {
                final long codeIndex;
                final String name;
                final String signature;
                final int length;
                final int slot;

                private SlotInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.codeIndex = ps.readLong();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "codeIndex(long): " + this.codeIndex);
                    }
                    this.name = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.length = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "length(int): " + this.length);
                    }
                    this.slot = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "slot(int): " + this.slot);
                    }
                }
            }
        }

        static class LineTable {
            static final int COMMAND = 1;
            final long start;
            final long end;
            final LineInfo[] lines;

            static LineTable process(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) throws JDWPException {
                PacketStream ps = LineTable.enqueueCommand(vm, refType, methodID);
                return LineTable.waitForReply(vm, ps);
            }

            static CompletableFuture<LineTable> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = LineTable.enqueueCommand(vm, refType, methodID);
                return ps.readReply(p -> new LineTable(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType, long methodID) {
                PacketStream ps = new PacketStream(vm, 6, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.Method.LineTable" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                ps.send();
                return ps;
            }

            static LineTable waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new LineTable(vm, ps);
            }

            private LineTable(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.Method.LineTable" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.start = ps.readLong();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "start(long): " + this.start);
                }
                this.end = ps.readLong();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "end(long): " + this.end);
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "lines(LineInfo[]): ");
                }
                int linesCount = ps.readInt();
                this.lines = new LineInfo[linesCount];
                for (int i = 0; i < linesCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "lines[i](LineInfo): ");
                    }
                    this.lines[i] = new LineInfo(vm, ps);
                }
            }

            static class LineInfo {
                final long lineCodeIndex;
                final int lineNumber;

                private LineInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.lineCodeIndex = ps.readLong();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "lineCodeIndex(long): " + this.lineCodeIndex);
                    }
                    this.lineNumber = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "lineNumber(int): " + this.lineNumber);
                    }
                }
            }
        }
    }

    static class InterfaceType {
        static final int COMMAND_SET = 5;

        private InterfaceType() {
        }

        static class InvokeMethod {
            static final int COMMAND = 1;
            final ValueImpl returnValue;
            final ObjectReferenceImpl exception;

            static InvokeMethod process(VirtualMachineImpl vm, InterfaceTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) throws JDWPException {
                PacketStream ps = InvokeMethod.enqueueCommand(vm, clazz, thread, methodID, arguments, options);
                return InvokeMethod.waitForReply(vm, ps);
            }

            static CompletableFuture<InvokeMethod> processAsync(VirtualMachineImpl vm, InterfaceTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) {
                PacketStream ps = InvokeMethod.enqueueCommand(vm, clazz, thread, methodID, arguments, options);
                return ps.readReply(p -> new InvokeMethod(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, InterfaceTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) {
                PacketStream ps = new PacketStream(vm, 5, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.InterfaceType.InvokeMethod" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 clazz(InterfaceTypeImpl): " + (String)(clazz == null ? "NULL" : "ref=" + clazz.ref()));
                }
                ps.writeClassRef(clazz.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                ps.writeInt(arguments.length);
                for (int i = 0; i < arguments.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + arguments[i]);
                    }
                    ps.writeValue(arguments[i]);
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 options(int): " + options);
                }
                ps.writeInt(options);
                ps.send();
                return ps;
            }

            static InvokeMethod waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new InvokeMethod(vm, ps);
            }

            InvokeMethod(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.InterfaceType.InvokeMethod" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.returnValue = ps.readValue();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "returnValue(ValueImpl): " + this.returnValue);
                }
                this.exception = ps.readTaggedObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (String)(this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }
        }
    }

    static class ArrayType {
        static final int COMMAND_SET = 4;

        private ArrayType() {
        }

        static class NewInstance {
            static final int COMMAND = 1;
            final ObjectReferenceImpl newArray;

            static NewInstance process(VirtualMachineImpl vm, ArrayTypeImpl arrType, int length) throws JDWPException {
                PacketStream ps = NewInstance.enqueueCommand(vm, arrType, length);
                return NewInstance.waitForReply(vm, ps);
            }

            static CompletableFuture<NewInstance> processAsync(VirtualMachineImpl vm, ArrayTypeImpl arrType, int length) {
                PacketStream ps = NewInstance.enqueueCommand(vm, arrType, length);
                return ps.readReply(p -> new NewInstance(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ArrayTypeImpl arrType, int length) {
                PacketStream ps = new PacketStream(vm, 4, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ArrayType.NewInstance" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 arrType(ArrayTypeImpl): " + (String)(arrType == null ? "NULL" : "ref=" + arrType.ref()));
                }
                ps.writeClassRef(arrType.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 length(int): " + length);
                }
                ps.writeInt(length);
                ps.send();
                return ps;
            }

            static NewInstance waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new NewInstance(vm, ps);
            }

            private NewInstance(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ArrayType.NewInstance" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.newArray = ps.readTaggedObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "newArray(ObjectReferenceImpl): " + (String)(this.newArray == null ? "NULL" : "ref=" + this.newArray.ref()));
                }
            }
        }
    }

    static class ClassType {
        static final int COMMAND_SET = 3;

        private ClassType() {
        }

        static class NewInstance {
            static final int COMMAND = 4;
            final ObjectReferenceImpl newObject;
            final ObjectReferenceImpl exception;

            static NewInstance process(VirtualMachineImpl vm, ClassTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) throws JDWPException {
                PacketStream ps = NewInstance.enqueueCommand(vm, clazz, thread, methodID, arguments, options);
                return NewInstance.waitForReply(vm, ps);
            }

            static CompletableFuture<NewInstance> processAsync(VirtualMachineImpl vm, ClassTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) {
                PacketStream ps = NewInstance.enqueueCommand(vm, clazz, thread, methodID, arguments, options);
                return ps.readReply(p -> new NewInstance(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ClassTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) {
                PacketStream ps = new PacketStream(vm, 3, 4);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ClassType.NewInstance" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (String)(clazz == null ? "NULL" : "ref=" + clazz.ref()));
                }
                ps.writeClassRef(clazz.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                ps.writeInt(arguments.length);
                for (int i = 0; i < arguments.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + arguments[i]);
                    }
                    ps.writeValue(arguments[i]);
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 options(int): " + options);
                }
                ps.writeInt(options);
                ps.send();
                return ps;
            }

            static NewInstance waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new NewInstance(vm, ps);
            }

            private NewInstance(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ClassType.NewInstance" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.newObject = ps.readTaggedObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "newObject(ObjectReferenceImpl): " + (String)(this.newObject == null ? "NULL" : "ref=" + this.newObject.ref()));
                }
                this.exception = ps.readTaggedObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (String)(this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }
        }

        static class InvokeMethod {
            static final int COMMAND = 3;
            final ValueImpl returnValue;
            final ObjectReferenceImpl exception;

            static InvokeMethod process(VirtualMachineImpl vm, ClassTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) throws JDWPException {
                PacketStream ps = InvokeMethod.enqueueCommand(vm, clazz, thread, methodID, arguments, options);
                return InvokeMethod.waitForReply(vm, ps);
            }

            static CompletableFuture<InvokeMethod> processAsync(VirtualMachineImpl vm, ClassTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) {
                PacketStream ps = InvokeMethod.enqueueCommand(vm, clazz, thread, methodID, arguments, options);
                return ps.readReply(p -> new InvokeMethod(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ClassTypeImpl clazz, ThreadReferenceImpl thread, long methodID, ValueImpl[] arguments, int options) {
                PacketStream ps = new PacketStream(vm, 3, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ClassType.InvokeMethod" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (String)(clazz == null ? "NULL" : "ref=" + clazz.ref()));
                }
                ps.writeClassRef(clazz.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (String)(thread == null ? "NULL" : "ref=" + thread.ref()));
                }
                ps.writeObjectRef(thread.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 methodID(long): " + methodID);
                }
                ps.writeMethodRef(methodID);
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                ps.writeInt(arguments.length);
                for (int i = 0; i < arguments.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + arguments[i]);
                    }
                    ps.writeValue(arguments[i]);
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 options(int): " + options);
                }
                ps.writeInt(options);
                ps.send();
                return ps;
            }

            static InvokeMethod waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new InvokeMethod(vm, ps);
            }

            InvokeMethod(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ClassType.InvokeMethod" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.returnValue = ps.readValue();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "returnValue(ValueImpl): " + this.returnValue);
                }
                this.exception = ps.readTaggedObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (String)(this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }
        }

        static class SetValues {
            static final int COMMAND = 2;

            static SetValues process(VirtualMachineImpl vm, ClassTypeImpl clazz, FieldValue[] values) throws JDWPException {
                PacketStream ps = SetValues.enqueueCommand(vm, clazz, values);
                return SetValues.waitForReply(vm, ps);
            }

            static CompletableFuture<SetValues> processAsync(VirtualMachineImpl vm, ClassTypeImpl clazz, FieldValue[] values) {
                PacketStream ps = SetValues.enqueueCommand(vm, clazz, values);
                return ps.readReply(p -> new SetValues(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ClassTypeImpl clazz, FieldValue[] values) {
                PacketStream ps = new PacketStream(vm, 3, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ClassType.SetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (String)(clazz == null ? "NULL" : "ref=" + clazz.ref()));
                }
                ps.writeClassRef(clazz.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 values(FieldValue[]): ");
                }
                ps.writeInt(values.length);
                for (int i = 0; i < values.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     values[i](FieldValue): ");
                    }
                    values[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static SetValues waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SetValues(vm, ps);
            }

            private SetValues(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ClassType.SetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }

            static class FieldValue {
                final long fieldID;
                final ValueImpl value;

                FieldValue(long fieldID, ValueImpl value) {
                    this.fieldID = fieldID;
                    this.value = value;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    ps.writeFieldRef(this.fieldID);
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     value(ValueImpl): " + this.value);
                    }
                    ps.writeUntaggedValue(this.value);
                }
            }
        }

        static class Superclass {
            static final int COMMAND = 1;
            final ClassTypeImpl superclass;

            static Superclass process(VirtualMachineImpl vm, ClassTypeImpl clazz) throws JDWPException {
                PacketStream ps = Superclass.enqueueCommand(vm, clazz);
                return Superclass.waitForReply(vm, ps);
            }

            static CompletableFuture<Superclass> processAsync(VirtualMachineImpl vm, ClassTypeImpl clazz) {
                PacketStream ps = Superclass.enqueueCommand(vm, clazz);
                return ps.readReply(p -> new Superclass(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ClassTypeImpl clazz) {
                PacketStream ps = new PacketStream(vm, 3, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ClassType.Superclass" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (String)(clazz == null ? "NULL" : "ref=" + clazz.ref()));
                }
                ps.writeClassRef(clazz.ref());
                ps.send();
                return ps;
            }

            static Superclass waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Superclass(vm, ps);
            }

            private Superclass(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ClassType.Superclass" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.superclass = vm.classType(ps.readClassRef());
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "superclass(ClassTypeImpl): " + (String)(this.superclass == null ? "NULL" : "ref=" + this.superclass.ref()));
                }
            }
        }
    }

    static class ReferenceType {
        static final int COMMAND_SET = 2;

        private ReferenceType() {
        }

        static class Module {
            static final int COMMAND = 19;
            final ModuleReferenceImpl module;

            static Module process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = Module.enqueueCommand(vm, refType);
                return Module.waitForReply(vm, ps);
            }

            static CompletableFuture<Module> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = Module.enqueueCommand(vm, refType);
                return ps.readReply(p -> new Module(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 19);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Module" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static Module waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Module(vm, ps);
            }

            private Module(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Module" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.module = ps.readModule();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "module(ModuleReferenceImpl): " + (String)(this.module == null ? "NULL" : "ref=" + this.module.ref()));
                }
            }
        }

        static class ConstantPool {
            static final int COMMAND = 18;
            final int count;
            final byte[] bytes;

            static ConstantPool process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = ConstantPool.enqueueCommand(vm, refType);
                return ConstantPool.waitForReply(vm, ps);
            }

            static CompletableFuture<ConstantPool> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = ConstantPool.enqueueCommand(vm, refType);
                return ps.readReply(p -> new ConstantPool(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 18);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.ConstantPool" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static ConstantPool waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ConstantPool(vm, ps);
            }

            private ConstantPool(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.ConstantPool" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.count = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "count(int): " + this.count);
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "bytes(byte[]): ");
                }
                int bytesCount = ps.readInt();
                this.bytes = new byte[bytesCount];
                for (int i = 0; i < bytesCount; ++i) {
                    this.bytes[i] = ps.readByte();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "bytes[i](byte): " + this.bytes[i]);
                }
            }
        }

        static class ClassFileVersion {
            static final int COMMAND = 17;
            final int majorVersion;
            final int minorVersion;

            static ClassFileVersion process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = ClassFileVersion.enqueueCommand(vm, refType);
                return ClassFileVersion.waitForReply(vm, ps);
            }

            static CompletableFuture<ClassFileVersion> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = ClassFileVersion.enqueueCommand(vm, refType);
                return ps.readReply(p -> new ClassFileVersion(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 17);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.ClassFileVersion" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static ClassFileVersion waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ClassFileVersion(vm, ps);
            }

            private ClassFileVersion(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.ClassFileVersion" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.majorVersion = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "majorVersion(int): " + this.majorVersion);
                }
                this.minorVersion = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "minorVersion(int): " + this.minorVersion);
                }
            }
        }

        static class Instances {
            static final int COMMAND = 16;
            final ObjectReferenceImpl[] instances;

            static Instances process(VirtualMachineImpl vm, ReferenceTypeImpl refType, int maxInstances) throws JDWPException {
                PacketStream ps = Instances.enqueueCommand(vm, refType, maxInstances);
                return Instances.waitForReply(vm, ps);
            }

            static CompletableFuture<Instances> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType, int maxInstances) {
                PacketStream ps = Instances.enqueueCommand(vm, refType, maxInstances);
                return ps.readReply(p -> new Instances(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType, int maxInstances) {
                PacketStream ps = new PacketStream(vm, 2, 16);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Instances" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 maxInstances(int): " + maxInstances);
                }
                ps.writeInt(maxInstances);
                ps.send();
                return ps;
            }

            static Instances waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Instances(vm, ps);
            }

            private Instances(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Instances" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "instances(ObjectReferenceImpl[]): ");
                }
                int instancesCount = ps.readInt();
                this.instances = new ObjectReferenceImpl[instancesCount];
                for (int i = 0; i < instancesCount; ++i) {
                    this.instances[i] = ps.readTaggedObjectReference();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "instances[i](ObjectReferenceImpl): " + (String)(this.instances[i] == null ? "NULL" : "ref=" + this.instances[i].ref()));
                }
            }
        }

        static class MethodsWithGeneric {
            static final int COMMAND = 15;
            final MethodInfo[] declared;

            static MethodsWithGeneric process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = MethodsWithGeneric.enqueueCommand(vm, refType);
                return MethodsWithGeneric.waitForReply(vm, ps);
            }

            static CompletableFuture<MethodsWithGeneric> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = MethodsWithGeneric.enqueueCommand(vm, refType);
                return ps.readReply(p -> new MethodsWithGeneric(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 15);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.MethodsWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static MethodsWithGeneric waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new MethodsWithGeneric(vm, ps);
            }

            private MethodsWithGeneric(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.MethodsWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "declared(MethodInfo[]): ");
                }
                int declaredCount = ps.readInt();
                this.declared = new MethodInfo[declaredCount];
                for (int i = 0; i < declaredCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "declared[i](MethodInfo): ");
                    }
                    this.declared[i] = new MethodInfo(vm, ps);
                }
            }

            static class MethodInfo {
                final long methodID;
                final String name;
                final String signature;
                final String genericSignature;
                final int modBits;

                private MethodInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.methodID = ps.readMethodRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "methodID(long): " + this.methodID);
                    }
                    this.name = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.genericSignature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "genericSignature(String): " + this.genericSignature);
                    }
                    this.modBits = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "modBits(int): " + this.modBits);
                    }
                }
            }
        }

        static class FieldsWithGeneric {
            static final int COMMAND = 14;
            final FieldInfo[] declared;

            static FieldsWithGeneric process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = FieldsWithGeneric.enqueueCommand(vm, refType);
                return FieldsWithGeneric.waitForReply(vm, ps);
            }

            static CompletableFuture<FieldsWithGeneric> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = FieldsWithGeneric.enqueueCommand(vm, refType);
                return ps.readReply(p -> new FieldsWithGeneric(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 14);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.FieldsWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static FieldsWithGeneric waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new FieldsWithGeneric(vm, ps);
            }

            private FieldsWithGeneric(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.FieldsWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "declared(FieldInfo[]): ");
                }
                int declaredCount = ps.readInt();
                this.declared = new FieldInfo[declaredCount];
                for (int i = 0; i < declaredCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "declared[i](FieldInfo): ");
                    }
                    this.declared[i] = new FieldInfo(vm, ps);
                }
            }

            static class FieldInfo {
                final long fieldID;
                final String name;
                final String signature;
                final String genericSignature;
                final int modBits;

                private FieldInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.fieldID = ps.readFieldRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "fieldID(long): " + this.fieldID);
                    }
                    this.name = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.genericSignature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "genericSignature(String): " + this.genericSignature);
                    }
                    this.modBits = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "modBits(int): " + this.modBits);
                    }
                }
            }
        }

        static class SignatureWithGeneric {
            static final int COMMAND = 13;
            final String signature;
            final String genericSignature;

            static SignatureWithGeneric process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = SignatureWithGeneric.enqueueCommand(vm, refType);
                return SignatureWithGeneric.waitForReply(vm, ps);
            }

            static CompletableFuture<SignatureWithGeneric> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = SignatureWithGeneric.enqueueCommand(vm, refType);
                return ps.readReply(p -> new SignatureWithGeneric(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 13);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.SignatureWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static SignatureWithGeneric waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SignatureWithGeneric(vm, ps);
            }

            private SignatureWithGeneric(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.SignatureWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.signature = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "signature(String): " + this.signature);
                }
                this.genericSignature = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "genericSignature(String): " + this.genericSignature);
                }
            }
        }

        static class SourceDebugExtension {
            static final int COMMAND = 12;
            final String extension;

            static SourceDebugExtension process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = SourceDebugExtension.enqueueCommand(vm, refType);
                return SourceDebugExtension.waitForReply(vm, ps);
            }

            static CompletableFuture<SourceDebugExtension> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = SourceDebugExtension.enqueueCommand(vm, refType);
                return ps.readReply(p -> new SourceDebugExtension(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 12);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.SourceDebugExtension" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static SourceDebugExtension waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SourceDebugExtension(vm, ps);
            }

            private SourceDebugExtension(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.SourceDebugExtension" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.extension = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "extension(String): " + this.extension);
                }
            }
        }

        static class ClassObject {
            static final int COMMAND = 11;
            final ClassObjectReferenceImpl classObject;

            static ClassObject process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = ClassObject.enqueueCommand(vm, refType);
                return ClassObject.waitForReply(vm, ps);
            }

            static CompletableFuture<ClassObject> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = ClassObject.enqueueCommand(vm, refType);
                return ps.readReply(p -> new ClassObject(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 11);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.ClassObject" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static ClassObject waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ClassObject(vm, ps);
            }

            private ClassObject(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.ClassObject" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.classObject = ps.readClassObjectReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classObject(ClassObjectReferenceImpl): " + (String)(this.classObject == null ? "NULL" : "ref=" + this.classObject.ref()));
                }
            }
        }

        static class Interfaces {
            static final int COMMAND = 10;
            final InterfaceTypeImpl[] interfaces;

            static Interfaces process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = Interfaces.enqueueCommand(vm, refType);
                return Interfaces.waitForReply(vm, ps);
            }

            static CompletableFuture<Interfaces> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = Interfaces.enqueueCommand(vm, refType);
                return ps.readReply(p -> new Interfaces(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 10);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Interfaces" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static Interfaces waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Interfaces(vm, ps);
            }

            private Interfaces(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Interfaces" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "interfaces(InterfaceTypeImpl[]): ");
                }
                int interfacesCount = ps.readInt();
                this.interfaces = new InterfaceTypeImpl[interfacesCount];
                for (int i = 0; i < interfacesCount; ++i) {
                    this.interfaces[i] = vm.interfaceType(ps.readClassRef());
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "interfaces[i](InterfaceTypeImpl): " + (String)(this.interfaces[i] == null ? "NULL" : "ref=" + this.interfaces[i].ref()));
                }
            }
        }

        static class Status {
            static final int COMMAND = 9;
            final int status;

            static Status process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = Status.enqueueCommand(vm, refType);
                return Status.waitForReply(vm, ps);
            }

            static CompletableFuture<Status> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = Status.enqueueCommand(vm, refType);
                return ps.readReply(p -> new Status(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 9);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Status" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static Status waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Status(vm, ps);
            }

            private Status(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Status" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.status = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "status(int): " + this.status);
                }
            }
        }

        static class NestedTypes {
            static final int COMMAND = 8;
            final TypeInfo[] classes;

            static NestedTypes process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = NestedTypes.enqueueCommand(vm, refType);
                return NestedTypes.waitForReply(vm, ps);
            }

            static CompletableFuture<NestedTypes> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = NestedTypes.enqueueCommand(vm, refType);
                return ps.readReply(p -> new NestedTypes(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 8);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.NestedTypes" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static NestedTypes waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new NestedTypes(vm, ps);
            }

            private NestedTypes(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.NestedTypes" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classes(TypeInfo[]): ");
                }
                int classesCount = ps.readInt();
                this.classes = new TypeInfo[classesCount];
                for (int i = 0; i < classesCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "classes[i](TypeInfo): ");
                    }
                    this.classes[i] = new TypeInfo(vm, ps);
                }
            }

            static class TypeInfo {
                final byte refTypeTag;
                final long typeID;

                private TypeInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.refTypeTag = ps.readByte();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = ps.readClassRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                }
            }
        }

        static class SourceFile {
            static final int COMMAND = 7;
            final String sourceFile;

            static SourceFile process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = SourceFile.enqueueCommand(vm, refType);
                return SourceFile.waitForReply(vm, ps);
            }

            static CompletableFuture<SourceFile> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = SourceFile.enqueueCommand(vm, refType);
                return ps.readReply(p -> new SourceFile(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 7);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.SourceFile" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static SourceFile waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SourceFile(vm, ps);
            }

            private SourceFile(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.SourceFile" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.sourceFile = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "sourceFile(String): " + this.sourceFile);
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 6;
            final ValueImpl[] values;

            static GetValues process(VirtualMachineImpl vm, ReferenceTypeImpl refType, Field[] fields) throws JDWPException {
                PacketStream ps = GetValues.enqueueCommand(vm, refType, fields);
                return GetValues.waitForReply(vm, ps);
            }

            static CompletableFuture<GetValues> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType, Field[] fields) {
                PacketStream ps = GetValues.enqueueCommand(vm, refType, fields);
                return ps.readReply(p -> new GetValues(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType, Field[] fields) {
                PacketStream ps = new PacketStream(vm, 2, 6);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.GetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 fields(Field[]): ");
                }
                ps.writeInt(fields.length);
                for (int i = 0; i < fields.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     fields[i](Field): ");
                    }
                    fields[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static GetValues waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new GetValues(vm, ps);
            }

            private GetValues(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.GetValues" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int valuesCount = ps.readInt();
                this.values = new ValueImpl[valuesCount];
                for (int i = 0; i < valuesCount; ++i) {
                    this.values[i] = ps.readValue();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "values[i](ValueImpl): " + this.values[i]);
                }
            }

            static class Field {
                final long fieldID;

                Field(long fieldID) {
                    this.fieldID = fieldID;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    ps.writeFieldRef(this.fieldID);
                }
            }
        }

        static class Methods {
            static final int COMMAND = 5;
            final MethodInfo[] declared;

            static Methods process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = Methods.enqueueCommand(vm, refType);
                return Methods.waitForReply(vm, ps);
            }

            static CompletableFuture<Methods> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = Methods.enqueueCommand(vm, refType);
                return ps.readReply(p -> new Methods(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 5);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Methods" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static Methods waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Methods(vm, ps);
            }

            private Methods(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Methods" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "declared(MethodInfo[]): ");
                }
                int declaredCount = ps.readInt();
                this.declared = new MethodInfo[declaredCount];
                for (int i = 0; i < declaredCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "declared[i](MethodInfo): ");
                    }
                    this.declared[i] = new MethodInfo(vm, ps);
                }
            }

            static class MethodInfo {
                final long methodID;
                final String name;
                final String signature;
                final int modBits;

                private MethodInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.methodID = ps.readMethodRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "methodID(long): " + this.methodID);
                    }
                    this.name = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.modBits = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "modBits(int): " + this.modBits);
                    }
                }
            }
        }

        static class Fields {
            static final int COMMAND = 4;
            final FieldInfo[] declared;

            static Fields process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = Fields.enqueueCommand(vm, refType);
                return Fields.waitForReply(vm, ps);
            }

            static CompletableFuture<Fields> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = Fields.enqueueCommand(vm, refType);
                return ps.readReply(p -> new Fields(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 4);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Fields" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static Fields waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Fields(vm, ps);
            }

            private Fields(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Fields" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "declared(FieldInfo[]): ");
                }
                int declaredCount = ps.readInt();
                this.declared = new FieldInfo[declaredCount];
                for (int i = 0; i < declaredCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "declared[i](FieldInfo): ");
                    }
                    this.declared[i] = new FieldInfo(vm, ps);
                }
            }

            static class FieldInfo {
                final long fieldID;
                final String name;
                final String signature;
                final int modBits;

                private FieldInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.fieldID = ps.readFieldRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "fieldID(long): " + this.fieldID);
                    }
                    this.name = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.modBits = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "modBits(int): " + this.modBits);
                    }
                }
            }
        }

        static class Modifiers {
            static final int COMMAND = 3;
            final int modBits;

            static Modifiers process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = Modifiers.enqueueCommand(vm, refType);
                return Modifiers.waitForReply(vm, ps);
            }

            static CompletableFuture<Modifiers> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = Modifiers.enqueueCommand(vm, refType);
                return ps.readReply(p -> new Modifiers(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Modifiers" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static Modifiers waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Modifiers(vm, ps);
            }

            private Modifiers(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Modifiers" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.modBits = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "modBits(int): " + this.modBits);
                }
            }
        }

        static class ClassLoader {
            static final int COMMAND = 2;
            final ClassLoaderReferenceImpl classLoader;

            static ClassLoader process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = ClassLoader.enqueueCommand(vm, refType);
                return ClassLoader.waitForReply(vm, ps);
            }

            static CompletableFuture<ClassLoader> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = ClassLoader.enqueueCommand(vm, refType);
                return ps.readReply(p -> new ClassLoader(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.ClassLoader" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static ClassLoader waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ClassLoader(vm, ps);
            }

            private ClassLoader(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.ClassLoader" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.classLoader = ps.readClassLoaderReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classLoader(ClassLoaderReferenceImpl): " + (String)(this.classLoader == null ? "NULL" : "ref=" + this.classLoader.ref()));
                }
            }
        }

        static class Signature {
            static final int COMMAND = 1;
            final String signature;

            static Signature process(VirtualMachineImpl vm, ReferenceTypeImpl refType) throws JDWPException {
                PacketStream ps = Signature.enqueueCommand(vm, refType);
                return Signature.waitForReply(vm, ps);
            }

            static CompletableFuture<Signature> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = Signature.enqueueCommand(vm, refType);
                return ps.readReply(p -> new Signature(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl refType) {
                PacketStream ps = new PacketStream(vm, 2, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Signature" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (String)(refType == null ? "NULL" : "ref=" + refType.ref()));
                }
                ps.writeClassRef(refType.ref());
                ps.send();
                return ps;
            }

            static Signature waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Signature(vm, ps);
            }

            private Signature(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.ReferenceType.Signature" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.signature = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "signature(String): " + this.signature);
                }
            }
        }
    }

    static class VirtualMachine {
        static final int COMMAND_SET = 1;

        private VirtualMachine() {
        }

        static class AllModules {
            static final int COMMAND = 22;
            final ModuleReferenceImpl[] modules;

            static AllModules process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = AllModules.enqueueCommand(vm);
                return AllModules.waitForReply(vm, ps);
            }

            static CompletableFuture<AllModules> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = AllModules.enqueueCommand(vm);
                return ps.readReply(p -> new AllModules(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 22);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.AllModules" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static AllModules waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new AllModules(vm, ps);
            }

            private AllModules(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.AllModules" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "modules(ModuleReferenceImpl[]): ");
                }
                int modulesCount = ps.readInt();
                this.modules = new ModuleReferenceImpl[modulesCount];
                for (int i = 0; i < modulesCount; ++i) {
                    this.modules[i] = ps.readModule();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "modules[i](ModuleReferenceImpl): " + (String)(this.modules[i] == null ? "NULL" : "ref=" + this.modules[i].ref()));
                }
            }
        }

        static class InstanceCounts {
            static final int COMMAND = 21;
            final long[] counts;

            static InstanceCounts process(VirtualMachineImpl vm, ReferenceTypeImpl[] refTypesCount) throws JDWPException {
                PacketStream ps = InstanceCounts.enqueueCommand(vm, refTypesCount);
                return InstanceCounts.waitForReply(vm, ps);
            }

            static CompletableFuture<InstanceCounts> processAsync(VirtualMachineImpl vm, ReferenceTypeImpl[] refTypesCount) {
                PacketStream ps = InstanceCounts.enqueueCommand(vm, refTypesCount);
                return ps.readReply(p -> new InstanceCounts(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ReferenceTypeImpl[] refTypesCount) {
                PacketStream ps = new PacketStream(vm, 1, 21);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.InstanceCounts" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 refTypesCount(ReferenceTypeImpl[]): ");
                }
                ps.writeInt(refTypesCount.length);
                for (int i = 0; i < refTypesCount.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     refTypesCount[i](ReferenceTypeImpl): " + (String)(refTypesCount[i] == null ? "NULL" : "ref=" + refTypesCount[i].ref()));
                    }
                    ps.writeClassRef(refTypesCount[i].ref());
                }
                ps.send();
                return ps;
            }

            static InstanceCounts waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new InstanceCounts(vm, ps);
            }

            private InstanceCounts(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.InstanceCounts" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "counts(long[]): ");
                }
                int countsCount = ps.readInt();
                this.counts = new long[countsCount];
                for (int i = 0; i < countsCount; ++i) {
                    this.counts[i] = ps.readLong();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "counts[i](long): " + this.counts[i]);
                }
            }
        }

        static class AllClassesWithGeneric {
            static final int COMMAND = 20;
            final ClassInfo[] classes;

            static AllClassesWithGeneric process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = AllClassesWithGeneric.enqueueCommand(vm);
                return AllClassesWithGeneric.waitForReply(vm, ps);
            }

            static CompletableFuture<AllClassesWithGeneric> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = AllClassesWithGeneric.enqueueCommand(vm);
                return ps.readReply(p -> new AllClassesWithGeneric(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 20);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.AllClassesWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static AllClassesWithGeneric waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new AllClassesWithGeneric(vm, ps);
            }

            private AllClassesWithGeneric(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.AllClassesWithGeneric" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int classesCount = ps.readInt();
                this.classes = new ClassInfo[classesCount];
                for (int i = 0; i < classesCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "classes[i](ClassInfo): ");
                    }
                    this.classes[i] = new ClassInfo(vm, ps);
                }
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;
                final String signature;
                final String genericSignature;
                final int status;

                private ClassInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.refTypeTag = ps.readByte();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = ps.readClassRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                    this.signature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.genericSignature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "genericSignature(String): " + this.genericSignature);
                    }
                    this.status = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "status(int): " + this.status);
                    }
                }
            }
        }

        static class SetDefaultStratum {
            static final int COMMAND = 19;

            static SetDefaultStratum process(VirtualMachineImpl vm, String stratumID) throws JDWPException {
                PacketStream ps = SetDefaultStratum.enqueueCommand(vm, stratumID);
                return SetDefaultStratum.waitForReply(vm, ps);
            }

            static CompletableFuture<SetDefaultStratum> processAsync(VirtualMachineImpl vm, String stratumID) {
                PacketStream ps = SetDefaultStratum.enqueueCommand(vm, stratumID);
                return ps.readReply(p -> new SetDefaultStratum(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, String stratumID) {
                PacketStream ps = new PacketStream(vm, 1, 19);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.SetDefaultStratum" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 stratumID(String): " + stratumID);
                }
                ps.writeString(stratumID);
                ps.send();
                return ps;
            }

            static SetDefaultStratum waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new SetDefaultStratum(vm, ps);
            }

            private SetDefaultStratum(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.SetDefaultStratum" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class RedefineClasses {
            static final int COMMAND = 18;

            static RedefineClasses process(VirtualMachineImpl vm, ClassDef[] classes) throws JDWPException {
                PacketStream ps = RedefineClasses.enqueueCommand(vm, classes);
                return RedefineClasses.waitForReply(vm, ps);
            }

            static CompletableFuture<RedefineClasses> processAsync(VirtualMachineImpl vm, ClassDef[] classes) {
                PacketStream ps = RedefineClasses.enqueueCommand(vm, classes);
                return ps.readReply(p -> new RedefineClasses(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, ClassDef[] classes) {
                PacketStream ps = new PacketStream(vm, 1, 18);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.RedefineClasses" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 classes(ClassDef[]): ");
                }
                ps.writeInt(classes.length);
                for (int i = 0; i < classes.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     classes[i](ClassDef): ");
                    }
                    classes[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static RedefineClasses waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new RedefineClasses(vm, ps);
            }

            private RedefineClasses(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.RedefineClasses" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }

            static class ClassDef {
                final ReferenceTypeImpl refType;
                final byte[] classfile;

                ClassDef(ReferenceTypeImpl refType, byte[] classfile) {
                    this.refType = refType;
                    this.classfile = classfile;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     refType(ReferenceTypeImpl): " + (String)(this.refType == null ? "NULL" : "ref=" + this.refType.ref()));
                    }
                    ps.writeClassRef(this.refType.ref());
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     classfile(byte[]): ");
                    }
                    ps.writeInt(this.classfile.length);
                    for (int i = 0; i < this.classfile.length; ++i) {
                        if ((ps.vm.traceFlags & 1) != 0) {
                            ps.vm.printTrace("Sending:                         classfile[i](byte): " + this.classfile[i]);
                        }
                        ps.writeByte(this.classfile[i]);
                    }
                }
            }
        }

        static class CapabilitiesNew {
            static final int COMMAND = 17;
            final boolean canWatchFieldModification;
            final boolean canWatchFieldAccess;
            final boolean canGetBytecodes;
            final boolean canGetSyntheticAttribute;
            final boolean canGetOwnedMonitorInfo;
            final boolean canGetCurrentContendedMonitor;
            final boolean canGetMonitorInfo;
            final boolean canRedefineClasses;
            final boolean canAddMethod;
            final boolean canUnrestrictedlyRedefineClasses;
            final boolean canPopFrames;
            final boolean canUseInstanceFilters;
            final boolean canGetSourceDebugExtension;
            final boolean canRequestVMDeathEvent;
            final boolean canSetDefaultStratum;
            final boolean canGetInstanceInfo;
            final boolean canRequestMonitorEvents;
            final boolean canGetMonitorFrameInfo;
            final boolean canUseSourceNameFilters;
            final boolean canGetConstantPool;
            final boolean canForceEarlyReturn;
            final boolean reserved22;
            final boolean reserved23;
            final boolean reserved24;
            final boolean reserved25;
            final boolean reserved26;
            final boolean reserved27;
            final boolean reserved28;
            final boolean reserved29;
            final boolean reserved30;
            final boolean reserved31;
            final boolean reserved32;

            static CapabilitiesNew process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = CapabilitiesNew.enqueueCommand(vm);
                return CapabilitiesNew.waitForReply(vm, ps);
            }

            static CompletableFuture<CapabilitiesNew> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = CapabilitiesNew.enqueueCommand(vm);
                return ps.readReply(p -> new CapabilitiesNew(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 17);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.CapabilitiesNew" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static CapabilitiesNew waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new CapabilitiesNew(vm, ps);
            }

            private CapabilitiesNew(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.CapabilitiesNew" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.canWatchFieldModification = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canWatchFieldModification(boolean): " + this.canWatchFieldModification);
                }
                this.canWatchFieldAccess = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canWatchFieldAccess(boolean): " + this.canWatchFieldAccess);
                }
                this.canGetBytecodes = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetBytecodes(boolean): " + this.canGetBytecodes);
                }
                this.canGetSyntheticAttribute = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetSyntheticAttribute(boolean): " + this.canGetSyntheticAttribute);
                }
                this.canGetOwnedMonitorInfo = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetOwnedMonitorInfo(boolean): " + this.canGetOwnedMonitorInfo);
                }
                this.canGetCurrentContendedMonitor = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetCurrentContendedMonitor(boolean): " + this.canGetCurrentContendedMonitor);
                }
                this.canGetMonitorInfo = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetMonitorInfo(boolean): " + this.canGetMonitorInfo);
                }
                this.canRedefineClasses = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canRedefineClasses(boolean): " + this.canRedefineClasses);
                }
                this.canAddMethod = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canAddMethod(boolean): " + this.canAddMethod);
                }
                this.canUnrestrictedlyRedefineClasses = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canUnrestrictedlyRedefineClasses(boolean): " + this.canUnrestrictedlyRedefineClasses);
                }
                this.canPopFrames = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canPopFrames(boolean): " + this.canPopFrames);
                }
                this.canUseInstanceFilters = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canUseInstanceFilters(boolean): " + this.canUseInstanceFilters);
                }
                this.canGetSourceDebugExtension = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetSourceDebugExtension(boolean): " + this.canGetSourceDebugExtension);
                }
                this.canRequestVMDeathEvent = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canRequestVMDeathEvent(boolean): " + this.canRequestVMDeathEvent);
                }
                this.canSetDefaultStratum = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canSetDefaultStratum(boolean): " + this.canSetDefaultStratum);
                }
                this.canGetInstanceInfo = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetInstanceInfo(boolean): " + this.canGetInstanceInfo);
                }
                this.canRequestMonitorEvents = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canRequestMonitorEvents(boolean): " + this.canRequestMonitorEvents);
                }
                this.canGetMonitorFrameInfo = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetMonitorFrameInfo(boolean): " + this.canGetMonitorFrameInfo);
                }
                this.canUseSourceNameFilters = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canUseSourceNameFilters(boolean): " + this.canUseSourceNameFilters);
                }
                this.canGetConstantPool = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetConstantPool(boolean): " + this.canGetConstantPool);
                }
                this.canForceEarlyReturn = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canForceEarlyReturn(boolean): " + this.canForceEarlyReturn);
                }
                this.reserved22 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved22(boolean): " + this.reserved22);
                }
                this.reserved23 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved23(boolean): " + this.reserved23);
                }
                this.reserved24 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved24(boolean): " + this.reserved24);
                }
                this.reserved25 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved25(boolean): " + this.reserved25);
                }
                this.reserved26 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved26(boolean): " + this.reserved26);
                }
                this.reserved27 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved27(boolean): " + this.reserved27);
                }
                this.reserved28 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved28(boolean): " + this.reserved28);
                }
                this.reserved29 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved29(boolean): " + this.reserved29);
                }
                this.reserved30 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved30(boolean): " + this.reserved30);
                }
                this.reserved31 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved31(boolean): " + this.reserved31);
                }
                this.reserved32 = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "reserved32(boolean): " + this.reserved32);
                }
            }
        }

        static class ReleaseEvents {
            static final int COMMAND = 16;

            static ReleaseEvents process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = ReleaseEvents.enqueueCommand(vm);
                return ReleaseEvents.waitForReply(vm, ps);
            }

            static CompletableFuture<ReleaseEvents> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = ReleaseEvents.enqueueCommand(vm);
                return ps.readReply(p -> new ReleaseEvents(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 16);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.ReleaseEvents" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static ReleaseEvents waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ReleaseEvents(vm, ps);
            }

            private ReleaseEvents(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.ReleaseEvents" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class HoldEvents {
            static final int COMMAND = 15;

            static HoldEvents process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = HoldEvents.enqueueCommand(vm);
                return HoldEvents.waitForReply(vm, ps);
            }

            static CompletableFuture<HoldEvents> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = HoldEvents.enqueueCommand(vm);
                return ps.readReply(p -> new HoldEvents(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 15);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.HoldEvents" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static HoldEvents waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new HoldEvents(vm, ps);
            }

            private HoldEvents(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.HoldEvents" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class DisposeObjects {
            static final int COMMAND = 14;

            static DisposeObjects process(VirtualMachineImpl vm, Request[] requests) throws JDWPException {
                PacketStream ps = DisposeObjects.enqueueCommand(vm, requests);
                return DisposeObjects.waitForReply(vm, ps);
            }

            static CompletableFuture<DisposeObjects> processAsync(VirtualMachineImpl vm, Request[] requests) {
                PacketStream ps = DisposeObjects.enqueueCommand(vm, requests);
                return ps.readReply(p -> new DisposeObjects(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, Request[] requests) {
                PacketStream ps = new PacketStream(vm, 1, 14);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.DisposeObjects" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 requests(Request[]): ");
                }
                ps.writeInt(requests.length);
                for (int i = 0; i < requests.length; ++i) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     requests[i](Request): ");
                    }
                    requests[i].write(ps);
                }
                ps.send();
                return ps;
            }

            static DisposeObjects waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new DisposeObjects(vm, ps);
            }

            private DisposeObjects(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.DisposeObjects" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }

            static class Request {
                final ObjectReferenceImpl object;
                final int refCnt;

                Request(ObjectReferenceImpl object, int refCnt) {
                    this.object = object;
                    this.refCnt = refCnt;
                }

                private void write(PacketStream ps) {
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     object(ObjectReferenceImpl): " + (String)(this.object == null ? "NULL" : "ref=" + this.object.ref()));
                    }
                    ps.writeObjectRef(this.object.ref());
                    if ((ps.vm.traceFlags & 1) != 0) {
                        ps.vm.printTrace("Sending:                     refCnt(int): " + this.refCnt);
                    }
                    ps.writeInt(this.refCnt);
                }
            }
        }

        static class ClassPaths {
            static final int COMMAND = 13;
            final String baseDir;
            final String[] classpaths;
            final String[] bootclasspaths;

            static ClassPaths process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = ClassPaths.enqueueCommand(vm);
                return ClassPaths.waitForReply(vm, ps);
            }

            static CompletableFuture<ClassPaths> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = ClassPaths.enqueueCommand(vm);
                return ps.readReply(p -> new ClassPaths(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 13);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.ClassPaths" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static ClassPaths waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ClassPaths(vm, ps);
            }

            private ClassPaths(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.ClassPaths" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.baseDir = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "baseDir(String): " + this.baseDir);
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classpaths(String[]): ");
                }
                int classpathsCount = ps.readInt();
                this.classpaths = new String[classpathsCount];
                for (int i = 0; i < classpathsCount; ++i) {
                    this.classpaths[i] = ps.readString();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "classpaths[i](String): " + this.classpaths[i]);
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "bootclasspaths(String[]): ");
                }
                int bootclasspathsCount = ps.readInt();
                this.bootclasspaths = new String[bootclasspathsCount];
                for (int i = 0; i < bootclasspathsCount; ++i) {
                    this.bootclasspaths[i] = ps.readString();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "bootclasspaths[i](String): " + this.bootclasspaths[i]);
                }
            }
        }

        static class Capabilities {
            static final int COMMAND = 12;
            final boolean canWatchFieldModification;
            final boolean canWatchFieldAccess;
            final boolean canGetBytecodes;
            final boolean canGetSyntheticAttribute;
            final boolean canGetOwnedMonitorInfo;
            final boolean canGetCurrentContendedMonitor;
            final boolean canGetMonitorInfo;

            static Capabilities process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = Capabilities.enqueueCommand(vm);
                return Capabilities.waitForReply(vm, ps);
            }

            static CompletableFuture<Capabilities> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = Capabilities.enqueueCommand(vm);
                return ps.readReply(p -> new Capabilities(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 12);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Capabilities" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static Capabilities waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Capabilities(vm, ps);
            }

            private Capabilities(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Capabilities" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.canWatchFieldModification = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canWatchFieldModification(boolean): " + this.canWatchFieldModification);
                }
                this.canWatchFieldAccess = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canWatchFieldAccess(boolean): " + this.canWatchFieldAccess);
                }
                this.canGetBytecodes = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetBytecodes(boolean): " + this.canGetBytecodes);
                }
                this.canGetSyntheticAttribute = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetSyntheticAttribute(boolean): " + this.canGetSyntheticAttribute);
                }
                this.canGetOwnedMonitorInfo = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetOwnedMonitorInfo(boolean): " + this.canGetOwnedMonitorInfo);
                }
                this.canGetCurrentContendedMonitor = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetCurrentContendedMonitor(boolean): " + this.canGetCurrentContendedMonitor);
                }
                this.canGetMonitorInfo = ps.readBoolean();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "canGetMonitorInfo(boolean): " + this.canGetMonitorInfo);
                }
            }
        }

        static class CreateString {
            static final int COMMAND = 11;
            final StringReferenceImpl stringObject;

            static CreateString process(VirtualMachineImpl vm, String utf) throws JDWPException {
                PacketStream ps = CreateString.enqueueCommand(vm, utf);
                return CreateString.waitForReply(vm, ps);
            }

            static CompletableFuture<CreateString> processAsync(VirtualMachineImpl vm, String utf) {
                PacketStream ps = CreateString.enqueueCommand(vm, utf);
                return ps.readReply(p -> new CreateString(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, String utf) {
                PacketStream ps = new PacketStream(vm, 1, 11);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.CreateString" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 utf(String): " + utf);
                }
                ps.writeString(utf);
                ps.send();
                return ps;
            }

            static CreateString waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new CreateString(vm, ps);
            }

            private CreateString(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.CreateString" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.stringObject = ps.readStringReference();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "stringObject(StringReferenceImpl): " + (String)(this.stringObject == null ? "NULL" : "ref=" + this.stringObject.ref()));
                }
            }
        }

        static class Exit {
            static final int COMMAND = 10;

            static Exit process(VirtualMachineImpl vm, int exitCode) throws JDWPException {
                PacketStream ps = Exit.enqueueCommand(vm, exitCode);
                return Exit.waitForReply(vm, ps);
            }

            static CompletableFuture<Exit> processAsync(VirtualMachineImpl vm, int exitCode) {
                PacketStream ps = Exit.enqueueCommand(vm, exitCode);
                return ps.readReply(p -> new Exit(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, int exitCode) {
                PacketStream ps = new PacketStream(vm, 1, 10);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Exit" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 exitCode(int): " + exitCode);
                }
                ps.writeInt(exitCode);
                ps.send();
                return ps;
            }

            static Exit waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Exit(vm, ps);
            }

            private Exit(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Exit" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class Resume {
            static final int COMMAND = 9;

            static Resume process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = Resume.enqueueCommand(vm);
                return Resume.waitForReply(vm, ps);
            }

            static CompletableFuture<Resume> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = Resume.enqueueCommand(vm);
                return ps.readReply(p -> new Resume(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 9);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Resume" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static Resume waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Resume(vm, ps);
            }

            Resume(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Resume" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class Suspend {
            static final int COMMAND = 8;

            static Suspend process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = Suspend.enqueueCommand(vm);
                return Suspend.waitForReply(vm, ps);
            }

            static CompletableFuture<Suspend> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = Suspend.enqueueCommand(vm);
                return ps.readReply(p -> new Suspend(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 8);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Suspend" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static Suspend waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Suspend(vm, ps);
            }

            private Suspend(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Suspend" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class IDSizes {
            static final int COMMAND = 7;
            final int fieldIDSize;
            final int methodIDSize;
            final int objectIDSize;
            final int referenceTypeIDSize;
            final int frameIDSize;

            static IDSizes process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = IDSizes.enqueueCommand(vm);
                return IDSizes.waitForReply(vm, ps);
            }

            static CompletableFuture<IDSizes> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = IDSizes.enqueueCommand(vm);
                return ps.readReply(p -> new IDSizes(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 7);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.IDSizes" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static IDSizes waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new IDSizes(vm, ps);
            }

            private IDSizes(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.IDSizes" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.fieldIDSize = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "fieldIDSize(int): " + this.fieldIDSize);
                }
                this.methodIDSize = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "methodIDSize(int): " + this.methodIDSize);
                }
                this.objectIDSize = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "objectIDSize(int): " + this.objectIDSize);
                }
                this.referenceTypeIDSize = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "referenceTypeIDSize(int): " + this.referenceTypeIDSize);
                }
                this.frameIDSize = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "frameIDSize(int): " + this.frameIDSize);
                }
            }
        }

        static class Dispose {
            static final int COMMAND = 6;

            static Dispose process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = Dispose.enqueueCommand(vm);
                return Dispose.waitForReply(vm, ps);
            }

            static CompletableFuture<Dispose> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = Dispose.enqueueCommand(vm);
                return ps.readReply(p -> new Dispose(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 6);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Dispose" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static Dispose waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Dispose(vm, ps);
            }

            private Dispose(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Dispose" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
            }
        }

        static class TopLevelThreadGroups {
            static final int COMMAND = 5;
            final ThreadGroupReferenceImpl[] groups;

            static TopLevelThreadGroups process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = TopLevelThreadGroups.enqueueCommand(vm);
                return TopLevelThreadGroups.waitForReply(vm, ps);
            }

            static CompletableFuture<TopLevelThreadGroups> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = TopLevelThreadGroups.enqueueCommand(vm);
                return ps.readReply(p -> new TopLevelThreadGroups(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 5);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.TopLevelThreadGroups" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static TopLevelThreadGroups waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new TopLevelThreadGroups(vm, ps);
            }

            private TopLevelThreadGroups(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.TopLevelThreadGroups" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "groups(ThreadGroupReferenceImpl[]): ");
                }
                int groupsCount = ps.readInt();
                this.groups = new ThreadGroupReferenceImpl[groupsCount];
                for (int i = 0; i < groupsCount; ++i) {
                    this.groups[i] = ps.readThreadGroupReference();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "groups[i](ThreadGroupReferenceImpl): " + (String)(this.groups[i] == null ? "NULL" : "ref=" + this.groups[i].ref()));
                }
            }
        }

        static class AllThreads {
            static final int COMMAND = 4;
            final ThreadReferenceImpl[] threads;

            static AllThreads process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = AllThreads.enqueueCommand(vm);
                return AllThreads.waitForReply(vm, ps);
            }

            static CompletableFuture<AllThreads> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = AllThreads.enqueueCommand(vm);
                return ps.readReply(p -> new AllThreads(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 4);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.AllThreads" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static AllThreads waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new AllThreads(vm, ps);
            }

            private AllThreads(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.AllThreads" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "threads(ThreadReferenceImpl[]): ");
                }
                int threadsCount = ps.readInt();
                this.threads = new ThreadReferenceImpl[threadsCount];
                for (int i = 0; i < threadsCount; ++i) {
                    this.threads[i] = ps.readThreadReference();
                    if (!vm.traceReceives) continue;
                    vm.printReceiveTrace(5, "threads[i](ThreadReferenceImpl): " + (String)(this.threads[i] == null ? "NULL" : "ref=" + this.threads[i].ref()));
                }
            }
        }

        static class AllClasses {
            static final int COMMAND = 3;
            final ClassInfo[] classes;

            static AllClasses process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = AllClasses.enqueueCommand(vm);
                return AllClasses.waitForReply(vm, ps);
            }

            static CompletableFuture<AllClasses> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = AllClasses.enqueueCommand(vm);
                return ps.readReply(p -> new AllClasses(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 3);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.AllClasses" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static AllClasses waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new AllClasses(vm, ps);
            }

            private AllClasses(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.AllClasses" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int classesCount = ps.readInt();
                this.classes = new ClassInfo[classesCount];
                for (int i = 0; i < classesCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "classes[i](ClassInfo): ");
                    }
                    this.classes[i] = new ClassInfo(vm, ps);
                }
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;
                final String signature;
                final int status;

                private ClassInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.refTypeTag = ps.readByte();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = ps.readClassRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                    this.signature = ps.readString();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.status = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "status(int): " + this.status);
                    }
                }
            }
        }

        static class ClassesBySignature {
            static final int COMMAND = 2;
            final ClassInfo[] classes;

            static ClassesBySignature process(VirtualMachineImpl vm, String signature) throws JDWPException {
                PacketStream ps = ClassesBySignature.enqueueCommand(vm, signature);
                return ClassesBySignature.waitForReply(vm, ps);
            }

            static CompletableFuture<ClassesBySignature> processAsync(VirtualMachineImpl vm, String signature) {
                PacketStream ps = ClassesBySignature.enqueueCommand(vm, signature);
                return ps.readReply(p -> new ClassesBySignature(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm, String signature) {
                PacketStream ps = new PacketStream(vm, 1, 2);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.ClassesBySignature" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                if ((ps.vm.traceFlags & 1) != 0) {
                    ps.vm.printTrace("Sending:                 signature(String): " + signature);
                }
                ps.writeString(signature);
                ps.send();
                return ps;
            }

            static ClassesBySignature waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new ClassesBySignature(vm, ps);
            }

            private ClassesBySignature(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.ClassesBySignature" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int classesCount = ps.readInt();
                this.classes = new ClassInfo[classesCount];
                for (int i = 0; i < classesCount; ++i) {
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "classes[i](ClassInfo): ");
                    }
                    this.classes[i] = new ClassInfo(vm, ps);
                }
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;
                final int status;

                private ClassInfo(VirtualMachineImpl vm, PacketStream ps) {
                    this.refTypeTag = ps.readByte();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = ps.readClassRef();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                    this.status = ps.readInt();
                    if (vm.traceReceives) {
                        vm.printReceiveTrace(5, "status(int): " + this.status);
                    }
                }
            }
        }

        static class Version {
            static final int COMMAND = 1;
            final String description;
            final int jdwpMajor;
            final int jdwpMinor;
            final String vmVersion;
            final String vmName;

            static Version process(VirtualMachineImpl vm) throws JDWPException {
                PacketStream ps = Version.enqueueCommand(vm);
                return Version.waitForReply(vm, ps);
            }

            static CompletableFuture<Version> processAsync(VirtualMachineImpl vm) {
                PacketStream ps = Version.enqueueCommand(vm);
                return ps.readReply(p -> new Version(vm, ps));
            }

            static PacketStream enqueueCommand(VirtualMachineImpl vm) {
                PacketStream ps = new PacketStream(vm, 1, 1);
                if ((vm.traceFlags & 1) != 0) {
                    vm.printTrace("Sending Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Version" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : ""));
                }
                ps.send();
                return ps;
            }

            static Version waitForReply(VirtualMachineImpl vm, PacketStream ps) throws JDWPException {
                ps.waitForReply();
                return new Version(vm, ps);
            }

            private Version(VirtualMachineImpl vm, PacketStream ps) {
                if (vm.traceReceives) {
                    vm.printTrace("Receiving Command(id=" + ps.pkt.id + ") JDWP.VirtualMachine.Version" + (String)(ps.pkt.flags != 0 ? ", FLAGS=" + ps.pkt.flags : "") + (String)(ps.pkt.errorCode != 0 ? ", ERROR CODE=" + ps.pkt.errorCode : ""));
                }
                this.description = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "description(String): " + this.description);
                }
                this.jdwpMajor = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "jdwpMajor(int): " + this.jdwpMajor);
                }
                this.jdwpMinor = ps.readInt();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "jdwpMinor(int): " + this.jdwpMinor);
                }
                this.vmVersion = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "vmVersion(String): " + this.vmVersion);
                }
                this.vmName = ps.readString();
                if (vm.traceReceives) {
                    vm.printReceiveTrace(4, "vmName(String): " + this.vmName);
                }
            }
        }
    }
}

