/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.download.SharedIndexAuthException;
import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.download.SharedIndexDownloadJson;
import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.download.SharedIndexListLookup;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexNetworkCache;
import com.intellij.indexing.shared.download.SharedIndexNetworkCacheScope;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0004\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JX\u0010\u0016\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102/\u0010\u0019\u001a+\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u0001H\u00180\u001a\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006$"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup;", "", "()V", "cache", "com/intellij/indexing/shared/download/SharedIndexLookup$cache$1", "Lcom/intellij/indexing/shared/download/SharedIndexLookup$cache$1;", "cacheSize", "", "downloadIndexList", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indexUrl", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "invalidateCaches", "", "lookupSharedIndex", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "lookupSharedIndexWithoutCache", "ourVersion", "T", "matchItem", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "url", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "parseIndexList", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "CacheEntry", "Companion", "intellij.indexing.shared"})
public final class SharedIndexLookup {
    private final cache.1 cache = new SharedIndexNetworkCache<SharedIndexLookupRequest, CacheEntry>(){

        @NotNull
        protected Instant getCreated(@NotNull CacheEntry $this$created) {
            Intrinsics.checkNotNullParameter((Object)$this$created, (String)"$this$created");
            return $this$created.getComputed();
        }
    };
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final SharedIndexLookupResult lookupSharedIndex(@NotNull SharedIndexLookupRequest request, @NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        CacheEntry cacheEntry = (CacheEntry)this.cache.lookupOrCompute(request, indicator, (Function1)new Function1<CacheEntry, Boolean>(ideVersion){
            final /* synthetic */ SharedIndexInfrastructureVersion $ideVersion;

            public final boolean invoke(@NotNull CacheEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)((Object)it.getIdeVersion()), (Object)((Object)this.$ideVersion));
            }
            {
                this.$ideVersion = sharedIndexInfrastructureVersion;
                super(1);
            }
        }, (Function1)new Function1<SharedIndexNetworkCacheScope, CacheEntry>(this, request, ideVersion, indicator){
            final /* synthetic */ SharedIndexLookup this$0;
            final /* synthetic */ SharedIndexLookupRequest $request;
            final /* synthetic */ SharedIndexInfrastructureVersion $ideVersion;
            final /* synthetic */ ProgressIndicator $indicator;

            @Nullable
            public final CacheEntry invoke(@NotNull SharedIndexNetworkCacheScope $this$lookupOrCompute) {
                SharedIndexLookupResult sharedIndexLookupResult;
                Intrinsics.checkNotNullParameter((Object)$this$lookupOrCompute, (String)"$receiver");
                try {
                    sharedIndexLookupResult = SharedIndexLookup.access$lookupSharedIndexWithoutCache(this.this$0, this.$request, this.$ideVersion, this.$indicator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    if (t instanceof SharedIndexAuthException) {
                        throw t;
                    }
                    this.$indicator.checkCanceled();
                    SharedIndexLookup.access$getLOG$cp().warn("Failed to lookup shared index for " + this.$request + ". " + t.getMessage(), t);
                    sharedIndexLookupResult = null;
                }
                SharedIndexLookupResult result2 = sharedIndexLookupResult;
                return new CacheEntry(this.$ideVersion, $this$lookupOrCompute.getNow(), result2);
            }
            {
                this.this$0 = sharedIndexLookup;
                this.$request = sharedIndexLookupRequest;
                this.$ideVersion = sharedIndexInfrastructureVersion;
                this.$indicator = progressIndicator;
                super(1);
            }
        });
        return cacheEntry != null ? cacheEntry.getValue() : null;
    }

    private final SharedIndexLookupResult lookupSharedIndexWithoutCache(SharedIndexLookupRequest request, SharedIndexInfrastructureVersion ourVersion, ProgressIndicator indicator) {
        return (SharedIndexLookupResult)this.lookupSharedIndexWithoutCache(request, indicator, (Function2)new Function2<String, List<? extends SharedIndexLookupResult>, SharedIndexLookupResult>(ourVersion){
            final /* synthetic */ SharedIndexInfrastructureVersion $ourVersion;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final SharedIndexLookupResult invoke(@NotNull String $noName_0, @NotNull List<SharedIndexLookupResult> results) {
                void var3_3;
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(results, (String)"results");
                SharedIndexLookupResult bestSuitableIndex = SharedIndexMetadata.Companion.selectBestSuitableIndex(this.$ourVersion, results);
                if (bestSuitableIndex == null && SharedIndexLookup.access$getLOG$cp().isTraceEnabled()) {
                    void $this$buildString;
                    boolean bl = false;
                    boolean bl2 = false;
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    StringBuilder stringBuilder2 = stringBuilder;
                    Logger logger = SharedIndexLookup.access$getLOG$cp();
                    boolean bl5 = false;
                    void var10_12 = $this$buildString;
                    String string = "Among " + results.size() + " candidate indexes no one is compatible with current IDE";
                    boolean bl6 = false;
                    StringBuilder stringBuilder3 = var10_12.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                    StringBuilder stringBuilder4 = stringBuilder3;
                    boolean bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                    var10_12 = $this$buildString;
                    string = "Current IDE version:";
                    bl6 = false;
                    StringBuilder stringBuilder5 = var10_12.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                    stringBuilder4 = stringBuilder5;
                    bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                    var10_12 = $this$buildString;
                    string = "    " + (Object)((Object)this.$ourVersion);
                    bl6 = false;
                    StringBuilder stringBuilder6 = var10_12.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                    stringBuilder4 = stringBuilder6;
                    bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                    var10_12 = $this$buildString;
                    string = "Candidates:";
                    bl6 = false;
                    StringBuilder stringBuilder7 = var10_12.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                    stringBuilder4 = stringBuilder7;
                    bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                    boolean bl8 = false;
                    for (SharedIndexLookupResult result2 : (Iterable)results) {
                        void index2;
                        stringBuilder4 = $this$buildString;
                        String string2 = (int)(index2 + true) + ") Result : " + result2;
                        boolean bl9 = false;
                        StringBuilder stringBuilder8 = stringBuilder4.append(string2);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
                        StringBuilder stringBuilder9 = stringBuilder8;
                        boolean bl10 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append('\\n')");
                        stringBuilder4 = $this$buildString;
                        string2 = (int)(index2 + true) + ") Version: " + (Object)((Object)result2.getIndexVersion());
                        bl9 = false;
                        StringBuilder stringBuilder10 = stringBuilder4.append(string2);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
                        stringBuilder9 = stringBuilder10;
                        bl10 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append('\\n')");
                        ++index2;
                    }
                    Unit unit = Unit.INSTANCE;
                    String string3 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                    logger.trace(string3);
                }
                return var3_3;
            }
            {
                this.$ourVersion = sharedIndexInfrastructureVersion;
                super(2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final <T> T lookupSharedIndexWithoutCache(@NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator, @NotNull Function2<? super String, ? super List<SharedIndexLookupResult>, ? extends T> matchItem) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(matchItem, (String)"matchItem");
        boolean $i$f$service22 = false;
        Class<SharedIndexListLookup> serviceClass$iv = SharedIndexListLookup.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        List<String> urlsToProcess = ((SharedIndexListLookup)object).collectUrlsToProcess(request, indicator);
        Collection $i$f$service22 = urlsToProcess;
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv.pushState();
        try {
            void $this$forEachWithProgress$iv;
            boolean bl = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv = $this$forEachWithProgress$iv.size();
            boolean bl2 = false;
            for (Object y$iv : (Iterable)$this$forEachWithProgress$iv) {
                void subIndicator;
                void i$iv;
                indicator.checkCanceled();
                double lowerBound$iv = (double)i$iv / size$iv;
                double upperBound$iv = (double)(i$iv + true) / size$iv;
                indicator.setFraction(lowerBound$iv);
                String prevText$iv = indicator.getText();
                String prevText2$iv = indicator.getText2();
                ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv, (double)upperBound$iv);
                String url = (String)y$iv;
                boolean bl3 = false;
                subIndicator.setText2(url);
                String indexUrl = StringsKt.trim((String)url, (char[])new char[]{'/'}) + "/index.json.xz";
                List<SharedIndexLookupResult> results = this.downloadIndexList(request, indexUrl, (ProgressIndicator)subIndicator);
                subIndicator.checkCanceled();
                Object object2 = matchItem.invoke((Object)url, results);
                if (object2 != null) {
                    Object object3 = object2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object best = object3;
                    boolean bl6 = false;
                    LOG.info("Selected pre-built shared index " + best + " from " + url + " for " + request);
                    Object object4 = best;
                    return (T)object4;
                }
                indicator.setText(prevText$iv);
                indicator.setText2(prevText2$iv);
                ++i$iv;
            }
            indicator.setFraction(1.0);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
            $this$withPushPop$iv$iv.popState();
        }
        LOG.debug("No matching shared indexes are found for " + request + ". The following URLs were tried: " + CollectionsKt.joinToString$default((Iterable)urlsToProcess, null, null, null, (int)0, null, null, (int)63, null));
        return null;
    }

    public final void invalidateCaches() {
        boolean $i$f$serviceIfCreated = false;
        SharedIndexListLookup sharedIndexListLookup = (SharedIndexListLookup)ApplicationManager.getApplication().getServiceIfCreated(SharedIndexListLookup.class);
        if (sharedIndexListLookup != null) {
            sharedIndexListLookup.invalidateCaches();
        }
        this.cache.invalidateCaches();
    }

    @VisibleForTesting
    public final int cacheSize() {
        return this.cache.cacheSize();
    }

    @VisibleForTesting
    @NotNull
    public final List<SharedIndexLookupResult> downloadIndexList(@NotNull SharedIndexLookupRequest request, @NotNull String indexUrl, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ObjectNode objectNode = SharedIndexDownloadJson.INSTANCE.downloadJsonXz(request, indexUrl, indicator);
        if (objectNode == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        ObjectNode json = objectNode;
        return this.parseIndexList(json, indexUrl, request);
    }

    @VisibleForTesting
    @NotNull
    public final List<SharedIndexLookupResult> parseIndexList(@NotNull ObjectNode json, @NotNull String indexUrl, @NotNull SharedIndexLookupRequest request) {
        String listVersion;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        JsonNode jsonNode = json.get("list_version");
        String string = listVersion = jsonNode != null ? jsonNode.asText() : null;
        if (Intrinsics.areEqual((Object)listVersion, (Object)"1") ^ true) {
            LOG.trace("Index data version mismatch. The current version is " + listVersion + " in " + indexUrl + " for " + request);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode2 = json.get("entries");
        if (!(jsonNode2 instanceof ArrayNode)) {
            jsonNode2 = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode2;
        if (arrayNode == null) {
            SharedIndexLookup sharedIndexLookup = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedIndexLookup $this$run = sharedIndexLookup;
            boolean bl3 = false;
            LOG.trace("Index data format is incomplete. Missing 'entries' element in " + indexUrl + " for " + request);
            boolean bl4 = false;
            return CollectionsKt.emptyList();
        }
        ArrayNode entries = arrayNode;
        Iterator iterator = entries.elements();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"entries.elements()");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<JsonNode, SharedIndexLookupResult>(this, indexUrl, request){
            final /* synthetic */ SharedIndexLookup this$0;
            final /* synthetic */ String $indexUrl;
            final /* synthetic */ SharedIndexLookupRequest $request;

            @Nullable
            public final SharedIndexLookupResult invoke(JsonNode node) {
                boolean bl;
                Object object;
                Object object2;
                if (!(node instanceof ObjectNode)) {
                    return null;
                }
                Object object3 = node.get("url");
                if (object3 == null || (object3 = object3.asText()) == null) {
                    return null;
                }
                String string = SharedIndexLookup.Companion.resolveRelativeUrl(this.$indexUrl, (String)object3);
                if (string == null) {
                    return null;
                }
                String url = string;
                Object object4 = node.get("sha256");
                if (object4 == null || (object4 = object4.asText()) == null) {
                    return null;
                }
                Object sha = object4;
                JsonNode jsonNode = node.get("size");
                if (jsonNode == null) {
                    return null;
                }
                long size = jsonNode.asLong();
                JsonNode jsonNode2 = node.get("metadata");
                if (!(jsonNode2 instanceof ObjectNode)) {
                    jsonNode2 = null;
                }
                ObjectNode objectNode = (ObjectNode)jsonNode2;
                if (objectNode == null) {
                    return null;
                }
                ObjectNode indexVersionJson = objectNode;
                SharedIndexLookup sharedIndexLookup = this.this$0;
                boolean bl2 = false;
                try {
                    SharedIndexLineup sharedIndexLineup;
                    object2 = Result.Companion;
                    SharedIndexLookup $this$runCatching = sharedIndexLookup;
                    boolean bl3 = false;
                    JsonNode jsonNode3 = node.get("lineup");
                    if (!(jsonNode3 instanceof ObjectNode)) {
                        jsonNode3 = null;
                    }
                    ObjectNode objectNode2 = (ObjectNode)jsonNode3;
                    if (objectNode2 != null) {
                        object = objectNode2;
                        bl = false;
                        boolean bl4 = false;
                        ObjectNode it = object;
                        boolean bl5 = false;
                        String string2 = it.get("name").asText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.get(\"name\").asText()");
                        sharedIndexLineup = new SharedIndexLineup(string2, it.get("creationStamp").asLong(), it.get("indexedFileCount").asInt());
                    } else {
                        sharedIndexLineup = null;
                    }
                    SharedIndexLineup sharedIndexLineup2 = sharedIndexLineup;
                    boolean bl6 = false;
                    object2 = Result.constructor-impl(sharedIndexLineup2);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl7 = false;
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                sharedIndexLookup = object2;
                bl2 = false;
                boolean bl8 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)sharedIndexLookup);
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    object = throwable2;
                    bl = false;
                    Object it = object;
                    boolean bl11 = false;
                    SharedIndexLookup $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(SharedIndexLookup.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.info((Throwable)it);
                }
                bl2 = false;
                SharedIndexLineup lineup = (SharedIndexLineup)((Object)(Result.isFailure-impl((Object)sharedIndexLookup) ? null : sharedIndexLookup));
                JsonNode jsonNode4 = node.get("format");
                SharedIndexCompression sharedIndexCompression = SharedIndexCompression.Companion.findByType(jsonNode4 != null ? jsonNode4.asText() : null);
                if (sharedIndexCompression == null) {
                    return null;
                }
                SharedIndexCompression compression = sharedIndexCompression;
                SharedIndexMetadata sharedIndexMetadata = SharedIndexMetadata.Companion.tryReadSharedIndexMetadata(indexVersionJson);
                if (sharedIndexMetadata == null) {
                    return null;
                }
                SharedIndexMetadata indexVersion2 = sharedIndexMetadata;
                return new SharedIndexLookupResult(this.$request, url, (String)sha, size, compression, indexVersion2, lineup);
            }
            {
                this.this$0 = sharedIndexLookup;
                this.$indexUrl = string;
                this.$request = sharedIndexLookupRequest;
                super(1);
            }
        })));
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexLookup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ SharedIndexLookupResult access$lookupSharedIndexWithoutCache(SharedIndexLookup $this, SharedIndexLookupRequest request, SharedIndexInfrastructureVersion ourVersion, ProgressIndicator indicator) {
        return $this.lookupSharedIndexWithoutCache(request, ourVersion, indicator);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup$CacheEntry;", "", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "computed", "Ljava/time/Instant;", "value", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "(Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;Ljava/time/Instant;Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;)V", "getComputed", "()Ljava/time/Instant;", "getIdeVersion", "()Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "getValue", "()Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared"})
    private static final class CacheEntry {
        @NotNull
        private final SharedIndexInfrastructureVersion ideVersion;
        @NotNull
        private final Instant computed;
        @Nullable
        private final SharedIndexLookupResult value;

        @NotNull
        public final SharedIndexInfrastructureVersion getIdeVersion() {
            return this.ideVersion;
        }

        @NotNull
        public final Instant getComputed() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexLookupResult getValue() {
            return this.value;
        }

        public CacheEntry(@NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull Instant computed, @Nullable SharedIndexLookupResult value) {
            Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            this.ideVersion = ideVersion;
            this.computed = computed;
            this.value = value;
        }

        @NotNull
        public final SharedIndexInfrastructureVersion component1() {
            return this.ideVersion;
        }

        @NotNull
        public final Instant component2() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexLookupResult component3() {
            return this.value;
        }

        @NotNull
        public final CacheEntry copy(@NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull Instant computed, @Nullable SharedIndexLookupResult value) {
            Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            return new CacheEntry(ideVersion, computed, value);
        }

        public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion, Instant instant, SharedIndexLookupResult sharedIndexLookupResult, int n, Object object) {
            if ((n & 1) != 0) {
                sharedIndexInfrastructureVersion = cacheEntry.ideVersion;
            }
            if ((n & 2) != 0) {
                instant = cacheEntry.computed;
            }
            if ((n & 4) != 0) {
                sharedIndexLookupResult = cacheEntry.value;
            }
            return cacheEntry.copy(sharedIndexInfrastructureVersion, instant, sharedIndexLookupResult);
        }

        @NotNull
        public String toString() {
            return "CacheEntry(ideVersion=" + (Object)((Object)this.ideVersion) + ", computed=" + this.computed + ", value=" + this.value + ")";
        }

        public int hashCode() {
            SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = this.ideVersion;
            Instant instant = this.computed;
            SharedIndexLookupResult sharedIndexLookupResult = this.value;
            return ((sharedIndexInfrastructureVersion != null ? ((Object)((Object)sharedIndexInfrastructureVersion)).hashCode() : 0) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (sharedIndexLookupResult != null ? ((Object)sharedIndexLookupResult).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CacheEntry)) break block3;
                    CacheEntry cacheEntry = (CacheEntry)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.ideVersion), (Object)((Object)cacheEntry.ideVersion)) || !Intrinsics.areEqual((Object)this.computed, (Object)cacheEntry.computed) || !Intrinsics.areEqual((Object)this.value, (Object)cacheEntry.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "resolveRelativeUrl", "", "indexUrl", "relative", "intellij.indexing.shared"})
    public static final class Companion {
        @Nullable
        public final String resolveRelativeUrl(@NotNull String indexUrl, @NotNull String relative) {
            String string;
            Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
            Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
            if (StringsKt.startsWith$default((String)relative, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"https://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"file:/", (boolean)false, (int)2, null)) {
                return relative;
            }
            try {
                string = URI.create(StringsKt.trimEnd((String)indexUrl, (char[])new char[]{'/'})).resolve(relative).toURL().toExternalForm();
            }
            catch (Throwable t) {
                LOG.warn("Failed to resolve relative URL " + relative + " with base " + indexUrl);
                string = null;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

