/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.download.SharedIndexDownloadHistoryStore;
import com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex;
import com.intellij.indexing.shared.platform.impl.CompositeInvertedIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.HashIndexKey;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.indexing.shared.platform.impl.SharedIndexFileIndexingStatusProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedIndexInfrastructure
implements FileBasedIndexInfrastructureExtension {
    public static final int SHARED_INDEX_INFRASTRUCTURE_VERSION = 6 + (FileContentHashIndex.USE_VFS_ATTR_BASED_FORWARD_INDEX ? 1 : 0);
    private static final int REBUILD_COUNTER = 1;
    private static final int NULL_VERSION = -1;
    private static final String SHARED_INDEX_INFRASTRUCTURE_VERSION_FILE_NAME = "version";
    private static final Logger LOG = Logger.getInstance(SharedIndexInfrastructure.class);

    public FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor createFileIndexingStatusProcessor(@NotNull Project project) {
        if (project == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(0);
        }
        return new SharedIndexFileIndexingStatusProcessor(project);
    }

    public <K, V> UpdatableIndex<K, V, FileContent> combineIndex(@NotNull FileBasedIndexExtension<K, V> indexExtension, @NotNull UpdatableIndex<K, V, FileContent> baseIndex) throws IOException {
        if (indexExtension == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(1);
        }
        if (baseIndex == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(2);
        }
        return indexExtension.dependsOnFileContent() ? new CompositeInvertedIndex<K, V>(indexExtension.getName(), baseIndex) : null;
    }

    public void onFileBasedIndexVersionChanged(@NotNull ID<?, ?> indexId2) {
        if (indexId2 == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(3);
        }
    }

    public void onStubIndexVersionChanged(@NotNull StubIndexKey<?, ?> indexId2) {
        if (indexId2 == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public FileBasedIndexInfrastructureExtension.InitializationResult initialize(@Nullable(value="null if default") @Nullable(value="null if default") String indexLayoutId) {
        FileBasedIndexInfrastructureExtension.InitializationResult versionReadResult;
        int version = SharedIndexInfrastructure.readPersistedVersion();
        if (FileContentHashIndex.USE_VFS_ATTR_BASED_FORWARD_INDEX) {
            try {
                AttrBasedFileContentHashForwardIndex.readVersions();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (version == -1 && !Files.exists(SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot(), new LinkOption[0])) {
            this.persistVersion();
            versionReadResult = FileBasedIndexInfrastructureExtension.InitializationResult.SUCCESSFULLY;
        } else if (version != this.getVersion()) {
            LOG.info("Shared index version updated from " + version + " to " + this.getVersion());
            versionReadResult = FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED;
            try {
                this.resetPersistentState();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        } else {
            versionReadResult = FileBasedIndexInfrastructureExtension.InitializationResult.SUCCESSFULLY;
        }
        FileBasedIndexInfrastructureExtension.InitializationResult initializationResult = SharedIndexChunkConfiguration.getInstance().initialize();
        FileBasedIndexInfrastructureExtension.InitializationResult initializationResult2 = versionReadResult == FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED || initializationResult == FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED ? FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED : FileBasedIndexInfrastructureExtension.InitializationResult.SUCCESSFULLY;
        if (initializationResult2 == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(5);
        }
        return initializationResult2;
    }

    @NotNull
    public String getPersistentStateRoot() {
        return "shared_indexes";
    }

    public void resetPersistentState() {
        ((SharedIndexDownloadHistoryStore)((Object)ApplicationManager.getApplication().getService(SharedIndexDownloadHistoryStore.class))).reset();
        Path sharedIndexConfigurationRoot = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot();
        try (Stream<Path> stream = Files.list(sharedIndexConfigurationRoot);){
            stream.forEach(p -> {
                String fileName = p.getFileName().toString();
                if (fileName.startsWith("shared.index.hashes.")) {
                    FileUtil.deleteWithRenaming((File)p.toFile());
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        try {
            SharedIndexChunkConfiguration.getInstance().dropMutableChunkStorage();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        this.persistVersion();
        LOG.info("Shared index persistent data has been cleared");
    }

    public void resetPersistentState(@NotNull ID<?, ?> indexId2) {
        if (indexId2 == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(6);
        }
        HashIndexKey hashIndexKey = HashIndexKey.createHashIndexKey(indexId2);
        if (FileContentHashIndex.USE_VFS_ATTR_BASED_FORWARD_INDEX) {
            AttrBasedFileContentHashForwardIndex.bumpForwardIndexVersion(hashIndexKey);
        }
        FileUtil.deleteWithRenaming((File)FileContentHashIndex.getFileContentHashIndexDir(hashIndexKey).toFile());
    }

    public synchronized void shutdown() {
        SharedIndexInfrastructure.runSafe(() -> {
            SharedIndexChunkConfiguration sharedIndexChunkConfiguration = SharedIndexChunkConfiguration.getInstanceIfCreated();
            if (sharedIndexChunkConfiguration != null) {
                sharedIndexChunkConfiguration.shutdown();
            }
        });
        SharedIndexInfrastructure.runSafe(AttrBasedFileContentHashForwardIndex::disposeAllCaches);
    }

    public int getVersion() {
        return SHARED_INDEX_INFRASTRUCTURE_VERSION + 1;
    }

    private void persistVersion() {
        SharedIndexInfrastructure.persistVersion(this.getVersion());
        try {
            if (FileContentHashIndex.USE_VFS_ATTR_BASED_FORWARD_INDEX) {
                AttrBasedFileContentHashForwardIndex.bumpBaseVersion();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static void persistVersion(int version) {
        try {
            Files.createDirectories(SharedIndexInfrastructure.getVersionFile().getParent(), new FileAttribute[0]);
            try (DataOutputStream os = (DataOutputStream)FileUtilRt.doIOOperation(lastAttempt -> {
                try {
                    return new DataOutputStream(Files.newOutputStream(SharedIndexInfrastructure.getVersionFile(), new OpenOption[0]));
                }
                catch (IOException ex) {
                    if (lastAttempt) {
                        throw ex;
                    }
                    return null;
                }
            });){
                assert (os != null);
                DataInputOutputUtil.writeINT((DataOutput)os, (int)version);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static int readPersistedVersion() {
        int n;
        Path versionFile = SharedIndexInfrastructure.getVersionFile();
        DataInputStream in = new DataInputStream(Files.newInputStream(versionFile, new OpenOption[0]));
        try {
            n = DataInputOutputUtil.readINT((DataInput)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        in.close();
        return n;
    }

    @NotNull
    private static Path getVersionFile() {
        Path path = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SHARED_INDEX_INFRASTRUCTURE_VERSION_FILE_NAME);
        if (path == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(7);
        }
        return path;
    }

    private static void runSafe(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndex";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/SharedIndexInfrastructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexInfrastructure";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initialize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileIndexingStatusProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "combineIndex";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onFileBasedIndexVersionChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onStubIndexVersionChanged";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetPersistentState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

