/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util.zipFs;

import com.intellij.indexing.shared.util.zipFs.UncompressedZipEntryFileAttributeView;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipEntryFileAttributes;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileStore;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipPath;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class UncompressedZipFileSystemProvider
extends FileSystemProvider {
    public static final UncompressedZipFileSystemProvider INSTANCE = new UncompressedZipFileSystemProvider();

    private UncompressedZipFileSystemProvider() {
    }

    @Override
    public String getScheme() {
        return "zip0";
    }

    public String toString() {
        return "UncompressedZipFileSystemProvider{}";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        throw new UnsupportedOperationException("newFileSystem operation is not supported for " + this);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        throw new UnsupportedOperationException("getFileSystem operation is not supported for " + this);
    }

    @NotNull
    public UncompressedZipFileSystem newFileSystem(Path uncompressedZip2) throws IOException {
        FileSystem fileSystem = this.newFileSystem(uncompressedZip2, Collections.emptyMap());
        if (fileSystem == null) {
            UncompressedZipFileSystemProvider.$$$reportNull$$$0(0);
        }
        return fileSystem;
    }

    @Override
    public UncompressedZipFileSystem newFileSystem(Path uncompressedZip2, Map<String, ?> env) throws IOException {
        return new UncompressedZipFileSystem(uncompressedZip2, this);
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        if (uri == null) {
            UncompressedZipFileSystemProvider.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException("getPath operation is not supported for " + this);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.newFileChannel(path, options, attrs);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        assert (options != null);
        UncompressedZipFileSystem.ZipTreeNode node = UncompressedZipFileSystemProvider.find(path);
        if (node.isDirectory()) {
            throw new IllegalArgumentException(path.toString());
        }
        @NotNull UncompressedZipFileSystem.LightZipEntry entry = node.getEntry();
        return ((UncompressedZipFileSystem)path.getFileSystem()).openChannel(path.toString(), entry);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(final Path dir, final DirectoryStream.Filter<? super Path> filter) throws IOException {
        final UncompressedZipFileSystem.ZipTreeNode element = UncompressedZipFileSystemProvider.find(dir);
        if (!element.isDirectory()) {
            throw new NotDirectoryException(dir.toString());
        }
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return element.getChildNames().stream().map(n -> dir.resolve((String)n)).filter(p -> {
                    try {
                        return filter.accept(p);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
        throw new UnsupportedOperationException("Create directory " + dir + " is not supported for " + this);
    }

    @Override
    public void delete(Path path) throws IOException {
        throw new IOException("Create " + path + " is not supported for " + this);
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) {
        throw new UnsupportedOperationException("Copy " + source + " to " + target + " is not supported for " + this);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) {
        throw new UnsupportedOperationException("Move " + source + " to " + target + " is not supported for " + this);
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        if (path1.getFileSystem().provider() != path2.getFileSystem().provider()) {
            return false;
        }
        UncompressedZipFileSystem system1 = (UncompressedZipFileSystem)path1.getFileSystem();
        UncompressedZipFileSystem system2 = (UncompressedZipFileSystem)path2.getFileSystem();
        if (!Files.isSameFile(system1.getUncompressedZipPath(), system2.getUncompressedZipPath())) {
            return false;
        }
        UncompressedZipPath absolutePath1 = (UncompressedZipPath)path1.toAbsolutePath();
        UncompressedZipPath absolutePath2 = (UncompressedZipPath)path2.toAbsolutePath();
        return Arrays.equals(absolutePath1.getNameElements(), absolutePath2.getNameElements());
    }

    @Override
    public boolean isHidden(Path path) {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) {
        return new UncompressedZipFileStore((UncompressedZipFileSystem)path.getFileSystem());
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        if (ArrayUtil.contains((Object)((Object)AccessMode.WRITE), (Object[])new Comparable[]{path}) || ArrayUtil.contains((Object)((Object)AccessMode.EXECUTE), (Object[])new Comparable[]{path})) {
            throw new AccessDeniedException(path.toString());
        }
        UncompressedZipFileSystemProvider.find(path);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (type == BasicFileAttributeView.class) {
            return (V)((FileAttributeView)type.cast(new UncompressedZipEntryFileAttributeView((UncompressedZipPath)path)));
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class) {
            return (A)((BasicFileAttributes)type.cast(new UncompressedZipEntryFileAttributes((UncompressedZipPath)path)));
        }
        throw new UnsupportedOperationException("Only basic attributes are supported, but were: " + (type != null ? type.getName() : null) + " for " + this);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
        throw new UnsupportedOperationException("Read attributes for " + path + " is not supported for " + this);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        throw new UnsupportedOperationException("Set attributes for " + path + " is not supported for " + this);
    }

    @NotNull
    static UncompressedZipFileSystem.ZipTreeNode find(@NotNull Path path) throws IOException {
        if (path == null) {
            UncompressedZipFileSystemProvider.$$$reportNull$$$0(2);
        }
        UncompressedZipPath absoluteDir = (UncompressedZipPath)path.toAbsolutePath();
        String[] elements = absoluteDir.getNameElements();
        UncompressedZipFileSystem.ZipTreeNode currentNode = absoluteDir.getFileSystem().getRoot();
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            if ((currentNode = currentNode.getChild(element)) != null && (i >= elements.length - 1 || currentNode.isDirectory())) continue;
            throw new NoSuchFileException(path.toString());
        }
        UncompressedZipFileSystem.ZipTreeNode zipTreeNode = currentNode;
        if (zipTreeNode == null) {
            UncompressedZipFileSystemProvider.$$$reportNull$$$0(3);
        }
        return zipTreeNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystemProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newFileSystem";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystemProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

