/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.AndPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionHandler
extends MatchingHandler {
    @NotNull
    private final String name;
    private final int maxOccurs;
    private final int minOccurs;
    private final boolean greedy;
    private boolean target;
    private MatchPredicate predicate;
    private MatchingHandler matchHandler;
    private boolean subtype;
    private boolean strictSubtype;
    private int matchedOccurs;
    private int totalMatchedOccurs;
    private MatchResultImpl myNestedResult;
    private boolean myRepeatedVar;
    private static final NodeFilter VARS_DELIM_FILTER = element -> {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        if (profile == null) {
            return false;
        }
        return profile.canBeVarDelimiter(element);
    };

    public SubstitutionHandler(@NotNull String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        if (name == null) {
            SubstitutionHandler.$$$reportNull$$$0(0);
        }
        this.totalMatchedOccurs = -1;
        if (minOccurs < 0) {
            throw new IllegalArgumentException("minOccurs must be greater or equal to 0");
        }
        if (minOccurs > maxOccurs) {
            throw new IllegalArgumentException("maxOccurs must be greater equal to minOccurs");
        }
        this.name = name;
        this.maxOccurs = maxOccurs;
        this.minOccurs = minOccurs;
        this.target = target;
        this.greedy = greedy;
    }

    public boolean isSubtype() {
        return this.subtype;
    }

    public boolean isStrictSubtype() {
        return this.strictSubtype;
    }

    public void setStrictSubtype(boolean strictSubtype) {
        this.strictSubtype = strictSubtype;
    }

    public void setSubtype(boolean subtype) {
        this.subtype = subtype;
    }

    public void setPredicate(@NotNull MatchPredicate handler) {
        if (handler == null) {
            SubstitutionHandler.$$$reportNull$$$0(1);
        }
        this.predicate = handler;
    }

    public MatchPredicate getPredicate() {
        return this.predicate;
    }

    @Nullable
    public RegExpPredicate findRegExpPredicate() {
        return SubstitutionHandler.findRegExpPredicate(this.getPredicate());
    }

    public void setRepeatedVar(boolean repeatedVar) {
        this.myRepeatedVar = repeatedVar;
    }

    private static RegExpPredicate findRegExpPredicate(MatchPredicate start) {
        if (start == null) {
            return null;
        }
        if (start instanceof RegExpPredicate) {
            return (RegExpPredicate)start;
        }
        if (start instanceof AndPredicate) {
            AndPredicate binary = (AndPredicate)start;
            RegExpPredicate result = SubstitutionHandler.findRegExpPredicate(binary.getFirst());
            if (result != null) {
                return result;
            }
            return SubstitutionHandler.findRegExpPredicate(binary.getSecond());
        }
        if (start instanceof NotPredicate) {
            return null;
        }
        return null;
    }

    private boolean validateOneMatch(@NotNull PsiElement match, int start, int end, @NotNull MatchResult result, @NotNull MatchContext matchContext) {
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SubstitutionHandler.$$$reportNull$$$0(3);
        }
        if (matchContext == null) {
            SubstitutionHandler.$$$reportNull$$$0(4);
        }
        if (!this.myRepeatedVar) {
            return true;
        }
        if (start == 0 && end == -1 && result.getStart() == 0 && result.getEnd() == -1) {
            return matchContext.getMatcher().match(match, result.getMatch());
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        assert (profile != null);
        return profile.getText(match, start, end).equals(result.getMatchImage());
    }

    public boolean validate(PsiElement match, @NotNull MatchContext context) {
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(5);
        }
        return this.validate(match, 0, -1, context);
    }

    public boolean validate(PsiElement match, int start, int end, @NotNull MatchContext context) {
        MatchResultImpl previous;
        MatchResult result;
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(6);
        }
        if (match == null || this.predicate != null && !this.predicate.match(match, start, end, context)) {
            return false;
        }
        MatchResult matchResult = result = context.hasResult() ? context.getResult().findChild(this.name) : null;
        if (result == null && this.myNestedResult != null) {
            result = this.myNestedResult.findChild(this.name);
        }
        if (result == null && (previous = context.getPreviousResult()) != null) {
            result = previous.findChild(this.name);
        }
        if (result != null) {
            if (this.minOccurs == 1 && this.maxOccurs == 1) {
                return this.validateOneMatch(match, start, end, result, context);
            }
            if (this.maxOccurs > 1 && this.totalMatchedOccurs != -1) {
                if (result.isMultipleMatch()) {
                    List<MatchResult> children = result.getChildren();
                    int size = children.size();
                    if (this.matchedOccurs >= size) {
                        return false;
                    }
                    if (size != 0) {
                        result = children.get(this.matchedOccurs);
                    }
                }
                return this.validateOneMatch(match, start, end, result, context);
            }
        }
        return true;
    }

    @Override
    public boolean match(PsiElement node, PsiElement match, @NotNull MatchContext context) {
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(7);
        }
        if (!super.match(node, match, context)) {
            return false;
        }
        return this.matchHandler == null ? context.getMatcher().match(node, match) : this.matchHandler.match(node, match, context);
    }

    public void addResult(@NotNull PsiElement match, @NotNull MatchContext context) {
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(9);
        }
        this.addResult(match, 0, -1, context);
    }

    public void addResult(@NotNull PsiElement match, int start, int end, @NotNull MatchContext context) {
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(11);
        }
        if (this.totalMatchedOccurs == -1) {
            MatchResultImpl matchResult = context.getResult();
            MatchResultImpl substitution = matchResult.getChild(this.name);
            if (substitution == null) {
                matchResult.addChild(this.createMatch(match, start, end));
            } else if (this.maxOccurs > 1 || this.target && !this.myRepeatedVar) {
                MatchResultImpl result = this.createMatch(match, start, end);
                if (!substitution.isMultipleMatch()) {
                    MatchResultImpl sonresult = new MatchResultImpl(substitution.getName(), substitution.getMatchImage(), substitution.getMatchRef(), substitution.getStart(), substitution.getEnd(), this.target);
                    substitution.setMatchRef(new SmartPsiPointer(match));
                    substitution.setMultipleMatch(true);
                    if (substitution.isScopeMatch()) {
                        substitution.setScopeMatch(false);
                        sonresult.setScopeMatch(true);
                        for (MatchResult r : substitution.getChildren()) {
                            sonresult.addChild(r);
                        }
                        substitution.removeChildren();
                    }
                    substitution.addChild(sonresult);
                }
                substitution.addChild(result);
            }
        }
    }

    public boolean handle(PsiElement match, @NotNull MatchContext context) {
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(12);
        }
        return this.handle(match, 0, -1, context);
    }

    public boolean handle(PsiElement match, int start, int end, @NotNull MatchContext context) {
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(13);
        }
        if (!this.validate(match, start, end, context)) {
            this.myNestedResult = null;
            return false;
        }
        if (!"__context__".equals(this.name)) {
            this.addResult(match, start, end, context);
        }
        return true;
    }

    @NotNull
    private MatchResultImpl createMatch(@NotNull PsiElement match, int start, int end) {
        MatchResultImpl result;
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(14);
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        assert (profile != null);
        String image = profile.getText(match, start, end);
        SmartPsiPointer ref = new SmartPsiPointer(match);
        MatchResultImpl matchResultImpl = result = this.myNestedResult == null ? new MatchResultImpl(this.name, image, ref, start, end, this.target) : this.myNestedResult;
        if (this.myNestedResult != null) {
            this.myNestedResult.setName(this.name);
            this.myNestedResult.setMatchImage(image);
            this.myNestedResult.setMatchRef(ref);
            this.myNestedResult.setStart(start);
            this.myNestedResult.setEnd(end);
            this.myNestedResult.setTarget(this.target);
            this.myNestedResult = null;
        }
        MatchResultImpl matchResultImpl2 = result;
        if (matchResultImpl2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(15);
        }
        return matchResultImpl2;
    }

    @Override
    public boolean validate(@NotNull MatchContext context, int matchedOccurs) {
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(16);
        }
        if (this.target) {
            return matchedOccurs > 0;
        }
        if (this.minOccurs > matchedOccurs) {
            return false;
        }
        return this.maxOccurs >= matchedOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    private void removeLastResults(int numberOfResults, @NotNull MatchContext context) {
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(17);
        }
        if (numberOfResults == 0) {
            return;
        }
        MatchResultImpl substitution = context.getResult().getChild(this.name);
        if (substitution != null) {
            if (substitution.hasChildren()) {
                while (numberOfResults > 0) {
                    --numberOfResults;
                    MatchResult matchResult = substitution.removeLastChild();
                    context.removeMatchedNode(matchResult.getMatch());
                }
                if (!substitution.hasChildren()) {
                    context.getResult().removeChild(this.name);
                }
            } else {
                MatchResult matchResult = context.getResult().removeChild(this.name);
                assert (matchResult != null);
                context.removeMatchedNode(matchResult.getMatch());
            }
        }
    }

    @Override
    public boolean matchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes, @NotNull MatchContext context) {
        if (patternNodes == null) {
            SubstitutionHandler.$$$reportNull$$$0(18);
        }
        if (matchNodes == null) {
            SubstitutionHandler.$$$reportNull$$$0(19);
        }
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(20);
        }
        return this.doMatchSequentially(patternNodes, matchNodes, context);
    }

    protected boolean doMatchSequentiallyBySimpleHandler(NodeIterator patternNodes, NodeIterator matchNodes, @NotNull MatchContext context) {
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(21);
        }
        boolean oldValue = context.shouldRecursivelyMatch();
        context.setShouldRecursivelyMatch(false);
        boolean result = super.matchSequentially(patternNodes, matchNodes, context);
        context.setShouldRecursivelyMatch(oldValue);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doMatchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes, @NotNull MatchContext context) {
        if (patternNodes == null) {
            SubstitutionHandler.$$$reportNull$$$0(22);
        }
        if (matchNodes == null) {
            SubstitutionHandler.$$$reportNull$$$0(23);
        }
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(24);
        }
        int previousMatchedOccurs = this.matchedOccurs;
        FilteringNodeIterator fNodes = new FilteringNodeIterator(matchNodes, VARS_DELIM_FILTER);
        try {
            MatchingHandler nextHandler;
            PsiElement current2;
            CompiledPattern pattern = context.getPattern();
            PsiElement currentPatternNode = patternNodes.current();
            MatchingHandler handler = pattern.getHandler(currentPatternNode);
            this.matchedOccurs = 0;
            boolean flag = false;
            SmartList matchedNodes = new SmartList();
            while (fNodes.hasNext() && (this.matchedOccurs < this.minOccurs || this.target && !this.myRepeatedVar && !(handler instanceof TopLevelMatchingHandler))) {
                current2 = matchNodes.current();
                if (handler.match(currentPatternNode, current2, context)) {
                    matchedNodes.add(current2);
                    ++this.matchedOccurs;
                } else if (handler instanceof TopLevelMatchingHandler && this.matchedOccurs == 0 || currentPatternNode instanceof PsiComment || !(matchNodes.current() instanceof PsiComment)) break;
                fNodes.advance();
                flag = true;
            }
            if (this.matchedOccurs != this.minOccurs && (!this.target || this.myRepeatedVar || this.matchedOccurs == 0)) {
                this.removeLastResults(this.matchedOccurs, context);
                fNodes.rewind(this.matchedOccurs);
                boolean current2 = false;
                return current2;
            }
            if (this.greedy) {
                while (fNodes.hasNext() && this.matchedOccurs < this.maxOccurs) {
                    current2 = matchNodes.current();
                    if (handler.match(currentPatternNode, current2, context)) {
                        matchedNodes.add(current2);
                        ++this.matchedOccurs;
                    } else if (handler instanceof TopLevelMatchingHandler && this.matchedOccurs == 0 || currentPatternNode instanceof PsiComment || !(matchNodes.current() instanceof PsiComment)) break;
                    fNodes.advance();
                    flag = true;
                }
                if (flag) {
                    fNodes.rewind();
                    matchNodes.advance();
                }
                patternNodes.advance();
                if (patternNodes.hasNext()) {
                    nextHandler = pattern.getHandler(patternNodes.current());
                    while (this.matchedOccurs >= this.minOccurs && patternNodes.hasNext()) {
                        if (nextHandler.matchSequentially(patternNodes, matchNodes, context)) {
                            this.totalMatchedOccurs = this.matchedOccurs;
                            boolean bl = true;
                            return bl;
                        }
                        int size = matchedNodes.size();
                        if (size > 0) {
                            matchNodes.rewindTo((PsiElement)matchedNodes.remove(size - 1));
                        }
                        this.removeLastResults(1, context);
                        --this.matchedOccurs;
                    }
                    if (this.matchedOccurs > 0) {
                        this.removeLastResults(this.matchedOccurs, context);
                    }
                    patternNodes.rewind();
                } else {
                    if (handler.isMatchSequentiallySucceeded(matchNodes)) {
                        boolean nextHandler2 = this.checkSameOccurrencesConstraint(context);
                        return nextHandler2;
                    }
                    this.removeLastResults(this.matchedOccurs, context);
                }
                boolean nextHandler2 = false;
                return nextHandler2;
            }
            patternNodes.advance();
            if (flag) {
                fNodes.rewind();
                matchNodes.advance();
            }
            if (patternNodes.hasNext()) {
                nextHandler = pattern.getHandler(patternNodes.current());
                flag = false;
                while (matchNodes.hasNext() && this.matchedOccurs <= this.maxOccurs) {
                    if (nextHandler.matchSequentially(patternNodes, matchNodes, context)) {
                        boolean bl = this.checkSameOccurrencesConstraint(context);
                        return bl;
                    }
                    if (flag) {
                        matchNodes.rewind();
                        fNodes.advance();
                    }
                    if (handler.match(patternNodes.current(), matchNodes.current(), context)) {
                        ++this.matchedOccurs;
                    } else {
                        patternNodes.rewind();
                        this.removeLastResults(this.matchedOccurs, context);
                        boolean bl = false;
                        return bl;
                    }
                    matchNodes.advance();
                    flag = true;
                }
                patternNodes.rewind();
                this.removeLastResults(this.matchedOccurs, context);
                boolean bl = false;
                return bl;
            }
            boolean bl = this.checkSameOccurrencesConstraint(context);
            return bl;
        }
        finally {
            this.matchedOccurs = previousMatchedOccurs;
        }
    }

    private boolean checkSameOccurrencesConstraint(@NotNull MatchContext context) {
        MatchResultImpl result;
        if (context == null) {
            SubstitutionHandler.$$$reportNull$$$0(25);
        }
        if (this.totalMatchedOccurs == -1) {
            this.totalMatchedOccurs = this.matchedOccurs;
            return true;
        }
        MatchResultImpl matchResultImpl = result = context.hasResult() ? context.getResult().getChild(this.name) : null;
        if (result == null && context.getPreviousResult() != null) {
            result = context.getPreviousResult().getChild(this.name);
        }
        return result == null || ((MatchResult)result).size() == this.matchedOccurs || this.target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public void setMatchHandler(@NotNull MatchingHandler matchHandler) {
        if (matchHandler == null) {
            SubstitutionHandler.$$$reportNull$$$0(26);
        }
        this.matchHandler = matchHandler;
    }

    public boolean isTarget() {
        return this.target;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            SubstitutionHandler.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public void reset() {
        super.reset();
        this.totalMatchedOccurs = -1;
    }

    @Override
    public boolean shouldAdvanceThePatternFor(@NotNull PsiElement patternElement, @NotNull PsiElement matchedElement) {
        if (patternElement == null) {
            SubstitutionHandler.$$$reportNull$$$0(28);
        }
        if (matchedElement == null) {
            SubstitutionHandler.$$$reportNull$$$0(29);
        }
        return this.maxOccurs <= 1 && !this.target;
    }

    public void setNestedResult(MatchResultImpl nestedResult) {
        this.myNestedResult = nestedResult;
    }

    public MatchResultImpl getNestedResult() {
        return this.myNestedResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/handlers/SubstitutionHandler";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNodes";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchNodes";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchHandler";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/handlers/SubstitutionHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatch";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPredicate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateOneMatch";
                break;
            }
            case 5: 
            case 6: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMatch";
                break;
            }
            case 15: 
            case 27: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeLastResults";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "matchSequentially";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doMatchSequentiallyBySimpleHandler";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doMatchSequentially";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkSameOccurrencesConstraint";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setMatchHandler";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldAdvanceThePatternFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

