/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.core.CoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypeChooser
extends ComboBoxAction
implements DumbAware {
    private final List<FileTypeInfo> myFileTypeInfos = FileTypeChooser.createFileTypeInfos();
    private FileTypeInfo mySelectedItem = this.myFileTypeInfos.get(0);
    private Consumer<? super FileTypeInfo> myConsumer;

    FileTypeChooser() {
        this.setSmallVariant(false);
    }

    public void setFileTypeInfoConsumer(@Nullable Consumer<? super FileTypeInfo> consumer) {
        this.myConsumer = consumer;
    }

    private static List<FileTypeInfo> createFileTypeInfos() {
        ArrayList<LanguageFileType> types = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType) == null) continue;
            types.add(fileType);
        }
        types.sort((o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
        ArrayList<FileTypeInfo> infos = new ArrayList<FileTypeInfo>();
        for (LanguageFileType fileType : types) {
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile != null);
            Language language = fileType.getLanguage();
            ArrayList<PatternContext> patternContexts = new ArrayList<PatternContext>(profile.getPatternContexts());
            if (!patternContexts.isEmpty()) {
                infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(0), false));
                for (int i = 1; i < patternContexts.size(); ++i) {
                    infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(i), true));
                }
                continue;
            }
            infos.add(new FileTypeInfo(fileType, language, null, false));
            ArrayList<Language> dialects = new ArrayList<Language>(language.getDialects());
            dialects.sort(Comparator.comparing(Language::getDisplayName));
            for (Language dialect : dialects) {
                if (!profile.isMyLanguage(dialect)) continue;
                infos.add(new FileTypeInfo(fileType, dialect, null, true));
            }
        }
        return infos;
    }

    public void setSelectedItem(@Nullable LanguageFileType type, @Nullable Language dialect, @Nullable PatternContext context) {
        if (type == null) {
            this.setSelectedItem(null);
        } else {
            for (FileTypeInfo info : this.myFileTypeInfos) {
                if (!info.isEqualTo(type, dialect, context)) continue;
                this.setSelectedItem(info);
                return;
            }
        }
    }

    private void setSelectedItem(FileTypeInfo info) {
        this.mySelectedItem = info;
        if (this.myConsumer != null) {
            this.myConsumer.accept(info);
        }
    }

    public FileTypeInfo getSelectedItem() {
        return this.mySelectedItem;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FileTypeChooser.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (this.mySelectedItem == null) {
            presentation.setIcon(AllIcons.FileTypes.Unknown);
            presentation.setText(CoreBundle.message((String)"filetype.unknown.description", (Object[])new Object[0]));
        } else {
            presentation.setIcon(this.mySelectedItem.getFileType().getIcon());
            presentation.setText(this.mySelectedItem.getText());
        }
    }

    @NotNull
    protected ComboBoxAction.ComboBoxButton createComboBoxButton(@NotNull Presentation presentation) {
        if (presentation == null) {
            FileTypeChooser.$$$reportNull$$$0(1);
        }
        return new ComboBoxAction.ComboBoxButton(presentation){

            public int getDisplayedMnemonicIndex() {
                return -1;
            }
        };
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            FileTypeChooser.$$$reportNull$$$0(2);
        }
        if (place == null) {
            FileTypeChooser.$$$reportNull$$$0(3);
        }
        JPanel panel = new JPanel(new BorderLayout(1, 0));
        ComboBoxAction.ComboBoxButton button = this.createComboBoxButton(presentation);
        String text = SSRBundle.message("search.dialog.file.type.label", new Object[0]);
        JBLabel label = new JBLabel(text);
        label.setLabelFor((Component)button);
        button.setMnemonic(TextWithMnemonic.parse((String)text).getMnemonic());
        panel.add((Component)label, "West");
        panel.add((Component)button, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            FileTypeChooser.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (FileTypeInfo fileTypeInfo : this.myFileTypeInfos) {
            group.add((AnAction)new FileTypeInfoAction(fileTypeInfo));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            FileTypeChooser.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return action -> ((FileTypeInfoAction)((Object)action)).getFileTypeInfo() == this.mySelectedItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeChooser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createComboBoxButton";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FileTypeInfoAction
    extends DumbAwareAction {
        private final FileTypeInfo myFileTypeInfo;

        FileTypeInfoAction(FileTypeInfo fileTypeInfo) {
            this.myFileTypeInfo = fileTypeInfo;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(fileTypeInfo.isNested() ? null : fileTypeInfo.getFileType().getIcon());
            presentation.setText((String)(fileTypeInfo.isNested() ? "    " + fileTypeInfo.getText() : fileTypeInfo.getText()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FileTypeInfoAction.$$$reportNull$$$0(0);
            }
            FileTypeChooser.this.setSelectedItem(this.myFileTypeInfo);
        }

        FileTypeInfo getFileTypeInfo() {
            return this.myFileTypeInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/FileTypeChooser$FileTypeInfoAction", "actionPerformed"));
        }
    }
}

