/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UIUtil {
    @NonNls
    private static final String SS_GROUP = "structuralsearchgroup";
    @NonNls
    public static final String SSR_NOTIFICATION_GROUP_ID = "Structural Search";
    @NonNls
    public static final String TEXT = "TEXT";
    @NonNls
    public static final String TEXT_HIERARCHY = "TEXT HIERARCHY";
    @NonNls
    public static final String REFERENCE = "REFERENCE";
    @NonNls
    public static final String TYPE = "TYPE";
    @NonNls
    public static final String TYPE_REGEX = "TYPE REGEX";
    @NonNls
    public static final String EXPECTED_TYPE = "EXPECTED TYPE";
    @NonNls
    public static final String MINIMUM_ZERO = "MINIMUM ZERO";
    @NonNls
    public static final String MAXIMUM_UNLIMITED = "MAXIMUM UNLIMITED";
    @NonNls
    public static final String CONTEXT = "CONTEXT";

    private UIUtil() {
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project, boolean editable, @Nullable TemplateContextType contextType) {
        if (doc == null) {
            UIUtil.$$$reportNull$$$0(0);
        }
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project) : EditorFactory.getInstance().createViewer(doc, project);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color c = globalScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (c == null) {
                c = globalScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(c);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)contextType);
        Editor editor2 = editor;
        if (editor2 == null) {
            UIUtil.$$$reportNull$$$0(1);
        }
        return editor2;
    }

    public static void setContent(@NotNull Editor editor, String text) {
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(2);
        }
        String value = text != null ? text : "";
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)SS_GROUP, () -> document.replaceString(0, document.getTextLength(), (CharSequence)value), (PsiFile[])new PsiFile[0]);
    }

    public static void setContent(@NotNull EditorTextField editor, @NotNull String text) {
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(3);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(4);
        }
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)SS_GROUP, () -> document.replaceString(0, document.getTextLength(), (CharSequence)text), (PsiFile[])new PsiFile[0]);
    }

    public static void invokeAction(@NotNull Configuration config, @NotNull SearchContext context) {
        if (config == null) {
            UIUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            UIUtil.$$$reportNull$$$0(6);
        }
        StructuralSearchAction.triggerAction(config, context, !(config instanceof SearchConfiguration));
    }

    @NotNull
    public static MatchVariableConstraint getOrAddVariableConstraint(@NotNull String varName, @NotNull Configuration configuration) {
        MatchOptions options;
        MatchVariableConstraint varInfo;
        if (varName == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            UIUtil.$$$reportNull$$$0(8);
        }
        if ((varInfo = (options = configuration.getMatchOptions()).getVariableConstraint(varName)) != null) {
            MatchVariableConstraint matchVariableConstraint = varInfo;
            if (matchVariableConstraint == null) {
                UIUtil.$$$reportNull$$$0(9);
            }
            return matchVariableConstraint;
        }
        MatchVariableConstraint matchVariableConstraint = configuration.getMatchOptions().addNewVariableConstraint(varName);
        if (matchVariableConstraint == null) {
            UIUtil.$$$reportNull$$$0(10);
        }
        return matchVariableConstraint;
    }

    @NotNull
    public static ReplacementVariableDefinition getOrAddReplacementVariable(@NotNull String varName, @NotNull Configuration configuration) {
        ReplaceOptions replaceOptions;
        ReplacementVariableDefinition definition;
        if (varName == null) {
            UIUtil.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            UIUtil.$$$reportNull$$$0(12);
        }
        if ((definition = (replaceOptions = configuration.getReplaceOptions()).getVariableDefinition(varName)) != null) {
            ReplacementVariableDefinition replacementVariableDefinition = definition;
            if (replacementVariableDefinition == null) {
                UIUtil.$$$reportNull$$$0(13);
            }
            return replacementVariableDefinition;
        }
        ReplacementVariableDefinition replacementVariableDefinition = replaceOptions.addNewVariableDefinition(varName);
        if (replacementVariableDefinition == null) {
            UIUtil.$$$reportNull$$$0(14);
        }
        return replacementVariableDefinition;
    }

    public static boolean isTarget(@NotNull String varName, @NotNull MatchOptions matchOptions) {
        if (varName == null) {
            UIUtil.$$$reportNull$$$0(15);
        }
        if (matchOptions == null) {
            UIUtil.$$$reportNull$$$0(16);
        }
        if ("__context__".equals(varName)) {
            for (String name : matchOptions.getVariableConstraintNames()) {
                if (name.equals("__context__") || !matchOptions.getVariableConstraint(name).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint constraint = matchOptions.getVariableConstraint(varName);
        if (constraint == null) {
            return false;
        }
        return constraint.isPartOfSearchResults();
    }

    @NotNull
    public static EditorTextField createTextComponent(@NotNull String text, @NotNull Project project) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            UIUtil.$$$reportNull$$$0(18);
        }
        return UIUtil.createEditorComponent(text, "1.txt", project);
    }

    @NotNull
    public static EditorTextField createRegexComponent(@NotNull String text, @NotNull Project project) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(19);
        }
        if (project == null) {
            UIUtil.$$$reportNull$$$0(20);
        }
        return UIUtil.createEditorComponent(text, "1.regexp", project);
    }

    @NotNull
    public static EditorTextField createScriptComponent(@NotNull String text, @NotNull Project project) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(21);
        }
        if (project == null) {
            UIUtil.$$$reportNull$$$0(22);
        }
        return UIUtil.createEditorComponent(text, "1.groovy", project);
    }

    @NotNull
    public static EditorTextField createEditorComponent(@NotNull String text, @NotNull String fileName, @NotNull Project project) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(23);
        }
        if (fileName == null) {
            UIUtil.$$$reportNull$$$0(24);
        }
        if (project == null) {
            UIUtil.$$$reportNull$$$0(25);
        }
        FileType fileType = UIUtil.getFileType(fileName);
        Document document = UIUtil.createDocument(fileType, text, project);
        return new EditorTextField(document, project, fileType);
    }

    @NotNull
    public static Document createDocument(@NotNull FileType fileType, @NotNull String text, @NotNull Project project) {
        if (fileType == null) {
            UIUtil.$$$reportNull$$$0(26);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(27);
        }
        if (project == null) {
            UIUtil.$$$reportNull$$$0(28);
        }
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("Dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)text, -1L, true);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            UIUtil.$$$reportNull$$$0(29);
        }
        return document2;
    }

    @NotNull
    private static FileType getFileType(@NotNull String fileName) {
        FileType fileType;
        if (fileName == null) {
            UIUtil.$$$reportNull$$$0(30);
        }
        if ((fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName)) == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            UIUtil.$$$reportNull$$$0(31);
        }
        return fileType2;
    }

    @NotNull
    public static LanguageFileType detectFileType(@NotNull SearchContext searchContext) {
        Language language;
        StructuralSearchProfile profile;
        if (searchContext == null) {
            UIUtil.$$$reportNull$$$0(32);
        }
        PsiFile file = searchContext.getFile();
        PsiElement context = null;
        Editor editor = searchContext.getEditor();
        if (editor != null && file != null) {
            int offset = editor.getCaretModel().getOffset();
            context = InjectedLanguageManager.getInstance((Project)searchContext.getProject()).findInjectedElementAt(file, offset);
            if (context == null) {
                context = file.findElementAt(offset);
            }
            if (context != null) {
                context = context.getParent();
            }
            if (context == null) {
                context = file;
            }
        }
        if (context != null && (profile = StructuralSearchUtil.getProfileByLanguage(language = context.getLanguage())) != null) {
            LanguageFileType fileType = profile.detectFileType(context);
            if (fileType == null) {
                fileType = language.getAssociatedFileType();
            }
            if (fileType != null) {
                LanguageFileType languageFileType = fileType;
                if (languageFileType == null) {
                    UIUtil.$$$reportNull$$$0(33);
                }
                return languageFileType;
            }
        }
        LanguageFileType languageFileType = StructuralSearchUtil.getDefaultFileType();
        if (languageFileType == null) {
            UIUtil.$$$reportNull$$$0(34);
        }
        return languageFileType;
    }

    @NotNull
    public static Document createDocument(@NotNull Project project, @Nullable LanguageFileType fileType, Language dialect, PatternContext patternContext, @NotNull String text, @Nullable StructuralSearchProfile profile) {
        if (project == null) {
            UIUtil.$$$reportNull$$$0(35);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(36);
        }
        if (fileType != null && profile != null) {
            String contextId = patternContext == null ? null : patternContext.getId();
            PsiCodeFragment codeFragment = profile.createCodeFragment(project, text, contextId);
            if (codeFragment == null) {
                codeFragment = UIUtil.createFileFragment(project, fileType, dialect, text);
            }
            if (codeFragment != null) {
                Document doc = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)codeFragment);
                assert (doc != null) : "code fragment element should be physical";
                Document document = doc;
                if (document == null) {
                    UIUtil.$$$reportNull$$$0(37);
                }
                return document;
            }
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text);
        if (document == null) {
            UIUtil.$$$reportNull$$$0(38);
        }
        return document;
    }

    @NotNull
    public static Editor createEditor(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text, boolean editable, @NotNull StructuralSearchProfile profile) {
        Document doc;
        PsiCodeFragment codeFragment;
        if (project == null) {
            UIUtil.$$$reportNull$$$0(39);
        }
        if (fileType == null) {
            UIUtil.$$$reportNull$$$0(40);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(41);
        }
        if (profile == null) {
            UIUtil.$$$reportNull$$$0(42);
        }
        if ((codeFragment = profile.createCodeFragment(project, text, null)) == null) {
            codeFragment = UIUtil.createFileFragment(project, fileType, dialect, text);
        }
        if (codeFragment != null) {
            doc = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled((PsiFile)codeFragment, false);
        } else {
            doc = EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        return UIUtil.createEditor(doc, project, editable, UIUtil.getTemplateContextType(profile));
    }

    private static PsiFile createFileFragment(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text) {
        if (project == null) {
            UIUtil.$$$reportNull$$$0(43);
        }
        if (fileType == null) {
            UIUtil.$$$reportNull$$$0(44);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(45);
        }
        String name = "__dummy." + fileType.getDefaultExtension();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        return dialect == null ? factory.createFileFromText(name, (FileType)fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, true) : factory.createFileFromText(name, dialect, (CharSequence)text, true, true);
    }

    public static TemplateContextType getTemplateContextType(@NotNull StructuralSearchProfile profile) {
        if (profile == null) {
            UIUtil.$$$reportNull$$$0(46);
        }
        Class<? extends TemplateContextType> clazz = profile.getTemplateContextTypeClass();
        return (TemplateContextType)ContainerUtil.findInstance((Object[])((TemplateContextType[])TemplateContextType.EP_NAME.getExtensions()), clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 36: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 35: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 26: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrAddVariableConstraint";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrAddReplacementVariable";
                break;
            }
            case 29: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrAddVariableConstraint";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrAddReplacementVariable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTarget";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTextComponent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createRegexComponent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createScriptComponent";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createFileFragment";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateContextType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

