/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.filters.Filter;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.SimpleColoredComponent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FilterAction
extends DumbAwareAction
implements Filter {
    @Deprecated(forRemoval=true)
    public static final ExtensionPointName<FilterAction> EP_NAME = ExtensionPointName.create((String)"com.intellij.structuralsearch.filter");
    private static final AtomicInteger myFilterCount = new AtomicInteger();
    protected final SimpleColoredComponent myLabel;
    protected FilterTable myTable;
    private final int myPosition;
    private boolean myApplicable;
    private boolean myActive;

    protected FilterAction(@NotNull Supplier<String> text) {
        if (text == null) {
            FilterAction.$$$reportNull$$$0(0);
        }
        super(text);
        this.myLabel = new SimpleColoredComponent();
        this.myApplicable = true;
        this.myActive = false;
        this.myPosition = myFilterCount.incrementAndGet();
    }

    public void setTable(@NotNull FilterTable table) {
        if (table == null) {
            FilterAction.$$$reportNull$$$0(1);
        }
        this.myTable = table;
    }

    @Override
    public final int position() {
        return this.myPosition;
    }

    @NotNull
    public String getShortText(NamedScriptableDefinition variable) {
        return "";
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FilterAction.$$$reportNull$$$0(2);
        }
        this.initFilter();
        this.myApplicable = false;
        this.myActive = true;
        this.myTable.addFilter(this);
    }

    public final SimpleColoredComponent getRenderer() {
        this.myLabel.clear();
        this.setLabel(this.myLabel);
        return this.myLabel;
    }

    protected abstract void setLabel(SimpleColoredComponent var1);

    public abstract boolean hasFilter();

    final boolean isActive() {
        if (this.hasFilter()) {
            this.myActive = true;
        }
        return this.myActive;
    }

    protected void initFilter() {
    }

    public abstract void clearFilter();

    final void reset() {
        this.myApplicable = true;
        this.myActive = false;
    }

    protected abstract boolean isApplicable(List<? extends PsiElement> var1, boolean var2, boolean var3);

    protected final boolean isApplicableConstraint(@NonNls String constraintName, List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        StructuralSearchProfile profile = this.myTable.getProfile();
        return profile != null && profile.isApplicableConstraint(constraintName, nodes, completePattern, target);
    }

    final boolean isAvailable() {
        return this.myApplicable && !this.isActive();
    }

    final boolean checkApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        this.myApplicable = this.isApplicable(nodes, completePattern, target);
        return this.myApplicable;
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FilterAction.$$$reportNull$$$0(3);
        }
        e.getPresentation().setEnabledAndVisible(this.myApplicable && !this.isActive());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/filters/FilterAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

