/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class BTWMavenConsole
extends MavenConsole {
    private final Project myProject;

    public BTWMavenConsole(Project project2, MavenExecutionOptions.LoggingLevel outputLevel, boolean printStrackTrace) {
        super(outputLevel, printStrackTrace);
        this.myProject = project2;
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public boolean isOutputPaused() {
        return false;
    }

    @Override
    public void setOutputPaused(boolean outputPaused) {
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler) {
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                BTWMavenConsole.this.sendToSyncConsole(event.getText(), ProcessOutputType.isStdout((Key)outputType));
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (event.getExitCode() != 0) {
                    String text = "PROCESS TERMINATED: " + event.getExitCode();
                    BTWMavenConsole.this.sendToSyncConsole(text, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/maven/execution/BTWMavenConsole$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected void doPrint(String text, MavenConsole.OutputType type2) {
        this.sendToSyncConsole(text, type2 == MavenConsole.OutputType.NORMAL);
    }

    private void sendToSyncConsole(@NlsSafe String text, boolean stdout) {
        MavenSyncConsole syncConsole = MavenProjectsManager.getInstance(this.myProject).getSyncConsole();
        syncConsole.addText(text, stdout);
    }
}

