/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.openapi.project.Project;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelPluginQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelPropertyQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.TargetLevelPluginQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.TargetLevelPropertyQuickFix;
import org.jetbrains.idea.maven.importing.MavenProjectModelModifier;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class LanguageLevelQuickFixFactory {
    @Nullable
    public static LanguageLevelQuickFix getInstance(@NotNull Project project2, @NotNull MavenProject mavenProject2) {
        if (project2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(0);
        }
        if (mavenProject2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(1);
        }
        return LanguageLevelQuickFixFactory.getInstance(project2, mavenProject2, false);
    }

    @Nullable
    public static LanguageLevelQuickFix getTargetInstance(@NotNull Project project2, @NotNull MavenProject mavenProject2) {
        if (project2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(2);
        }
        if (mavenProject2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(3);
        }
        return LanguageLevelQuickFixFactory.getInstance(project2, mavenProject2, true);
    }

    @Nullable
    private static LanguageLevelQuickFix getInstance(@NotNull Project project2, @NotNull MavenProject mavenProject2, boolean targetVersion) {
        FixHolder holder;
        if (project2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(4);
        }
        if (mavenProject2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(5);
        }
        if ((holder = LanguageLevelQuickFixFactory.getFixHolder(project2, mavenProject2, targetVersion)) == null) {
            return null;
        }
        return holder.toInstance();
    }

    @Nullable
    private static FixHolder getFixHolder(@NotNull Project project2, @NotNull MavenProject mavenProject2, boolean targetVersion) {
        MavenDomProjectModel model2;
        if (project2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(6);
        }
        if (mavenProject2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(7);
        }
        if ((model2 = MavenDomUtil.getMavenDomProjectModel(project2, mavenProject2.getFile())) == null) {
            return null;
        }
        if (LanguageLevelQuickFixFactory.containCompilerPluginSource(model2)) {
            return new FixHolder(true, targetVersion, mavenProject2, project2);
        }
        if (LanguageLevelQuickFixFactory.containPropertySource(model2)) {
            return new FixHolder(false, targetVersion, mavenProject2, project2);
        }
        if (mavenProject2.getParentId() == null) {
            return new FixHolder(false, targetVersion, mavenProject2, project2);
        }
        model2 = MavenDomUtil.getMavenDomProjectModel(project2, (mavenProject2 = LanguageLevelQuickFixFactory.getParentMavenProject(project2, mavenProject2)).getFile());
        if (model2 == null) {
            return null;
        }
        return LanguageLevelQuickFixFactory.containCompilerPluginSource(model2) ? new FixHolder(true, targetVersion, mavenProject2, project2) : new FixHolder(false, targetVersion, mavenProject2, project2);
    }

    @NotNull
    private static MavenProject getParentMavenProject(@NotNull Project project2, @NotNull MavenProject mavenProject2) {
        if (project2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(8);
        }
        if (mavenProject2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(9);
        }
        MavenProject parentProject = mavenProject2;
        while (parentProject.getParentId() != null) {
            parentProject = MavenProjectsManager.getInstance(project2).findProject(parentProject.getParentId());
            if (parentProject != null) continue;
            MavenProject mavenProject3 = mavenProject2;
            if (mavenProject3 == null) {
                LanguageLevelQuickFixFactory.$$$reportNull$$$0(10);
            }
            return mavenProject3;
        }
        MavenProject mavenProject4 = parentProject;
        if (mavenProject4 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(11);
        }
        return mavenProject4;
    }

    private static boolean containCompilerPluginSource(@NotNull MavenDomProjectModel model2) {
        if (model2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(12);
        }
        return Optional.ofNullable(MavenProjectModelModifier.findCompilerPlugin(model2)).map(p -> p.getConfiguration()).map(c -> c.getXmlTag()).map(tag -> tag.findFirstSubTag("source") != null).orElse(false);
    }

    private static boolean containPropertySource(@NotNull MavenDomProjectModel model2) {
        if (model2 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(13);
        }
        return Optional.ofNullable(model2.getProperties().getXmlTag()).map(tag -> tag.findFirstSubTag("maven.compiler.source") != null).orElse(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/LanguageLevelQuickFixFactory";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/LanguageLevelQuickFixFactory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentMavenProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFixHolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentMavenProject";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containCompilerPluginSource";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containPropertySource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FixHolder {
        final boolean isPlugin;
        final boolean isTarget;
        final MavenProject mavenProject;
        final Project project;

        private FixHolder(boolean plugin, boolean target, MavenProject mavenProject2, Project project2) {
            this.isPlugin = plugin;
            this.isTarget = target;
            this.mavenProject = mavenProject2;
            this.project = project2;
        }

        private LanguageLevelQuickFix toInstance() {
            if (this.isPlugin && this.isTarget) {
                return new TargetLevelPluginQuickFix(this.project, this.mavenProject);
            }
            if (!this.isPlugin && this.isTarget) {
                return new TargetLevelPropertyQuickFix(this.project, this.mavenProject);
            }
            if (this.isPlugin) {
                return new LanguageLevelPluginQuickFix(this.project, this.mavenProject);
            }
            return new LanguageLevelPropertyQuickFix(this.project, this.mavenProject);
        }
    }
}

