/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/SetupModuleSdkQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "moduleName", "", "isSdkInherited", "", "(Ljava/lang/String;Z)V", "id", "getId", "()Ljava/lang/String;", "()Z", "getModuleName", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.maven"})
public final class SetupModuleSdkQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String id;
    @NotNull
    private final String moduleName;
    private final boolean isSdkInherited;

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isSdkInherited) {
            ProjectSettingsService.getInstance((Project)project2).openProjectSettings();
        } else {
            ProjectSettingsService.getInstance((Project)project2).showModuleConfigurationDialog(this.moduleName, ClasspathEditor.getName());
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture<Any>(null)");
        return completableFuture;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    public final boolean isSdkInherited() {
        return this.isSdkInherited;
    }

    public SetupModuleSdkQuickFix(@NotNull String moduleName, boolean isSdkInherited) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this.moduleName = moduleName;
        this.isSdkInherited = isSdkInherited;
        this.id = "setup_module_sdk_quick_fix";
    }
}

