/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxy;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyWrapper;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenModuleImporter {
    public static final String SUREFIRE_PLUGIN_LIBRARY_NAME = "maven-surefire-plugin urls";
    private static final Set<String> IMPORTED_CLASSIFIERS = Set.of("client");
    private static final Map<String, LanguageLevel> MAVEN_IDEA_PLUGIN_LEVELS = ImmutableMap.of((Object)"JDK_1_3", (Object)LanguageLevel.JDK_1_3, (Object)"JDK_1_4", (Object)LanguageLevel.JDK_1_4, (Object)"JDK_1_5", (Object)LanguageLevel.JDK_1_5, (Object)"JDK_1_6", (Object)LanguageLevel.JDK_1_6, (Object)"JDK_1_7", (Object)LanguageLevel.JDK_1_7);
    private final Module myModule;
    private final MavenProjectsTree myMavenTree;
    private final MavenProject myMavenProject;
    @Nullable
    private final MavenProjectChanges myMavenProjectChanges;
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    private final MavenImportingSettings mySettings;
    private final ModifiableModelsProviderProxy myModifiableModelsProvider;
    private MavenRootModelAdapter myRootModelAdapter;
    private IdeModifiableModelsProvider myProviderForExtensions;

    public MavenModuleImporter(Module module, MavenProjectsTree mavenTree, MavenProject mavenProject2, @Nullable MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, MavenImportingSettings settings, ModifiableModelsProviderProxy modifiableModelsProvider) {
        this.myModule = module;
        this.myMavenTree = mavenTree;
        this.myMavenProject = mavenProject2;
        this.myMavenProjectChanges = changes;
        this.myMavenProjectToModuleName = mavenProjectToModuleName;
        this.mySettings = settings;
        this.myModifiableModelsProvider = modifiableModelsProvider;
        VirtualFile pomFile = mavenProject2.getFile();
        if (!FileUtil.namesEqual((String)"pom", (String)pomFile.getNameWithoutExtension())) {
            MavenPomPathModuleService.getInstance(module).setPomFileUrl(pomFile.getUrl());
        }
    }

    public ModifiableRootModel getRootModel() {
        return this.myRootModelAdapter.getRootModel();
    }

    void setRootModelAdapter(MavenRootModelAdapter mavenRootModelAdapter) {
        this.myRootModelAdapter = mavenRootModelAdapter;
    }

    public void config(MavenRootModelAdapter mavenRootModelAdapter) {
        this.myRootModelAdapter = mavenRootModelAdapter;
        this.configFolders();
        this.configDependencies();
        this.configLanguageLevel();
    }

    public void preConfigFacets() {
        MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.getSuitableImporters()) {
                try {
                    MavenProjectChanges changes;
                    if (this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    importer.preProcess(this.myModule, this.myMavenProject, changes, this.myProviderForExtensions);
                }
                catch (Exception e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        });
    }

    public void configFacets(List<MavenProjectsProcessorTask> postTasks) {
        MavenUtil.smartInvokeAndWait(this.myModule.getProject(), ModalityState.defaultModalityState(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (MavenImporter importer : this.getSuitableImporters()) {
                    MavenProjectChanges changes;
                    if (this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    try {
                        importer.process(this.myProviderForExtensions, this.myModule, this.myRootModelAdapter, this.myMavenTree, this.myMavenProject, changes, this.myMavenProjectToModuleName, postTasks);
                    }
                    catch (Exception e) {
                        MavenLog.LOG.error((Throwable)e);
                    }
                }
            });
        });
    }

    public void postConfigFacets() {
        MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.getSuitableImporters()) {
                try {
                    MavenProjectChanges changes;
                    if (this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    importer.postProcess(this.myModule, this.myMavenProject, changes, this.myProviderForExtensions);
                }
                catch (Exception e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        });
    }

    private List<MavenImporter> getSuitableImporters() {
        return this.myMavenProject.getSuitableImporters();
    }

    private void configFolders() {
        new MavenFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).config();
    }

    private void configDependencies() {
        HashSet dependencyTypesFromSettings = new HashSet();
        if (!((Boolean)ReadAction.compute(() -> {
            if (this.myModule.getProject().isDisposed()) {
                return false;
            }
            dependencyTypesFromSettings.addAll(MavenProjectsManager.getInstance(this.myModule.getProject()).getImportingSettings().getDependencyTypesAsSet());
            return true;
        })).booleanValue()) {
            return;
        }
        for (MavenArtifact artifact : this.myMavenProject.getDependencies()) {
            String dependencyType = artifact.getType();
            if (!dependencyTypesFromSettings.contains(dependencyType) && !this.myMavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) continue;
            DependencyScope scope = MavenModuleImporter.selectScope(artifact.getScope());
            MavenProject depProject = this.myMavenTree.findProject(artifact.getMavenId());
            if (depProject != null) {
                String classifier;
                if (depProject == this.myMavenProject) continue;
                String moduleName = this.myMavenProjectToModuleName.get(depProject);
                if (moduleName == null || this.myMavenTree.isIgnored(depProject)) {
                    MavenArtifact projectsArtifactInRepository = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), dependencyType, artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, this.myMavenProject.getLocalRepository(), false, false);
                    this.myRootModelAdapter.addLibraryDependency(projectsArtifactInRepository, scope, this.myModifiableModelsProvider, this.myMavenProject);
                    continue;
                }
                boolean isTestJar = "test-jar".equals(dependencyType) || "tests".equals(artifact.getClassifier());
                this.myRootModelAdapter.addModuleDependency(moduleName, scope, isTestJar);
                Element buildHelperCfg = depProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact");
                if (buildHelperCfg != null) {
                    this.addAttachArtifactDependency(buildHelperCfg, scope, depProject, artifact);
                }
                if ((classifier = artifact.getClassifier()) == null || !IMPORTED_CLASSIFIERS.contains(classifier) || isTestJar || "system".equals(artifact.getScope()) || "false".equals(System.getProperty("idea.maven.classifier.dep"))) continue;
                MavenArtifact a = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), dependencyType, classifier, artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, this.myMavenProject.getLocalRepository(), false, false);
                this.myRootModelAdapter.addLibraryDependency(a, scope, this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if ("system".equals(artifact.getScope())) {
                this.myRootModelAdapter.addSystemDependency(artifact, scope);
                continue;
            }
            if ("bundle".equals(dependencyType)) {
                artifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, this.myMavenProject.getLocalRepository(), false, false);
            }
            LibraryOrderEntry libraryOrderEntry = this.myRootModelAdapter.addLibraryDependency(artifact, scope, this.myModifiableModelsProvider, this.myMavenProject);
            this.myModifiableModelsProvider.trySubstitute(this.myModule, libraryOrderEntry, new ProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }
        this.configSurefirePlugin();
    }

    private void configSurefirePlugin() {
        LibraryTable moduleLibraryTable = this.myRootModelAdapter.getRootModel().getModuleLibraryTable();
        Library library = moduleLibraryTable.getLibraryByName(SUREFIRE_PLUGIN_LIBRARY_NAME);
        if (library != null) {
            moduleLibraryTable.removeLibrary(library);
        }
    }

    private void addAttachArtifactDependency(@NotNull Element buildHelperCfg, @NotNull DependencyScope scope, @NotNull MavenProject mavenProject2, @NotNull MavenArtifact artifact) {
        if (buildHelperCfg == null) {
            MavenModuleImporter.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            MavenModuleImporter.$$$reportNull$$$0(1);
        }
        if (mavenProject2 == null) {
            MavenModuleImporter.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            MavenModuleImporter.$$$reportNull$$$0(3);
        }
        Library.ModifiableModel libraryModel = null;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                VirtualFile file;
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !typeString.equals("jar")) continue;
                OrderRootType rootType = OrderRootType.CLASSES;
                String classifier = artifactElement.getChildTextTrim("classifier");
                if ("sources".equals(classifier)) {
                    rootType = OrderRootType.SOURCES;
                } else if ("javadoc".equals(classifier)) {
                    rootType = JavadocOrderRootType.getInstance();
                }
                if (StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file"))) || (file = VfsUtil.findRelativeFile((String)filePath, (VirtualFile)mavenProject2.getDirectoryFile())) == null || (file = JarFileSystem.getInstance().getJarRootForLocalFile(file)) == null) continue;
                if (libraryModel == null) {
                    String libraryName = MavenModuleImporter.getAttachedJarsLibName(artifact);
                    Library library = this.myModifiableModelsProvider.getLibraryByName(libraryName);
                    if (library == null) {
                        library = this.myModifiableModelsProvider.createLibrary(libraryName, MavenRootModelAdapter.getMavenExternalSource());
                    }
                    libraryModel = this.myModifiableModelsProvider.getModifiableLibraryModel(library);
                    LibraryOrderEntry entry = this.myRootModelAdapter.getRootModel().addLibraryEntry(library);
                    entry.setScope(scope);
                }
                libraryModel.addRoot(file, rootType);
            }
        }
    }

    public IdeModifiableModelsProvider getModifiableModelsProvider() {
        return this.myProviderForExtensions;
    }

    public void setModifiableModelsProvider(IdeModifiableModelsProvider providerForExtensions) {
        this.myProviderForExtensions = providerForExtensions;
        MavenRootModelAdapter mavenRootModelAdapter = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(this.myMavenProject, this.myModule, new ModifiableModelsProviderProxyWrapper(this.myProviderForExtensions)));
        this.setRootModelAdapter(mavenRootModelAdapter);
    }

    @NotNull
    public static String getAttachedJarsLibName(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenModuleImporter.$$$reportNull$$$0(4);
        }
        Object libraryName = artifact.getLibraryName();
        assert (((String)libraryName).startsWith("Maven: "));
        Object object = libraryName = "Maven: ATTACHED-JAR: " + ((String)libraryName).substring("Maven: ".length());
        if (object == null) {
            MavenModuleImporter.$$$reportNull$$$0(5);
        }
        return object;
    }

    @NotNull
    public static DependencyScope selectScope(String mavenScope) {
        if ("runtime".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.RUNTIME;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(6);
            }
            return dependencyScope;
        }
        if ("test".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(7);
            }
            return dependencyScope;
        }
        if ("provided".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.PROVIDED;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(8);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = DependencyScope.COMPILE;
        if (dependencyScope == null) {
            MavenModuleImporter.$$$reportNull$$$0(9);
        }
        return dependencyScope;
    }

    private void configLanguageLevel() {
        if ("false".equalsIgnoreCase(System.getProperty("idea.maven.configure.language.level"))) {
            return;
        }
        LanguageLevel level = MavenModuleImporter.getLanguageLevel(this.myMavenProject);
        this.myRootModelAdapter.setLanguageLevel(level);
    }

    public static LanguageLevel getLanguageLevel(MavenProject mavenProject2) {
        String mavenProjectSourceLevel;
        String mavenProjectReleaseLevel;
        LanguageLevel level = null;
        Element cfg = mavenProject2.getPluginConfiguration("com.googlecode", "maven-idea-plugin");
        if (cfg != null) {
            level = MAVEN_IDEA_PLUGIN_LEVELS.get(cfg.getChildTextTrim("jdkLevel"));
        }
        if (level == null && ((level = LanguageLevel.parse((String)(mavenProjectReleaseLevel = mavenProject2.getReleaseLevel()))) == null || StringUtil.compareVersionNumbers((String)MavenUtil.getCompilerPluginVersion(mavenProject2), (String)"3.6") < 0) && (level = LanguageLevel.parse((String)(mavenProjectSourceLevel = mavenProject2.getSourceLevel()))) == null && (StringUtil.isNotEmpty((String)mavenProjectSourceLevel) || StringUtil.isNotEmpty((String)mavenProjectReleaseLevel))) {
            level = LanguageLevel.HIGHEST;
        }
        if (level == null) {
            level = MavenModuleImporter.getDefaultLevel(mavenProject2);
        }
        if (level.isAtLeast(LanguageLevel.JDK_11)) {
            level = MavenModuleImporter.adjustPreviewLanguageLevel(mavenProject2, level);
        }
        return level;
    }

    @NotNull
    public static LanguageLevel getDefaultLevel(MavenProject mavenProject2) {
        MavenPlugin plugin = mavenProject2.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
        if (plugin != null && plugin.getVersion() != null) {
            if (VersionComparatorUtil.compare((String)"3.8.1", (String)plugin.getVersion()) <= 0) {
                LanguageLevel languageLevel = LanguageLevel.JDK_1_6;
                if (languageLevel == null) {
                    MavenModuleImporter.$$$reportNull$$$0(10);
                }
                return languageLevel;
            }
            LanguageLevel languageLevel = LanguageLevel.JDK_1_5;
            if (languageLevel == null) {
                MavenModuleImporter.$$$reportNull$$$0(11);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.JDK_1_5;
        if (languageLevel == null) {
            MavenModuleImporter.$$$reportNull$$$0(12);
        }
        return languageLevel;
    }

    private static LanguageLevel adjustPreviewLanguageLevel(MavenProject mavenProject2, LanguageLevel level) {
        Element compilerArgs;
        Element compilerConfiguration = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
        if (compilerConfiguration != null && (compilerArgs = compilerConfiguration.getChild("compilerArgs")) != null && (MavenModuleImporter.isPreviewText(compilerArgs) || compilerArgs.getChildren("arg").stream().anyMatch(MavenModuleImporter::isPreviewText) || compilerArgs.getChildren("compilerArg").stream().anyMatch(MavenModuleImporter::isPreviewText))) {
            try {
                return LanguageLevel.valueOf((String)(level.name() + "_PREVIEW"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return level;
    }

    private static boolean isPreviewText(Element child) {
        return "--enable-preview".equals(child.getTextTrim());
    }

    public boolean isModuleDisposed() {
        return this.myModule.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildHelperCfg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenModuleImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenModuleImporter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedJarsLibName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "selectScope";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAttachArtifactDependency";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedJarsLibName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

