/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenArchetypesProvider;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenRehighlighter;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenIndicesManager
implements Disposable {
    private static final String ELEMENT_ARCHETYPES = "archetypes";
    private static final String ELEMENT_ARCHETYPE = "archetype";
    private static final String ELEMENT_GROUP_ID = "groupId";
    private static final String ELEMENT_ARTIFACT_ID = "artifactId";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_REPOSITORY = "repository";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String LOCAL_REPOSITORY_ID = "local";
    @NotNull
    private final Project myProject;
    private final AtomicBoolean myInitStarted;
    private final CompletableFuture<IndexKeeper> myKeeper;
    private volatile Path myTestIndicesDir;
    private final Object myUpdatingIndicesLock;
    private final List<MavenSearchIndex> myWaitingIndices;
    private volatile MavenSearchIndex myUpdatingIndex;
    private final IndexFixer myIndexFixer;
    private final BackgroundTaskQueue myUpdatingQueue;

    public static MavenIndicesManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndicesManager.$$$reportNull$$$0(0);
        }
        return (MavenIndicesManager)project2.getService(MavenIndicesManager.class);
    }

    public MavenIndicesManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndicesManager.$$$reportNull$$$0(1);
        }
        this.myInitStarted = new AtomicBoolean(false);
        this.myKeeper = new CompletableFuture();
        this.myUpdatingIndicesLock = new Object();
        this.myWaitingIndices = new ArrayList<MavenSearchIndex>();
        this.myIndexFixer = new IndexFixer();
        this.myUpdatingQueue = new BackgroundTaskQueue(null, IndicesBundle.message("maven.indices.updating", new Object[0]));
        this.myProject = project2;
    }

    @TestOnly
    public void setTestIndexDir(Path indicesDir) {
        this.myTestIndicesDir = indicesDir;
    }

    public void clear() {
        this.myUpdatingQueue.clear();
    }

    @NotNull
    private MavenIndices getIndicesObject() {
        MavenIndices mavenIndices = (MavenIndices)ReadAction.nonBlocking(() -> this.ensureInitialized().myIndices).executeSynchronously();
        if (mavenIndices == null) {
            MavenIndicesManager.$$$reportNull$$$0(2);
        }
        return mavenIndices;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private IndexKeeper ensureInitialized() {
        IndexKeeper indexKeeper;
        if (this.myInitStarted.compareAndSet(false, true)) {
            this.startInitialization();
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        while (true) {
            ProgressManager.checkCanceled();
            try {
                IndexKeeper indexKeeper2 = this.myKeeper.get(10L, TimeUnit.MILLISECONDS);
                if (indexKeeper2 == null) continue;
                indexKeeper = indexKeeper2;
            }
            catch (TimeoutException indexKeeper2) {
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            break;
        }
        if (indexKeeper == null) {
            MavenIndicesManager.$$$reportNull$$$0(3);
        }
        return indexKeeper;
    }

    private void startInitialization() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                MavenIndexerWrapper indexer = MavenServerManager.getInstance().createIndexer(this.myProject);
                MavenServerDownloadListener downloadListener = new MavenServerDownloadListener(){

                    public void artifactDownloaded(File file, String relativePath) {
                        MavenIndicesManager.this.addArtifact(file, relativePath);
                    }
                };
                MavenIndices indices = new MavenIndices(indexer, this.getIndicesDir().toFile(), new MavenSearchIndex.IndexListener(){

                    @Override
                    public void indexIsBroken(@NotNull MavenSearchIndex index) {
                        if (index == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (index instanceof MavenIndex) {
                            MavenIndicesManager.this.scheduleUpdate(null, Collections.singletonList((MavenIndex)index), false);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/idea/maven/indices/MavenIndicesManager$2", "indexIsBroken"));
                    }
                });
                ArrayList<Object> archetypes = MavenIndicesManager.loadUserArchetypes(this.getUserArchetypesFile());
                if (archetypes == null) {
                    archetypes = new ArrayList();
                }
                IndexKeeper keeper = new IndexKeeper(indexer, indices, archetypes, downloadListener);
                Disposer.register((Disposable)this, (Disposable)keeper);
                this.myKeeper.complete(keeper);
            }
            catch (Exception e) {
                MavenLog.LOG.error((Throwable)e);
                this.myKeeper.completeExceptionally(e);
            }
        });
    }

    @NotNull
    private Path getIndicesDir() {
        Path path = this.myTestIndicesDir == null ? MavenUtil.getPluginSystemDir("Indices") : this.myTestIndicesDir;
        if (path == null) {
            MavenIndicesManager.$$$reportNull$$$0(4);
        }
        return path;
    }

    public void dispose() {
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            PathKt.delete((Path)this.getIndicesDir());
        }
    }

    public List<MavenIndex> getIndices() {
        return this.getIndicesObject().getIndices();
    }

    public MavenIndex ensureRemoteIndexExist(@NotNull Pair<String, String> remoteIndexIdAndUrl) {
        if (remoteIndexIdAndUrl == null) {
            MavenIndicesManager.$$$reportNull$$$0(5);
        }
        try {
            MavenIndices indicesObjectCache = (MavenIndices)ReadAction.nonBlocking(() -> {
                if (this.myProject.isDisposed()) {
                    return null;
                }
                return this.getIndicesObject();
            }).executeSynchronously();
            if (indicesObjectCache == null) {
                return null;
            }
            return indicesObjectCache.add((String)remoteIndexIdAndUrl.first, (String)remoteIndexIdAndUrl.second, MavenSearchIndex.Kind.REMOTE);
        }
        catch (MavenIndexException e) {
            if (this.myProject.isDisposed()) {
                MavenLog.LOG.warn(e.getMessage());
            } else {
                MavenLog.LOG.warn((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    public MavenIndex createIndexForLocalRepo(Project project2, @Nullable File localRepository) {
        if (localRepository == null) {
            return null;
        }
        MavenIndices indicesObjectCache = this.getIndicesObject();
        try {
            MavenIndex localIndex = indicesObjectCache.add(LOCAL_REPOSITORY_ID, localRepository.getPath(), MavenSearchIndex.Kind.LOCAL);
            if (localIndex.getUpdateTimestamp() == -1L) {
                this.scheduleUpdate(project2, Collections.singletonList(localIndex));
            }
            return localIndex;
        }
        catch (MavenIndexException e) {
            MavenLog.LOG.warn("Cannot create index:" + e.getMessage());
            return null;
        }
    }

    public List<MavenIndex> ensureIndicesExist(Collection<Pair<String, String>> remoteRepositoriesIdsAndUrls) {
        LinkedHashSet<MavenIndex> result = new LinkedHashSet<MavenIndex>();
        for (Pair<String, String> eachIdAndUrl : remoteRepositoriesIdsAndUrls) {
            MavenIndex index = this.ensureRemoteIndexExist(eachIdAndUrl);
            if (index == null) continue;
            result.add(index);
        }
        return new ArrayList<MavenIndex>(result);
    }

    private void addArtifact(File artifactFile, String relativePath) {
        File repositoryFile = MavenIndicesManager.getRepositoryFile(artifactFile, relativePath);
        this.fixArtifactIndexAsync(artifactFile, repositoryFile);
    }

    public void fixArtifactIndexAsync(File artifactFile, File localRepository) {
        if (!this.myKeeper.isDone()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            MavenIndex index = this.getIndicesObject().find(localRepository.getPath(), MavenSearchIndex.Kind.LOCAL);
            if (index != null) {
                this.myIndexFixer.fixIndex(artifactFile, index);
            }
        });
    }

    private static File getRepositoryFile(File artifactFile, String name) {
        List<String> parts = MavenIndicesManager.getArtifactParts(name);
        File result = artifactFile;
        for (int i = 0; i < parts.size(); ++i) {
            result = result.getParentFile();
        }
        return result;
    }

    private static List<String> getArtifactParts(String name) {
        return StringUtil.split((String)name, (String)"/");
    }

    public Promise<Void> scheduleUpdate(@Nullable Project project2, List<MavenIndex> indices) {
        return this.scheduleUpdate(project2, indices, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Promise<Void> scheduleUpdate(final @Nullable Project project2, List<MavenIndex> indices, final boolean fullUpdate) {
        final ArrayList<MavenSearchIndex> toSchedule = new ArrayList<MavenSearchIndex>();
        Object object = this.myUpdatingIndicesLock;
        synchronized (object) {
            for (MavenSearchIndex mavenSearchIndex : indices) {
                if (this.myWaitingIndices.contains(mavenSearchIndex)) continue;
                toSchedule.add(mavenSearchIndex);
            }
            this.myWaitingIndices.addAll(toSchedule);
        }
        if (toSchedule.isEmpty()) {
            return Promises.resolvedPromise();
        }
        final AsyncPromise promise = new AsyncPromise();
        this.myUpdatingQueue.run(new Task.Backgroundable(project2, IndicesBundle.message("maven.indices.updating", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    indicator.setIndeterminate(false);
                    MavenIndicesManager.this.doUpdateIndices(project2, toSchedule, fullUpdate, new MavenProgressIndicator(project2, indicator, null));
                }
                catch (MavenProcessCanceledException mavenProcessCanceledException) {
                }
                finally {
                    promise.setResult(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/indices/MavenIndicesManager$3", "run"));
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateIndices(Project projectOrNull, List<MavenSearchIndex> indices, boolean fullUpdate, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        Object object;
        MavenLog.LOG.assertTrue(!fullUpdate || projectOrNull != null);
        ArrayList<MavenSearchIndex> remainingWaiting = new ArrayList<MavenSearchIndex>(indices);
        try {
            for (MavenSearchIndex each : indices) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText(IndicesBundle.message("maven.indices.updating.index", each.getRepositoryId(), each.getRepositoryPathOrUrl()));
                object = this.myUpdatingIndicesLock;
                synchronized (object) {
                    remainingWaiting.remove(each);
                    this.myWaitingIndices.remove(each);
                    this.myUpdatingIndex = each;
                }
                try {
                    MavenIndices.updateOrRepair(each, fullUpdate, fullUpdate ? MavenIndicesManager.getMavenSettings(projectOrNull, indicator) : null, indicator);
                    if (projectOrNull == null) continue;
                    MavenRehighlighter.rehighlight(projectOrNull);
                }
                finally {
                    object = this.myUpdatingIndicesLock;
                    synchronized (object) {
                        this.myUpdatingIndex = null;
                    }
                }
            }
        }
        finally {
            object = this.myUpdatingIndicesLock;
            synchronized (object) {
                this.myWaitingIndices.removeAll(remainingWaiting);
            }
        }
    }

    private static MavenGeneralSettings getMavenSettings(@NotNull Project project2, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        MavenGeneralSettings settings;
        if (project2 == null) {
            MavenIndicesManager.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            MavenIndicesManager.$$$reportNull$$$0(7);
        }
        if ((settings = (MavenGeneralSettings)ReadAction.compute(() -> project2.isDisposed() ? null : MavenProjectsManager.getInstance(project2).getGeneralSettings().clone())) == null) {
            indicator.cancel();
            indicator.checkCanceled();
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexUpdatingState getUpdatingState(MavenSearchIndex index) {
        Object object = this.myUpdatingIndicesLock;
        synchronized (object) {
            if (this.myUpdatingIndex == index) {
                return IndexUpdatingState.UPDATING;
            }
            if (this.myWaitingIndices.contains(index)) {
                return IndexUpdatingState.WAITING;
            }
            return IndexUpdatingState.IDLE;
        }
    }

    public Set<MavenArchetype> getArchetypes() {
        IndexKeeper indexKeeper = this.ensureInitialized();
        HashSet<MavenArchetype> result = new HashSet<MavenArchetype>(indexKeeper.myIndexer.getArchetypes());
        result.addAll(indexKeeper.myUserArchetypes);
        for (MavenIndex index : indexKeeper.myIndices.getIndices()) {
            result.addAll(index.getArchetypes());
        }
        for (MavenArchetypesProvider each : MavenArchetypesProvider.EP_NAME.getExtensionList()) {
            result.addAll(each.getArchetypes());
        }
        return result;
    }

    public void addArchetype(MavenArchetype archetype) {
        IndexKeeper indexKeeper = this.ensureInitialized();
        List<MavenArchetype> archetypes = indexKeeper.myUserArchetypes;
        int idx = archetypes.indexOf(archetype);
        if (idx >= 0) {
            archetypes.set(idx, archetype);
        } else {
            archetypes.add(archetype);
        }
        this.saveUserArchetypes(archetypes);
    }

    private static ArrayList<MavenArchetype> loadUserArchetypes(Path file) {
        try {
            if (!PathKt.exists((Path)file)) {
                return null;
            }
            LinkedHashSet<MavenArchetype> result = new LinkedHashSet<MavenArchetype>();
            List children = JDOMUtil.load((Path)file).getChildren(ELEMENT_ARCHETYPE);
            for (int i = children.size() - 1; i >= 0; --i) {
                Element each = (Element)children.get(i);
                String groupId = each.getAttributeValue(ELEMENT_GROUP_ID);
                String artifactId = each.getAttributeValue(ELEMENT_ARTIFACT_ID);
                String version2 = each.getAttributeValue(ELEMENT_VERSION);
                String repository = each.getAttributeValue(ELEMENT_REPOSITORY);
                String description = each.getAttributeValue(ELEMENT_DESCRIPTION);
                if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)artifactId) || StringUtil.isEmptyOrSpaces((String)version2)) continue;
                result.add(new MavenArchetype(groupId, artifactId, version2, repository, description));
            }
            ArrayList<MavenArchetype> listResult = new ArrayList<MavenArchetype>(result);
            Collections.reverse(listResult);
            return listResult;
        }
        catch (IOException | JDOMException e) {
            MavenLog.LOG.warn(e);
            return null;
        }
    }

    private void saveUserArchetypes(List<MavenArchetype> userArchetypes) {
        Element root = new Element(ELEMENT_ARCHETYPES);
        for (MavenArchetype each : userArchetypes) {
            Element childElement = new Element(ELEMENT_ARCHETYPE);
            childElement.setAttribute(ELEMENT_GROUP_ID, each.groupId);
            childElement.setAttribute(ELEMENT_ARTIFACT_ID, each.artifactId);
            childElement.setAttribute(ELEMENT_VERSION, each.version);
            if (each.repository != null) {
                childElement.setAttribute(ELEMENT_REPOSITORY, each.repository);
            }
            if (each.description != null) {
                childElement.setAttribute(ELEMENT_DESCRIPTION, each.description);
            }
            root.addContent(childElement);
        }
        try {
            JdomKt.write((Parent)root, (Path)this.getUserArchetypesFile());
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private Path getUserArchetypesFile() {
        Path path = this.getIndicesDir().resolve("UserArchetypes.xml");
        if (path == null) {
            MavenIndicesManager.$$$reportNull$$$0(8);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndicesManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteIndexIdAndUrl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndicesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureInitialized";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesDir";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserArchetypesFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureRemoteIndexExist";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMavenSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class IndexFixer {
        private final Set<String> indexedCache = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
        private final ConcurrentLinkedQueue<Pair<File, MavenIndex>> queueToAdd = new ConcurrentLinkedQueue();
        private final MergingUpdateQueue myMergingUpdateQueue;

        private IndexFixer() {
            this.myMergingUpdateQueue = new MergingUpdateQueue(this.getClass().getName(), 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)MavenIndicesManager.this, null, false).usePassThroughInUnitTestMode();
        }

        public void fixIndex(File file, MavenIndex index) {
            if (this.indexedCache.contains(file.getName())) {
                return;
            }
            this.queueToAdd.add((Pair<File, MavenIndex>)new Pair.NonNull((Object)file, (Object)index));
            this.myMergingUpdateQueue.queue(Update.create((Object)this, (Runnable)new AddToIndexRunnable()));
        }

        private class AddToIndexRunnable
        implements Runnable {
            private AddToIndexRunnable() {
            }

            @Override
            public void run() {
                Pair<File, MavenIndex> elementToAdd;
                ArrayList<Pair<File, MavenIndex>> retryElements = new ArrayList<Pair<File, MavenIndex>>();
                while ((elementToAdd = IndexFixer.this.queueToAdd.poll()) != null) {
                    if (IndexFixer.this.indexedCache.contains(((File)elementToAdd.first).getName())) continue;
                    boolean added = ((MavenIndex)elementToAdd.second).tryAddArtifact((File)elementToAdd.first);
                    if (added) {
                        IndexFixer.this.indexedCache.add(((File)elementToAdd.first).getName());
                        continue;
                    }
                    retryElements.add(elementToAdd);
                }
                if (retryElements.size() < 10000) {
                    IndexFixer.this.queueToAdd.addAll(retryElements);
                }
            }
        }
    }

    public static enum IndexUpdatingState {
        IDLE,
        WAITING,
        UPDATING;

    }

    private class IndexKeeper
    implements Disposable {
        @NotNull
        private final MavenIndexerWrapper myIndexer;
        @NotNull
        private final MavenIndices myIndices;
        @NotNull
        private final List<MavenArchetype> myUserArchetypes;
        @NotNull
        private final MavenServerDownloadListener myDownloadListener;

        private IndexKeeper(@NotNull MavenIndexerWrapper indexer, @NotNull MavenIndices indices, List<MavenArchetype> archetypes, MavenServerDownloadListener downloadListener) {
            if (indexer == null) {
                IndexKeeper.$$$reportNull$$$0(0);
            }
            if (indices == null) {
                IndexKeeper.$$$reportNull$$$0(1);
            }
            if (archetypes == null) {
                IndexKeeper.$$$reportNull$$$0(2);
            }
            this.myIndexer = indexer;
            this.myIndices = indices;
            this.myUserArchetypes = archetypes;
            this.myDownloadListener = downloadListener;
            MavenServerManager.getInstance().addDownloadListener(downloadListener);
        }

        public void dispose() {
            try {
                this.myIndices.close();
            }
            catch (Exception e) {
                MavenLog.LOG.error("", (Throwable)e);
            }
            MavenServerManager mavenServerManager = MavenServerManager.getInstanceIfCreated();
            if (mavenServerManager != null) {
                mavenServerManager.removeDownloadListener(this.myDownloadListener);
            }
            MavenIndicesManager.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indices";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = MavenIndicesManager.ELEMENT_ARCHETYPES;
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/indices/MavenIndicesManager$IndexKeeper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

