/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;

public class MavenRepositoriesConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private JPanel myMainPanel;
    private JBTable myIndicesTable;
    private JButton myUpdateButton;
    private JPanel myBorderPanel;
    private AnimatedIcon myUpdatingIcon;
    private Timer myRepaintTimer;
    private ActionListener myTimerListener;

    public MavenRepositoriesConfigurable(Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.configControls();
        this.myBorderPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)MavenConfigurableBundle.message("maven.settings.repositories.title", new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
    }

    public boolean isModified() {
        return false;
    }

    private void configControls() {
        this.myUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenRepositoriesConfigurable.this.doUpdateIndex();
            }
        });
        this.myIndicesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MavenRepositoriesConfigurable.this.updateButtonsState();
            }
        });
        this.myIndicesTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = MavenRepositoriesConfigurable.this.myIndicesTable.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                MavenRepositoriesConfigurable.this.updateIndexHint(row);
            }
        });
        this.myIndicesTable.setDefaultRenderer(Object.class, (TableCellRenderer)new MyCellRenderer());
        this.myIndicesTable.setDefaultRenderer(MavenIndicesManager.IndexUpdatingState.class, (TableCellRenderer)new MyIconCellRenderer());
        this.myIndicesTable.getEmptyText().setText(MavenConfigurableBundle.message("maven.settings.repositories.no", new Object[0]));
        this.updateButtonsState();
    }

    private void updateButtonsState() {
        boolean hasSelection = !this.myIndicesTable.getSelectionModel().isSelectionEmpty();
        this.myUpdateButton.setEnabled(hasSelection);
    }

    public void updateIndexHint(int row) {
        MavenIndex index = this.getIndexAt(row);
        String message = index.getFailureMessage();
        if (message == null) {
            this.myIndicesTable.setToolTipText(null);
        } else {
            this.myIndicesTable.setToolTipText(message);
        }
    }

    private void doUpdateIndex() {
        MavenProjectIndicesManager.getInstance(this.myProject).scheduleUpdate(this.getSelectedIndices());
    }

    private List<MavenIndex> getSelectedIndices() {
        ArrayList<MavenIndex> result = new ArrayList<MavenIndex>();
        for (int i : this.myIndicesTable.getSelectedRows()) {
            result.add(this.getIndexAt(i));
        }
        return result;
    }

    private MavenIndex getIndexAt(int i) {
        MyTableModel model2 = (MyTableModel)this.myIndicesTable.getModel();
        return model2.getIndex(i);
    }

    public String getDisplayName() {
        return IndicesBundle.message("maven.repositories.title", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.project.maven.repository.indices";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            MavenRepositoriesConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
        this.myIndicesTable.setModel((TableModel)new MyTableModel(MavenProjectIndicesManager.getInstance(this.myProject).getIndices()));
        this.myIndicesTable.getColumnModel().getColumn(0).setPreferredWidth(400);
        this.myIndicesTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.myIndicesTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.myIndicesTable.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.myUpdatingIcon = new AsyncProcessIcon(IndicesBundle.message("maven.indices.updating", new Object[0]));
        this.myUpdatingIcon.resume();
        this.myTimerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenRepositoriesConfigurable.this.myIndicesTable.repaint();
            }
        };
        this.myRepaintTimer = TimerUtil.createNamedTimer((String)"Maven repaint", (int)(AsyncProcessIcon.CYCLE_LENGTH / AsyncProcessIcon.COUNT), (ActionListener)this.myTimerListener);
        this.myRepaintTimer.start();
    }

    public void disposeUIResources() {
        if (this.myRepaintTimer == null) {
            return;
        }
        this.myRepaintTimer.removeActionListener(this.myTimerListener);
        this.myRepaintTimer.stop();
        Disposer.dispose((Disposable)this.myUpdatingIcon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/indices/MavenRepositoriesConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myBorderPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myIndicesTable = jBTable = new JBTable();
        jBTable.setShowHorizontalLines(false);
        jBTable.setShowVerticalLines(false);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUpdateButton = jButton = new JButton();
        jButton.setFocusable(false);
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenRepositoriesConfigurable.class).getString("maven.settings.repositories.update"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyIconCellRenderer
    extends MyCellRenderer {
        MavenIndicesManager.IndexUpdatingState myState;

        private MyIconCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myState = (MavenIndicesManager.IndexUpdatingState)((Object)value);
            return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension size = this.getSize();
            switch (this.myState) {
                case UPDATING: {
                    MavenRepositoriesConfigurable.this.myUpdatingIcon.setBackground(this.getBackground());
                    MavenRepositoriesConfigurable.this.myUpdatingIcon.setSize(size.width, size.height);
                    MavenRepositoriesConfigurable.this.myUpdatingIcon.paint(g);
                    break;
                }
                case WAITING: {
                    int x = (size.width - AllIcons.Process.Step_passive.getIconWidth()) / 2;
                    int y = (size.height - AllIcons.Process.Step_passive.getIconHeight()) / 2;
                    AllIcons.Process.Step_passive.paintIcon(this, g, x, y);
                }
            }
        }
    }

    private class MyCellRenderer
    extends DefaultTableCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(null);
            this.setBackground(null);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            MavenIndex index = MavenRepositoriesConfigurable.this.getIndexAt(row);
            if (index.getFailureMessage() != null) {
                if (isSelected) {
                    this.setForeground((Color)JBColor.PINK);
                } else {
                    this.setBackground((Color)JBColor.PINK);
                }
            }
            return c;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private final String[] COLUMNS = new String[]{IndicesBundle.message("maven.index.url", new Object[0]), IndicesBundle.message("maven.index.type", new Object[0]), IndicesBundle.message("maven.index.updated", new Object[0]), ""};
        private final List<MavenIndex> myIndices;

        MyTableModel(List<MavenIndex> indices) {
            this.myIndices = indices;
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.COLUMNS[index];
        }

        @Override
        public int getRowCount() {
            return this.myIndices.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return MavenIndicesManager.IndexUpdatingState.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MavenIndex i = this.getIndex(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return i.getRepositoryPathOrUrl();
                }
                case 1: {
                    if (i.getKind() == MavenSearchIndex.Kind.LOCAL) {
                        return "Local";
                    }
                    if (i.getKind() == MavenSearchIndex.Kind.ONLINE) {
                        return "Online";
                    }
                    return "Remote";
                }
                case 2: {
                    if (i.getFailureMessage() != null) {
                        return IndicesBundle.message("maven.index.updated.error", new Object[0]);
                    }
                    long timestamp = i.getUpdateTimestamp();
                    if (timestamp == -1L) {
                        return IndicesBundle.message("maven.index.updated.never", new Object[0]);
                    }
                    return DateFormatUtil.formatDate((long)timestamp);
                }
                case 3: {
                    return MavenProjectIndicesManager.getInstance(MavenRepositoriesConfigurable.this.myProject).getUpdatingState(i);
                }
            }
            throw new RuntimeException();
        }

        public MavenIndex getIndex(int rowIndex) {
            return this.myIndices.get(rowIndex);
        }
    }
}

