/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenUnlinkedProjectAware;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenOpenProjectProvider;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/project/MavenUnlinkedProjectAware;", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "isBuildFile", "", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLinkedProject", "externalProjectPath", "", "linkAndLoadProject", "", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "ProjectsTreeListener", "intellij.maven"})
public final class MavenUnlinkedProjectAware
implements ExternalSystemUnlinkedProjectAware {
    @NotNull
    private final ProjectSystemId systemId;

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    public boolean isBuildFile(@NotNull Project project2, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return MavenUtil.isPomFile(project2, buildFile);
    }

    public boolean isLinkedProject(@NotNull Project project2, @NotNull String externalProjectPath) {
        boolean bl;
        block3: {
            MavenProjectsManager mavenProjectsManager;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            MavenProjectsManager mavenProjectsManager2 = mavenProjectsManager = MavenProjectsManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager2, (String)"mavenProjectsManager");
            List<MavenProject> list = mavenProjectsManager2.getProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProjectsManager.projects");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MavenProject it = (MavenProject)element$iv;
                    boolean bl2 = false;
                    MavenProject mavenProject2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"it");
                    if (!VfsUtilCore.pathEqualsTo((VirtualFile)mavenProject2.getDirectoryFile(), (String)externalProjectPath)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void subscribe(@NotNull Project project2, @NotNull ExternalSystemProjectLinkListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        mavenProjectsManager.addProjectsTreeListener(new ProjectsTreeListener(project2, listener2), parentDisposable);
    }

    public void linkAndLoadProject(@NotNull Project project2, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        new MavenOpenProjectProvider().linkToExistingProject(externalProjectPath, project2);
    }

    public MavenUnlinkedProjectAware() {
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"MavenUtil.SYSTEM_ID");
        this.systemId = projectSystemId;
    }

    @Nls
    @NotNull
    public String getNotificationText() {
        return ExternalSystemUnlinkedProjectAware.DefaultImpls.getNotificationText((ExternalSystemUnlinkedProjectAware)this);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u0017\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\u000e\u00a2\u0006\u0002\b\r0\n\u00a2\u0006\u0002\b\rH\u0002J0\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRF\u0010\t\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\u000e\u00a2\u0006\u0002\b\r0\n\u00a2\u0006\u0002\b\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/project/MavenUnlinkedProjectAware$ProjectsTreeListener;", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;)V", "getListener", "()Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "mavenProjects", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getMavenProjects", "()Ljava/util/Set;", "setMavenProjects", "(Ljava/util/Set;)V", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "getMavenProjectsManager", "()Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "getMavenProjectPaths", "projectsUpdated", "", "updated", "", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "deleted", "intellij.maven"})
    private static final class ProjectsTreeListener
    implements MavenProjectsTree.Listener {
        @NotNull
        private final MavenProjectsManager mavenProjectsManager;
        @NotNull
        private Set<String> mavenProjects;
        @NotNull
        private final ExternalSystemProjectLinkListener listener;

        @NotNull
        public final MavenProjectsManager getMavenProjectsManager() {
            return this.mavenProjectsManager;
        }

        @NotNull
        public final Set<String> getMavenProjects() {
            return this.mavenProjects;
        }

        public final void setMavenProjects(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.mavenProjects = set;
        }

        public void projectsUpdated(@NotNull List<? extends Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<? extends MavenProject> deleted) {
            MavenProject it;
            Object element$iv;
            Intrinsics.checkNotNullParameter(updated, (String)"updated");
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            Object $this$forEach$iv = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)updated), (Function1)projectsUpdated.1.INSTANCE), (Function1)((Function1)new Function1<MavenProject, Boolean>(this){
                final /* synthetic */ ProjectsTreeListener this$0;

                public final boolean invoke(MavenProject it) {
                    Set<String> set = this.this$0.getMavenProjects();
                    MavenProject mavenProject2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"it");
                    return set.contains(mavenProject2.getDirectory());
                }
                {
                    this.this$0 = projectsTreeListener;
                    super(1);
                }
            }));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (MavenProject)element$iv;
                boolean bl = false;
                MavenProject mavenProject2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"it");
                String string = mavenProject2.getDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.directory");
                this.listener.onProjectLinked(string);
            }
            $this$forEach$iv = deleted;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (MavenProject)element$iv;
                boolean bl = false;
                String string = it.getDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.directory");
                this.listener.onProjectUnlinked(string);
            }
            this.mavenProjects = this.getMavenProjectPaths();
        }

        private final Set<String> getMavenProjectPaths() {
            List<MavenProject> list = this.mavenProjectsManager.getProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProjectsManager.projects");
            Collection collection = SequencesKt.toCollection((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getMavenProjectPaths.1.INSTANCE), (Collection)CollectionFactory.createFilePathSet());
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"mavenProjectsManager.pro\u2026tory.createFilePathSet())");
            return (Set)collection;
        }

        @NotNull
        public final ExternalSystemProjectLinkListener getListener() {
            return this.listener;
        }

        public ProjectsTreeListener(@NotNull Project project2, @NotNull ExternalSystemProjectLinkListener listener2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.listener = listener2;
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
            this.mavenProjectsManager = mavenProjectsManager;
            this.mavenProjects = this.getMavenProjectPaths();
        }
    }
}

