/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.server.MavenBuildPathsChange;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;

public abstract class MavenServerConnector
implements Disposable {
    public static final Logger LOG = Logger.getInstance(MavenServerConnector.class);
    protected final Project myProject;
    protected final MavenServerManager myManager;
    @NotNull
    protected final MavenDistribution myDistribution;
    protected final Sdk myJdk;
    protected final Set<String> myMultimoduleDirectories;
    protected final String myVmOptions;

    public MavenServerConnector(@NotNull Project project2, @NotNull MavenServerManager manager, @NotNull Sdk jdk2, @NotNull String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        if (project2 == null) {
            MavenServerConnector.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MavenServerConnector.$$$reportNull$$$0(1);
        }
        if (jdk2 == null) {
            MavenServerConnector.$$$reportNull$$$0(2);
        }
        if (vmOptions == null) {
            MavenServerConnector.$$$reportNull$$$0(3);
        }
        if (mavenDistribution == null) {
            MavenServerConnector.$$$reportNull$$$0(4);
        }
        if (multimoduleDirectory == null) {
            MavenServerConnector.$$$reportNull$$$0(5);
        }
        this.myProject = project2;
        this.myManager = manager;
        this.myDistribution = mavenDistribution;
        this.myVmOptions = vmOptions;
        this.myJdk = jdk2;
        this.myMultimoduleDirectories = new LinkedHashSet<String>();
        this.myMultimoduleDirectories.add(multimoduleDirectory);
    }

    boolean addMultimoduleDir(String multimoduleDirectory) {
        return this.myMultimoduleDirectories.add(multimoduleDirectory);
    }

    abstract boolean isNew();

    public abstract boolean isCompatibleWith(Sdk var1, String var2, MavenDistribution var3);

    protected abstract void connect();

    @NotNull
    protected abstract MavenServer getServer();

    MavenServerEmbedder createEmbedder(MavenEmbedderSettings settings) throws RemoteException {
        return this.getServer().createEmbedder(settings, MavenRemoteObjectWrapper.ourToken);
    }

    MavenServerIndexer createIndexer() throws RemoteException {
        return this.getServer().createIndexer(MavenRemoteObjectWrapper.ourToken);
    }

    @NotNull
    public MavenModel interpolateAndAlignModel(MavenModel model2, File basedir) {
        MavenModel mavenModel = this.perform(() -> {
            MavenModel m = this.getServer().interpolateAndAlignModel(model2, basedir, MavenRemoteObjectWrapper.ourToken);
            RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(this.myProject);
            if (transformer != RemotePathTransformerFactory.Transformer.ID) {
                new MavenBuildPathsChange((Function1<? super String, String>)((Function1)s -> transformer.toIdePath((String)s)), (Function1<? super String, Boolean>)((Function1)s -> transformer.canBeRemotePath((String)s))).perform(m);
            }
            return m;
        });
        if (mavenModel == null) {
            MavenServerConnector.$$$reportNull$$$0(6);
        }
        return mavenModel;
    }

    public MavenModel assembleInheritance(MavenModel model2, MavenModel parentModel) {
        return this.perform(() -> this.getServer().assembleInheritance(model2, parentModel, MavenRemoteObjectWrapper.ourToken));
    }

    public ProfileApplicationResult applyProfiles(MavenModel model2, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        return this.perform(() -> this.getServer().applyProfiles(model2, basedir, explicitProfiles, alwaysOnProfiles, MavenRemoteObjectWrapper.ourToken));
    }

    public abstract void addDownloadListener(MavenServerDownloadListener var1);

    public abstract void removeDownloadListener(MavenServerDownloadListener var1);

    @ApiStatus.Internal
    public void shutdown(boolean wait) {
        this.myManager.cleanUp(this);
    }

    protected <R, E extends Exception> R perform(RemoteObjectWrapper.Retriable<R, E> r) throws E {
        try {
            return r.execute();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String getSupportType();

    public abstract State getState();

    public abstract boolean checkConnected();

    public void dispose() {
        this.shutdown(true);
    }

    @NotNull
    public Sdk getJdk() {
        Sdk sdk = this.myJdk;
        if (sdk == null) {
            MavenServerConnector.$$$reportNull$$$0(7);
        }
        return sdk;
    }

    public MavenDistribution getMavenDistribution() {
        return this.myDistribution;
    }

    public String getVMOptions() {
        return this.myVmOptions;
    }

    public Project getProject() {
        return this.myProject;
    }

    public List<String> getMultimoduleDirectories() {
        return new ArrayList<String>(this.myMultimoduleDirectories);
    }

    public String toString() {
        return "MavenServerConnector{" + Integer.toHexString(this.hashCode()) + ", myDistribution=" + this.myDistribution.getMavenHome() + ", myJdk=" + this.myJdk.getName() + ", myMultimoduleDirectories=" + this.myMultimoduleDirectories + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDistribution";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multimoduleDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerConnector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerConnector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum State {
        STARTING,
        RUNNING,
        FAILED,
        STOPPED;

    }
}

