/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenAttachSourcesProvider
implements AttachSourcesProvider {
    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, final PsiFile psiFile) {
        Collection<MavenProject> projects = MavenAttachSourcesProvider.getMavenProjects(psiFile);
        if (projects.isEmpty()) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                MavenAttachSourcesProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (MavenAttachSourcesProvider.findArtifacts(projects, orderEntries).isEmpty()) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                MavenAttachSourcesProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Set<AttachSourcesProvider.AttachSourcesAction> set = Collections.singleton(new AttachSourcesProvider.AttachSourcesAction(){

            public String getName() {
                return MavenProjectBundle.message("maven.action.download.sources", new Object[0]);
            }

            public String getBusyText() {
                return MavenProjectBundle.message("maven.action.download.sources.busy.text", new Object[0]);
            }

            public ActionCallback perform(List<LibraryOrderEntry> orderEntries) {
                Collection<MavenProject> mavenProjects = MavenAttachSourcesProvider.getMavenProjects(psiFile);
                if (mavenProjects.isEmpty()) {
                    return ActionCallback.REJECTED;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(psiFile.getProject());
                Collection<MavenArtifact> artifacts = MavenAttachSourcesProvider.findArtifacts(mavenProjects, orderEntries);
                if (artifacts.isEmpty()) {
                    return ActionCallback.REJECTED;
                }
                AsyncPromise result = new AsyncPromise();
                manager.scheduleArtifactsDownloading(mavenProjects, artifacts, true, false, (AsyncPromise<MavenArtifactDownloader.DownloadResult>)result);
                ActionCallback resultWrapper = new ActionCallback();
                result.onSuccess(downloadResult -> {
                    HtmlBuilder builder = null;
                    if (!downloadResult.unresolvedSources.isEmpty()) {
                        builder = new HtmlBuilder();
                        builder.append(MavenProjectBundle.message("sources.not.found.for", new Object[0]));
                        int count = 0;
                        for (MavenId each : downloadResult.unresolvedSources) {
                            if (count++ > 5) {
                                builder.append((HtmlChunk)HtmlChunk.br()).append(MavenProjectBundle.message("and.more", new Object[0]));
                                break;
                            }
                            builder.append((HtmlChunk)HtmlChunk.br()).append(each.getDisplayString());
                        }
                    }
                    if (builder != null) {
                        MavenAttachSourcesProvider.cleanUpUnresolvedSourceFiles(psiFile.getProject(), downloadResult.unresolvedSources);
                        Notifications.Bus.notify((Notification)new Notification("Maven", MavenProjectBundle.message("maven.sources.cannot.download", new Object[0]), builder.wrapWithHtmlBody().toString(), NotificationType.WARNING), (Project)psiFile.getProject());
                    }
                    if (downloadResult.resolvedSources.isEmpty()) {
                        resultWrapper.setRejected();
                    } else {
                        resultWrapper.setDone();
                    }
                });
                return resultWrapper;
            }
        });
        if (set == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static void cleanUpUnresolvedSourceFiles(Project project2, Collection<MavenId> mavenIds) {
        for (MavenId mavenId : mavenIds) {
            File[] files2;
            File parentFile = MavenUtil.getRepositoryParentFile(project2, mavenId);
            if (parentFile == null || (files2 = parentFile.listFiles((dir2, name) -> MavenAttachSourcesProvider.isTargetFile(name, MavenExtraArtifactType.SOURCES))) == null) continue;
            for (File file : files2) {
                boolean deleted = FileUtil.delete((File)file);
                if (deleted) continue;
                MavenLog.LOG.warn(file + " not deleted");
            }
        }
    }

    private static boolean isTargetFile(String name, MavenExtraArtifactType type2) {
        return name.contains("-" + type2.getDefaultClassifier()) && name.contains("." + type2.getDefaultExtension());
    }

    private static Collection<MavenArtifact> findArtifacts(Collection<MavenProject> mavenProjects, List<LibraryOrderEntry> orderEntries) {
        HashSet<MavenArtifact> artifacts = new HashSet<MavenArtifact>();
        for (MavenProject each : mavenProjects) {
            for (LibraryOrderEntry entry : orderEntries) {
                MavenArtifact artifact = MavenRootModelAdapter.findArtifact(each, entry.getLibrary());
                if (artifact == null || "system".equals(artifact.getScope())) continue;
                artifacts.add(artifact);
            }
        }
        return artifacts;
    }

    private static Collection<MavenProject> getMavenProjects(PsiFile psiFile) {
        Project project2 = psiFile.getProject();
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (OrderEntry each : ProjectRootManager.getInstance((Project)project2).getFileIndex().getOrderEntriesForFile(psiFile.getVirtualFile())) {
            MavenProject mavenProject2 = MavenProjectsManager.getInstance(project2).findProject(each.getOwnerModule());
            if (mavenProject2 == null) continue;
            result.add(mavenProject2);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenAttachSourcesProvider", "getActions"));
    }
}

