/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.kpmsearch;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.HttpRequests;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.kpmsearch.PackageSearchEndpointConfig;

public final class DefaultPackageServiceConfig
implements PackageSearchEndpointConfig {
    private static final Object MUTEX = new Object();
    public static final long TIMEOUT = Registry.intValue((String)"packagesearch.timeout");
    private static final long INFO_TTL = TimeUnit.DAYS.toMillis(7L);
    private static final String CONFIG_URL = Registry.stringValue((String)"packagesearch.config.url");
    private static final String CONFIG_UPDATED_TIMESTAMP_KEY = "packagesearch.status.updated.ts";
    private static final String CONFIG_URL_KEY_PREFIX = "packagesearch.endpoint.url.";
    private static final Gson GSON = new Gson();
    private volatile PackageSearchEndpointUrls myPackageSearchEndpointUrls;

    public DefaultPackageServiceConfig() {
        if (ApplicationManager.getApplication().isUnitTestMode() || !Registry.is((String)"maven.packagesearch.enabled")) {
            this.myPackageSearchEndpointUrls = null;
            return;
        }
        this.updateIfNessesary();
    }

    private Promise<PackageSearchEndpointUrls> reloadConfig() {
        AsyncPromise asyncPromise = new AsyncPromise();
        asyncPromise.onError(t -> {});
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                LinkedTreeMap config = (LinkedTreeMap)GSON.fromJson(HttpRequests.request((String)CONFIG_URL).userAgent(this.getUserAgent()).forceHttps(true).readString(), LinkedTreeMap.class);
                Object idea = config.get((Object)"idea");
                if (!(idea instanceof Map)) {
                    asyncPromise.setResult((Object)new PackageSearchEndpointUrls(null, null));
                    return;
                }
                String fulltextUrl = DefaultPackageServiceConfig.extract("fulltext", (Map)idea);
                String suggestUrl = DefaultPackageServiceConfig.extract("suggest", (Map)idea);
                asyncPromise.setResult((Object)new PackageSearchEndpointUrls(fulltextUrl, suggestUrl));
            }
            catch (Exception e) {
                asyncPromise.setError((Throwable)e);
            }
        });
        return asyncPromise;
    }

    @Override
    public String getFullTextUrl() {
        if (this.myPackageSearchEndpointUrls == null) {
            return null;
        }
        return this.myPackageSearchEndpointUrls.fulltextUrl;
    }

    @Override
    public String getSuggestUrl() {
        if (this.myPackageSearchEndpointUrls == null) {
            return null;
        }
        return this.myPackageSearchEndpointUrls.suggestUrl;
    }

    @Override
    public int getReadTimeout() {
        return (int)TIMEOUT;
    }

    @Override
    public int getConnectTimeout() {
        return (int)TIMEOUT;
    }

    private static String extract(String fulltext, Map<Object, Object> idea) {
        Object url;
        Object enabled;
        Object urlMap = idea.get(fulltext);
        if (urlMap instanceof Map && Boolean.valueOf(String.valueOf(enabled = ((Map)urlMap).get("enabled"))).booleanValue() && (url = ((Map)urlMap).get("url")) instanceof String) {
            return url.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfNessesary() {
        Object object = MUTEX;
        synchronized (object) {
            long updatedTimestamp = PropertiesComponent.getInstance().getLong(CONFIG_UPDATED_TIMESTAMP_KEY, 0L);
            if (System.currentTimeMillis() - updatedTimestamp > INFO_TTL) {
                this.reloadConfig().onSuccess(eu -> {
                    PropertiesComponent.getInstance().setValue(CONFIG_UPDATED_TIMESTAMP_KEY, String.valueOf(System.currentTimeMillis()));
                    PropertiesComponent.getInstance().setValue("packagesearch.endpoint.url.fulltext", eu.fulltextUrl);
                    PropertiesComponent.getInstance().setValue("packagesearch.endpoint.url.suggest", eu.suggestUrl);
                    this.myPackageSearchEndpointUrls = eu;
                    this.myPackageSearchEndpointUrls = DefaultPackageServiceConfig.loadPersistedResult();
                });
            } else {
                this.myPackageSearchEndpointUrls = DefaultPackageServiceConfig.loadPersistedResult();
            }
        }
    }

    @NotNull
    private static PackageSearchEndpointUrls loadPersistedResult() {
        return new PackageSearchEndpointUrls(PropertiesComponent.getInstance().getValue("packagesearch.endpoint.url.fulltext"), PropertiesComponent.getInstance().getValue("packagesearch.endpoint.url.suggest"));
    }

    static class PackageSearchEndpointUrls {
        final String fulltextUrl;
        final String suggestUrl;

        PackageSearchEndpointUrls(String fulltextUrl, String suggestUrl) {
            this.fulltextUrl = fulltextUrl;
            this.suggestUrl = suggestUrl;
        }
    }
}

