/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.mercury.artifact.ArtifactMetadata;
import org.apache.maven.mercury.artifact.ArtifactScopeEnum;
import org.apache.maven.mercury.artifact.Counter;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataTreeNode {
    private static final int DEFAULT_QUERY_COUNT = 8;
    private static final int DEFAULT_CHILDREN_COUNT = 16;
    private static final Language LANG = new DefaultLanguage(MetadataTreeNode.class);
    ArtifactMetadata md;
    boolean optional = false;
    boolean real = true;
    MetadataTreeNode parent;
    int id;
    ArtifactMetadata query;
    List<ArtifactMetadata> queries;
    List<MetadataTreeNode> children;
    String name;

    public int countNodes() {
        return MetadataTreeNode.countNodes(this);
    }

    public static int countNodes(MetadataTreeNode node) {
        int res = 1;
        if (node.children != null && node.children.size() > 0) {
            for (MetadataTreeNode child : node.children) {
                res += MetadataTreeNode.countNodes(child);
            }
        }
        return res;
    }

    public int countDistinctNodes() {
        TreeSet<String> nodes = new TreeSet<String>();
        MetadataTreeNode.getDistinctNodes(this, nodes);
        return nodes.size();
    }

    public static void getDistinctNodes(MetadataTreeNode node, TreeSet<String> nodes) {
        if (node.getMd() == null) {
            throw new IllegalArgumentException("tree node without metadata");
        }
        nodes.add(node.getMd().getGAV());
        if (node.children != null && node.children.size() > 0) {
            for (MetadataTreeNode child : node.children) {
                MetadataTreeNode.getDistinctNodes(child, nodes);
            }
        }
    }

    public MetadataTreeNode() {
    }

    public MetadataTreeNode(ArtifactMetadata md, MetadataTreeNode parent, ArtifactMetadata query) {
        if (md != null) {
            md.setArtifactScope(ArtifactScopeEnum.checkScope(md.getArtifactScope()));
        }
        this.md = md;
        this.parent = parent;
        this.query = query;
    }

    public MetadataTreeNode addChild(MetadataTreeNode kid) {
        if (kid == null) {
            return this;
        }
        if (this.children == null) {
            this.children = new ArrayList<MetadataTreeNode>(16);
        }
        kid.setParent(this);
        this.children.add(kid);
        return this;
    }

    public MetadataTreeNode addQuery(ArtifactMetadata query) {
        if (query == null) {
            return this;
        }
        if (this.queries == null) {
            this.queries = new ArrayList<ArtifactMetadata>(8);
        }
        this.queries.add(query);
        return this;
    }

    public String toString() {
        return this.md == null ? "no metadata, parent " + (this.parent == null ? "null" : this.parent.toString()) : this.md.toString() + ":d=" + this.getDepth();
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public ArtifactMetadata getMd() {
        return this.md;
    }

    public MetadataTreeNode getParent() {
        return this.parent;
    }

    public int getDepth() {
        int depth = 0;
        MetadataTreeNode p = this.parent;
        while (p != null) {
            ++depth;
            p = p.parent;
        }
        return depth;
    }

    public int getMaxDepth(int depth) {
        int res = 0;
        if (!this.hasChildren()) {
            return depth + 1;
        }
        for (MetadataTreeNode kid : this.children) {
            int kidDepth = kid.getMaxDepth(depth + 1);
            if (kidDepth <= res) continue;
            res = kidDepth;
        }
        return res;
    }

    public void setParent(MetadataTreeNode parent) {
        this.parent = parent;
    }

    public List<MetadataTreeNode> getChildren() {
        return this.children;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isReal() {
        return this.real;
    }

    public void setReal(boolean real) {
        this.real = real;
    }

    public ArtifactMetadata getQuery() {
        return this.query;
    }

    public List<ArtifactMetadata> getQueries() {
        return this.queries;
    }

    public static final MetadataTreeNode deepCopy(MetadataTreeNode node) {
        MetadataTreeNode res = new MetadataTreeNode(node.getMd(), node.getParent(), node.getQuery());
        res.setId(node.getId());
        if (node.hasChildren()) {
            for (MetadataTreeNode kid : node.children) {
                MetadataTreeNode deepKid = MetadataTreeNode.deepCopy(kid);
                res.addChild(deepKid);
            }
        }
        return res;
    }

    public static final void showNode(MetadataTreeNode n, int level, Writer wr) throws IOException {
        if (n == null) {
            wr.write("null node");
            return;
        }
        for (int i = 0; i < level; ++i) {
            wr.write("  ");
        }
        wr.write(level + " " + n.getMd() + "\n");
        if (n.hasChildren()) {
            for (MetadataTreeNode kid : n.getChildren()) {
                MetadataTreeNode.showNode(kid, level + 1, wr);
            }
        }
    }

    public static final void showNode(MetadataTreeNode n, int level) throws IOException {
        StringWriter sw = new StringWriter();
        MetadataTreeNode.showNode(n, 0, sw);
        System.out.println(sw.toString());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public static void reNumber(MetadataTreeNode node, int startNum) {
        MetadataTreeNode.reNum(node, new Counter(startNum));
    }

    private static void reNum(MetadataTreeNode node, Counter num) {
        node.setId(num.next());
        if (node.hasChildren()) {
            for (MetadataTreeNode kid : node.getChildren()) {
                MetadataTreeNode.reNum(kid, num);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void createNames(int level, int seq) {
        this.name = this.md.toScopedString() + ":" + level + "." + seq;
        if (this.hasChildren()) {
            int no = 0;
            for (MetadataTreeNode kid : this.children) {
                kid.createNames(level + 1, no++);
            }
        }
    }
}

