/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors.string;

import com.intellij.ide.DataManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.editors.string.NewKeyDialog;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditorDialog;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeyChooserDialog
extends DialogWrapper {
    private final PropertiesFile myBundle;
    private final String myBundleName;
    private ArrayList<Couple<String>> myPairs;
    private final JComponent myCenterPanel;
    private final JTable myTable;
    @NonNls
    private static final String NULL = "null";
    private final MyTableModel myModel;
    private final GuiEditor myEditor;
    private static final String OK_ACTION = "OkAction";

    public KeyChooserDialog(Component parent, @NotNull PropertiesFile bundle, @NotNull String bundleName, String keyToPreselect, GuiEditor editor) {
        int maxWidth;
        if (bundle == null) {
            KeyChooserDialog.$$$reportNull$$$0(0);
        }
        if (bundleName == null) {
            KeyChooserDialog.$$$reportNull$$$0(1);
        }
        super(parent, true);
        this.myEditor = editor;
        this.myBundle = bundle;
        this.myBundleName = bundleName;
        this.setTitle(UIDesignerBundle.message("title.chooser.value", new Object[0]));
        this.fillPropertyList();
        this.myModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myModel);
        this.myTable.getSelectionModel().setSelectionMode(0);
        new MySpeedSearch(this.myTable);
        this.myCenterPanel = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        this.myTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), OK_ACTION);
        this.myTable.getActionMap().put(OK_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyChooserDialog.this.getOKAction().actionPerformed(e);
            }
        });
        Project projectGuess = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parent));
        Dimension size = DimensionService.getInstance().getSize(this.getDimensionServiceKey(), projectGuess);
        FontMetrics metrics = this.myTable.getFontMetrics(this.myTable.getFont());
        int minWidth = 200;
        int n = maxWidth = size != null ? size.width / 2 : Integer.MAX_VALUE;
        if (minWidth > maxWidth) {
            minWidth = maxWidth;
        }
        int width = minWidth;
        for (int i = this.myPairs.size() - 1; i >= 0; --i) {
            Couple<String> pair = this.myPairs.get(i);
            width = Math.max(width, metrics.stringWidth((String)pair.getFirst()));
        }
        width += 20;
        width = Math.max(width, metrics.stringWidth(this.myModel.getColumnName(0)));
        width = Math.max(width, minWidth);
        width = Math.min(width, maxWidth);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn keyColumn = columnModel.getColumn(0);
        keyColumn.setMaxWidth(width);
        keyColumn.setMinWidth(width);
        TableCellRenderer defaultRenderer = this.myTable.getDefaultRenderer(String.class);
        if (defaultRenderer instanceof JComponent) {
            JComponent component = (JComponent)((Object)defaultRenderer);
            component.putClientProperty("html.disable", Boolean.TRUE);
        }
        this.selectKey(keyToPreselect);
        this.init();
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                KeyChooserDialog.this.doOKAction();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/propertyInspector/editors/string/KeyChooserDialog$2", "onDoubleClick"));
            }
        }.installOn((Component)this.myTable);
    }

    private void fillPropertyList() {
        this.myPairs = new ArrayList();
        List properties = this.myBundle.getProperties();
        for (IProperty property : properties) {
            String key = property.getUnescapedKey();
            String value = property.getValue();
            if (key == null) continue;
            this.myPairs.add((Couple<String>)Couple.of((Object)key, (Object)(value != null ? value : NULL)));
        }
        this.myPairs.sort(new MyPairComparator());
    }

    private void selectKey(String keyToPreselect) {
        int indexToPreselect = -1;
        for (int i = this.myPairs.size() - 1; i >= 0; --i) {
            Couple<String> pair = this.myPairs.get(i);
            if (!((String)pair.getFirst()).equals(keyToPreselect)) continue;
            indexToPreselect = i;
            break;
        }
        if (indexToPreselect != -1) {
            this.selectElementAt(indexToPreselect);
        }
    }

    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = new Action[]{new NewKeyValueAction()};
        if (actionArray == null) {
            KeyChooserDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    private void selectElementAt(int index) {
        this.myTable.getSelectionModel().setSelectionInterval(index, index);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(index, 0, true));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            KeyChooserDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    @Nullable
    StringDescriptor getDescriptor() {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow < 0 || selectedRow >= this.myTable.getRowCount()) {
            return null;
        }
        Couple<String> pair = this.myPairs.get(selectedRow);
        StringDescriptor descriptor = new StringDescriptor(this.myBundleName, (String)pair.getFirst());
        descriptor.setResolvedValue((String)pair.getSecond());
        return descriptor;
    }

    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/editors/string/KeyChooserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/editors/string/KeyChooserDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NewKeyValueAction
    extends AbstractAction {
        NewKeyValueAction() {
            this.putValue("Name", UIDesignerBundle.message("key.chooser.new.property", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewKeyDialog dlg = new NewKeyDialog(KeyChooserDialog.this.getWindow());
            if (dlg.showAndGet()) {
                if (!StringEditorDialog.saveCreatedProperty(KeyChooserDialog.this.myBundle, dlg.getName(), dlg.getValue(), KeyChooserDialog.this.myEditor.getPsiFile())) {
                    return;
                }
                KeyChooserDialog.this.fillPropertyList();
                KeyChooserDialog.this.myModel.update();
                KeyChooserDialog.this.selectKey(dlg.getName());
            }
        }
    }

    private final class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        private Object2IntMap<Object> myElements;
        private Object[] myElementsArray;

        MySpeedSearch(JTable component) {
            super((JComponent)component);
        }

        protected int convertIndexToModel(int viewIndex) {
            return ((JTable)this.getComponent()).convertRowIndexToModel(viewIndex);
        }

        public int getSelectedIndex() {
            return ((JTable)this.myComponent).getSelectedRow();
        }

        public Object @NotNull [] getAllElements() {
            if (this.myElements == null) {
                this.myElements = new Object2IntOpenHashMap();
                this.myElementsArray = KeyChooserDialog.this.myPairs.toArray();
                for (int idx = 0; idx < this.myElementsArray.length; ++idx) {
                    Object element = this.myElementsArray[idx];
                    this.myElements.put(element, idx);
                }
            }
            if (this.myElementsArray == null) {
                MySpeedSearch.$$$reportNull$$$0(0);
            }
            return this.myElementsArray;
        }

        public String getElementText(Object element) {
            return (String)((Couple)element).getFirst();
        }

        public void selectElement(Object element, String selectedText) {
            int index = this.myElements.getInt(element);
            KeyChooserDialog.this.selectElementAt(((JTable)this.getComponent()).convertRowIndexToView(index));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/editors/string/KeyChooserDialog$MySpeedSearch", "getAllElements"));
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return UIDesignerBundle.message("column.key", new Object[0]);
            }
            if (column == 1) {
                return UIDesignerBundle.message("column.value", new Object[0]);
            }
            throw new IllegalArgumentException("unknown column: " + column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return String.class;
            }
            if (column == 1) {
                return String.class;
            }
            throw new IllegalArgumentException("unknown column: " + column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return KeyChooserDialog.this.myPairs.get(row).getFirst();
            }
            if (column == 1) {
                return KeyChooserDialog.this.myPairs.get(row).getSecond();
            }
            throw new IllegalArgumentException("unknown column: " + column);
        }

        @Override
        public int getRowCount() {
            return KeyChooserDialog.this.myPairs.size();
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }

    private static final class MyPairComparator
    implements Comparator<Couple<String>> {
        private MyPairComparator() {
        }

        @Override
        public int compare(Couple<String> p1, Couple<String> p2) {
            return ((String)p1.getFirst()).compareToIgnoreCase((String)p2.getFirst());
        }
    }
}

