/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.ui;

import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.ui.icons.SpaceMeIcon;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RoundedIcon;
import com.intellij.util.ui.AvatarUtils;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/space/ui/SpaceAvatarUtils;", "", "()V", "OUTLINE_WIDTH", "", "getOUTLINE_WIDTH", "()I", "buildImageWithStatus", "Ljava/awt/image/BufferedImage;", "image", "statusColor", "Ljava/awt/Color;", "buildImageWithStatus$intellij_space", "createAvatars", "Lcom/intellij/space/ui/icons/SpaceMeIcon;", "generateAvatars", "gradientSeed", "", "name", "outlineCircleIcon", "Ljavax/swing/Icon;", "icon", "outlineColor", "intellij.space"})
public final class SpaceAvatarUtils {
    @NotNull
    public static final SpaceAvatarUtils INSTANCE;

    public final int getOUTLINE_WIDTH() {
        return JBUI.scale((int)3);
    }

    @NotNull
    public final BufferedImage buildImageWithStatus$intellij_space(@NotNull BufferedImage image, @NotNull Color statusColor) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)statusColor, (String)"statusColor");
        int n = image.getWidth();
        int n2 = image.getHeight();
        boolean bl = false;
        int size = Math.min(n, n2);
        double outerD = (double)size / 2.5;
        double innerD = (double)size / 3.5;
        int greenSize = (int)((double)size - (innerD + outerD) / (double)2);
        Area avatarOvalArea = new Area(new Ellipse2D.Double(0.0, 0.0, size, size));
        Area onlineOvalArea = new Area(new Ellipse2D.Double(greenSize, greenSize, outerD, outerD));
        avatarOvalArea.subtract(onlineOvalArea);
        BufferedImage bufferedImage = ImageUtil.createImageByMask((BufferedImage)image, (Area)avatarOvalArea);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImageByMask(image, avatarOvalArea)");
        BufferedImage circleAvatar = bufferedImage;
        Graphics2D g2 = circleAvatar.createGraphics();
        ImageUtil.applyQualityRenderingHints((Graphics2D)g2);
        Graphics2D graphics2D = g2;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"g2");
        graphics2D.setPaint(statusColor);
        g2.fillOval(size - (int)innerD, size - (int)innerD, (int)innerD, (int)innerD);
        g2.dispose();
        return circleAvatar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Icon outlineCircleIcon(@NotNull Icon icon, @Nullable Color outlineColor) {
        JBScalableIcon jBScalableIcon;
        BufferedImage colorImage;
        BufferedImage bufferedImage;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        int iconSize = icon.getIconWidth();
        int outlineIconSize = iconSize + 2 * this.getOUTLINE_WIDTH();
        Color color = outlineColor;
        if (color != null) {
            Color color2 = color;
            boolean bl2 = false;
            bl = false;
            Color it = color2;
            boolean bl3 = false;
            BufferedImage result2 = new BufferedImage(outlineIconSize, outlineIconSize, 1);
            Graphics2D g2d = result2.createGraphics();
            try {
                Graphics2D graphics2D = g2d;
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"g2d");
                graphics2D.setColor(it);
                g2d.fillRect(0, 0, result2.getWidth(), result2.getHeight());
            }
            finally {
                g2d.dispose();
            }
            bufferedImage = result2;
        } else {
            bufferedImage = null;
        }
        BufferedImage bufferedImage2 = colorImage = bufferedImage;
        if (bufferedImage2 != null) {
            BufferedImage bufferedImage3 = bufferedImage2;
            bl = false;
            boolean bl4 = false;
            BufferedImage it = bufferedImage3;
            boolean bl5 = false;
            jBScalableIcon = (JBScalableIcon)new RoundedIcon((Image)it, 1.0, true);
        } else {
            EmptyIcon emptyIcon = EmptyIcon.create((int)outlineIconSize);
            Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"EmptyIcon.create(outlineIconSize)");
            jBScalableIcon = (JBScalableIcon)emptyIcon;
        }
        JBScalableIcon colorIcon = jBScalableIcon;
        Icon innerIcon = outlineColor != null ? icon : UtilitiesKt.resizeIconScaled(icon, iconSize + JBUI.scale((int)1));
        return (Icon)new LayeredIcon(new Icon[]{(Icon)colorIcon, (Icon)new CenteredIcon(innerIcon, outlineIconSize, outlineIconSize, false)});
    }

    @NotNull
    public final SpaceMeIcon createAvatars(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return new SpaceMeIcon.Avatar(image);
    }

    @NotNull
    public final SpaceMeIcon generateAvatars(@NotNull String gradientSeed, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)gradientSeed, (String)"gradientSeed");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BufferedImage generatedImage = AvatarUtils.generateColoredAvatar$default((AvatarUtils)AvatarUtils.INSTANCE, (String)gradientSeed, (String)name, null, (int)4, null);
        return this.createAvatars(generatedImage);
    }

    private SpaceAvatarUtils() {
    }

    static {
        SpaceAvatarUtils spaceAvatarUtils;
        INSTANCE = spaceAvatarUtils = new SpaceAvatarUtils();
    }
}

