/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.diff;

import com.intellij.diff.editor.DiffContentVirtualFile;
import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.space.editor.SpaceDiffComplexPathVirtualFileSystem;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.vcs.diff.SpaceDiffFileType;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0001\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/space/vcs/diff/SpaceDiffFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/intellij/diff/editor/DiffContentVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "sessionId", "", "projectHash", "fileId", "fileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileId", "()Ljava/lang/String;", "getFileName", "enforcePresentableName", "", "equals", "other", "", "getFileSystem", "Lcom/intellij/space/editor/SpaceDiffComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "hashCode", "", "intellij.space"})
public final class SpaceDiffFile
extends LightVirtualFile
implements DiffContentVirtualFile,
VirtualFilePathWrapper {
    private final String sessionId;
    private final String projectHash;
    @NotNull
    private final String fileId;
    @NotNull
    private final String fileName;

    @NotNull
    public SpaceDiffComplexPathVirtualFileSystem getFileSystem() {
        return SpaceDiffComplexPathVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        String string;
        try {
            string = this.getFileSystem().getPath(this.sessionId, this.projectHash, this.fileId);
        }
        catch (Exception e) {
            String string2 = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            string = string2;
        }
        return string;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentablePath() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.space.vcs.diff.SpaceDiffFile");
        }
        SpaceDiffFile cfr_ignored_0 = (SpaceDiffFile)((Object)object2);
        return !(Intrinsics.areEqual((Object)this.fileId, (Object)((SpaceDiffFile)((Object)other)).fileId) ^ true);
    }

    public int hashCode() {
        return this.fileId.hashCode();
    }

    @NotNull
    public final String getFileId() {
        return this.fileId;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public SpaceDiffFile(@NotNull String sessionId, @NotNull String projectHash, @NotNull String fileId, @Nls @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        super(SpaceBundle.message("review.diff.tab.title", fileName), (FileType)SpaceDiffFileType.INSTANCE, (CharSequence)"");
        this.sessionId = sessionId;
        this.projectHash = projectHash;
        this.fileId = fileId;
        this.fileName = fileName;
        DiffVirtualFile.Companion.useDiffWindowDimensionKey((VirtualFile)this);
        DiffVirtualFile.Companion.turnOffReopeningWindow((VirtualFile)this);
        this.setWritable(false);
    }
}

