/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.log;

import circlet.client.api.AutomationDetailsTab;
import circlet.pipelines.api.JobExecutionDTO;
import circlet.pipelines.common.api.ExecutionStatus;
import com.intellij.icons.AllIcons;
import com.intellij.space.SpaceIcons;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.utils.DateUtilitiesKt;
import com.intellij.space.utils.SpaceUrls;
import com.intellij.space.vcs.log.SpaceJobExecution;
import com.intellij.space.vcs.log.SpaceJobExecutionRendererKt$WhenMappings;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0015\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0015\u0010\f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a-\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u000b\u0010\u0010\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"getDescription", "", "Lorg/jetbrains/annotations/Nls;", "value", "Lcom/intellij/space/vcs/log/SpaceJobExecution;", "getDescriptionUrl", "getIcon", "Ljavax/swing/Icon;", "status", "Lcirclet/pipelines/common/api/ExecutionStatus;", "getText", "getTextUrl", "getTime", "append", "", "Lcom/intellij/ui/SimpleColoredComponent;", "text", "url", "textAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "intellij.space"})
public final class SpaceJobExecutionRendererKt {
    private static final void append(SimpleColoredComponent $this$append, String text2, String url, SimpleTextAttributes textAttributes) {
        $this$append.append(text2, url != null ? SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES : textAttributes, (Object)(url != null ? new SimpleColoredComponent.BrowserLauncherTag(url) : null));
    }

    static /* synthetic */ void append$default(SimpleColoredComponent simpleColoredComponent, String string, String string2, SimpleTextAttributes simpleTextAttributes, int n, Object object) {
        if ((n & 4) != 0) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
            simpleTextAttributes = simpleTextAttributes2;
        }
        SpaceJobExecutionRendererKt.append(simpleColoredComponent, string, string2, simpleTextAttributes);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Icon getIcon(ExecutionStatus status) {
        Icon icon;
        ExecutionStatus executionStatus = status;
        if (executionStatus != null) {
            switch (SpaceJobExecutionRendererKt$WhenMappings.$EnumSwitchMapping$0[executionStatus.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    Icon icon2 = SpaceIcons.Pending;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SpaceIcons.Pending");
                    return icon;
                }
                case 6: 
                case 7: {
                    Icon icon3 = SpaceIcons.Running;
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SpaceIcons.Running");
                    return icon;
                }
                case 8: {
                    Icon icon4 = AllIcons.RunConfigurations.ToolbarPassed;
                    icon = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AllIcons.RunConfigurations.ToolbarPassed");
                    return icon;
                }
                case 9: {
                    Icon icon5 = SpaceIcons.Failed;
                    icon = icon5;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"SpaceIcons.Failed");
                    return icon;
                }
                case 10: 
                case 11: {
                    Icon icon6 = SpaceIcons.Terminated;
                    icon = icon6;
                    Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"SpaceIcons.Terminated");
                    return icon;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Icon icon7 = AllIcons.RunConfigurations.TestIgnored;
        icon = icon7;
        Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"AllIcons.RunConfigurations.TestIgnored");
        return icon;
    }

    private static final String getText(SpaceJobExecution value) {
        return value.getJobName();
    }

    private static final String getTextUrl(SpaceJobExecution value) {
        return value.getExecution() == null ? SpaceUrls.INSTANCE.jobHistory(value.getProject(), value.getJobId()) : SpaceUrls.jobExecution$default(SpaceUrls.INSTANCE, value.getProject(), value.getExecution().getExecutionId(), null, 4, null);
    }

    private static final String getDescription(SpaceJobExecution value) {
        String string;
        Integer changesCount;
        JobExecutionDTO jobExecutionDTO = value.getExecution();
        Integer n = changesCount = jobExecutionDTO != null ? Integer.valueOf(jobExecutionDTO.getChangesCount()) : null;
        if (changesCount == null) {
            String string2 = SpaceBundle.message("label.no.executions.triggered", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"label.no.executions.triggered\")");
        } else if (changesCount == 0) {
            String string3 = SpaceBundle.message("label.no.changes", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"label.no.changes\")");
        } else {
            String string4 = SpaceBundle.message("label.changes.count", changesCount);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"label.changes.count\", changesCount)");
        }
        return string;
    }

    private static final String getDescriptionUrl(SpaceJobExecution value) {
        Integer changesCount;
        JobExecutionDTO jobExecutionDTO = value.getExecution();
        Integer n = changesCount = jobExecutionDTO != null ? Integer.valueOf(jobExecutionDTO.getChangesCount()) : null;
        if (changesCount == null || changesCount == 0) {
            return null;
        }
        return SpaceUrls.INSTANCE.jobExecution(value.getProject(), value.getExecution().getExecutionId(), AutomationDetailsTab.Changes);
    }

    private static final String getTime(SpaceJobExecution value) {
        Object object = value.getExecution();
        if (object == null || (object = object.executionDuration()) == null) {
            return "";
        }
        long duration = (Long)object;
        return DateUtilitiesKt.formatDuration(duration);
    }

    public static final /* synthetic */ Icon access$getIcon(ExecutionStatus status) {
        return SpaceJobExecutionRendererKt.getIcon(status);
    }

    public static final /* synthetic */ String access$getText(SpaceJobExecution value) {
        return SpaceJobExecutionRendererKt.getText(value);
    }

    public static final /* synthetic */ String access$getTextUrl(SpaceJobExecution value) {
        return SpaceJobExecutionRendererKt.getTextUrl(value);
    }

    public static final /* synthetic */ String access$getTime(SpaceJobExecution value) {
        return SpaceJobExecutionRendererKt.getTime(value);
    }

    public static final /* synthetic */ void access$append(SimpleColoredComponent $this$access_u24append, String text2, String url, SimpleTextAttributes textAttributes) {
        SpaceJobExecutionRendererKt.append($this$access_u24append, text2, url, textAttributes);
    }

    public static final /* synthetic */ String access$getDescription(SpaceJobExecution value) {
        return SpaceJobExecutionRendererKt.getDescription(value);
    }

    public static final /* synthetic */ String access$getDescriptionUrl(SpaceJobExecution value) {
        return SpaceJobExecutionRendererKt.getDescriptionUrl(value);
    }
}

