/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.visiting;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.coverage.gnu.trove.TIntHashSet;
import org.jetbrains.coverage.gnu.trove.TIntIntHashMap;
import org.jetbrains.coverage.gnu.trove.TIntIntProcedure;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinInlineVisitingFilter
extends MethodVisitingFilter {
    private static final String INLINE_FUNCTION_PREFIX = "$i$f$";
    private static final String INLINE_ARGUMENT_PREFIX = "$i$a-$";
    private static final boolean ourCheckInlineSignatures = "true".equals(System.getProperty("idea.coverage.check.inline.signatures"));
    private static final String DEFAULT_DESC = "()V";
    private static final String UNKNOWN_DESC = "(?)?";
    private TIntIntHashMap myLines;
    private TIntHashSet myLinesSet;
    private Map<Label, Integer> myLabelIds;
    private List<InlineRange> myInlineFunctionRanges;
    private List<InlineRange> myInlineArgumentRanges;
    private String myName;
    private int myLabelCounter;

    public static boolean shouldCheckLineSignatures() {
        return ourCheckInlineSignatures;
    }

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context) && ourCheckInlineSignatures;
    }

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String name, String desc) {
        super.initFilter(methodVisitor, context, name, desc);
        this.myLines = new TIntIntHashMap();
        this.myLinesSet = new TIntHashSet();
        this.myLabelIds = new HashMap<Label, Integer>();
        this.myInlineFunctionRanges = new ArrayList<InlineRange>();
        this.myInlineArgumentRanges = new ArrayList<InlineRange>();
        this.myName = name;
        this.myLabelCounter = 0;
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.myLabelIds.put(label, this.myLabelCounter++);
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, descriptor, signature, start, end, index);
        if (name.startsWith(INLINE_FUNCTION_PREFIX)) {
            String inlineMethodName = name.substring(INLINE_FUNCTION_PREFIX.length());
            if (this.isSameMethod(inlineMethodName)) {
                return;
            }
            this.myInlineFunctionRanges.add(new InlineRange(inlineMethodName, this.myLabelIds.get(start), this.myLabelIds.get(end)));
        }
        if (name.startsWith(INLINE_ARGUMENT_PREFIX)) {
            int i = name.lastIndexOf(45);
            if (i < 0) {
                return;
            }
            String inlineMethodName = name.substring(INLINE_ARGUMENT_PREFIX.length(), i);
            if (this.isSameMethod(inlineMethodName)) {
                return;
            }
            this.myInlineArgumentRanges.add(new InlineRange("", this.myLabelIds.get(start), this.myLabelIds.get(end)));
        }
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        if (this.myLinesSet.add(line)) {
            this.myLines.put(this.myLabelIds.get(start), line);
        }
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myInlineFunctionRanges.isEmpty()) {
            return;
        }
        if (this.myName == null) {
            return;
        }
        try {
            FileMapData[] mappings = this.getMappings();
            if (mappings == null) {
                return;
            }
            Collections.sort(this.myInlineFunctionRanges);
            Collections.sort(this.myInlineArgumentRanges);
            final TreeMap lines = new TreeMap();
            this.myLines.forEachEntry(new TIntIntProcedure(){

                public boolean execute(int offset, int line) {
                    lines.put(offset, line);
                    return true;
                }
            });
            for (InlineRange range : this.myInlineFunctionRanges) {
                for (Map.Entry entry : lines.subMap(range.myStart, range.myEnd).entrySet()) {
                    LineData lineData;
                    int line = (Integer)entry.getValue();
                    if (!this.isLineMapped(line, mappings) || KotlinInlineVisitingFilter.isInside(range, this.findInlineArgumentRange(entry.getKey())) || (lineData = this.myContext.getLineData(line)) == null) continue;
                    lineData.setMethodSignature(range.myName + UNKNOWN_DESC);
                }
            }
        }
        catch (Throwable e) {
            ErrorReporter.reportError("Error during inline ranges collection", e);
        }
    }

    private boolean isLineMapped(int line, FileMapData[] mappings) {
        for (FileMapData map : mappings) {
            LineMapData[] lines;
            if (map == null || map.getClassName().equals(this.myContext.getClassName()) || (lines = map.getLines()) == null) continue;
            int low = 0;
            int high = lines.length - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                LineMapData lineMapData = lines[mid];
                if (line < lineMapData.getTargetMinLine()) {
                    high = mid - 1;
                    continue;
                }
                if (line > lineMapData.getTargetMaxLine()) {
                    low = mid + 1;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private FileMapData[] getMappings() {
        ProjectData project = ProjectData.getProjectData();
        if (project == null) {
            return null;
        }
        Map<String, FileMapData[]> mappings = project.getLinesMap();
        if (mappings == null) {
            return null;
        }
        return mappings.get(this.myContext.getClassName());
    }

    private boolean isSameMethod(String name) {
        return this.myName.equals(name) || this.myName.equals(name + "$default") || this.myName.equals(name + "-impl");
    }

    private static boolean isInside(InlineRange container, InlineRange content) {
        return container != null && content != null && content.myStart >= container.myStart && content.myEnd <= container.myEnd;
    }

    private InlineRange findInlineArgumentRange(int offset) {
        int low = 0;
        int high = this.myInlineArgumentRanges.size() - 1;
        InlineRange result = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            InlineRange midValue = this.myInlineArgumentRanges.get(mid);
            if (offset < midValue.myStart) {
                high = mid - 1;
                continue;
            }
            if (offset >= midValue.myEnd) {
                low = mid + 1;
                continue;
            }
            if (result == null || result.length() > midValue.length()) {
                result = midValue;
            }
            if (midValue.myStart == offset) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return result;
    }

    public static boolean isInlineMethod(String methodName, String variableName) {
        return variableName.equals(INLINE_FUNCTION_PREFIX + methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLineSignatures(final ClassData classData, ClassFinder classFinder) {
        if (!ourCheckInlineSignatures) {
            return;
        }
        final TIntHashSet linesWithIncorrectSignatures = new TIntHashSet();
        for (LineData line : (LineData[])classData.getLines()) {
            if (line == null || line.getMethodSignature() == null || !line.getMethodSignature().endsWith(UNKNOWN_DESC)) continue;
            linesWithIncorrectSignatures.add(line.getLineNumber());
        }
        if (linesWithIncorrectSignatures.isEmpty()) {
            return;
        }
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>(classFinder.getClassloaders());
        classLoaders.add(null);
        for (ClassLoader loader : classLoaders) {
            InputStream is = null;
            try {
                ClassEntry classEntry = new ClassEntry(classData.getName(), loader);
                is = classEntry.getClassInputStream();
                if (is == null) continue;
                ClassReader reader = new ClassReader(is);
                reader.accept(new ClassVisitor(589824){

                    public MethodVisitor visitMethod(int access, final String name, final String descriptor, String signature, String[] exceptions) {
                        return new MethodVisitor(589824){

                            public void visitLineNumber(int line, Label start) {
                                super.visitLineNumber(line, start);
                                if (linesWithIncorrectSignatures.remove(line)) {
                                    LineData lineData = classData.getLineData(line);
                                    lineData.setMethodSignature(name + descriptor);
                                }
                            }
                        };
                    }
                }, 4);
                break;
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        linesWithIncorrectSignatures.forEach(new TIntProcedure(){

            public boolean execute(int line) {
                LineData lineData = classData.getLineData(line);
                lineData.setMethodSignature(lineData.getMethodSignature().replace(KotlinInlineVisitingFilter.UNKNOWN_DESC, KotlinInlineVisitingFilter.DEFAULT_DESC));
                return true;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InlineRange
    implements Comparable<InlineRange> {
        private final String myName;
        private final int myStart;
        private final int myEnd;

        private InlineRange(String name, int start, int end) {
            this.myName = name;
            this.myStart = start;
            this.myEnd = end;
        }

        public int length() {
            return this.myEnd - this.myStart;
        }

        public String toString() {
            return "InlineRange{name=" + this.myName + ", start=" + this.myStart + ", end=" + this.myEnd + '}';
        }

        @Override
        public int compareTo(InlineRange o) {
            int startDiff = this.myStart - o.myStart;
            if (startDiff == 0) {
                return this.myEnd - o.myEnd;
            }
            return startDiff;
        }
    }
}

