/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.module.JpsModule;

public class ModuleChunk {
    private static final NotNullFunction<JpsModule, String> GET_NAME = dom -> dom.getName();
    private final Set<JpsModule> myModules;
    private final boolean myContainsTests;
    private final Set<ModuleBuildTarget> myTargets;

    public ModuleChunk(Set<ModuleBuildTarget> targets) {
        boolean containsTests = false;
        this.myTargets = targets;
        this.myModules = new LinkedHashSet<JpsModule>();
        for (ModuleBuildTarget target : targets) {
            this.myModules.add(target.getModule());
            containsTests |= target.isTests();
        }
        this.myContainsTests = containsTests;
    }

    @Nls
    public String getPresentableShortName() {
        String name;
        String first = this.myModules.iterator().next().getName();
        if (this.myModules.size() > 1) {
            name = JpsBuildBundle.message("target.description.0.and.1.more", first, this.myModules.size() - 1);
            String fullName = this.getName();
            if (fullName.length() < name.length()) {
                name = fullName;
            }
        } else {
            name = first;
        }
        if (this.containsTests()) {
            return JpsBuildBundle.message("target.description.tests.of.0", name);
        }
        return name;
    }

    public String getName() {
        if (this.myModules.size() == 1) {
            return this.myModules.iterator().next().getName();
        }
        return StringUtil.join(this.myModules, GET_NAME, (String)",");
    }

    public Set<JpsModule> getModules() {
        return this.myModules;
    }

    public boolean containsTests() {
        return this.myContainsTests;
    }

    public Set<ModuleBuildTarget> getTargets() {
        return this.myTargets;
    }

    public String toString() {
        return this.getName();
    }

    public ModuleBuildTarget representativeTarget() {
        return this.myTargets.iterator().next();
    }
}

