/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.VersionView;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheStatus;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@H\u0002J\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EJ\u0016\u0010F\u001a\u00020>2\u000e\b\u0002\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00000\tJ \u0010H\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020A0I2\b\b\u0002\u0010J\u001a\u00020\u001bJ\u0006\u0010K\u001a\u00020>J\u0006\u0010L\u001a\u00020\u001bJ\b\u0010M\u001a\u000204H\u0016R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u0005@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R0\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u0005@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u0011\u0010+\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001dR\u001b\u0010-\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0014\u001a\u0004\b-\u0010\u001dR\u001b\u0010/\u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0014\u001a\u0004\b0\u00101R\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b8\u00106R\u0015\u00109\u001a\u0006\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010%\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "", "context", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "targets", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Ljava/util/List;)V", "_dependent", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "get_dependent$kotlin_jps_plugin", "()Ljava/util/Set;", "set_dependent$kotlin_jps_plugin", "(Ljava/util/Set;)V", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "apiVersion$delegate", "Lkotlin/Lazy;", "compilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getCompilerArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "compilerArguments$delegate", "containsTests", "", "getContainsTests", "()Z", "getContext", "()Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "defaultLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "<set-?>", "dependencies", "getDependencies", "()Ljava/util/List;", "setDependencies$kotlin_jps_plugin", "(Ljava/util/List;)V", "dependent", "getDependent", "setDependent$kotlin_jps_plugin", "haveSameCompiler", "getHaveSameCompiler", "isEnabled", "isEnabled$delegate", "langVersion", "getLangVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "langVersion$delegate", "presentableModulesToCompilersList", "", "getPresentableModulesToCompilersList", "()Ljava/lang/String;", "presentableShortName", "getPresentableShortName", "representativeTarget", "getRepresentativeTarget", "()Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTargets", "addDependentCaches", "", "targetsCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "buildMetaInfoFile", "Ljava/nio/file/Path;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "collectDependentChunksRecursivelyExportedOnly", "result", "loadCaches", "", "loadDependent", "saveVersions", "shouldRebuild", "toString", "kotlin.jps-plugin"})
public final class KotlinChunk {
    private final boolean containsTests;
    public List<KotlinModuleBuildTarget.Dependency> dependencies;
    public List<KotlinModuleBuildTarget.Dependency> dependent;
    @Nullable
    private Set<KotlinModuleBuildTarget.Dependency> _dependent;
    private final boolean haveSameCompiler;
    private final LanguageVersion defaultLanguageVersion;
    @NotNull
    private final Lazy compilerArguments$delegate;
    @NotNull
    private final Lazy langVersion$delegate;
    @NotNull
    private final Lazy apiVersion$delegate;
    @NotNull
    private final Lazy isEnabled$delegate;
    @NotNull
    private final KotlinCompileContext context;
    @NotNull
    private final List<KotlinModuleBuildTarget<?>> targets;

    public final boolean getContainsTests() {
        return this.containsTests;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget.Dependency> getDependencies() {
        List<KotlinModuleBuildTarget.Dependency> list = this.dependencies;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        }
        return list;
    }

    public final void setDependencies$kotlin_jps_plugin(@NotNull List<KotlinModuleBuildTarget.Dependency> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dependencies = list;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget.Dependency> getDependent() {
        List<KotlinModuleBuildTarget.Dependency> list = this.dependent;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependent");
        }
        return list;
    }

    public final void setDependent$kotlin_jps_plugin(@NotNull List<KotlinModuleBuildTarget.Dependency> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dependent = list;
    }

    @Nullable
    public final Set<KotlinModuleBuildTarget.Dependency> get_dependent$kotlin_jps_plugin() {
        return this._dependent;
    }

    public final void set_dependent$kotlin_jps_plugin(@Nullable Set<KotlinModuleBuildTarget.Dependency> set) {
        this._dependent = set;
    }

    @NotNull
    public final KotlinModuleBuildTarget<?> getRepresentativeTarget() {
        return (KotlinModuleBuildTarget)kotlin.collections.CollectionsKt.first(this.targets);
    }

    @NotNull
    public final String getPresentableModulesToCompilersList() {
        return kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.targets, null, null, null, (int)0, null, (Function1)presentableModulesToCompilersList.1.INSTANCE, (int)31, null);
    }

    public final boolean getHaveSameCompiler() {
        return this.haveSameCompiler;
    }

    @NotNull
    public final CommonCompilerArguments getCompilerArguments() {
        Lazy lazy = this.compilerArguments$delegate;
        KotlinChunk kotlinChunk = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CommonCompilerArguments)lazy.getValue();
    }

    @NotNull
    public final LanguageVersion getLangVersion() {
        Lazy lazy = this.langVersion$delegate;
        KotlinChunk kotlinChunk = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LanguageVersion)lazy.getValue();
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        Lazy lazy = this.apiVersion$delegate;
        KotlinChunk kotlinChunk = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ApiVersion)lazy.getValue();
    }

    public final boolean isEnabled() {
        Lazy lazy = this.isEnabled$delegate;
        KotlinChunk kotlinChunk = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    public final boolean shouldRebuild() {
        BuildMetaInfo buildMetaInfo = this.getRepresentativeTarget().getBuildMetaInfoFactory().create(this.getCompilerArguments());
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            if (target.isVersionChanged(this, buildMetaInfo)) {
                KotlinBuilder.Companion.getLOG().info(target + " version changed, rebuilding " + this);
                return true;
            }
            if (target.getInitialLocalCacheAttributesDiff().getStatus() != CacheStatus.INVALID) continue;
            TestingBuildLogger testingBuildLogger = this.context.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.invalidOrUnusedCache(this, null, target.getInitialLocalCacheAttributesDiff());
            }
            KotlinBuilder.Companion.getLOG().info(target + " cache is invalid " + target.getInitialLocalCacheAttributesDiff() + ", rebuilding " + this);
            return true;
        }
        return false;
    }

    @NotNull
    public final Path buildMetaInfoFile(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = this.context.getDataPaths().getTargetDataRoot((BuildTarget)target).toPath().resolve(this.getRepresentativeTarget().getBuildMetaInfoFileName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"context.dataPaths\n      \u2026et.buildMetaInfoFileName)");
        return path;
    }

    public final void saveVersions() {
        this.context.ensureLookupsCacheAttributesSaved();
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            CacheAttributesManager.DefaultImpls.writeVersion$default(it.getInitialLocalCacheAttributesDiff().getManager(), null, 1, null);
        }
        String serializedMetaInfo = this.getRepresentativeTarget().getBuildMetaInfoFactory().serializeToString(this.getCompilerArguments());
        Iterable $this$forEach$iv2 = this.targets;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            PathsKt.writeText$default((Path)this.buildMetaInfoFile(it.getJpsModuleBuildTarget()), (CharSequence)serializedMetaInfo, null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
    }

    public final void collectDependentChunksRecursivelyExportedOnly(@NotNull Set<KotlinChunk> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        List<KotlinModuleBuildTarget.Dependency> list = this.dependent;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependent");
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget.Dependency it = (KotlinModuleBuildTarget.Dependency)element$iv;
            boolean bl = false;
            if (!result.add(it.getSrc().getChunk()) || !it.getExported()) continue;
            it.getSrc().getChunk().collectDependentChunksRecursivelyExportedOnly(result);
        }
    }

    public static /* synthetic */ void collectDependentChunksRecursivelyExportedOnly$default(KotlinChunk kotlinChunk, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        kotlinChunk.collectDependentChunksRecursivelyExportedOnly(set);
    }

    @NotNull
    public final Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> loadCaches(boolean loadDependent) {
        BuildDataManager dataManager = this.context.getDataManager();
        Map cacheByChunkTarget2 = CollectionsKt.keysToMapExceptNulls((Iterable)this.targets, (Function1)new Function1<KotlinModuleBuildTarget<?>, JpsIncrementalCache>(dataManager){
            final /* synthetic */ BuildDataManager $dataManager;

            @Nullable
            public final JpsIncrementalCache invoke(@NotNull KotlinModuleBuildTarget<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                BuildDataManager buildDataManager = this.$dataManager;
                Intrinsics.checkNotNullExpressionValue((Object)buildDataManager, (String)"dataManager");
                return JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
            }
            {
                this.$dataManager = buildDataManager;
                super(1);
            }
        });
        if (loadDependent) {
            this.addDependentCaches(cacheByChunkTarget2.values());
        }
        return cacheByChunkTarget2;
    }

    public static /* synthetic */ Map loadCaches$default(KotlinChunk kotlinChunk, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return kotlinChunk.loadCaches(bl);
    }

    private final void addDependentCaches(Collection<? extends JpsIncrementalCache> targetsCaches) {
        boolean bl = false;
        Set dependentChunks = new LinkedHashSet();
        this.collectDependentChunksRecursivelyExportedOnly(dependentChunks);
        BuildDataManager dataManager = this.context.getDataManager();
        Iterable $this$forEach$iv = dependentChunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk decedentChunk = (KotlinChunk)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = decedentChunk.targets;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl3 = false;
                BuildDataManager buildDataManager = dataManager;
                Intrinsics.checkNotNullExpressionValue((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache dependentCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
                if (dependentCache == null) continue;
                for (JpsIncrementalCache jpsIncrementalCache : targetsCaches) {
                    jpsIncrementalCache.addJpsDependentCache(dependentCache);
                }
            }
        }
    }

    @NotNull
    public final String getPresentableShortName() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        if (this.containsTests) {
            $this$buildString.append("tests of ");
        }
        $this$buildString.append(((KotlinModuleBuildTarget)kotlin.collections.CollectionsKt.first(this.targets)).getModule().getName());
        if (this.targets.size() > 1) {
            String andXMore = " and " + (this.targets.size() - 1) + " more";
            String other = ", " + SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this.targets), (int)1), null, null, null, (int)0, null, null, (int)63, null);
            $this$buildString.append(other.length() < andXMore.length() ? other : andXMore);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return "KotlinChunk<" + this.getRepresentativeTarget().getClass().getSimpleName() + '>' + '(' + kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.targets, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null) + ')';
    }

    @NotNull
    public final KotlinCompileContext getContext() {
        return this.context;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget<?>> getTargets() {
        return this.targets;
    }

    /*
     * WARNING - void declaration
     */
    public KotlinChunk(@NotNull KotlinCompileContext context, @NotNull List<? extends KotlinModuleBuildTarget<?>> targets) {
        boolean bl;
        boolean bl2;
        block7: {
            void $this$all$iv;
            KotlinModuleBuildTarget it;
            boolean bl3;
            KotlinChunk kotlinChunk;
            block6: {
                void $this$any$iv22;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(targets, (String)"targets");
                this.context = context;
                this.targets = targets;
                Iterable iterable = this.targets;
                kotlinChunk = this;
                boolean $i$f$any = false;
                if ($this$any$iv22 instanceof Collection && ((Collection)$this$any$iv22).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv22) {
                        it = (KotlinModuleBuildTarget)element$iv;
                        boolean bl4 = false;
                        if (!it.isTests()) continue;
                        bl3 = true;
                        break block6;
                    }
                    bl3 = false;
                }
            }
            kotlinChunk.containsTests = bl2 = bl3;
            boolean $this$any$iv22 = false;
            this._dependent = new LinkedHashSet();
            Iterable $this$any$iv22 = this.targets;
            kotlinChunk = this;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (KotlinModuleBuildTarget)element$iv;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual(it.getClass(), this.getRepresentativeTarget().getClass())) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        kotlinChunk.haveSameCompiler = bl2 = bl;
        this.defaultLanguageVersion = VersionView.Companion.getRELEASED_VERSION();
        this.compilerArguments$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CommonCompilerArguments>(this){
            final /* synthetic */ KotlinChunk this$0;

            @NotNull
            public final CommonCompilerArguments invoke() {
                JpsModule jpsModule = this.this$0.getRepresentativeTarget().getJpsModuleBuildTarget().getModule();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"representativeTarget.jpsModuleBuildTarget.module");
                CommonCompilerArguments commonCompilerArguments = ModuleSettingsKt.getKotlinCompilerArguments(jpsModule);
                boolean bl = false;
                boolean bl2 = false;
                CommonCompilerArguments it = commonCompilerArguments;
                boolean bl3 = false;
                it.setReportOutputFiles(true);
                it.setVersion(true);
                if (it.getLanguageVersion() == null) {
                    it.setLanguageVersion(KotlinChunk.access$getDefaultLanguageVersion$p(this.this$0).getVersionString());
                }
                return commonCompilerArguments;
            }
            {
                this.this$0 = kotlinChunk;
                super(0);
            }
        }));
        this.langVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LanguageVersion>(this){
            final /* synthetic */ KotlinChunk this$0;

            @NotNull
            public final LanguageVersion invoke() {
                String string;
                block3: {
                    block2: {
                        string = this.this$0.getCompilerArguments().getLanguageVersion();
                        if (string == null) break block2;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        string = LanguageVersion.Companion.fromVersionString(it);
                        if (string != null) break block3;
                    }
                    string = KotlinChunk.access$getDefaultLanguageVersion$p(this.this$0);
                }
                return string;
            }
            {
                this.this$0 = kotlinChunk;
                super(0);
            }
        }));
        this.apiVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ApiVersion>(this){
            final /* synthetic */ KotlinChunk this$0;

            @NotNull
            public final ApiVersion invoke() {
                String string;
                block3: {
                    block2: {
                        string = this.this$0.getCompilerArguments().getApiVersion();
                        if (string == null) break block2;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        string = ApiVersion.Companion.parse(it);
                        if (string != null) break block3;
                    }
                    string = ApiVersion.Companion.createByLanguageVersion(this.this$0.getLangVersion());
                }
                return string;
            }
            {
                this.this$0 = kotlinChunk;
                super(0);
            }
        }));
        this.isEnabled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinChunk this$0;

            public final boolean invoke() {
                return this.this$0.getRepresentativeTarget().isEnabled(this.this$0.getCompilerArguments());
            }
            {
                this.this$0 = kotlinChunk;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ LanguageVersion access$getDefaultLanguageVersion$p(KotlinChunk $this) {
        return $this.defaultLanguageVersion;
    }
}

