/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.project.IntelliJProjectConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public final class MavenDependencyUtil {
    public static void addFromMaven(@NotNull ModifiableRootModel model, String mavenCoordinates) {
        if (model == null) {
            MavenDependencyUtil.$$$reportNull$$$0(0);
        }
        MavenDependencyUtil.addFromMaven(model, mavenCoordinates, true);
    }

    public static void addFromMaven(@NotNull ModifiableRootModel model, String mavenCoordinates, boolean includeTransitiveDependencies) {
        if (model == null) {
            MavenDependencyUtil.$$$reportNull$$$0(1);
        }
        MavenDependencyUtil.addFromMaven(model, mavenCoordinates, includeTransitiveDependencies, DependencyScope.COMPILE);
    }

    public static void addFromMaven(@NotNull ModifiableRootModel model, String mavenCoordinates, boolean includeTransitiveDependencies, DependencyScope dependencyScope) {
        if (model == null) {
            MavenDependencyUtil.$$$reportNull$$$0(2);
        }
        MavenDependencyUtil.addFromMaven(model, mavenCoordinates, includeTransitiveDependencies, dependencyScope, Collections.emptyList());
    }

    public static void addFromMaven(@NotNull ModifiableRootModel model, String mavenCoordinates, boolean includeTransitiveDependencies, DependencyScope dependencyScope, List<RemoteRepositoryDescription> additionalRepositories) {
        if (model == null) {
            MavenDependencyUtil.$$$reportNull$$$0(3);
        }
        List remoteRepositoryDescriptions = ContainerUtil.concat(MavenDependencyUtil.getRemoteRepositoryDescriptions(), additionalRepositories);
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(mavenCoordinates, includeTransitiveDependencies);
        Collection roots = JarRepositoryManager.loadDependenciesModal((Project)model.getProject(), (RepositoryLibraryProperties)libraryProperties, (boolean)false, (boolean)false, null, (Collection)remoteRepositoryDescriptions);
        LibraryTable.ModifiableModel tableModel = model.getModuleLibraryTable().getModifiableModel();
        Library library = tableModel.createLibrary(mavenCoordinates, RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        if (roots.isEmpty()) {
            throw new IllegalStateException(String.format("No roots for '%s'", mavenCoordinates));
        }
        for (OrderRoot root : roots) {
            libraryModel.addRoot(root.getFile(), root.getType());
        }
        ((LibraryEx.ModifiableModelEx)libraryModel).setProperties((LibraryProperties)libraryProperties);
        LibraryOrderEntry libraryOrderEntry = model.findLibraryOrderEntry(library);
        if (libraryOrderEntry == null) {
            throw new IllegalStateException("Unable to find registered library " + mavenCoordinates);
        }
        libraryOrderEntry.setScope(dependencyScope);
        libraryModel.commit();
        tableModel.commit();
    }

    @NotNull
    private static List<RemoteRepositoryDescription> getRemoteRepositoryDescriptions() {
        List list = ContainerUtil.map((Collection)IntelliJProjectConfiguration.getRemoteRepositoryDescriptions(), repository -> new RemoteRepositoryDescription(repository.getId(), repository.getName(), repository.getUrl()));
        if (list == null) {
            MavenDependencyUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/MavenDependencyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/MavenDependencyUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteRepositoryDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFromMaven";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

