/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public abstract class UseEqualsInspectionBase
extends DevKitUastInspectionBase {
    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(0);
        }
        return super.isAllowed(holder) && JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(this.getTargetClass().getName(), holder.getFile().getResolveScope()) != null;
    }

    @Override
    @NotNull
    protected final PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(1);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitBinaryExpression(@NotNull UBinaryExpression binaryExpression) {
                PsiElement sourcePsi;
                if (binaryExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiElement psiElement = sourcePsi = UseEqualsInspectionBase.this.isEqualityExpression(binaryExpression) ? binaryExpression.getSourcePsi() : null;
                if (sourcePsi != null) {
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.equals.description", UseEqualsInspectionBase.this.getTargetClass().getSimpleName()), new LocalQuickFix[0]);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/idea/devkit/inspections/internal/UseEqualsInspectionBase$1", "visitBinaryExpression"));
            }
        }, (Class[])new Class[]{UBinaryExpression.class});
        if (psiElementVisitor == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    @NotNull
    protected abstract Class<?> getTargetClass();

    protected boolean isExcluded(@NotNull UExpression operand) {
        if (operand == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(3);
        }
        return operand instanceof ULiteralExpression || operand instanceof UThisExpression;
    }

    private boolean hasTargetType(@NotNull UExpression operand) {
        if (operand == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(4);
        }
        return operand.getSourcePsi() != null && InheritanceUtil.isInheritor((PsiType)operand.getExpressionType(), (String)this.getTargetClass().getName());
    }

    private boolean isEqualityExpression(@NotNull UBinaryExpression binaryExpression) {
        UastBinaryOperator operator;
        if (binaryExpression == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(5);
        }
        if ((operator = binaryExpression.getOperator()) != UastBinaryOperator.IDENTITY_EQUALS && operator != UastBinaryOperator.IDENTITY_NOT_EQUALS) {
            return false;
        }
        UExpression leftOperand = binaryExpression.getLeftOperand();
        if (this.isExcluded(leftOperand)) {
            return false;
        }
        UExpression rightOperand = binaryExpression.getRightOperand();
        if (this.isExcluded(rightOperand)) {
            return false;
        }
        return this.hasTargetType(leftOperand) || this.hasTargetType(rightOperand);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseEqualsInspectionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseEqualsInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasTargetType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEqualityExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

