/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.Location;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.testframework.TestTreeViewAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.ui.awt.RelativePoint;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByTestDiscoveryUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataLineMarkerProvider;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationHandler;
import org.jetbrains.idea.devkit.testAssistant.TestDataReferenceCollector;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class NavigateToTestDataAction
extends AnAction
implements TestTreeViewAction,
UpdateInBackground {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        RelativePoint point = editor != null ? popupFactory.guessBestPopupLocation(editor) : popupFactory.guessBestPopupLocation(dataContext);
        List<TestDataFile> fileNames = NavigateToTestDataAction.findTestDataFiles(dataContext, project, true);
        if (fileNames.isEmpty()) {
            Notification notification = new Notification("testdata", DevKitBundle.message("testdata.notification.no.test.datafiles.title", new Object[0]), DevKitBundle.message("testdata.notification.no.test.datafiles.content", new Object[0]), NotificationType.INFORMATION);
            Notifications.Bus.notify((Notification)notification, (Project)project);
        } else {
            TestDataNavigationHandler.navigate(point, fileNames, project);
        }
    }

    @NotNull
    static List<TestDataFile> findTestDataFiles(@NotNull DataContext dataContext, @NotNull Project project, boolean shouldGuess) {
        if (dataContext == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(2);
        }
        List list = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            List<TestDataFile> fileNames = NavigateToTestDataAction.tryFindTestDataFiles(dataContext);
            if (fileNames.isEmpty() && shouldGuess) {
                return (List)ReadAction.compute(() -> {
                    PsiMethod method = NavigateToTestDataAction.findTargetMethod(dataContext);
                    return method == null ? Collections.emptyList() : TestDataGuessByExistingFilesUtil.guessTestDataName(method);
                });
            }
            return fileNames;
        }, DevKitBundle.message("testdata.searching", new Object[0]), true, project);
        if (list == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<TestDataFile> tryFindTestDataFiles(@NotNull DataContext context) {
        PsiMethod method;
        if (context == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(4);
        }
        if ((method = (PsiMethod)ReadAction.compute(() -> NavigateToTestDataAction.findTargetMethod(context))) == null) {
            PsiClass parametrizedTestClass = (PsiClass)ReadAction.compute(() -> NavigateToTestDataAction.findParametrizedClass(context));
            List<Object> list = parametrizedTestClass == null ? Collections.emptyList() : TestDataGuessByTestDiscoveryUtil.collectTestDataByExistingFiles(parametrizedTestClass);
            if (list == null) {
                NavigateToTestDataAction.$$$reportNull$$$0(5);
            }
            return list;
        }
        String name = (String)ReadAction.compute(() -> method.getName());
        if (name.startsWith("test")) {
            String testDataPath = (String)ReadAction.compute(() -> TestDataLineMarkerProvider.getTestDataBasePath(method.getContainingClass()));
            TestDataReferenceCollector collector = new TestDataReferenceCollector(testDataPath, name.substring(4));
            List<TestDataFile> list = collector.collectTestDataReferences(method);
            if (list == null) {
                NavigateToTestDataAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = (List)ReadAction.compute(() -> {
            PsiClass parametrizedTestClass;
            Location location = (Location)Location.DATA_KEY.getData(context);
            if (location instanceof PsiMemberParameterizedLocation && (parametrizedTestClass = NavigateToTestDataAction.findParametrizedClass(context)) != null) {
                String testDataPath = TestDataLineMarkerProvider.getTestDataBasePath(parametrizedTestClass);
                String paramSetName = ((PsiMemberParameterizedLocation)location).getParamSetName();
                String baseFileName = StringUtil.trimEnd((String)StringUtil.trimStart((String)paramSetName, (String)"["), (String)"]");
                return TestDataGuessByExistingFilesUtil.suggestTestDataFiles(baseFileName, testDataPath, parametrizedTestClass);
            }
            return Collections.emptyList();
        });
        if (list == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(8);
        }
        e.getPresentation().setEnabledAndVisible(NavigateToTestDataAction.findTargetMethod(e.getDataContext()) != null || NavigateToTestDataAction.findParametrizedClass(e.getDataContext()) != null);
    }

    @Nullable
    static PsiClass findParametrizedClass(@NotNull DataContext context) {
        PsiElement element;
        UClass uClass;
        if (context == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(9);
        }
        if ((uClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)(element = (PsiElement)context.getData(CommonDataKeys.PSI_ELEMENT)), UClass.class)) == null) {
            return null;
        }
        UAnnotation annotation = (UAnnotation)UastContextKt.toUElement((PsiElement)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)uClass.getJavaPsi(), Collections.singleton("org.junit.runner.RunWith")), UAnnotation.class);
        if (annotation == null) {
            return null;
        }
        UExpression value = annotation.findAttributeValue("value");
        if (!(value instanceof UClassLiteralExpression)) {
            return null;
        }
        UClassLiteralExpression classLiteralExpression = (UClassLiteralExpression)value;
        PsiType type = classLiteralExpression.getType();
        return type != null && type.equalsToText("com.intellij.testFramework.Parameterized") ? uClass.getJavaPsi() : null;
    }

    @Nullable
    private static PsiMethod findTargetMethod(@NotNull DataContext context) {
        UMethod method;
        Location location;
        if (context == null) {
            NavigateToTestDataAction.$$$reportNull$$$0(10);
        }
        if ((location = (Location)Location.DATA_KEY.getData(context)) != null && (method = (UMethod)UastContextKt.getUastParentOfType((PsiElement)location.getPsiElement(), UMethod.class, (boolean)false)) != null) {
            return method;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file != null && editor != null) {
            return (PsiMethod)UastContextKt.findUElementAt((PsiFile)file, (int)editor.getCaretModel().getOffset(), UMethod.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/NavigateToTestDataAction";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/NavigateToTestDataAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestDataFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFindTestDataFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTestDataFiles";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryFindTestDataFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParametrizedClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTargetMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

