/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInspection.i18n.folding.EditPropertyValueTooltipManager;
import com.intellij.codeInspection.i18n.folding.PropertyFoldingEditHandler;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditPropertyValueAction
extends BaseRefactoringAction {
    private static final Key<Boolean> EDITABLE_PROPERTY_VALUE = Key.create((String)"editable.property.value");
    private static final KeyStroke SHIFT_ENTER = KeyStroke.getKeyStroke(10, 1);

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            EditPropertyValueAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            EditPropertyValueAction.$$$reportNull$$$0(1);
        }
        return new Handler();
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            EditPropertyValueAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            EditPropertyValueAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            EditPropertyValueAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            EditPropertyValueAction.$$$reportNull$$$0(5);
        }
        return EditPropertyValueAction.isEnabled(editor);
    }

    public static boolean isEnabled(@NotNull Editor editor) {
        if (editor == null) {
            EditPropertyValueAction.$$$reportNull$$$0(6);
        }
        if (!(editor instanceof EditorImpl) || editor.getProject() == null) {
            return false;
        }
        FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(editor.getCaretModel().getOffset());
        if (region == null) {
            return false;
        }
        return EditPropertyValueAction.getEditableElement(region) != null;
    }

    @Nullable
    public static PsiElement getEditableElement(@NotNull FoldRegion region) {
        PsiElement psiElement;
        if (region == null) {
            EditPropertyValueAction.$$$reportNull$$$0(7);
        }
        return (psiElement = EditorFoldingInfo.get((Editor)region.getEditor()).getPsiElement(region)) == null || psiElement.getUserData(EDITABLE_PROPERTY_VALUE) == null ? null : psiElement;
    }

    public static void doEdit(@NotNull Editor editor) {
        if (editor == null) {
            EditPropertyValueAction.$$$reportNull$$$0(8);
        }
        if (!(editor instanceof EditorImpl) || editor.getProject() == null) {
            return;
        }
        FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(editor.getCaretModel().getOffset());
        if (region == null) {
            return;
        }
        PsiElement psiElement = EditPropertyValueAction.getEditableElement(region);
        PropertyFoldingEditHandler handler = new PropertyFoldingEditHandler(psiElement);
        if (!handler.isValid()) {
            return;
        }
        VisualPosition regionPosition = editor.offsetToVisualPosition(region.getStartOffset());
        VisualPosition caretPosition = editor.getCaretModel().getVisualPosition();
        int placeholderOffset = ((EditorImpl)editor).visualColumnToOffsetInFoldRegion(region, caretPosition.column - regionPosition.column, false);
        int valueOffset = handler.placeholderToValueOffset(placeholderOffset);
        String value = StringUtil.notNullize((String)handler.getValue());
        final Pair<String, Integer> unescaped = EditPropertyValueAction.unescape(value, valueOffset);
        final Ref manuallyResized = new Ref();
        final Ref popupRef = new Ref();
        EditorTextField textField = new EditorTextField((String)unescaped.first, editor.getProject(), (FileType)FileTypes.PLAIN_TEXT){

            @NotNull
            protected EditorEx createEditor() {
                EditorEx e = super.createEditor();
                e.getCaretModel().moveToOffset(Math.max(0, Math.min(e.getDocument().getTextLength(), (Integer)unescaped.second)));
                e.setHorizontalScrollbarVisible(true);
                e.getDocument().addDocumentListener(new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (manuallyResized.isNull()) {
                            ((JBPopup)popupRef.get()).pack(true, true);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/i18n/folding/EditPropertyValueAction$1$1", "documentChanged"));
                    }
                });
                EditorEx editorEx = e;
                if (editorEx == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorEx;
            }

            protected boolean shouldHaveBorder() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/folding/EditPropertyValueAction$1", "createEditor"));
            }
        };
        textField.setOneLineMode(false);
        textField.setFontInheritedFromLAF(false);
        MyShiftEnterAction shiftEnterAction = new MyShiftEnterAction();
        JPanel panel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                int MIN_WIDTH = JBUI.scale((int)350);
                int MAX_WIDTH = JBUI.scale((int)550);
                Dimension size = super.getPreferredSize();
                int width = size.width;
                int height = size.height;
                if (width > MAX_WIDTH) {
                    this.setSize(MAX_WIDTH, height);
                    this.validate();
                    size = super.getPreferredSize();
                    width = size.width;
                    height = size.height;
                }
                return new Dimension(Math.max(MIN_WIDTH, Math.min(MAX_WIDTH, width)), Math.min(MAX_WIDTH, height));
            }
        };
        panel.setBackground(textField.getBackground());
        int topBottomGap = 2;
        int sideGap = 4;
        int betweenGap = 1;
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, (Insets)new JBInsets(topBottomGap, sideGap, topBottomGap, betweenGap), 0, 0);
        panel.add((Component)textField, c);
        JComponent button = EditPropertyValueAction.createNewLineButton(textField, editor.getLineHeight(), (AnAction)shiftEnterAction);
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new JBInsets(topBottomGap, betweenGap, topBottomGap, sideGap);
        panel.add((Component)button, c);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)textField).setRequestFocus(true).setResizable(true).setLocateByContent(true).setCancelOnWindowDeactivation(false).createPopup();
        popupRef.set((Object)popup);
        ((AbstractPopup)popup).addResizeListener(() -> manuallyResized.set((Object)Boolean.TRUE), (Disposable)popup);
        new MyEnterAction(textField, region, popup, handler).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0)), (JComponent)textField);
        shiftEnterAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(SHIFT_ENTER), (JComponent)textField);
        Point location = editor.visualPositionToXY(new VisualPosition(regionPosition.line, regionPosition.column + 1));
        location.translate(-JBUI.scale((int)sideGap), -JBUI.scale((int)topBottomGap));
        popup.show(new RelativePoint((Component)editor.getContentComponent(), location));
        final LightweightHint hint = EditPropertyValueAction.showTooltip(editor, handler.getFile(), handler.getKey());
        if (hint != null) {
            popup.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    hint.hide();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/i18n/folding/EditPropertyValueAction$3", "onClosed"));
                }
            });
        }
    }

    private static Pair<String, Integer> unescape(String value, int offset) {
        StringBuilder b = new StringBuilder(value);
        int[] offsets = new int[]{offset};
        boolean escaped = false;
        for (int i = 0; i < b.length(); ++i) {
            String replacement;
            char c = b.charAt(i);
            if (c == '\\') {
                if (escaped) {
                    escaped = false;
                    i = EditPropertyValueAction.replaceEscapePair(b, i, "\\", offsets);
                    continue;
                }
                escaped = true;
                continue;
            }
            if (!escaped) continue;
            escaped = false;
            switch (c) {
                case '\n': {
                    replacement = "";
                    break;
                }
                case 'r': {
                    replacement = "\n";
                    break;
                }
                case 'n': {
                    replacement = "\r";
                    break;
                }
                case 'U': 
                case 'u': {
                    replacement = null;
                    break;
                }
                default: {
                    replacement = Character.toString(c);
                }
            }
            if (replacement == null) continue;
            i = EditPropertyValueAction.replaceEscapePair(b, i, replacement, offsets);
        }
        String result = StringUtil.convertLineSeparators((String)b.toString(), (String)"\n", (int[])offsets);
        return Pair.create((Object)result, (Object)offsets[0]);
    }

    private static int replaceEscapePair(StringBuilder b, int midOffset, String replacement, int[] offsetToKeep) {
        b.replace(midOffset - 1, midOffset + 1, replacement);
        int shift = replacement.length() - 2;
        if (offsetToKeep[0] > midOffset) {
            offsetToKeep[0] = offsetToKeep[0] + shift;
        }
        return midOffset + shift;
    }

    private static JComponent createNewLineButton(final EditorTextField textField, int minSize, AnAction shiftEnterAction) {
        Presentation presentation = shiftEnterAction.getTemplatePresentation();
        int size = Math.max(JBUI.scale((int)16), minSize);
        JBDimension d = new JBDimension(size, size, true);
        ActionButton button = new ActionButton(shiftEnterAction, presentation, "unknown", (Dimension)d){

            protected DataContext getDataContext() {
                return DataManager.getInstance().getDataContext((Component)textField);
            }

            public Insets getInsets() {
                return JBUI.emptyInsets();
            }
        };
        button.setLook(ActionButtonLook.INPLACE_LOOK);
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    private static LightweightHint showTooltip(@NotNull Editor editor, @Nullable VirtualFile file, @Nullable @NlsSafe String key) {
        if (editor == null) {
            EditPropertyValueAction.$$$reportNull$$$0(9);
        }
        if (file == null && key == null) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        if (file != null) {
            panel.add(new JLabel(file.getPresentableName() + (key == null ? "" : ": "), IconUtil.getIcon((VirtualFile)file, (int)0, (Project)editor.getProject()), 2));
        }
        if (key != null) {
            panel.add(new JLabel(key, AllIcons.Nodes.Property, 2));
        }
        return EditPropertyValueTooltipManager.showTooltip(editor, panel, true);
    }

    public static void registerFoldedElement(@NotNull PsiElement element, @NotNull Document document) {
        if (element == null) {
            EditPropertyValueAction.$$$reportNull$$$0(10);
        }
        if (document == null) {
            EditPropertyValueAction.$$$reportNull$$$0(11);
        }
        element.putUserData(EDITABLE_PROPERTY_VALUE, (Object)Boolean.TRUE);
        EditPropertyValueTooltipManager.initializeForDocument(document);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/i18n/folding/EditPropertyValueAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditableElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doEdit";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showTooltip";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "registerFoldedElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyShiftEnterAction
    extends EditorAction {
        private MyShiftEnterAction() {
            super((EditorActionHandler)new Handler());
            Presentation presentation = this.getTemplatePresentation();
            presentation.setDescription(JavaI18nBundle.message("action.description.new.line.0", KeymapUtil.getKeystrokeText((KeyStroke)SHIFT_ENTER)));
            presentation.setIcon(AllIcons.Actions.SearchNewLine);
            presentation.setHoveredIcon(AllIcons.Actions.SearchNewLineHover);
        }

        private static class Handler
        extends EditorWriteActionHandler {
            private Handler() {
            }

            public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                if (editor == null) {
                    Handler.$$$reportNull$$$0(0);
                }
                EditorActionManager.getInstance().getActionHandler("EditorEnter").execute(editor, caret, dataContext);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInspection/i18n/folding/EditPropertyValueAction$MyShiftEnterAction$Handler", "executeWriteAction"));
            }
        }
    }

    private static final class MyEnterAction
    extends AnAction {
        private final EditorTextField field;
        private final FoldRegion foldRegion;
        private final JBPopup popup;
        private final PropertyFoldingEditHandler handler;

        private MyEnterAction(EditorTextField field, FoldRegion region, JBPopup popup, PropertyFoldingEditHandler handler) {
            this.field = field;
            this.foldRegion = region;
            this.popup = popup;
            this.handler = handler;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PsiFile targetPsiFile;
            if (e == null) {
                MyEnterAction.$$$reportNull$$$0(0);
            }
            if ((targetPsiFile = this.handler.getPsiFile()) == null) {
                return;
            }
            Project project = this.field.getProject();
            String newValue = this.field.getText();
            Editor fieldEditor = this.field.getEditor();
            if (fieldEditor == null) {
                return;
            }
            int valueOffset = fieldEditor.getCaretModel().getOffset();
            final Editor editor = this.foldRegion.getEditor();
            JComponent editorComponent = editor.getContentComponent();
            MyEnterAction.focusAndRun(editorComponent, () -> {
                WriteCommandAction.runWriteCommandAction((Project)project, (String)JavaI18nBundle.message("command.name.edit.property.value", new Object[0]), null, () -> {
                    this.handler.setValue(newValue.replace("\n", "\\n"));
                    final String oldPlaceholder = this.foldRegion.getPlaceholderText();
                    final String newPlaceholder = this.handler.getPlaceholder();
                    editor.getFoldingModel().runBatchFoldingOperation(() -> this.foldRegion.setPlaceholderText(newPlaceholder));
                    VisualPosition regionStartPosition = editor.offsetToVisualPosition(this.foldRegion.getStartOffset());
                    int placeholderOffset = Math.max(1, Math.min(newPlaceholder.length() - 1, this.handler.valueToPlaceholderOffset(valueOffset)));
                    int placeholderColumn = ((EditorImpl)editor).offsetToVisualColumnInFoldRegion(this.foldRegion, placeholderOffset, false);
                    editor.getCaretModel().moveToVisualPosition(new VisualPosition(regionStartPosition.line, regionStartPosition.column + placeholderColumn));
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    UndoManager.getInstance((Project)project).undoableActionPerformed(new UndoableAction(){

                        public void undo() {
                            if (foldRegion.isValid()) {
                                editor.getFoldingModel().runBatchFoldingOperation(() -> foldRegion.setPlaceholderText(oldPlaceholder));
                            }
                        }

                        public void redo() {
                            if (foldRegion.isValid()) {
                                editor.getFoldingModel().runBatchFoldingOperation(() -> foldRegion.setPlaceholderText(newPlaceholder));
                            }
                        }

                        public DocumentReference @Nullable [] getAffectedDocuments() {
                            return null;
                        }

                        public boolean isGlobal() {
                            return false;
                        }
                    });
                }, (PsiFile[])new PsiFile[]{targetPsiFile});
                editorComponent.paintImmediately(new Rectangle(editorComponent.getSize()));
                this.popup.cancel();
            });
        }

        private static void focusAndRun(final @NotNull Component component, final @NotNull Runnable runnable) {
            if (component == null) {
                MyEnterAction.$$$reportNull$$$0(1);
            }
            if (runnable == null) {
                MyEnterAction.$$$reportNull$$$0(2);
            }
            component.requestFocus();
            if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == component) {
                runnable.run();
            } else {
                component.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        component.removeFocusListener(this);
                        runnable.run();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/i18n/folding/EditPropertyValueAction$MyEnterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "focusAndRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Handler
    implements RefactoringActionHandler {
        private Handler() {
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
            if (project == null) {
                Handler.$$$reportNull$$$0(0);
            }
            EditPropertyValueAction.doEdit(editor);
        }

        public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
            if (project == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (elements == null) {
                Handler.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elements";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/i18n/folding/EditPropertyValueAction$Handler";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

