/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerWithMultipleStackFrames;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.KotlinFileTypeFactoryUtils;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.CodeFragmentContextUtilsKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.DelegateSourcePosition;
import org.jetbrains.kotlin.idea.debugger.HopelessExceptionUtilKt;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineStackTraceCalculator;
import org.jetbrains.kotlin.idea.debugger.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitorKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00bf\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f*\u0001\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001RB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020 H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\"\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010-2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020+0\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010:\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u001e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001e0\n2\u0006\u0010<\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020 0\n2\u0006\u0010\u0016\u001a\u00020\u0013J\u0014\u0010>\u001a\u00020?*\u00020@2\u0006\u0010A\u001a\u00020 H\u0002J \u0010B\u001a\u00020?*\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0C2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J0\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001e0\n*\u00020\u001e2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001e0\n2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020 H\u0002J$\u0010I\u001a\u0004\u0018\u000107*\b\u0012\u0004\u0012\u0002070\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020 H\u0002J$\u0010J\u001a\u0004\u0018\u000107*\b\u0012\u0004\u0012\u0002070\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00102\u001a\u000203H\u0002J&\u0010K\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0C0\n*\u00020G2\u0006\u0010H\u001a\u00020 H\u0002J4\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010C*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0C0\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010M\u001a\u0004\u0018\u000107*\b\u0012\u0004\u0012\u0002070\n2\u0006\u0010N\u001a\u000203H\u0002J\u0014\u0010O\u001a\u00020?*\u00020\u001e2\u0006\u0010P\u001a\u00020-H\u0002J\u001c\u0010Q\u001a\u00020?*\u00020\u001e2\u0006\u0010P\u001a\u00020-2\u0006\u0010H\u001a\u00020 H\u0002R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerWithMultipleStackFrames;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "allKotlinFilesScope", "org/jetbrains/kotlin/idea/debugger/KotlinPositionManager$allKotlinFilesScope$1", "Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager$allKotlinFilesScope$1;", "sourceSearchScopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "stackFrameInterceptor", "Lorg/jetbrains/kotlin/idea/debugger/StackFrameInterceptor;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "classPrepareRequestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequests", "requestor", "position", "createStackFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "defaultInternalName", "", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "frame", "expression", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getAlternativeSource", "Lcom/intellij/psi/PsiFile;", "getCallableReferenceIfInside", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "lineNumber", "", "getElementForDeclarationLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "getLambdaOrFunIfInside", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getPsiFileByLocation", "getReferenceTypesForPositionInKtFile", "getSourcePosition", "locationsOfLine", "type", "originalClassNamesForPosition", "calculatedClassNameMatches", "", "Lcom/intellij/psi/PsiElement;", "currentLocationClassName", "contains", "Lcom/intellij/openapi/util/Pair;", "findLocationsInSameInlinedFunction", "locations", "method", "Lcom/sun/jdi/Method;", "sourceFileName", "getAppropriateLiteralBasedOnDeclaringClassName", "getAppropriateLiteralBasedOnLambdaName", "getInlineFunctionBorders", "getLeastEnclosingBorders", "getSamLambdaWithIndex", "index", "hasFinallyBlockInParent", "psiFile", "shouldBeTreatedAsReentrantSourcePosition", "KotlinReentrantSourcePosition", "kotlin.jvm-debugger.core"})
public final class KotlinPositionManager
implements MultiRequestPositionManager,
PositionManagerWithMultipleStackFrames {
    private final StackFrameInterceptor stackFrameInterceptor;
    private final allKotlinFilesScope.1 allKotlinFilesScope;
    private final List<GlobalSearchScope> sourceSearchScopes;
    private final DebugProcess myDebugProcess;

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        Set<FileType> set2 = KotlinFileTypeFactoryUtils.KOTLIN_FILE_TYPES_SET;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"KotlinFileTypeFactoryUtils.KOTLIN_FILE_TYPES_SET");
        return set2;
    }

    @NotNull
    public ThreeState evaluateCondition(@NotNull EvaluationContext context2, @NotNull StackFrameProxyImpl frame, @NotNull Location location2, @NotNull String expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return ThreeState.UNSURE;
    }

    @NotNull
    public List<XStackFrame> createStackFrames(@NotNull StackFrameProxyImpl frameProxy, @NotNull DebugProcessImpl debugProcess, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        if (!DebuggerUtilKt.isInKotlinSources(location2)) {
            return CollectionsKt.emptyList();
        }
        XStackFrame coroutineFrame = this.stackFrameInterceptor.createStackFrame(frameProxy, debugProcess, location2);
        if (coroutineFrame != null) {
            return CollectionsKt.listOf((Object)coroutineFrame);
        }
        if (Registry.get((String)"debugger.kotlin.inline.stack.trace.enabled").asBoolean()) {
            List<XStackFrame> inlineStackTrace = InlineStackTraceCalculator.INSTANCE.calculateInlineStackTrace(frameProxy);
            Collection collection = inlineStackTrace;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return inlineStackTrace;
            }
        }
        return CollectionsKt.listOf((Object)((Object)new KotlinStackFrame(frameProxy)));
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) {
        SourcePosition sourcePosition2;
        PsiFile psiFile2;
        if (location2 == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        String string = SafeUtilKt.safeSourceName(location2);
        if (string == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        String fileName = string;
        int lineNumber2 = SafeUtilKt.safeLineNumber(location2);
        if (lineNumber2 < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        PsiFile psiFile3 = this.getAlternativeSource(location2);
        if (psiFile3 == null) {
            psiFile3 = psiFile2 = this.getPsiFileByLocation(location2);
        }
        if (psiFile2 == null) {
            ReferenceType referenceType = location2.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
            boolean isKotlinStrataAvailable = DebuggerUtilKt.containsKotlinStrata(referenceType);
            if (isKotlinStrataAvailable) {
                try {
                    Project project2;
                    String javaSourceFileName = location2.sourceName("Java");
                    JvmClassName jvmClassName = JvmClassName.byInternalName((String)this.defaultInternalName(location2));
                    Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026ltInternalName(location))");
                    JvmClassName javaClassName = jvmClassName;
                    Project project3 = project2 = this.myDebugProcess.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                    String string2 = javaSourceFileName;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaSourceFileName");
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project3, this.sourceSearchScopes, javaClassName, string2, location2);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException javaSourceFileName) {
                    // empty catch block
                }
            }
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!(psiFile2 instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        int sourceLineNumber = SafeUtilKt.safeLineNumber(location2) - 1;
        if (sourceLineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        KtFunction lambdaOrFunIfInside = this.getLambdaOrFunIfInside(location2, (KtFile)psiFile2, sourceLineNumber);
        if (lambdaOrFunIfInside != null) {
            KtExpression ktExpression = lambdaOrFunIfInside.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            return SourcePosition.createFromElement((PsiElement)((PsiElement)ktExpression));
        }
        KtCallableReferenceExpression callableReferenceIfInside = this.getCallableReferenceIfInside(location2, (KtFile)psiFile2, sourceLineNumber);
        if (callableReferenceIfInside != null && (sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)callableReferenceIfInside))) != null) {
            return new KotlinReentrantSourcePosition(sourcePosition2);
        }
        KtElement elementInDeclaration = this.getElementForDeclarationLine(location2, (KtFile)psiFile2, sourceLineNumber);
        if (elementInDeclaration != null) {
            return SourcePosition.createFromElement((PsiElement)((PsiElement)elementInDeclaration));
        }
        if (this.shouldBeTreatedAsReentrantSourcePosition(location2, psiFile2, fileName)) {
            SourcePosition sourcePosition3 = SourcePosition.createFromLine((PsiFile)psiFile2, (int)sourceLineNumber);
            Intrinsics.checkNotNullExpressionValue((Object)sourcePosition3, (String)"SourcePosition.createFro\u2026siFile, sourceLineNumber)");
            return new KotlinReentrantSourcePosition(sourcePosition3);
        }
        return SourcePosition.createFromLine((PsiFile)psiFile2, (int)sourceLineNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldBeTreatedAsReentrantSourcePosition(Location $this$shouldBeTreatedAsReentrantSourcePosition, PsiFile psiFile2, String sourceFileName) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Method method = SafeUtilKt.safeMethod($this$shouldBeTreatedAsReentrantSourcePosition);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        Iterable iterable = SafeUtilKt.safeAllLineLocations(method2);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(it), (Object)sourceFileName) && it.lineNumber() == $this$shouldBeTreatedAsReentrantSourcePosition.lineNumber())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sameLineLocations = (List)destination$iv$iv;
        if (sameLineLocations.size() < 2 || this.hasFinallyBlockInParent($this$shouldBeTreatedAsReentrantSourcePosition, psiFile2)) {
            return false;
        }
        List<Location> locationsInSameInlinedFunction = this.findLocationsInSameInlinedFunction($this$shouldBeTreatedAsReentrantSourcePosition, sameLineLocations, method2, sourceFileName);
        Collection collection2 = locationsInSameInlinedFunction;
        boolean bl = false;
        if (collection2.isEmpty()) {
            boolean bl2 = false;
            collection = sameLineLocations;
        } else {
            collection = collection2;
        }
        return ((List)collection).indexOf($this$shouldBeTreatedAsReentrantSourcePosition) > 0;
    }

    private final boolean hasFinallyBlockInParent(Location $this$hasFinallyBlockInParent, PsiFile psiFile2) {
        KtFinallySection ktFinallySection;
        PsiElement elementAt;
        PsiElement psiElement2;
        Integer n = PsiLinesUtilsKt.getLineStartOffset(psiFile2, $this$hasFinallyBlockInParent.lineNumber());
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            psiElement2 = psiFile2.findElementAt(it);
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        if (psiElement3 != null) {
            PsiElement $this$parentOfType$iv = psiElement3;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            ktFinallySection = (KtFinallySection)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFinallySection.class, (boolean)true);
        } else {
            ktFinallySection = null;
        }
        return ktFinallySection != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Location> findLocationsInSameInlinedFunction(Location $this$findLocationsInSameInlinedFunction, List<? extends Location> locations, Method method, String sourceFileName) {
        void $this$filterTo$iv$iv;
        Pair<Location, Location> pair = this.getLeastEnclosingBorders(this.getInlineFunctionBorders(method, sourceFileName), $this$findLocationsInSameInlinedFunction);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        Pair<Location, Location> leastEnclosingBorders = pair;
        Iterable $this$filter$iv = locations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            if (!this.contains(leastEnclosingBorders, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Pair<Location, Location> getLeastEnclosingBorders(List<? extends Pair<Location, Location>> $this$getLeastEnclosingBorders, Location location2) {
        Pair<Location, Location> result2 = null;
        for (Pair<Location, Location> pair : $this$getLeastEnclosingBorders) {
            if (!this.contains(pair, location2) || result2 != null && ((Location)pair.first).compareTo(result2.first) <= 0) continue;
            result2 = pair;
        }
        return result2;
    }

    private final boolean contains(Pair<Location, Location> $this$contains, Location location2) {
        Comparable comparable = location2;
        return comparable.compareTo((Comparable)$this$contains.first) >= 0 && comparable.compareTo((Comparable)$this$contains.second) <= 0;
    }

    private final List<Pair<Location, Location>> getInlineFunctionBorders(Method $this$getInlineFunctionBorders, String sourceFileName) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)KotlinPositionManagerKt.access$getInlineFunctionLocalVariables($this$getInlineFunctionBorders), (Function1)getInlineFunctionBorders.1.INSTANCE), (Function1)((Function1)new Function1<Pair<Location, Location>, Boolean>(sourceFileName){
            final /* synthetic */ String $sourceFileName;

            public final boolean invoke(@NotNull Pair<Location, Location> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Object object = it.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
                return Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName((Location)object), (Object)this.$sourceFileName);
            }
            {
                this.$sourceFileName = string;
                super(1);
            }
        })));
    }

    private final PsiFile getAlternativeSource(Location location2) {
        PsiManager psiManager2 = PsiManager.getInstance((Project)this.myDebugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"PsiManager.getInstance(myDebugProcess.project)");
        PsiManager manager = psiManager2;
        String qName = location2.declaringType().name();
        String string = DebuggerUtilsEx.getAlternativeSourceUrl((String)qName, (Project)this.myDebugProcess.getProject());
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DebuggerUtilsEx.getAlter\u2026s.project) ?: return null");
        String alternativeFileUrl = string;
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(alternativeFileUrl);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"VirtualFileManager.getIn\u2026veFileUrl) ?: return null");
        VirtualFile alternativePsiFile = virtualFile2;
        return manager.findFile(alternativePsiFile);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtElement getElementForDeclarationLine(Location location, KtFile file, int lineNumber) {
        block8: {
            block7: {
                block6: {
                    v0 = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, lineNumber);
                    if (v0 == null) {
                        return null;
                    }
                    lineStartOffset = v0;
                    elementAt = file.findElementAt(lineStartOffset);
                    contextElement = CodeFragmentContextUtilsKt.getContextElement(elementAt);
                    if (!(contextElement instanceof KtClass)) {
                        return null;
                    }
                    methodName = location.method().name();
                    v1 = methodName;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"methodName");
                    if (!JvmAbi.isGetterName((String)v1)) break block7;
                    v2 /* !! */  = ((KtClass)contextElement).getPrimaryConstructor();
                    if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getValueParameters()) == null) {
                        v2 /* !! */  = CollectionsKt.emptyList();
                    }
                    valueParameters /* !! */  = v2 /* !! */ ;
                    var9_9 = (Iterable)valueParameters /* !! */ ;
                    var10_10 = false;
                    var11_11 = var9_9;
                    var12_12 = false;
                    for (T var14_14 : var11_11) {
                        it = (KtParameter)var14_14;
                        $i$a$-find-KotlinPositionManager$getElementForDeclarationLine$1 = false;
                        if (!it.hasValOrVar()) ** GOTO lbl-1000
                        v3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                        if (v3.getName() == null) ** GOTO lbl-1000
                        v4 = it.getName();
                        Intrinsics.checkNotNull((Object)v4);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it.name!!");
                        if (Intrinsics.areEqual((Object)JvmAbi.getterName((String)v4), (Object)methodName)) {
                            v5 = true;
                        } else lbl-1000:
                        // 3 sources

                        {
                            v5 = false;
                        }
                        if (!v5) continue;
                        v6 = var14_14;
                        break block6;
                    }
                    v6 = null;
                }
                v7 = v6;
                break block8;
            }
            v7 = Intrinsics.areEqual((Object)methodName, (Object)"<init>") != false ? (KtElement)((KtClass)contextElement).getPrimaryConstructor() : null;
        }
        return v7;
    }

    /*
     * WARNING - void declaration
     */
    private final KtCallableReferenceExpression getCallableReferenceIfInside(Location location2, KtFile file2, int lineNumber2) {
        Object v5;
        block6: {
            List list2;
            String string = KotlinPositionManagerKt.getClassName(location2);
            if (string == null) {
                return null;
            }
            String currentLocationClassName = string;
            boolean $i$f$getElementsAtLineIfAny = false;
            PsiElement psiElement2 = DebuggerUtilKt.findElementAtLine(file2, lineNumber2);
            if (!(psiElement2 instanceof KtElement)) {
                psiElement2 = null;
            }
            KtElement ktElement = (KtElement)psiElement2;
            if (ktElement == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$filterIsInstanceTo$iv$iv$iv;
                void $this$filterIsInstance$iv$iv;
                KtElement lineElement$iv = ktElement;
                int start$iv = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement$iv));
                int end$iv = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement$iv));
                List<PsiElement> list3 = CodeInsightUtils.findElementsOfClassInRange((PsiFile)file2, start$iv, end$iv, KtCallableReferenceExpression.class);
                Intrinsics.checkNotNullExpressionValue(list3, (String)"CodeInsightUtils.findEle\u2026tart, end, T::class.java)");
                Iterable iterable = list3;
                boolean $i$f$filterIsInstance = false;
                void var12_15 = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof KtCallableReferenceExpression)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                list2 = (List)destination$iv$iv$iv;
            }
            List allReferenceExpressions = list2;
            Iterable $this$firstOrNull$iv = allReferenceExpressions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtCallableReferenceExpression it = (KtCallableReferenceExpression)element$iv;
                boolean bl = false;
                if (!this.calculatedClassNameMatches((PsiElement)it, currentLocationClassName)) continue;
                v5 = element$iv;
                break block6;
            }
            v5 = null;
        }
        return v5;
    }

    private final KtFunction getLambdaOrFunIfInside(Location location2, KtFile file2, int lineNumber2) {
        String string = KotlinPositionManagerKt.getClassName(location2);
        if (string == null) {
            return null;
        }
        String currentLocationClassName = string;
        Integer start2 = CodeInsightUtils.getStartLineOffset((PsiFile)file2, lineNumber2);
        Integer end = CodeInsightUtils.getEndLineOffset((PsiFile)file2, lineNumber2);
        if (start2 == null || end == null) {
            return null;
        }
        List<KtFunction> literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file2, lineNumber2);
        if (literalsOrFunctions.isEmpty()) {
            return null;
        }
        KtFunction ktFunction = this.getAppropriateLiteralBasedOnDeclaringClassName(literalsOrFunctions, location2, currentLocationClassName);
        if (ktFunction == null) {
            ktFunction = this.getAppropriateLiteralBasedOnLambdaName(literalsOrFunctions, location2, lineNumber2);
        }
        return ktFunction;
    }

    private final KtFunction getAppropriateLiteralBasedOnDeclaringClassName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnDeclaringClassName, Location location2, String currentLocationClassName) {
        for (KtFunction ktFunction : $this$getAppropriateLiteralBasedOnDeclaringClassName) {
            if (InlineUtil.isInlinedArgument((KtFunction)ktFunction, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)ktFunction), (BodyResolveMode)BodyResolveMode.PARTIAL), (boolean)true)) {
                DebugProcess debugProcess = this.myDebugProcess;
                if (debugProcess == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                }
                if (!DebuggerUtilKt.isInsideInlineArgument(ktFunction, location2, (DebugProcessImpl)debugProcess)) continue;
                return ktFunction;
            }
            PsiElement psiElement2 = ktFunction.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"literal.firstChild");
            if (!this.calculatedClassNameMatches(psiElement2, currentLocationClassName)) continue;
            return ktFunction;
        }
        return null;
    }

    private final boolean calculatedClassNameMatches(PsiElement $this$calculatedClassNameMatches, String currentLocationClassName) {
        boolean bl;
        block3: {
            Project project2 = this.myDebugProcess.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myDebugProcess.project");
            GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
            List<String> internalClassNames = new DebuggerClassNameProvider(project2, globalSearchScope, false, false, 4, null).getOuterClassNamesForElement($this$calculatedClassNameMatches, SetsKt.emptySet()).getClassNames();
            Iterable $this$any$iv = internalClassNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final KtFunction getAppropriateLiteralBasedOnLambdaName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnLambdaName, Location location, int lineNumber) {
        v0 = SafeUtilKt.safeMethod(location);
        if (v0 == null) {
            return null;
        }
        method = v0;
        v1 = method.name();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"method.name()");
        if (!DebuggerUtils.INSTANCE.isGeneratedLambdaName(v1)) {
            return null;
        }
        v2 = location.declaringType().methods();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"location.declaringType().methods()");
        var6_5 = v2;
        $i$f$filter = false;
        var8_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Method)element$iv$iv;
            $i$a$-filter-KotlinPositionManager$getAppropriateLiteralBasedOnLambdaName$lambdas$1 = false;
            v3 = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.name()");
            if (!DebuggerUtils.INSTANCE.isGeneratedLambdaName(v3)) ** GOTO lbl-1000
            v4 = DebuggerUtilsEx.locationsOfLine((Method)it, (int)(lineNumber + 1));
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"DebuggerUtilsEx.location\u2026fLine(it, lineNumber + 1)");
            var15_14 = v4;
            var16_15 = false;
            if (var15_14.isEmpty() == false) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        lambdas = (List)destination$iv$iv;
        return this.getSamLambdaWithIndex($this$getAppropriateLiteralBasedOnLambdaName, lambdas.indexOf(method));
    }

    private final KtFunction getSamLambdaWithIndex(List<? extends KtFunction> $this$getSamLambdaWithIndex, int index2) {
        int samLambdaCounter = 0;
        for (KtFunction ktFunction : $this$getSamLambdaWithIndex) {
            if (!SmartStepTargetVisitorKt.isSamLambda(ktFunction)) continue;
            if (samLambdaCounter == index2) {
                return ktFunction;
            }
            ++samLambdaCounter;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location2) {
        Project project2;
        String string;
        String string2 = SafeUtilKt.safeSourceName(location2);
        if (string2 == null) {
            return null;
        }
        String sourceName2 = string2;
        try {
            String string3;
            ReferenceType referenceType = location2.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
            if (DebuggerUtilKt.containsKotlinStrata(referenceType)) {
                String string4 = location2.sourcePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"location.sourcePath()");
                string3 = StringsKt.replace$default((String)string4, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            } else {
                string3 = this.defaultInternalName(location2);
            }
            string = string3;
        }
        catch (AbsentInformationException e) {
            string = this.defaultInternalName(location2);
        }
        String referenceInternalName = string;
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)referenceInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalName(referenceInternalName)");
        JvmClassName className2 = jvmClassName;
        Project project3 = project2 = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        return (PsiFile)DebuggerUtils.INSTANCE.findSourceFileForClass(project3, this.sourceSearchScopes, className2, sourceName2, location2);
    }

    private final String defaultInternalName(Location location2) {
        String referenceFqName;
        String string = referenceFqName = location2.declaringType().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"referenceFqName");
        return StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile2 = sourcePosition2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"sourcePosition.file");
        PsiFile psiFile3 = psiFile2;
        if (psiFile3 instanceof KtFile) {
            List list2;
            List list3;
            if (!ProjectRootsUtil.isInProjectOrLibSource$default((PsiElement)psiFile3, false, 2, null)) {
                return CollectionsKt.emptyList();
            }
            boolean $i$f$hopelessAware = false;
            try {
                boolean bl = false;
                list3 = this.getReferenceTypesForPositionInKtFile(sourcePosition2);
            }
            catch (Exception e$iv) {
                HopelessExceptionUtilKt.handleHopelessException(e$iv);
                list3 = null;
            }
            if ((list2 = list3) == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }
        if (psiFile3 instanceof ClsFileImpl) {
            PsiFile $this$readAction$iv = psiFile3;
            boolean $i$f$readAction = false;
            PsiFile decompiledPsiFile = (PsiFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiFile>((Object)$this$readAction$iv){
                final /* synthetic */ Object $this_readAction;
                {
                    this.$this_readAction = object;
                    super(0);
                }

                public final PsiFile invoke() {
                    ClsFileImpl it = (ClsFileImpl)this.$this_readAction;
                    boolean bl = false;
                    return it.getDecompiledPsiFile();
                }
            });
            if (decompiledPsiFile instanceof KtClsFile && ((Number)ApplicationUtilsKt.runReadAction((Function0)new Function0<Integer>(sourcePosition2){
                final /* synthetic */ SourcePosition $sourcePosition;

                public final int invoke() {
                    return this.$sourcePosition.getLine();
                }
                {
                    this.$sourcePosition = sourcePosition2;
                    super(0);
                }
            })).intValue() == -1) {
                String className2 = JvmFileClassUtil.getFileClassInternalName((KtFile)((KtFile)decompiledPsiFile));
                List list4 = this.myDebugProcess.getVirtualMachineProxy().classesByName(className2);
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"myDebugProcess.virtualMa\u2026.classesByName(className)");
                return list4;
            }
        }
        NoDataException noDataException = NoDataException.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
        throw (Throwable)noDataException;
    }

    private final List<ReferenceType> getReferenceTypesForPositionInKtFile(SourcePosition sourcePosition2) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Project project2 = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myDebugProcess.project");
        GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
        DebuggerClassNameProvider debuggerClassNameProvider = new DebuggerClassNameProvider(project2, globalSearchScope, false, false, 12, null);
        int lineNumber2 = ((Number)ApplicationUtilsKt.runReadAction((Function0)new Function0<Integer>(sourcePosition2){
            final /* synthetic */ SourcePosition $sourcePosition;

            public final int invoke() {
                return this.$sourcePosition.getLine();
            }
            {
                this.$sourcePosition = sourcePosition2;
                super(0);
            }
        })).intValue();
        Set<String> classes2 = debuggerClassNameProvider.getClassesForPosition(sourcePosition2);
        Iterable $this$flatMap$iv = classes2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String className2 = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.myDebugProcess.getVirtualMachineProxy().classesByName(className2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReferenceType referenceType = (ReferenceType)element$iv$iv;
            boolean bl = false;
            ReferenceType referenceType2 = referenceType;
            Intrinsics.checkNotNullExpressionValue((Object)referenceType2, (String)"referenceType");
            list$iv$iv = KotlinPositionManagerKt.access$findTargetClasses(this.myDebugProcess, referenceType2, lineNumber2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> originalClassNamesForPosition(@NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Project project2 = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myDebugProcess.project");
        GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
        DebuggerClassNameProvider debuggerClassNameProvider = new DebuggerClassNameProvider(project2, globalSearchScope, false, false, 8, null);
        return debuggerClassNameProvider.getOuterClassNamesForPosition(position);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        try {
            void $this$filterTo$iv$iv;
            int line;
            List locations;
            if (NoStrataPositionManagerHelperKt.isDexDebug(this.myDebugProcess)) {
                List inlineLocations2 = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends Location>>(this, type2, position){
                    final /* synthetic */ KotlinPositionManager this$0;
                    final /* synthetic */ ReferenceType $type;
                    final /* synthetic */ SourcePosition $position;

                    @NotNull
                    public final List<Location> invoke() {
                        GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getSearchScope();
                        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
                        return NoStrataPositionManagerHelperKt.getLocationsOfInlinedLine(this.$type, this.$position, globalSearchScope);
                    }
                    {
                        this.this$0 = kotlinPositionManager;
                        this.$type = referenceType;
                        this.$position = sourcePosition2;
                        super(0);
                    }
                });
                Collection collection = inlineLocations2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return inlineLocations2;
                }
            }
            if ((locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (String)"Kotlin", null, (int)(line = position.getLine() + 1))) == null || locations.isEmpty()) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
                throw (Throwable)noDataException;
            }
            Iterable $this$filter$iv = locations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Location it = (Location)element$iv$iv;
                boolean bl = false;
                String string = it.sourceName("Kotlin");
                PsiFile psiFile2 = position.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"position.file");
                if (!Intrinsics.areEqual((Object)string, (Object)psiFile2.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun", replaceWith=@ReplaceWith(imports={}, expression="createPrepareRequests(classPrepareRequestor, sourcePosition).firstOrNull()"))
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition2));
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        Object object = DumbService.getInstance((Project)this.myDebugProcess.getProject()).runReadActionInSmartMode(new Computable(this, position, requestor){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ SourcePosition $position;
            final /* synthetic */ ClassPrepareRequestor $requestor;

            /*
             * WARNING - void declaration
             */
            public final List<ClassPrepareRequest> compute() {
                void $this$flatMapTo$iv$iv;
                Project project2 = KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myDebugProcess.project");
                GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
                List<String> classNames = new DebuggerClassNameProvider(project2, globalSearchScope, false, false, 12, null).getOuterClassNamesForPosition(this.$position);
                Iterable $this$flatMap$iv = classNames;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    String name2 = (String)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])new ClassPrepareRequest[]{KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getRequestsManager().createClassPrepareRequest(this.$requestor, name2), KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getRequestsManager().createClassPrepareRequest(this.$requestor, name2 + "$*")});
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = kotlinPositionManager;
                this.$position = sourcePosition2;
                this.$requestor = classPrepareRequestor;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DumbService.getInstance(\u2026\n            }\n        })");
        return (List)object;
    }

    public KotlinPositionManager(@NotNull DebugProcess myDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)myDebugProcess, (String)"myDebugProcess");
        this.myDebugProcess = myDebugProcess;
        Project project2 = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myDebugProcess.project");
        ComponentManager $this$getServiceSafe$iv = (ComponentManager)project2;
        boolean $i$f$getServiceSafe = false;
        Object object = $this$getServiceSafe$iv.getService(StackFrameInterceptor.class);
        if (object == null) {
            String string = "Unable to locate service " + StackFrameInterceptor.class.getName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.stackFrameInterceptor = (StackFrameInterceptor)object;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myDebugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(myDebugProcess.project)");
        Project project3 = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myDebugProcess.project");
        this.allKotlinFilesScope = new DelegatingGlobalSearchScope(this, KotlinSourceFilterScope.Companion.projectAndLibrariesSources(globalSearchScope, project3)){
            private final ProjectFileIndex projectIndex;
            private final Comparator<VirtualFile> scopeComparator;
            final /* synthetic */ KotlinPositionManager this$0;

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
                return this.scopeComparator.compare(file1, file2);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)KotlinPositionManager.access$getMyDebugProcess$p(this$0).getProject());
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getIn\u2026e(myDebugProcess.project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026rocess.project).fileIndex");
                this.projectIndex = projectFileIndex;
                this.scopeComparator = Comparator.comparing(new Function(this){
                    final /* synthetic */ allKotlinFilesScope.1 this$0;

                    public final Boolean apply(VirtualFile it) {
                        return allKotlinFilesScope.1.access$getProjectIndex$p(this.this$0).isInSourceContent(it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).thenComparing(new Function(this){
                    final /* synthetic */ allKotlinFilesScope.1 this$0;

                    public final Boolean apply(VirtualFile it) {
                        return allKotlinFilesScope.1.access$getProjectIndex$p(this.this$0).isInLibrarySource(it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).thenComparing(new Comparator(this){
                    final /* synthetic */ allKotlinFilesScope.1 this$0;

                    public final int compare(VirtualFile file1, VirtualFile file2) {
                        return allKotlinFilesScope.1.access$compare$s-1623866647(this.this$0, file1, file2);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }

            public static final /* synthetic */ ProjectFileIndex access$getProjectIndex$p(allKotlinFilesScope.1 $this) {
                return $this.projectIndex;
            }

            public static final /* synthetic */ int access$compare$s-1623866647(allKotlinFilesScope.1 $this, VirtualFile p0, VirtualFile p1) {
                return super.compare(p0, p1);
            }
        };
        Object[] objectArray = new GlobalSearchScope[2];
        GlobalSearchScope globalSearchScope2 = this.myDebugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"myDebugProcess.searchScope");
        objectArray[0] = globalSearchScope2;
        objectArray[1] = (GlobalSearchScope)this.allKotlinFilesScope;
        this.sourceSearchScopes = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ DebugProcess access$getMyDebugProcess$p(KotlinPositionManager $this) {
        return $this.myDebugProcess;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager$KotlinReentrantSourcePosition;", "Lorg/jetbrains/kotlin/idea/debugger/DelegateSourcePosition;", "delegate", "Lcom/intellij/debugger/SourcePosition;", "(Lcom/intellij/debugger/SourcePosition;)V", "kotlin.jvm-debugger.core"})
    public static final class KotlinReentrantSourcePosition
    extends DelegateSourcePosition {
        public KotlinReentrantSourcePosition(@NotNull SourcePosition delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate);
        }
    }
}

