/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.command;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.command.CoroutineDumpAction;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CompleteCoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoDatasKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineDumpPanel;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/command/CoroutineDumpAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addCoroutineDump", "project", "Lcom/intellij/openapi/project/Project;", "coroutines", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CompleteCoroutineInfoData;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "update", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineDumpAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project3);
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        DebuggerContextImpl context2 = debuggerContextImpl;
        DebuggerSession session = context2.getDebuggerSession();
        if (session != null && session.isAttached()) {
            DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"context.debugProcess ?: return");
            DebugProcessImpl process2 = debugProcessImpl;
            process2.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(this, session, project3, context2, context2.getSuspendContext()){
                final /* synthetic */ CoroutineDumpAction this$0;
                final /* synthetic */ DebuggerSession $session;
                final /* synthetic */ Project $project;
                final /* synthetic */ DebuggerContextImpl $context;

                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                    CoroutineInfoCache states = new CoroutineDebugProbesProxy(suspendContext).dumpCoroutines();
                    if (states.isOk()) {
                        Function0 f2;
                        Function0 function0 = f2 = (Function0)new Function0<Unit>(this, states){
                            final /* synthetic */ actionPerformed.1 this$0;
                            final /* synthetic */ CoroutineInfoCache $states;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                void $this$mapTo$iv$iv;
                                XDebugSession xDebugSession = this.this$0.$session.getXDebugSession();
                                if (xDebugSession == null || (xDebugSession = xDebugSession.getUI()) == null) {
                                    return;
                                }
                                XDebugSession ui = xDebugSession;
                                Iterable $this$map$iv = this.$states.getCache();
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    CoroutineInfoData coroutineInfoData = (CoroutineInfoData)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    CompleteCoroutineInfoData completeCoroutineInfoData = CoroutineInfoDatasKt.toCompleteCoroutineInfoData((CoroutineInfoData)it);
                                    collection.add(completeCoroutineInfoData);
                                }
                                List coroutines = (List)destination$iv$iv;
                                CoroutineDumpAction coroutineDumpAction = this.this$0.this$0;
                                Project project2 = this.this$0.$project;
                                GlobalSearchScope globalSearchScope = this.this$0.$session.getSearchScope();
                                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"session.searchScope");
                                coroutineDumpAction.addCoroutineDump(project2, coroutines, (RunnerLayoutUi)ui, globalSearchScope);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$states = coroutineInfoCache;
                                super(0);
                            }
                        };
                        ApplicationManager.getApplication().invokeLater(new Runnable(function0){
                            private final /* synthetic */ Function0 function;
                            {
                                this.function = function0;
                            }

                            public final /* synthetic */ void run() {
                                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                            }
                        }, ModalityState.NON_MODAL);
                    } else {
                        String message2 = KotlinDebuggerCoroutinesBundle.message("coroutine.dump.failed", new Object[0]);
                        NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
                        MessageType messageType = MessageType.ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
                        notificationGroup.createNotification(message2, messageType).notify(this.$project);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$session = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$context = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    public final void addCoroutineDump(@NotNull Project project2, @NotNull List<CompleteCoroutineInfoData> coroutines, @NotNull RunnerLayoutUi ui, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(coroutines, (String)"coroutines");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"TextConsoleBuilderFactor\u2026().createBuilder(project)");
        TextConsoleBuilder consoleBuilder = textConsoleBuilder;
        consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)searchScope2));
        ConsoleView consoleView2 = consoleBuilder.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView2, (String)"consoleBuilder.console");
        ConsoleView consoleView3 = consoleView2;
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView3.allowHeavyFilters();
        CoroutineDumpPanel panel2 = new CoroutineDumpPanel(project2, consoleView3, toolbarActions, coroutines);
        String id = "DumpKt " + DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        Content content2 = ui.createContent(id, (JComponent)panel2, id, null, null);
        boolean bl = false;
        boolean bl2 = false;
        Content $this$apply = content2;
        boolean bl3 = false;
        $this$apply.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)true);
        $this$apply.setCloseable(true);
        $this$apply.setDescription(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.panel.title", new Object[0]));
        Content content3 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"ui.createContent(id, pan\u2026p.panel.title\")\n        }");
        Content content4 = content3;
        ui.addContent(content4);
        ui.selectAndFocus(content4, true, true);
        Disposer.register((Disposable)((Disposable)content4), (Disposable)((Disposable)consoleView3));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Presentation presentation2 = presentation;
        Project project2 = e.getProject();
        if (project2 == null) {
            CoroutineDumpAction coroutineDumpAction = this;
            boolean bl = false;
            boolean bl2 = false;
            CoroutineDumpAction $this$run = coroutineDumpAction;
            boolean bl3 = false;
            presentation2.setEnabledAndVisible(false);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: run {\n     \u2026         return\n        }");
        Project project3 = project2;
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project3);
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        if (debuggerContextImpl.getSuspendContext() == null) {
            presentation2.setEnabled(false);
            return;
        }
        DebuggerManagerEx debuggerManagerEx2 = DebuggerManagerEx.getInstanceEx((Project)project3);
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx2, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl2 = debuggerManagerEx2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl2, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        DebuggerSession debuggerSession = debuggerContextImpl2.getDebuggerSession();
        presentation2.setEnabled(debuggerSession != null && debuggerSession.isAttached());
        presentation2.setVisible(presentation2.isEnabled());
    }
}

