/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.sun.jdi.ObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolderKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.LocationCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.BaseContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.BaseMirror;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugMetadata;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.FieldVariable;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackTraceElement;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u00150\u000e2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider;", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;)V", "debugMetadata", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugMetadata;", "locationCache", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/LocationCache;", "findStackFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider$CoroutineStackFrames;", "mirror", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfCoroutineInfo;", "getSpilledVariablesForNFrames", "", "Lcom/intellij/debugger/engine/JavaValue;", "lastObservedFrame", "Lcom/sun/jdi/ObjectReference;", "n", "", "toJavaValues", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/FieldVariable;", "continuation", "CoroutineStackFrames", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineStackTraceProvider {
    private final LocationCache locationCache;
    private final DebugMetadata debugMetadata;
    private final DefaultExecutionContext executionContext;

    @Nullable
    public final CoroutineStackFrames findStackFrames(@NotNull MirrorOfCoroutineInfo mirror) {
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        return (CoroutineStackFrames)DebuggerUtilKt.invokeInManagerThread(this.executionContext.getDebugProcess(), (Function1)new Function1<DebuggerContextImpl, CoroutineStackFrames>(this, mirror){
            final /* synthetic */ CoroutineStackTraceProvider this$0;
            final /* synthetic */ MirrorOfCoroutineInfo $mirror;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CoroutineStackFrames invoke(@NotNull DebuggerContextImpl it) {
                void $this$mapIndexedTo$iv$iv;
                int n;
                int n2;
                void $this$mapIndexedTo$iv$iv2;
                int n3;
                Object it2;
                List frames;
                Object object;
                Collection collection;
                block10: {
                    Collection destination$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    List<MirrorOfStackTraceElement> list2 = this.$mirror.getEnhancedStackTraceProvider().getStackTrace();
                    if (list2 != null) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = list2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it3;
                            MirrorOfStackTraceElement mirrorOfStackTraceElement = (MirrorOfStackTraceElement)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            object = it3.stackTraceElement();
                            collection.add(object);
                        }
                    } else {
                        return null;
                    }
                    List $this$indexOfFirst$iv = frames = (List)destination$iv$iv;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (E item$iv : $this$indexOfFirst$iv) {
                        it2 = (StackTraceElement)item$iv;
                        boolean bl = false;
                        if (CoroutineUtilsKt.isCreationSeparatorFrame((StackTraceElement)it2)) {
                            n3 = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n3 = -1;
                }
                int index2 = n3;
                List restoredStackTraceElements = index2 >= 0 ? CollectionsKt.take((Iterable)frames, (int)index2) : frames;
                List spilledVariablesPerFrame = CoroutineStackTraceProvider.access$getSpilledVariablesForNFrames(this.this$0, this.$mirror.getLastObservedFrame(), restoredStackTraceElements.size());
                Iterable $this$mapIndexed$iv = restoredStackTraceElements;
                boolean $i$f$mapIndexed = false;
                it2 = $this$mapIndexed$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                    void element3;
                    void ix2;
                    int n4 = index$iv$iv++;
                    n2 = 0;
                    if (n4 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                    int n5 = n4;
                    collection = destination$iv$iv;
                    n = 0;
                    List list3 = (List)CollectionsKt.getOrNull((List)spilledVariablesPerFrame, (int)ix2);
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    List variables = list3;
                    object = new SuspendCoroutineStackFrameItem((StackTraceElement)element3, CoroutineStackTraceProvider.access$getLocationCache$p(this.this$0).createLocation((StackTraceElement)element3), variables);
                    collection.add(object);
                }
                List restoredStackFrames = (List)destination$iv$iv;
                Iterable $this$mapIndexed$iv2 = frames.subList(index2 + 1, frames.size());
                boolean $i$f$mapIndexed2 = false;
                destination$iv$iv = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void ix;
                    void element4;
                    n2 = index$iv$iv2++;
                    boolean bl = false;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    StackTraceElement ix2 = (StackTraceElement)item$iv$iv;
                    n = n2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    object = new CreationCoroutineStackFrameItem((StackTraceElement)element4, CoroutineStackTraceProvider.access$getLocationCache$p(this.this$0).createLocation((StackTraceElement)element4), ix == false);
                    collection.add(object);
                }
                List creationStackFrames = (List)destination$iv$iv2;
                return new CoroutineStackFrames(restoredStackFrames, creationStackFrames);
            }
            {
                this.this$0 = coroutineStackTraceProvider;
                this.$mirror = mirrorOfCoroutineInfo;
                super(1);
            }
        });
    }

    private final List<List<JavaValue>> getSpilledVariablesForNFrames(ObjectReference lastObservedFrame, int n) {
        BaseMirror baseMirror = this.debugMetadata;
        if (baseMirror == null || (baseMirror = ((DebugMetadata)baseMirror).getBaseContinuationImpl()) == null) {
            return CollectionsKt.emptyList();
        }
        BaseMirror baseContinuationImpl = baseMirror;
        boolean bl = false;
        List spilledVariablesPerFrame = new ArrayList();
        ObjectReference observedFrame = lastObservedFrame;
        while (observedFrame != null && spilledVariablesPerFrame.size() < n) {
            List<FieldVariable> spilledVariables = this.debugMetadata.getBaseContinuationImpl().getSpilledVariableFieldMapping(observedFrame, this.executionContext);
            spilledVariablesPerFrame.add(this.toJavaValues(spilledVariables, observedFrame));
            observedFrame = ((BaseContinuationImpl)baseContinuationImpl).getNextContinuation(observedFrame, this.executionContext);
        }
        return spilledVariablesPerFrame;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaValue> toJavaValues(List<FieldVariable> $this$toJavaValues, ObjectReference continuation2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toJavaValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FieldVariable fieldVariable = (FieldVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JavaValue javaValue = ContinuationHolderKt.toJavaValue((FieldVariable)it, continuation2, this.executionContext);
            collection.add(javaValue);
        }
        return (List)destination$iv$iv;
    }

    public CoroutineStackTraceProvider(@NotNull DefaultExecutionContext executionContext2) {
        Intrinsics.checkNotNullParameter((Object)executionContext2, (String)"executionContext");
        this.executionContext = executionContext2;
        this.locationCache = new LocationCache(this.executionContext);
        this.debugMetadata = DebugMetadata.Companion.instance(this.executionContext);
    }

    public static final /* synthetic */ List access$getSpilledVariablesForNFrames(CoroutineStackTraceProvider $this, ObjectReference lastObservedFrame, int n) {
        return $this.getSpilledVariablesForNFrames(lastObservedFrame, n);
    }

    public static final /* synthetic */ LocationCache access$getLocationCache$p(CoroutineStackTraceProvider $this) {
        return $this.locationCache;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider$CoroutineStackFrames;", "", "restoredStackFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendCoroutineStackFrameItem;", "creationStackFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "(Ljava/util/List;Ljava/util/List;)V", "getCreationStackFrames", "()Ljava/util/List;", "getRestoredStackFrames", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.coroutines"})
    public static final class CoroutineStackFrames {
        @NotNull
        private final List<SuspendCoroutineStackFrameItem> restoredStackFrames;
        @NotNull
        private final List<CreationCoroutineStackFrameItem> creationStackFrames;

        @NotNull
        public final List<SuspendCoroutineStackFrameItem> getRestoredStackFrames() {
            return this.restoredStackFrames;
        }

        @NotNull
        public final List<CreationCoroutineStackFrameItem> getCreationStackFrames() {
            return this.creationStackFrames;
        }

        public CoroutineStackFrames(@NotNull List<SuspendCoroutineStackFrameItem> restoredStackFrames, @NotNull List<CreationCoroutineStackFrameItem> creationStackFrames) {
            Intrinsics.checkNotNullParameter(restoredStackFrames, (String)"restoredStackFrames");
            Intrinsics.checkNotNullParameter(creationStackFrames, (String)"creationStackFrames");
            this.restoredStackFrames = restoredStackFrames;
            this.creationStackFrames = creationStackFrames;
        }

        @NotNull
        public final List<SuspendCoroutineStackFrameItem> component1() {
            return this.restoredStackFrames;
        }

        @NotNull
        public final List<CreationCoroutineStackFrameItem> component2() {
            return this.creationStackFrames;
        }

        @NotNull
        public final CoroutineStackFrames copy(@NotNull List<SuspendCoroutineStackFrameItem> restoredStackFrames, @NotNull List<CreationCoroutineStackFrameItem> creationStackFrames) {
            Intrinsics.checkNotNullParameter(restoredStackFrames, (String)"restoredStackFrames");
            Intrinsics.checkNotNullParameter(creationStackFrames, (String)"creationStackFrames");
            return new CoroutineStackFrames(restoredStackFrames, creationStackFrames);
        }

        public static /* synthetic */ CoroutineStackFrames copy$default(CoroutineStackFrames coroutineStackFrames, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = coroutineStackFrames.restoredStackFrames;
            }
            if ((n & 2) != 0) {
                list3 = coroutineStackFrames.creationStackFrames;
            }
            return coroutineStackFrames.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "CoroutineStackFrames(restoredStackFrames=" + this.restoredStackFrames + ", creationStackFrames=" + this.creationStackFrames + ")";
        }

        public int hashCode() {
            List<SuspendCoroutineStackFrameItem> list2 = this.restoredStackFrames;
            List<CreationCoroutineStackFrameItem> list3 = this.creationStackFrames;
            return (list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CoroutineStackFrames)) break block3;
                    CoroutineStackFrames coroutineStackFrames = (CoroutineStackFrames)object;
                    if (!Intrinsics.areEqual(this.restoredStackFrames, coroutineStackFrames.restoredStackFrames) || !Intrinsics.areEqual(this.creationStackFrames, coroutineStackFrames.creationStackFrames)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

