/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIcon;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIconKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer;", "", "()V", "settings", "Lcom/intellij/debugger/settings/ThreadsViewSettings;", "render", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "location", "Lcom/sun/jdi/Location;", "infoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "renderCreationNode", "renderErrorNode", "error", "", "renderGroup", "groupName", "renderInfoNode", "text", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class SimpleColoredTextIconPresentationRenderer {
    private final ThreadsViewSettings settings;
    @NotNull
    private static final ReadOnlyProperty log$delegate;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final SimpleColoredTextIcon render(@NotNull CoroutineInfoData infoData) {
        Intrinsics.checkNotNullParameter((Object)infoData, (String)"infoData");
        ThreadReference thread = infoData.getActiveThread();
        Object object = thread;
        if (object == null || (object = object.name()) == null || (object = StringsKt.substringBefore$default((String)object, (String)(" @" + infoData.getDescriptor().getName()), null, (int)2, null)) == null) {
            object = "";
        }
        Object name2 = object;
        String threadState = thread != null ? DebuggerUtilsEx.getThreadStatusText((int)thread.status()) : "";
        Icon icon2 = SimpleColoredTextIconKt.fromState(infoData.getDescriptor().getState());
        SimpleColoredTextIcon label2 = new SimpleColoredTextIcon(icon2, !infoData.isCreated());
        label2.append$kotlin_jvm_debugger_coroutines("\"");
        label2.appendValue$kotlin_jvm_debugger_coroutines(infoData.getDescriptor().formatName());
        label2.append$kotlin_jvm_debugger_coroutines("\": " + (Object)((Object)infoData.getDescriptor().getState()));
        CharSequence charSequence = (CharSequence)name2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            label2.append$kotlin_jvm_debugger_coroutines(" on thread \"");
            label2.appendValue$kotlin_jvm_debugger_coroutines((String)name2);
            label2.append$kotlin_jvm_debugger_coroutines("\": " + threadState);
        }
        return label2;
    }

    @NotNull
    public final SimpleColoredTextIcon render(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        SimpleColoredTextIcon label2 = new SimpleColoredTextIcon(null, false);
        DebuggerUIUtil.getColorScheme(null);
        if (location2.method() != null) {
            String methodDisplay;
            String myName = location2.method().name();
            String string = methodDisplay = this.settings.SHOW_ARGUMENTS_TYPES ? DebuggerUtilsEx.methodNameWithArguments((Method)location2.method()) : myName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodDisplay");
            label2.appendValue$kotlin_jvm_debugger_coroutines(string);
        }
        if (this.settings.SHOW_LINE_NUMBER) {
            label2.append$kotlin_jvm_debugger_coroutines(":");
            label2.append$kotlin_jvm_debugger_coroutines("" + DebuggerUtilsEx.getLineNumber((Location)location2, (boolean)false));
        }
        if (this.settings.SHOW_CLASS_NAME) {
            Object refType;
            try {
                ReferenceType referenceType = location2.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
                refType = referenceType;
                refType = refType.name();
            }
            catch (InternalError e) {
                refType = e.toString();
            }
            String name2 = refType;
            if (name2 != null) {
                label2.append$kotlin_jvm_debugger_coroutines(", ");
                int dotIndex = StringsKt.lastIndexOf$default((CharSequence)name2, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dotIndex < 0) {
                    label2.append$kotlin_jvm_debugger_coroutines(name2);
                } else {
                    String string = name2;
                    int n = dotIndex + 1;
                    boolean bl = false;
                    String string2 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    label2.append$kotlin_jvm_debugger_coroutines(string2);
                    if (this.settings.SHOW_PACKAGE_NAME) {
                        StringBuilder stringBuilder = new StringBuilder().append(" (");
                        string = name2;
                        n = 0;
                        bl = false;
                        String string3 = string.substring(n, dotIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        label2.append$kotlin_jvm_debugger_coroutines(stringBuilder.append(string3).append(')').toString());
                    }
                }
            }
        }
        if (this.settings.SHOW_SOURCE_NAME) {
            String sourceName2;
            label2.append$kotlin_jvm_debugger_coroutines(", ");
            String string = sourceName2 = DebuggerUtilsEx.getSourceName((Location)location2, (Function)new Function(location2){
                final /* synthetic */ Location $location;

                public final String apply(@Nullable Throwable e) {
                    SimpleColoredTextIconPresentationRenderer.Companion.getLog().error("Error while trying to resolve sourceName for location", e, new String[]{this.$location.toString()});
                    return "Unknown Source";
                }
                {
                    this.$location = location2;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceName");
            label2.append$kotlin_jvm_debugger_coroutines(string);
        }
        return label2;
    }

    @NotNull
    public final SimpleColoredTextIcon renderCreationNode() {
        return new SimpleColoredTextIcon(null, true, KotlinDebuggerCoroutinesBundle.message("coroutine.dump.creation.trace", new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderErrorNode(@NotNull String error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        return new SimpleColoredTextIcon(AllIcons.Actions.Lightning, false, KotlinDebuggerCoroutinesBundle.message(error2, new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderInfoNode(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return new SimpleColoredTextIcon(AllIcons.General.Information, false, KotlinDebuggerCoroutinesBundle.message(text2, new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderGroup(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return new SimpleColoredTextIcon(AllIcons.Debugger.ThreadGroup, true, groupName);
    }

    public SimpleColoredTextIconPresentationRenderer() {
        ThreadsViewSettings threadsViewSettings = ThreadsViewSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)threadsViewSettings, (String)"ThreadsViewSettings.getInstance()");
        this.settings = threadsViewSettings;
    }

    static {
        Companion = new Companion(null);
        log$delegate = ProvidersKt.getLogger();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)Companion, $$delegatedProperties[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

