/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stackFrame;

import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.jdi.LocalVariableImpl;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.InlineStackFrameVariableHolder;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stackFrame.AbstractInlineFunctionInfo;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineFunctionInfo;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineStackFrameInfo;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineStackFrameProxyKt;
import org.jetbrains.kotlin.idea.debugger.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.stackFrame.KotlinStackFrameWithProvidedVariables;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\f0\u0004H\u0002J(\u0010\u0011\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\f0\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000e*\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0004*\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u0004*\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0004*\u0004\u0018\u00010\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stackFrame/InlineStackTraceCalculator;", "", "()V", "calculateInlineStackTrace", "", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "createInlineStackFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/KotlinStackFrame;", "inlineStackFramesInfo", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/InlineStackFrameInfo;", "frameProxyLocation", "Lcom/sun/jdi/Location;", "fetchDepths", "", "fetchLocationsAndGetNewFrameProxyLocation", "allLocations", "originalLocation", "getInlineFunctionCallLocation", "", "inlineFunctionInfo", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/AbstractInlineFunctionInfo;", "getInlineFunctionInfos", "Lcom/sun/jdi/Method;", "getInlineStackFramesInfo", "location", "getVisibleVariables", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder;", "kotlin.jvm-debugger.core"})
public final class InlineStackTraceCalculator {
    @NotNull
    public static final InlineStackTraceCalculator INSTANCE;

    @NotNull
    public final List<XStackFrame> calculateInlineStackTrace(@NotNull StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
        if (location2 == null) {
            return CollectionsKt.emptyList();
        }
        Location location3 = location2;
        Method method = SafeUtilKt.safeMethod(location3);
        if (method == null) {
            return CollectionsKt.emptyList();
        }
        Method method2 = method;
        List<InlineStackFrameInfo> inlineStackFramesInfo = this.getInlineStackFramesInfo(method2, location3);
        if (inlineStackFramesInfo.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<Location> allLocations = SafeUtilKt.safeAllLineLocations(method2);
        if (allLocations.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        this.fetchDepths(inlineStackFramesInfo);
        Location newFrameProxyLocation = this.fetchLocationsAndGetNewFrameProxyLocation(inlineStackFramesInfo, allLocations, location3);
        return this.createInlineStackFrames(inlineStackFramesInfo, frameProxy, newFrameProxyLocation);
    }

    private final List<KotlinStackFrame> createInlineStackFrames(List<InlineStackFrameInfo> inlineStackFramesInfo, StackFrameProxyImpl frameProxy, Location frameProxyLocation) {
        boolean bl = false;
        List stackFrames2 = new ArrayList();
        InlineStackFrameVariableHolder variableHolder = InlineStackFrameVariableHolder.Companion.fromStackFrame(frameProxy);
        for (InlineStackFrameInfo info2 : CollectionsKt.asReversed(inlineStackFramesInfo)) {
            stackFrames2.add(info2.toInlineStackFrame(frameProxy, this.getVisibleVariables(variableHolder)));
            InlineStackFrameVariableHolder inlineStackFrameVariableHolder = variableHolder;
            variableHolder = inlineStackFrameVariableHolder != null ? inlineStackFrameVariableHolder.getParentFrame() : null;
        }
        KotlinStackFrameWithProvidedVariables originalFrame = new KotlinStackFrameWithProvidedVariables(InlineStackFrameProxyKt.safeInlineStackFrameProxy(frameProxyLocation, 0, frameProxy), this.getVisibleVariables(variableHolder));
        stackFrames2.add(originalFrame);
        return stackFrames2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineStackFrameInfo> getInlineStackFramesInfo(Method $this$getInlineStackFramesInfo, Location location2) {
        void $this$mapTo$iv$iv;
        AbstractInlineFunctionInfo it;
        void $this$filterTo$iv$iv222;
        Iterable $this$filter$iv = this.getInlineFunctionInfos($this$getInlineStackFramesInfo);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv222) {
            it = (AbstractInlineFunctionInfo)element$iv$iv;
            boolean bl = false;
            if (!it.contains(location2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean $this$filterTo$iv$iv222 = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                AbstractInlineFunctionInfo it = (AbstractInlineFunctionInfo)a;
                boolean bl2 = false;
                Comparable comparable = (Location)it.getBorders().getStart();
                it = (AbstractInlineFunctionInfo)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Location location2 = (Location)it.getBorders().getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)location2);
            }
        });
        boolean $i$f$map = false;
        Iterable $this$filterTo$iv$iv222 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AbstractInlineFunctionInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            InlineStackFrameInfo inlineStackFrameInfo = new InlineStackFrameInfo(it, location2, 0);
            collection.add(inlineStackFrameInfo);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbstractInlineFunctionInfo> getInlineFunctionInfos(Method $this$getInlineFunctionInfos) {
        Collection destination$iv$iv;
        boolean $i$f$filterIsInstance;
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$getInlineFunctionInfos);
        if (list2 != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = list2;
            $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LocalVariableImpl)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return CollectionsKt.emptyList();
        }
        List localVariables = (List)destination$iv$iv;
        $i$f$filterIsInstance = false;
        List inlineFunctionInfos = new ArrayList();
        for (LocalVariableImpl variable2 : localVariables) {
            String variableName = variable2.name();
            ClosedRange borders = RangesKt.rangeTo((Comparable)variable2.getScopeStart(), (Comparable)variable2.getScopeEnd());
            String string = variableName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableName");
            if (StringsKt.startsWith$default((String)string, (String)"$i$f$", (boolean)false, (int)2, null)) {
                inlineFunctionInfos.add(new InlineFunctionInfo(variableName, (ClosedRange<Location>)borders));
                continue;
            }
            if (!StringsKt.startsWith$default((String)variableName, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            inlineFunctionInfos.add(new InlineLambdaInfo(variableName, (ClosedRange<Location>)borders));
        }
        return inlineFunctionInfos;
    }

    /*
     * Unable to fully structure code
     */
    private final void fetchDepths(List<InlineStackFrameInfo> $this$fetchDepths) {
        currentDepth = 0;
        var4_3 = false;
        depths = new LinkedHashMap<K, V>();
        for (InlineStackFrameInfo inlineStackFrameInfo : $this$fetchDepths) {
            block4: {
                block3: {
                    inlineFunctionInfo = inlineStackFrameInfo.getInlineFunctionInfo();
                    if (!(inlineFunctionInfo instanceof InlineLambdaInfo)) break block3;
                    v0 = ((InlineLambdaInfo)inlineFunctionInfo).getDeclarationFunctionName();
                    if (v0 == null) ** GOTO lbl-1000
                    var8_9 = v0;
                    var9_10 = false;
                    var10_11 = false;
                    it = var8_9;
                    $i$a$-let-InlineStackTraceCalculator$fetchDepths$calculatedDepth$1 = false;
                    v0 = (Integer)depths.get(it);
                    if (v0 != null) {
                        v1 = v0.intValue();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = 0;
                    }
                    break block4;
                }
                v1 = currentDepth + 1;
            }
            calculatedDepth = v1;
            depths.put(inlineFunctionInfo.getName(), calculatedDepth);
            inlineStackFrameInfo.setDepth(calculatedDepth);
            currentDepth = calculatedDepth;
        }
    }

    private final Location fetchLocationsAndGetNewFrameProxyLocation(List<InlineStackFrameInfo> $this$fetchLocationsAndGetNewFrameProxyLocation, List<? extends Location> allLocations, Location originalLocation) {
        Iterator<? extends Location> iterator = allLocations.iterator();
        Location location2 = this.getInlineFunctionCallLocation(iterator, ((InlineStackFrameInfo)CollectionsKt.first($this$fetchLocationsAndGetNewFrameProxyLocation)).getInlineFunctionInfo());
        if (location2 == null) {
            location2 = originalLocation;
        }
        Location newFrameProxyLocation = location2;
        int inlineStackFrameIndex = 1;
        Location prevLocation = originalLocation;
        Iterator<? extends Location> iterator2 = iterator;
        boolean bl = false;
        Iterator<? extends Location> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Location location3 = iterator3.next();
            if (inlineStackFrameIndex > CollectionsKt.getLastIndex($this$fetchLocationsAndGetNewFrameProxyLocation)) break;
            if ($this$fetchLocationsAndGetNewFrameProxyLocation.get(inlineStackFrameIndex).getInlineFunctionInfo().contains(location3)) {
                $this$fetchLocationsAndGetNewFrameProxyLocation.get(inlineStackFrameIndex - 1).setLocation(prevLocation);
                ++inlineStackFrameIndex;
            }
            prevLocation = location3;
        }
        ((InlineStackFrameInfo)CollectionsKt.last($this$fetchLocationsAndGetNewFrameProxyLocation)).setLocation(originalLocation);
        return newFrameProxyLocation;
    }

    private final Location getInlineFunctionCallLocation(Iterator<? extends Location> $this$getInlineFunctionCallLocation, AbstractInlineFunctionInfo inlineFunctionInfo) {
        Location prevLocation = null;
        Iterator<? extends Location> iterator = $this$getInlineFunctionCallLocation;
        boolean bl = false;
        Iterator<? extends Location> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Location location2 = iterator2.next();
            if (inlineFunctionInfo.contains(location2)) {
                return prevLocation;
            }
            prevLocation = location2;
        }
        return null;
    }

    private final List<LocalVariableProxyImpl> getVisibleVariables(InlineStackFrameVariableHolder $this$getVisibleVariables) {
        InlineStackFrameVariableHolder inlineStackFrameVariableHolder = $this$getVisibleVariables;
        List list2 = inlineStackFrameVariableHolder != null ? inlineStackFrameVariableHolder.getVisibleVariables() : null;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    private InlineStackTraceCalculator() {
    }

    static {
        InlineStackTraceCalculator inlineStackTraceCalculator;
        INSTANCE = inlineStackTraceCalculator = new InlineStackTraceCalculator();
    }
}

