/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import com.sun.jdi.VMDisconnectedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinRequestHint;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepIntoRequestHint;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinRequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "parentHint", "Lcom/intellij/debugger/engine/RequestHint;", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;Lcom/intellij/debugger/engine/MethodFilter;Lcom/intellij/debugger/engine/RequestHint;)V", "lastWasKotlinFakeLineNumber", "", "getLastWasKotlinFakeLineNumber", "()Z", "setLastWasKotlinFakeLineNumber", "(Z)V", "getNextStepDepth", "", "context", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinStepIntoRequestHint
extends KotlinRequestHint {
    private boolean lastWasKotlinFakeLineNumber;
    @Deprecated
    private static final Logger LOG;
    @NotNull
    private static final Companion Companion;

    public final boolean getLastWasKotlinFakeLineNumber() {
        return this.lastWasKotlinFakeLineNumber;
    }

    public final void setLastWasKotlinFakeLineNumber(boolean bl) {
        this.lastWasKotlinFakeLineNumber = bl;
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        try {
            StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                return 0;
            }
            Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"context.frameProxy ?: return STOP");
            StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
            Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
            if (location2 != null && DebuggerUtils.INSTANCE.isKotlinFakeLineNumber(location2)) {
                this.lastWasKotlinFakeLineNumber = true;
                return 1;
            }
            if (this.lastWasKotlinFakeLineNumber) {
                this.lastWasKotlinFakeLineNumber = false;
                return 0;
            }
            return super.getNextStepDepth(context2);
        }
        catch (VMDisconnectedException frameProxy) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }

    public KotlinStepIntoRequestHint(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, @Nullable MethodFilter filter2, @Nullable RequestHint parentHint) {
        Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        super(stepThread, suspendContext, -2, 1, filter2, parentHint);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinStepIntoRequestHint.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026oRequestHint::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepIntoRequestHint$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

