/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.common;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.common.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.idea.decompiler.common.FileWithMetadata;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoader;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\n\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/common/KotlinMetadataStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "version", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "readFile", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata;", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "getStubVersion", "kotlin.core"})
public class KotlinMetadataStubBuilder
extends ClsStubBuilder {
    private final int version;
    private final FileType fileType;
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    private final Function2<VirtualFile, byte[], FileWithMetadata> readFile;

    public int getStubVersion() {
        return 26 + this.version;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        FileWithMetadata file2;
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        VirtualFile virtualFile2 = content2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"content.file");
        VirtualFile virtualFile3 = virtualFile2;
        boolean bl = Intrinsics.areEqual((Object)virtualFile3.getFileType(), (Object)this.fileType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinMetadataStubBuilder$buildFileStub$22 = false;
            String $i$a$-assert-KotlinMetadataStubBuilder$buildFileStub$22 = "Unexpected file type " + virtualFile3.getFileType();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-KotlinMetadataStubBuilder$buildFileStub$22));
        }
        byte[] byArray = content2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"content.content");
        FileWithMetadata fileWithMetadata = (FileWithMetadata)this.readFile.invoke((Object)virtualFile3, (Object)byArray);
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata fileWithMetadata2 = file2 = fileWithMetadata;
        if (fileWithMetadata2 instanceof FileWithMetadata.Incompatible) {
            return (PsiFileStub)ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        if (fileWithMetadata2 instanceof FileWithMetadata.Compatible) {
            ProtoBuf.Package packageProto = ((FileWithMetadata.Compatible)file2).getProto().getPackage();
            FqName packageFqName = ((FileWithMetadata.Compatible)file2).getPackageFqName();
            NameResolverImpl nameResolver = ((FileWithMetadata.Compatible)file2).getNameResolver();
            ClsStubBuilderComponents components = new ClsStubBuilderComponents((ClassDataFinder)new ProtoBasedClassDataFinder(((FileWithMetadata.Compatible)file2).getProto(), (NameResolver)nameResolver, ((FileWithMetadata.Compatible)file2).getVersion(), null, 8, null), (AnnotationAndConstantLoader<ClassId, Unit>)((AnnotationAndConstantLoader)new AnnotationLoaderForStubBuilderImpl((SerializerExtensionProtocol)this.serializerProtocol.invoke())), virtualFile3);
            NameResolver nameResolver2 = (NameResolver)nameResolver;
            ProtoBuf.Package package_ = packageProto;
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"packageProto");
            ProtoBuf.TypeTable typeTable = package_.getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"packageProto.typeTable");
            ClsStubBuilderContext context2 = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
            CallableClsStubBuilderKt.createPackageDeclarationsStubs((StubElement<? extends PsiElement>)((StubElement)fileStub), context2, new ProtoContainer.Package(packageFqName, context2.getNameResolver(), context2.getTypeTable(), null), packageProto);
            for (ProtoBuf.Class classProto : ((FileWithMetadata.Compatible)file2).getClassesToDecompile()) {
                ClassClsStubBuilderKt.createClassStub((StubElement<? extends PsiElement>)((StubElement)fileStub), classProto, (NameResolver)nameResolver, NameResolverUtilKt.getClassId((NameResolver)((NameResolver)nameResolver), (int)classProto.getFqName()), null, context2);
            }
            return (PsiFileStub)fileStub;
        }
        throw new NoWhenBranchMatchedException();
    }

    public KotlinMetadataStubBuilder(int version2, @NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull Function2<? super VirtualFile, ? super byte[], ? extends FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkNotNullParameter(readFile, (String)"readFile");
        this.version = version2;
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.readFile = readFile;
    }
}

