/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinDoWhileFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class KotlinDoWhileFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor2, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement2) {
        block5: {
            PsiElement lParen;
            block7: {
                PsiElement rParen;
                PsiElement whileKeyword;
                Document doc;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)((Object)processor2), (String)"processor");
                    Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
                    if (!(psiElement2 instanceof KtDoWhileExpression)) {
                        return;
                    }
                    Document document = editor2.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                    doc = document;
                    int start2 = FixersUtilKt.getStart(FixersUtilKt.getRange(psiElement2));
                    KtExpression body2 = ((KtDoWhileExpression)psiElement2).getBody();
                    whileKeyword = ((KtDoWhileExpression)psiElement2).getWhileKeyword();
                    if (body2 == null) {
                        if (whileKeyword == null) {
                            doc.replaceString(start2, start2 + "do".length(), (CharSequence)"do {} while()");
                        } else {
                            doc.insertString(start2 + "do".length(), (CharSequence)"{}");
                        }
                        return;
                    }
                    if (whileKeyword != null && !(body2 instanceof KtBlockExpression) && FixersUtilKt.startLine((PsiElement)body2, doc) > FixersUtilKt.startLine(psiElement2, doc)) {
                        doc.insertString(FixersUtilKt.getStart(FixersUtilKt.getRange(whileKeyword)), (CharSequence)"}");
                        doc.insertString(start2 + "do".length(), (CharSequence)"{");
                        return;
                    }
                    if (((KtDoWhileExpression)psiElement2).getCondition() != null) break block5;
                    lParen = ((KtDoWhileExpression)psiElement2).getLeftParenthesis();
                    rParen = ((KtDoWhileExpression)psiElement2).getRightParenthesis();
                    if (whileKeyword != null) break block6;
                    doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(psiElement2)), (CharSequence)"while()");
                    break block5;
                }
                if (lParen != null || rParen != null) break block7;
                doc.replaceString(FixersUtilKt.getStart(FixersUtilKt.getRange(whileKeyword)), FixersUtilKt.getEnd(FixersUtilKt.getRange(whileKeyword)), (CharSequence)"while()");
                break block5;
            }
            if (lParen == null) break block5;
            processor2.registerUnresolvedError(FixersUtilKt.getEnd(FixersUtilKt.getRange(lParen)));
        }
    }
}

