/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.scripting.GradleImportHelperKt;
import org.jetbrains.kotlin.idea.gradleJava.scripting.UtilsKt;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleScriptInfo;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/LoadConfigurationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "ensureValidActionVisibility", "getKotlinScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getNotificationVisibility", "", "update", "kotlin.gradle.gradle-java"})
public final class LoadConfigurationAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
        Editor editor3 = editor2;
        VirtualFile virtualFile2 = this.getKotlinScriptFile(editor3);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        Object object = GradleBuildRootsManager.Companion.getInstance(project3);
        if (object == null || (object = ((GradleBuildRootsLocator)object).getScriptInfo(file2)) == null || (object = ((GradleScriptInfo)object).getBuildRoot()) == null) {
            return;
        }
        Object root = object;
        GradleImportHelperKt.runPartialGradleImport(project3, (GradleBuildRoot)root);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ensureValidActionVisibility(e);
    }

    private final void ensureValidActionVisibility(AnActionEvent e) {
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
        Editor editor3 = editor2;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setVisible(this.getNotificationVisibility(editor3));
    }

    private final boolean getNotificationVisibility(Editor editor2) {
        if (!GradleImportHelperKt.getScriptConfigurationsNeedToBeUpdatedBalloon()) {
            return false;
        }
        if (DiffUtil.isDiffEditor((Editor)editor2)) {
            return false;
        }
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"editor.project ?: return false");
        Project project3 = project2;
        if (ScriptDefinitionProvider.Companion.getServiceIfCreated(project3) == null) {
            return false;
        }
        VirtualFile virtualFile2 = this.getKotlinScriptFile(editor2);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile file2 = virtualFile2;
        if (GradleImportHelperKt.autoReloadScriptConfigurations(project3, file2)) {
            return false;
        }
        GradleBuildRootsManager gradleBuildRootsManager = GradleBuildRootsManager.Companion.getInstance(project3);
        return gradleBuildRootsManager != null ? gradleBuildRootsManager.isConfigurationOutOfDate(file2) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile getKotlinScriptFile(Editor editor2) {
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (virtualFile2 == null) return null;
        VirtualFile virtualFile3 = virtualFile2;
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile it = virtualFile3;
        boolean bl3 = false;
        if (it instanceof LightVirtualFileBase) return null;
        VirtualFile virtualFile4 = it;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
        if (!virtualFile4.isValid()) return null;
        if (!Intrinsics.areEqual((Object)it.getFileType(), (Object)KotlinFileType.INSTANCE)) return null;
        if (!UtilsKt.isGradleKotlinScript(it)) return null;
        boolean bl4 = true;
        if (!bl4) return null;
        VirtualFile virtualFile5 = virtualFile3;
        return virtualFile5;
    }

    public LoadConfigurationAction() {
        super(KotlinIdeaGradleBundle.message("action.text.load.script.configurations", new Object[0]), KotlinIdeaGradleBundle.message("action.description.load.script.configurations", new Object[0]), KotlinIcons.LOAD_SCRIPT_CONFIGURATION);
    }
}

