/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingSuspender;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingSuspendNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "kotlin.core"})
public final class KotlinHighlightingSuspendNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Project project;
    private static final Key<EditorNotificationPanel> KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        if (Intrinsics.areEqual((Object)file2.getFileType(), (Object)KotlinFileType.INSTANCE) ^ true) {
            return null;
        }
        if (!KotlinHighlightingSuspender.Companion.getInstance(this.project).isSuspended(file2)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
        Object[] objectArray = new Object[1];
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        objectArray[0] = string;
        panel2.setText(KotlinIdeaAnalysisBundle.message("highlighting.for.0.is.suspended", objectArray));
        return panel2;
    }

    public KotlinHighlightingSuspendNotificationProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"KotlinHighlightingSuspend");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<EditorNotific\u2026tlinHighlightingSuspend\")");
        KEY = key;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingSuspendNotificationProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "kotlin.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

