/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor$WhenMappings;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "attributeKeyForObjectAccess", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "calculateClassReferenceAttributes", "target", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "calculateDeclarationReferenceAttributes", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "calculateTypeAliasReferenceAttributes", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "computeHighlightingRangeForUsage", "Lcom/intellij/openapi/util/TextRange;", "referenceTarget", "computeReferencedDescriptor", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitDynamicType", "type", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "visitSimpleNameExpression", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "kotlin.core"})
public final class TypeKindHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtSuperExpression || parent2 instanceof KtThisExpression) {
            return;
        }
        if (!NameHighlighter.INSTANCE.getNamesHighlightingEnabled()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = this.computeReferencedDescriptor(expression2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor referenceTarget = declarationDescriptor;
        TextAttributesKey textAttributesKey = this.attributeKeyForObjectAccess(expression2);
        if (textAttributesKey == null) {
            textAttributesKey = this.calculateDeclarationReferenceAttributes(referenceTarget);
        }
        if (textAttributesKey == null) {
            return;
        }
        TextAttributesKey key = textAttributesKey;
        AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, this.computeHighlightingRangeForUsage(expression2, referenceTarget), key, null, 4, null);
    }

    private final TextAttributesKey attributeKeyForObjectAccess(KtSimpleNameExpression expression2) {
        ResolvedCall resolvedCall2;
        ResolvedCall resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)this.getBindingContext());
        return (resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null) instanceof FakeCallableDescriptorForObject ? this.attributeKeyForCallFromExtensions(expression2, (ResolvedCall<? extends CallableDescriptor>)resolvedCall2) : null;
    }

    private final DeclarationDescriptor computeReferencedDescriptor(KtSimpleNameExpression expression2) {
        NavigatablePsiElement callElement2;
        NavigatablePsiElement navigatablePsiElement;
        boolean strict$iv;
        PsiElement $this$getParentOfTypeAndBranch$iv;
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression2);
        if (!(referenceTarget instanceof ConstructorDescriptor)) {
            return referenceTarget;
        }
        PsiElement psiElement2 = (PsiElement)expression2;
        boolean bl = true;
        Function1 branch$iv = computeReferencedDescriptor.callElement.1.INSTANCE;
        boolean $i$f$getParentOfTypeAndBranch = false;
        PsiElement $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallExpression.class, (boolean)strict$iv);
        KtCallExpression ktCallExpression = (KtCallExpression)(psiElement3 == null ? null : PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement3, (PsiElement)$this$getParentOfTypeAndBranch$iv, (Function1)branch$iv));
        if (ktCallExpression != null) {
            navigatablePsiElement = (NavigatablePsiElement)ktCallExpression;
        } else {
            $this$getParentOfTypeAndBranch$iv = (PsiElement)expression2;
            strict$iv = true;
            branch$iv = computeReferencedDescriptor.callElement.2.INSTANCE;
            $i$f$getParentOfTypeAndBranch = false;
            $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
            $i$f$getParentOfType = false;
            psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtSuperTypeCallEntry.class, (boolean)strict$iv);
            navigatablePsiElement = callElement2 = (NavigatablePsiElement)(psiElement3 == null ? null : PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement3, (PsiElement)$this$getParentOfTypeAndBranch$iv, (Function1)branch$iv));
        }
        if (callElement2 != null) {
            return referenceTarget;
        }
        return (DeclarationDescriptor)((ConstructorDescriptor)referenceTarget).getContainingDeclaration();
    }

    private final TextRange computeHighlightingRangeForUsage(KtSimpleNameExpression expression2, DeclarationDescriptor referenceTarget) {
        TextRange expressionRange2 = expression2.getTextRange();
        if (!(referenceTarget instanceof ClassDescriptor) || ((ClassDescriptor)referenceTarget).getKind() != ClassKind.ANNOTATION_CLASS) {
            TextRange textRange = expressionRange2;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expressionRange");
            return textRange;
        }
        KtAnnotationEntry annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), KtAnnotationEntry.class, (boolean)false, (Class[])new Class[]{KtValueArgumentList.class});
        KtAnnotationEntry ktAnnotationEntry = annotationEntry2;
        if (ktAnnotationEntry == null || (ktAnnotationEntry = ktAnnotationEntry.getAtSymbol()) == null) {
            TextRange textRange = expressionRange2;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expressionRange");
            return textRange;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"annotationEntry?.atSymbo\u2026?: return expressionRange");
        KtAnnotationEntry atSymbol = ktAnnotationEntry;
        TextRange textRange = atSymbol.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"atSymbol.textRange");
        int n = textRange.getStartOffset();
        TextRange textRange2 = expression2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"expression.textRange");
        return new TextRange(n, textRange2.getEndOffset());
    }

    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        PsiElement identifier2 = classOrObject.getNameIdentifier();
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.CLASS, (Object)classOrObject);
        if (identifier2 != null && classDescriptor != null) {
            TextAttributesKey textAttributesKey = this.attributeKeyForDeclarationFromExtensions((PsiElement)classOrObject, (DeclarationDescriptor)classDescriptor);
            if (textAttributesKey == null) {
                textAttributesKey = this.calculateClassReferenceAttributes(classDescriptor);
            }
            AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, identifier2, textAttributesKey, null, 4, null);
        }
        super.visitClassOrObject(classOrObject);
    }

    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias2) {
        Intrinsics.checkNotNullParameter((Object)typeAlias2, (String)"typeAlias");
        PsiElement identifier2 = typeAlias2.getNameIdentifier();
        TypeAliasDescriptor descriptor2 = (TypeAliasDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.TYPE_ALIAS, (Object)typeAlias2);
        if (identifier2 != null && descriptor2 != null) {
            TextAttributesKey textAttributesKey = this.attributeKeyForDeclarationFromExtensions(identifier2, (DeclarationDescriptor)descriptor2);
            if (textAttributesKey == null) {
                textAttributesKey = this.calculateTypeAliasReferenceAttributes(descriptor2);
            }
            TextAttributesKey key = textAttributesKey;
            AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, identifier2, key, null, 4, null);
        }
        super.visitTypeAlias(typeAlias2);
    }

    public void visitDynamicType(@NotNull KtDynamicType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
    }

    private final TextAttributesKey calculateClassReferenceAttributes(ClassDescriptor target2) {
        TextAttributesKey textAttributesKey;
        switch (TypeKindHighlightingVisitor$WhenMappings.$EnumSwitchMapping$0[target2.getKind().ordinal()]) {
            case 1: {
                TextAttributesKey textAttributesKey2 = KotlinHighlightingColors.ANNOTATION;
                textAttributesKey = textAttributesKey2;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"ANNOTATION");
                break;
            }
            case 2: {
                TextAttributesKey textAttributesKey3 = KotlinHighlightingColors.TRAIT;
                textAttributesKey = textAttributesKey3;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"TRAIT");
                break;
            }
            case 3: {
                TextAttributesKey textAttributesKey4 = KotlinHighlightingColors.OBJECT;
                textAttributesKey = textAttributesKey4;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"OBJECT");
                break;
            }
            case 4: {
                TextAttributesKey textAttributesKey5 = KotlinHighlightingColors.ENUM;
                textAttributesKey = textAttributesKey5;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey5, (String)"ENUM");
                break;
            }
            case 5: {
                TextAttributesKey textAttributesKey6 = KotlinHighlightingColors.ENUM_ENTRY;
                textAttributesKey = textAttributesKey6;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey6, (String)"ENUM_ENTRY");
                break;
            }
            default: {
                TextAttributesKey textAttributesKey7 = target2.getModality() == Modality.ABSTRACT ? KotlinHighlightingColors.ABSTRACT_CLASS : KotlinHighlightingColors.CLASS;
                textAttributesKey = textAttributesKey7;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey7, (String)"if (target.modality === \u2026ABSTRACT_CLASS else CLASS");
            }
        }
        return textAttributesKey;
    }

    private final TextAttributesKey calculateTypeAliasReferenceAttributes(TypeAliasDescriptor target2) {
        TextAttributesKey textAttributesKey;
        ClassifierDescriptor aliasedTarget = target2.getExpandedType().getConstructor().getDeclarationDescriptor();
        if (aliasedTarget instanceof ClassDescriptor && ((ClassDescriptor)aliasedTarget).getKind() == ClassKind.ANNOTATION_CLASS) {
            TextAttributesKey textAttributesKey2 = KotlinHighlightingColors.ANNOTATION;
            textAttributesKey = textAttributesKey2;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"ANNOTATION");
        } else {
            TextAttributesKey textAttributesKey3 = KotlinHighlightingColors.TYPE_ALIAS;
            textAttributesKey = textAttributesKey3;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"TYPE_ALIAS");
        }
        return textAttributesKey;
    }

    private final TextAttributesKey calculateDeclarationReferenceAttributes(DeclarationDescriptor target2) {
        DeclarationDescriptor declarationDescriptor = target2;
        return declarationDescriptor instanceof TypeParameterDescriptor ? KotlinHighlightingColors.TYPE_PARAMETER : (declarationDescriptor instanceof TypeAliasDescriptor ? this.calculateTypeAliasReferenceAttributes((TypeAliasDescriptor)target2) : (declarationDescriptor instanceof ClassDescriptor ? this.calculateClassReferenceAttributes((ClassDescriptor)target2) : null));
    }

    public TypeKindHighlightingVisitor(@NotNull HighlightInfoHolder holder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        super(holder, bindingContext2);
    }
}

