/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.ActualExpectedPsiElementCellRenderer;
import org.jetbrains.kotlin.idea.highlighter.markers.HasExpectedMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t*\u00020\u0007\u001a\f\u0010\n\u001a\u00020\u0005*\u00020\u0007H\u0007\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0007H\u0007\u00a8\u0006\f"}, d2={"buildNavigateToExpectedDeclarationsPopup", "Lorg/jetbrains/kotlin/idea/highlighter/markers/NavigationPopupDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "getExpectedDeclarationTooltip", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "allNavigatableExpectedDeclarations", "", "navigateToExpectedTitle", "navigateToExpectedUsagesTitle", "kotlin.idea"})
public final class HasExpectedMarkerKt {
    @Nullable
    public static final String getExpectedDeclarationTooltip(@NotNull KtDeclaration declaration2) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
            if (!(declarationDescriptor instanceof MemberDescriptor)) {
                declarationDescriptor = null;
            }
            MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
            if (memberDescriptor == null) {
                return null;
            }
            MemberDescriptor descriptor2 = memberDescriptor;
            KtFile ktFile = declaration2.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"declaration.containingKtFile");
            ModuleDescriptor platformModuleDescriptor = ResolutionUtils.findModuleDescriptor((KtElement)((KtElement)ktFile));
            List<ModuleDescriptor> commonModuleDescriptors = MultiplatformUtilKt.getImplementedDescriptors(platformModuleDescriptor);
            Iterable $this$any$iv = commonModuleDescriptors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ModuleDescriptor it = (ModuleDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!ExpectActualUtilKt.hasDeclarationOf(it, descriptor2)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (!bl) {
            return null;
        }
        return KotlinBundle.message("highlighter.tool.tip.has.declaration.in.common.module", new Object[0]);
    }

    @NotNull
    public static final List<KtDeclaration> allNavigatableExpectedDeclarations(@NotNull KtDeclaration $this$allNavigatableExpectedDeclarations) {
        Intrinsics.checkNotNullParameter((Object)$this$allNavigatableExpectedDeclarations, (String)"$this$allNavigatableExpectedDeclarations");
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)ExpectActualUtilKt.expectedDeclarationIfAny($this$allNavigatableExpectedDeclarations)), (Sequence)SequencesKt.mapNotNull(KotlinLineMarkerProviderKt.findMarkerBoundDeclarations($this$allNavigatableExpectedDeclarations), (Function1)allNavigatableExpectedDeclarations.1.INSTANCE));
    }

    @NlsContexts.PopupTitle
    @NotNull
    public static final String navigateToExpectedTitle(@NotNull KtDeclaration $this$navigateToExpectedTitle) {
        Intrinsics.checkNotNullParameter((Object)$this$navigateToExpectedTitle, (String)"$this$navigateToExpectedTitle");
        return KotlinBundle.message("highlighter.title.choose.expected.for", String.valueOf($this$navigateToExpectedTitle.getName()));
    }

    @NlsContexts.TabTitle
    @NotNull
    public static final String navigateToExpectedUsagesTitle(@NotNull KtDeclaration $this$navigateToExpectedUsagesTitle) {
        Intrinsics.checkNotNullParameter((Object)$this$navigateToExpectedUsagesTitle, (String)"$this$navigateToExpectedUsagesTitle");
        return KotlinBundle.message("highlighter.title.expected.for", String.valueOf($this$navigateToExpectedUsagesTitle.getName()));
    }

    @Nullable
    public static final NavigationPopupDescriptor buildNavigateToExpectedDeclarationsPopup(@Nullable PsiElement element3) {
        PsiElement psiElement2 = element3;
        if (psiElement2 != null && (psiElement2 = KotlinLineMarkerProviderKt.getMarkerDeclaration(psiElement2)) != null) {
            PsiElement psiElement3 = psiElement2;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement3;
            boolean bl3 = false;
            List<KtDeclaration> navigatableExpectedDeclarations = HasExpectedMarkerKt.allNavigatableExpectedDeclarations((KtDeclaration)it);
            if (navigatableExpectedDeclarations.isEmpty()) {
                return null;
            }
            return new NavigationPopupDescriptor(navigatableExpectedDeclarations, HasExpectedMarkerKt.navigateToExpectedTitle((KtDeclaration)it), HasExpectedMarkerKt.navigateToExpectedUsagesTitle((KtDeclaration)it), (ListCellRenderer)((Object)new ActualExpectedPsiElementCellRenderer()), null, 16, null);
        }
        return null;
    }
}

