/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspectionKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \t2\u00020\u0001:\u0004\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "ConstantConditionIfFix", "RemoveFix", "SimplifyFix", "kotlin.idea"})
public final class ConstantConditionIfInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.ifExpressionVisitor((Function1)((Function1)new Function1<KtIfExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtIfExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Boolean bl = org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspection$Companion.access$getConditionConstantValueIfAny(ConstantConditionIfInspection.Companion, expression2);
                if (bl == null) {
                    return;
                }
                boolean constantValue = bl;
                List fixes2 = org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspection$Companion.access$collectFixes(ConstantConditionIfInspection.Companion, expression2, constantValue);
                KtExpression ktExpression = expression2.getCondition();
                Intrinsics.checkNotNull((Object)ktExpression);
                Collection $this$toTypedArray$iv = fixes2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ConstantConditionIfFix[] constantConditionIfFixArray = thisCollection$iv.toArray(new ConstantConditionIfFix[0]);
                if (constantConditionIfFixArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                LocalQuickFix[] localQuickFixArray = constantConditionIfFixArray;
                this.$holder.registerProblem((PsiElement)ktExpression, KotlinBundle.message("condition.is.always.0", constantValue), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$ConstantConditionIfFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "applyFix", "", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "kotlin.idea"})
    private static interface ConstantConditionIfFix
    extends LocalQuickFix {
        public void applyFix(@NotNull KtIfExpression var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$SimplifyFix;", "Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$ConstantConditionIfFix;", "conditionValue", "", "isUsedAsExpression", "keepBraces", "(ZZZ)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class SimplifyFix
    implements ConstantConditionIfFix {
        private final boolean conditionValue;
        private final boolean isUsedAsExpression;
        private final boolean keepBraces;

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("simplify.fix.text", new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            void $this$getParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
            PsiElement psiElement3 = psiElement2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtIfExpression.class, (boolean)strict$iv);
            if (ktIfExpression == null) {
                return;
            }
            KtIfExpression ifExpression2 = ktIfExpression;
            this.applyFix(ifExpression2);
        }

        @Override
        public void applyFix(@NotNull KtIfExpression ifExpression2) {
            KtExpression ktExpression;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)ifExpression2, (String)"ifExpression");
                    ktExpression = ConstantConditionIfInspectionKt.access$branch(ifExpression2, this.conditionValue);
                    if (ktExpression == null) break block2;
                    KtExpression ktExpression2 = ktExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtExpression it = ktExpression2;
                    boolean bl3 = false;
                    ktExpression = this.keepBraces ? it : IfThenUtilsKt.unwrapBlockOrParenthesis(it);
                    if (ktExpression != null) break block3;
                }
                return;
            }
            KtExpression branch2 = ktExpression;
            ConstantConditionIfInspectionKt.replaceWithBranch((KtExpression)ifExpression2, branch2, this.isUsedAsExpression, this.keepBraces);
        }

        public SimplifyFix(boolean conditionValue, boolean isUsedAsExpression, boolean keepBraces) {
            this.conditionValue = conditionValue;
            this.isUsedAsExpression = isUsedAsExpression;
            this.keepBraces = keepBraces;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$RemoveFix;", "Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$ConstantConditionIfFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class RemoveFix
    implements ConstantConditionIfFix {
        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("remove.fix.text", new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            void $this$getParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
            PsiElement psiElement3 = psiElement2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtIfExpression.class, (boolean)strict$iv);
            if (ktIfExpression == null) {
                return;
            }
            KtIfExpression ifExpression2 = ktIfExpression;
            this.applyFix(ifExpression2);
        }

        @Override
        public void applyFix(@NotNull KtIfExpression ifExpression2) {
            PsiElement parent2;
            Intrinsics.checkNotNullParameter((Object)ifExpression2, (String)"ifExpression");
            PsiElement psiElement2 = parent2 = ifExpression2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
            ASTNode aSTNode = psiElement2.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"parent.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtNodeTypes.ELSE)) {
                KtIfExpression ktIfExpression;
                PsiElement psiElement3 = parent2.getParent();
                if (!(psiElement3 instanceof KtIfExpression)) {
                    psiElement3 = null;
                }
                if ((ktIfExpression = (KtIfExpression)psiElement3) != null && (ktIfExpression = ktIfExpression.getElseKeyword()) != null) {
                    ktIfExpression.delete();
                }
            }
            ifExpression2.delete();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J'\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$Companion;", "", "()V", "applyFixIfSingle", "", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "collectFixes", "", "Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$ConstantConditionIfFix;", "expression", "constantValue", "", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;Ljava/lang/Boolean;)Ljava/util/List;", "getConditionConstantValueIfAny", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)Ljava/lang/Boolean;", "kotlin.idea"})
    public static final class Companion {
        private final Boolean getConditionConstantValueIfAny(KtIfExpression $this$getConditionConstantValueIfAny) {
            KtExpression expr2 = $this$getConditionConstantValueIfAny.getCondition();
            while (expr2 instanceof KtParenthesizedExpression) {
                expr2 = ((KtParenthesizedExpression)expr2).getExpression();
            }
            if (!(expr2 instanceof KtConstantExpression)) {
                return null;
            }
            KtExpression ktExpression = $this$getConditionConstantValueIfAny.getCondition();
            if (ktExpression == null || (ktExpression = ResolutionUtils.analyze((KtElement)((KtElement)ktExpression), (BodyResolveMode)BodyResolveMode.PARTIAL_WITH_CFA)) == null) {
                return null;
            }
            KtExpression context2 = ktExpression;
            KotlinType kotlinType = CallUtilKt.getType((KtExpression)expr2, (BindingContext)context2);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expr2, (BindingContext)context2);
            if (compileTimeConstant == null || (compileTimeConstant = compileTimeConstant.toConstantValue(type2)) == null) {
                return null;
            }
            CompileTimeConstant constant = compileTimeConstant;
            Object object = constant.getValue();
            if (!(object instanceof Boolean)) {
                object = null;
            }
            return (Boolean)object;
        }

        private final List<ConstantConditionIfFix> collectFixes(KtIfExpression expression2, Boolean constantValue) {
            Object object;
            if (constantValue == null) {
                return CollectionsKt.emptyList();
            }
            boolean bl = false;
            List fixes2 = new ArrayList();
            if (ConstantConditionIfInspectionKt.access$branch(expression2, constantValue) != null) {
                boolean keepBraces = IfThenUtilsKt.isElseIf((KtExpression)expression2) && ConstantConditionIfInspectionKt.access$branch(expression2, constantValue) instanceof KtBlockExpression;
                object = fixes2;
                SimplifyFix simplifyFix = new SimplifyFix(constantValue, BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)expression2), (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)expression2), (BodyResolveMode)BodyResolveMode.PARTIAL_WITH_CFA)), keepBraces);
                boolean bl2 = false;
                object.add(simplifyFix);
            }
            if (!constantValue.booleanValue() && expression2.getElse() == null) {
                Collection collection = fixes2;
                object = new RemoveFix();
                boolean bl3 = false;
                collection.add(object);
            }
            return fixes2;
        }

        static /* synthetic */ List collectFixes$default(Companion companion, KtIfExpression ktIfExpression, Boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = companion.getConditionConstantValueIfAny(ktIfExpression);
            }
            return companion.collectFixes(ktIfExpression, bl);
        }

        public final void applyFixIfSingle(@NotNull KtIfExpression ifExpression2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)ifExpression2, (String)"ifExpression");
                ConstantConditionIfFix constantConditionIfFix = (ConstantConditionIfFix)CollectionsKt.singleOrNull((List)org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspection$Companion.collectFixes$default(this, ifExpression2, null, 2, null));
                if (constantConditionIfFix == null) break block0;
                constantConditionIfFix.applyFix(ifExpression2);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ Boolean access$getConditionConstantValueIfAny(Companion $this, KtIfExpression $this$access_u24getConditionConstantValueIfAny) {
            return $this.getConditionConstantValueIfAny($this$access_u24getConditionConstantValueIfAny);
        }

        public static final /* synthetic */ List access$collectFixes(Companion $this, KtIfExpression expression2, Boolean constantValue) {
            return $this.collectFixes(expression2, constantValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

