/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ConvertNaNEqualityInspectionKt;
import org.jetbrains.kotlin.idea.inspections.ConvertNaNEqualityQuickFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertNaNEqualityInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class ConvertNaNEqualityInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.binaryExpressionVisitor((Function1)((Function1)new Function1<KtBinaryExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtBinaryExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (ConvertNaNEqualityInspectionKt.access$isNaNExpression(expression2.getLeft()) || ConvertNaNEqualityInspectionKt.access$isNaNExpression(expression2.getRight())) {
                    boolean bl;
                    IElementType iElementType = expression2.getOperationToken();
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
                        bl = true;
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
                        bl = false;
                    } else {
                        return;
                    }
                    boolean inverted = bl;
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("equality.check.with.nan.should.be.replaced.with.isnan", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ConvertNaNEqualityQuickFix(inverted)});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

