/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantSetterInspectionKt;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantSetterFix;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantSetterInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "kotlin.idea"})
public final class RedundantSetterInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.propertyAccessorVisitor((Function1)((Function1)new Function1<KtPropertyAccessor, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtPropertyAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                PsiElement psiElement2 = accessor.getNamePlaceholder();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"accessor.namePlaceholder");
                TextRange textRange = psiElement2.getTextRange();
                if (textRange == null || (textRange = textRange.shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)accessor)))) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"accessor.namePlaceholder\u2026n@propertyAccessorVisitor");
                TextRange rangeInElement = textRange;
                if (RedundantSetterInspectionKt.isRedundantSetter(accessor)) {
                    this.$holder.registerProblem((PsiElement)accessor, KotlinBundle.message("redundant.setter", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, rangeInElement, new LocalQuickFix[]{new RemoveRedundantSetterFix()});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

