/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.inst.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.ArrayStoreInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.BooleanAndOrInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.BooleanBinaryInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.EnsureIndexInBoundsInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.EscapeInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.FoldArrayInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.JvmAssignmentInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.JvmPushInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.NotInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.NumericBinaryInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.PrimitiveConversionInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.StringConcatInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.ThrowInstruction;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.TrapTracker;
import com.intellij.codeInspection.dataFlow.jvm.problems.IndexOutOfBoundsProblem;
import com.intellij.codeInspection.dataFlow.jvm.transfer.EnterFinallyTrap;
import com.intellij.codeInspection.dataFlow.jvm.transfer.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.jvm.transfer.ExitFinallyTransfer;
import com.intellij.codeInspection.dataFlow.jvm.transfer.InsideFinallyTrap;
import com.intellij.codeInspection.dataFlow.jvm.transfer.InsideInlinedBlockTrap;
import com.intellij.codeInspection.dataFlow.jvm.transfer.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.jvm.transfer.TryCatchTrap;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ClosureInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.DupInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EnsureInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalUnknownInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PopInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SwapInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.UnwrapDerivedVariableInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.WrapDerivedVariableInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinCallableReferenceInstruction;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinClassToJavaClassInstruction;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinEqualityInstruction;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinFunctionCallInstruction;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinProblem;
import org.jetbrains.kotlin.idea.inspections.dfa.KtControlFlowBuilder;
import org.jetbrains.kotlin.idea.inspections.dfa.KtControlFlowBuilder$processEscapes$;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KtItVariableDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtThisDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtVariableDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.LambdaAndParameter;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessorKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00ae\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00b8\u00012\u00020\u0001:\u0004\u00b8\u0001\u00b9\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0002J\u001c\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J&\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010\"\u001a\u0004\u0018\u00010\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\b\u0010$\u001a\u0004\u0018\u00010\u001dH\u0002J&\u0010\"\u001a\u0004\u0018\u00010\u001d2\b\u0010%\u001a\u0004\u0018\u00010\u001d2\b\u0010&\u001a\u0004\u0018\u00010\u001d2\u0006\u0010'\u001a\u00020\bH\u0002J\b\u0010(\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J*\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\bH\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0016\u001a\u000209H\u0002J\u0014\u00107\u001a\u0004\u0018\u0001082\b\u0010:\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u00020?2\u0006\u0010\u0016\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u001c\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010*\u001a\u0004\u0018\u000102H\u0002J\u0012\u0010E\u001a\u00020D2\b\u0010F\u001a\u0004\u0018\u00010GH\u0002J\u0018\u0010H\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020@2\u0006\u0010I\u001a\u00020JH\u0002J \u0010K\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020@2\u0006\u0010L\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0018\u0010M\u001a\u00020\u00152\u0006\u0010I\u001a\u00020J2\u0006\u0010N\u001a\u00020?H\u0002J\u001f\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00150SH\u0082\bJ\u0018\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020D2\u0006\u0010V\u001a\u00020DH\u0002J\u001c\u0010W\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020X2\n\b\u0002\u0010Y\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010Z\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020]H\u0002J\u0010\u0010^\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020]H\u0002J \u0010_\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020]2\u0006\u0010`\u001a\u00020a2\u0006\u0010'\u001a\u00020\bH\u0002J\u0010\u0010b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020cH\u0002J\u001a\u0010d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020@2\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0002J\u0010\u0010e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020fH\u0002J\u0010\u0010g\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020hH\u0002J\u0010\u0010i\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010j\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020kH\u0002J\u0010\u0010l\u001a\u00020\u00152\u0006\u0010m\u001a\u00020nH\u0002J\u0010\u0010o\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020pH\u0002J\u0010\u0010q\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020rH\u0002J\u0010\u0010s\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0012\u0010t\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010u\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020vH\u0002J(\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00150S2\u0006\u0010\u0016\u001a\u00020v2\u0006\u0010x\u001a\u00020y2\b\u0010z\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010{\u001a\u00020\u00152\u0006\u0010|\u001a\u00020}H\u0002J0\u0010~\u001a\u00020\u00152\b\u0010\u007f\u001a\u0004\u0018\u00010\u001d2\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u00052\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020\bH\u0002J\u0012\u0010\u0084\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u0085\u0001H\u0002J\u0012\u0010\u0086\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u0087\u0001H\u0002J\u0011\u0010\u0088\u0001\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020JH\u0002J\u001b\u0010\u0089\u0001\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020]2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0002J\u0011\u0010\u008c\u0001\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020]H\u0002J\u0012\u0010\u008d\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u008e\u0001H\u0002J\u0012\u0010\u008f\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u0090\u0001H\u0002J\u0012\u0010\u0091\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u0092\u0001H\u0002J\u0011\u0010\u0093\u0001\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u000209H\u0002J\u001c\u0010\u0094\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u0095\u00012\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0002J\u0012\u0010\u0096\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u0097\u0001H\u0002J\u001a\u0010\u0098\u0001\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020]2\u0007\u0010\u0099\u0001\u001a\u00020\bH\u0002J\u0012\u0010\u009a\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u009b\u0001H\u0002J\u0012\u0010\u009c\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u009d\u0001H\u0002J\u0012\u0010\u009e\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u009f\u0001H\u0002J\u0013\u0010\u00a0\u0001\u001a\u00020\u00152\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0002J)\u0010\u00a3\u0001\u001a\u00020\u00152\t\u0010\u00a4\u0001\u001a\u0004\u0018\u00010y2\t\u0010\u00a5\u0001\u001a\u0004\u0018\u00010\u001d2\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u0001H\u0002J\u0012\u0010\u00a8\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u00a9\u0001H\u0002J\u0012\u0010\u00aa\u0001\u001a\u00020\u00152\u0007\u0010\u0016\u001a\u00030\u00ab\u0001H\u0002J%\u0010\u00ac\u0001\u001a\u00020\b2\u0007\u0010\u00ad\u0001\u001a\u00020\u00052\t\u0010\u00ae\u0001\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u000209H\u0002J$\u0010\u00af\u0001\u001a\u00020\u00182\u0011\u0010\u00b0\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00b2\u00010\u00b1\u00012\u0006\u0010\u0016\u001a\u00020@H\u0002J\t\u0010\u00b3\u0001\u001a\u00020\u0015H\u0002J\u0011\u0010\u00b4\u0001\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020@H\u0002J\u0013\u0010\u00b5\u0001\u001a\u00020\u00152\b\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ba\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtControlFlowBuilder;", "", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "context", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "broken", "", "getContext", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getFactory", "()Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "flow", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow;", "stringType", "Lcom/intellij/psi/PsiClassType;", "Lorg/jetbrains/annotations/NotNull;", "trapTracker", "Lcom/intellij/codeInspection/dataFlow/jvm/TrapTracker;", "addCall", "", "expr", "args", "", "qualifierOnStack", "addImplicitConversion", "expression", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "actualType", "addInstruction", "inst", "Lcom/intellij/codeInspection/dataFlow/lang/ir/Instruction;", "balanceType", "left", "right", "leftType", "rightType", "forceEqualityByContent", "buildFlow", "controlTransfer", "target", "Lcom/intellij/codeInspection/dataFlow/value/DfaControlTransferValue$TransferTarget;", "traps", "Lcom/intellij/util/containers/FList;", "Lcom/intellij/codeInspection/dataFlow/value/DfaControlTransferValue$Trap;", "createTransfer", "Lcom/intellij/codeInspection/dataFlow/jvm/transfer/InstructionTransfer;", "exitedStatement", "Lcom/intellij/psi/PsiElement;", "blockToFlush", "resultValue", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "exitBlock", "findSpecialField", "Lcom/intellij/codeInspection/dataFlow/jvm/SpecialField;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "type", "flushParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getLambdaOccurrenceRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "getReferenceValue", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "getTypeCheckDfType", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "inlineKnownLambdaCall", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "inlineKnownMethod", "argCount", "inlineLambda", "kind", "inlinedBlock", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "fn", "Lkotlin/Function0;", "mayCompareByContent", "leftDfType", "rightDfType", "processArrayAccess", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "storedValue", "processAsExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "processAssignmentExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "processBinaryExpression", "processBinaryRelationExpression", "relation", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "processBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "processCallExpression", "processCallableReference", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "processClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "processCodeDeclaration", "processConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "processDeclaration", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "processDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "processDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "processEscapes", "processExpression", "processForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "processForRange", "parameterVar", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "parameterType", "processIfExpression", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "processInCheck", "kotlinType", "range", "anchor", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinAnchor;", "negated", "processIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "processLabeledJumpExpression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "processLambda", "processMathExpression", "mathOp", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;", "processNullSafeOperator", "processObjectLiteral", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "processPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "processPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "processQualifiedReferenceExpression", "processReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "processReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "processShortCircuitExpression", "and", "processStringTemplate", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "processThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "processThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "processTryExpression", "statement", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "processWhenCondition", "dfVar", "dfVarType", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "processWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "processWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "pushJavaClassField", "receiver", "selector", "pushResolvedCallArguments", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "pushUnknown", "pushUnresolvedCallArguments", "setOffset", "offset", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow$DeferredOffset;", "Companion", "KotlinCatchClauseDescriptor", "kotlin.idea"})
public final class KtControlFlowBuilder {
    private final ControlFlow flow;
    private boolean broken;
    private final TrapTracker trapTracker;
    private final PsiClassType stringType;
    @NotNull
    private final DfaValueFactory factory;
    @NotNull
    private final KtExpression context;
    private static final Logger LOG;
    private static final TokenSet ASSIGNMENT_TOKENS;
    private static final ConcurrentHashMap.KeySetView<String, Boolean> unsupported;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final ControlFlow buildFlow() {
        this.processExpression(this.context);
        if (this.broken) {
            return null;
        }
        this.addInstruction((Instruction)new PopInstruction());
        this.flow.finish();
        return this.flow;
    }

    private final void processExpression(KtExpression expr2) {
        KtExpression ktExpression = expr2;
        if (ktExpression == null) {
            this.pushUnknown();
        } else if (ktExpression instanceof KtBlockExpression) {
            this.processBlock((KtBlockExpression)expr2);
        } else if (ktExpression instanceof KtParenthesizedExpression) {
            this.processExpression(((KtParenthesizedExpression)expr2).getExpression());
        } else if (ktExpression instanceof KtBinaryExpression) {
            this.processBinaryExpression((KtBinaryExpression)expr2);
        } else if (ktExpression instanceof KtBinaryExpressionWithTypeRHS) {
            this.processAsExpression((KtBinaryExpressionWithTypeRHS)expr2);
        } else if (ktExpression instanceof KtPrefixExpression) {
            this.processPrefixExpression((KtPrefixExpression)expr2);
        } else if (ktExpression instanceof KtPostfixExpression) {
            this.processPostfixExpression((KtPostfixExpression)expr2);
        } else if (ktExpression instanceof KtIsExpression) {
            this.processIsExpression((KtIsExpression)expr2);
        } else if (ktExpression instanceof KtCallExpression) {
            KtControlFlowBuilder.processCallExpression$default(this, (KtCallExpression)expr2, false, 2, null);
        } else if (ktExpression instanceof KtConstantExpression) {
            this.processConstantExpression((KtConstantExpression)expr2);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            KtControlFlowBuilder.processReferenceExpression$default(this, (KtSimpleNameExpression)expr2, false, 2, null);
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            this.processQualifiedReferenceExpression((KtQualifiedExpression)expr2);
        } else if (ktExpression instanceof KtSafeQualifiedExpression) {
            this.processQualifiedReferenceExpression((KtQualifiedExpression)expr2);
        } else if (ktExpression instanceof KtReturnExpression) {
            this.processReturnExpression((KtReturnExpression)expr2);
        } else if (ktExpression instanceof KtContinueExpression) {
            this.processLabeledJumpExpression((KtExpressionWithLabel)expr2);
        } else if (ktExpression instanceof KtBreakExpression) {
            this.processLabeledJumpExpression((KtExpressionWithLabel)expr2);
        } else if (ktExpression instanceof KtThrowExpression) {
            this.processThrowExpression((KtThrowExpression)expr2);
        } else if (ktExpression instanceof KtIfExpression) {
            this.processIfExpression((KtIfExpression)expr2);
        } else if (ktExpression instanceof KtWhenExpression) {
            this.processWhenExpression((KtWhenExpression)expr2);
        } else if (ktExpression instanceof KtWhileExpression) {
            this.processWhileExpression((KtWhileExpression)expr2);
        } else if (ktExpression instanceof KtDoWhileExpression) {
            this.processDoWhileExpression((KtDoWhileExpression)expr2);
        } else if (ktExpression instanceof KtForExpression) {
            this.processForExpression((KtForExpression)expr2);
        } else if (ktExpression instanceof KtProperty) {
            this.processDeclaration((KtProperty)expr2);
        } else if (ktExpression instanceof KtLambdaExpression) {
            this.processLambda((KtLambdaExpression)expr2);
        } else if (ktExpression instanceof KtStringTemplateExpression) {
            this.processStringTemplate((KtStringTemplateExpression)expr2);
        } else if (ktExpression instanceof KtArrayAccessExpression) {
            KtControlFlowBuilder.processArrayAccess$default(this, (KtArrayAccessExpression)expr2, null, 2, null);
        } else if (ktExpression instanceof KtAnnotatedExpression) {
            this.processExpression(((KtAnnotatedExpression)expr2).getBaseExpression());
        } else if (ktExpression instanceof KtClassLiteralExpression) {
            this.processClassLiteralExpression((KtClassLiteralExpression)expr2);
        } else if (ktExpression instanceof KtLabeledExpression) {
            this.processExpression(((KtLabeledExpression)expr2).getBaseExpression());
        } else if (ktExpression instanceof KtThisExpression) {
            this.processThisExpression((KtThisExpression)expr2);
        } else if (ktExpression instanceof KtSuperExpression) {
            this.pushUnknown();
        } else if (ktExpression instanceof KtCallableReferenceExpression) {
            this.processCallableReference((KtCallableReferenceExpression)expr2);
        } else if (ktExpression instanceof KtTryExpression) {
            this.processTryExpression((KtTryExpression)expr2);
        } else if (ktExpression instanceof KtDestructuringDeclaration) {
            this.processDestructuringDeclaration((KtDestructuringDeclaration)expr2);
        } else if (ktExpression instanceof KtObjectLiteralExpression) {
            this.processObjectLiteral((KtObjectLiteralExpression)expr2);
        } else if (ktExpression instanceof KtNamedFunction) {
            this.processCodeDeclaration(expr2);
        } else if (ktExpression instanceof KtClass) {
            this.processCodeDeclaration(expr2);
        } else {
            String className2;
            if (LOG.isDebugEnabled() && unsupported.add(className2 = expr2.getClass().getName())) {
                LOG.debug("Unsupported expression in control flow: " + className2);
            }
            this.broken = true;
        }
        this.flow.finishElement((PsiElement)expr2);
    }

    private final void processCodeDeclaration(KtExpression expr2) {
        this.processEscapes(expr2);
        this.pushUnknown();
    }

    private final void processObjectLiteral(KtObjectLiteralExpression expr2) {
        this.processEscapes((KtExpression)expr2);
        KtObjectDeclaration ktObjectDeclaration = expr2.getObjectDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"expr.objectDeclaration");
        for (KtSuperTypeListEntry superTypeListEntry : ktObjectDeclaration.getSuperTypeListEntries()) {
            if (!(superTypeListEntry instanceof KtSuperTypeCallEntry)) continue;
            this.addInstruction((Instruction)new FlushFieldsInstruction());
        }
        DfType dfType = KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType((KtExpression)expr2), (KtElement)expr2);
        this.addInstruction((Instruction)new PushValueInstruction(dfType, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
    }

    private final void processDestructuringDeclaration(KtDestructuringDeclaration expr2) {
        this.processExpression(expr2.getInitializer());
        for (KtDestructuringDeclarationEntry entry : expr2.getEntries()) {
            DfaVariableValue.Factory factory2 = this.factory.getVarFactory();
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry;
            Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"entry");
            this.addInstruction((Instruction)new FlushVariableInstruction(factory2.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)ktDestructuringDeclarationEntry))));
        }
    }

    private final void processTryExpression(KtTryExpression statement) {
        Object catchBlock;
        boolean bl5;
        Object it;
        EnterFinallyTrap finallyDescriptor;
        KtControlFlowBuilder this_$iv = this;
        boolean $i$f$inlinedBlock = false;
        this_$iv.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)((KtElement)statement)));
        this_$iv.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this_$iv.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
        boolean bl2 = false;
        KtBlockExpression ktBlockExpression = statement.getTryBlock();
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"statement.tryBlock");
        KtBlockExpression tryBlock2 = ktBlockExpression;
        KtFinallySection finallyBlock = statement.getFinallyBlock();
        ControlFlow.DeferredOffset finallyStart = new ControlFlow.DeferredOffset();
        EnterFinallyTrap enterFinallyTrap = finallyDescriptor = finallyBlock != null ? new EnterFinallyTrap((PsiElement)finallyBlock, (ControlFlow.ControlFlowOffset)finallyStart) : null;
        if (enterFinallyTrap != null) {
            EnterFinallyTrap enterFinallyTrap2 = enterFinallyTrap;
            boolean bl3 = false;
            boolean bl4 = false;
            it = enterFinallyTrap2;
            bl5 = false;
            this.trapTracker.pushTrap((DfaControlTransferValue.Trap)it);
        }
        DfaVariableValue dfaVariableValue = this.flow.createTempVariable(DfType.TOP);
        Intrinsics.checkNotNullExpressionValue((Object)dfaVariableValue, (String)"flow.createTempVariable(DfType.TOP)");
        DfaVariableValue tempVar = dfaVariableValue;
        List list2 = statement.getCatchClauses();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"statement.catchClauses");
        List sections = list2;
        LinkedHashMap clauses = new LinkedHashMap();
        it = sections;
        bl5 = false;
        if (!it.isEmpty()) {
            Iterator bl5 = sections.iterator();
            while (bl5.hasNext()) {
                KtCatchClause section;
                KtCatchClause ktCatchClause = section = (KtCatchClause)bl5.next();
                Intrinsics.checkNotNullExpressionValue((Object)ktCatchClause, (String)"section");
                catchBlock = ktCatchClause.getCatchBody();
                if (catchBlock == null) continue;
                ((Map)clauses).put(new KotlinCatchClauseDescriptor(section), new ControlFlow.DeferredOffset());
            }
            this.trapTracker.pushTrap((DfaControlTransferValue.Trap)new TryCatchTrap((PsiElement)statement, clauses));
        }
        this.processExpression((KtExpression)tryBlock2);
        this.addInstruction((Instruction)new JvmAssignmentInstruction(null, tempVar));
        InstructionTransfer gotoEnd = this.createTransfer((PsiElement)statement, (PsiElement)tryBlock2, (DfaValue)tempVar, true);
        FList singleFinally = FList.createFromReversed((Iterable)ContainerUtil.createMaybeSingletonList((Object)finallyDescriptor));
        DfaControlTransferValue.TransferTarget transferTarget = (DfaControlTransferValue.TransferTarget)gotoEnd;
        FList fList = singleFinally;
        Intrinsics.checkNotNullExpressionValue((Object)fList, (String)"singleFinally");
        this.controlTransfer(transferTarget, (FList<DfaControlTransferValue.Trap>)fList);
        catchBlock = sections;
        boolean bl6 = false;
        if (!catchBlock.isEmpty()) {
            this.trapTracker.popTrap(TryCatchTrap.class);
        }
        Iterator iterator = sections.iterator();
        while (iterator.hasNext()) {
            KtCatchClause section;
            KtCatchClause ktCatchClause = section = (KtCatchClause)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktCatchClause, (String)"section");
            ControlFlow.DeferredOffset offset2 = (ControlFlow.DeferredOffset)clauses.get(new KotlinCatchClauseDescriptor(ktCatchClause));
            if (offset2 == null) continue;
            this.setOffset(offset2);
            KtExpression catchBlock2 = section.getCatchBody();
            this.processExpression(catchBlock2);
            this.addInstruction((Instruction)new JvmAssignmentInstruction(null, tempVar));
            this.controlTransfer((DfaControlTransferValue.TransferTarget)gotoEnd, (FList<DfaControlTransferValue.Trap>)singleFinally);
        }
        if (finallyBlock != null) {
            this.setOffset(finallyStart);
            this.trapTracker.popTrap(EnterFinallyTrap.class);
            this.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideFinallyTrap((PsiElement)finallyBlock));
            this.processExpression((KtExpression)finallyBlock.getFinalExpression());
            this.addInstruction((Instruction)new PopInstruction());
            EnterFinallyTrap enterFinallyTrap3 = finallyDescriptor;
            Intrinsics.checkNotNull((Object)enterFinallyTrap3);
            DfaControlTransferValue.TransferTarget transferTarget2 = (DfaControlTransferValue.TransferTarget)new ExitFinallyTransfer(enterFinallyTrap3);
            FList fList2 = FList.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)fList2, (String)"FList.emptyList()");
            this.controlTransfer(transferTarget2, (FList<DfaControlTransferValue.Trap>)fList2);
            this.trapTracker.popTrap(InsideFinallyTrap.class);
        }
        this_$iv.trapTracker.popTrap(InsideInlinedBlockTrap.class);
        this_$iv.addInstruction((Instruction)new PopInstruction());
    }

    private final void processCallableReference(KtCallableReferenceExpression expr2) {
        this.processExpression(expr2.getReceiverExpression());
        this.addInstruction((Instruction)new KotlinCallableReferenceInstruction(expr2));
    }

    private final void processThisExpression(KtThisExpression expr2) {
        DfType dfType = KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType((KtExpression)expr2), (KtElement)expr2);
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)ResolutionUtils.analyze((KtElement)((KtElement)expr2), (BodyResolveMode)BodyResolveMode.FULL).get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expr2.getInstanceReference());
        if (descriptor2 != null) {
            KtThisDescriptor varDesc = new KtThisDescriptor(descriptor2, dfType);
            this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this.factory.getVarFactory().createVariableValue((VariableDescriptor)varDesc), (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
        } else {
            this.addInstruction((Instruction)new PushValueInstruction(dfType, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
        }
    }

    private final void processClassLiteralExpression(KtClassLiteralExpression expr2) {
        List arguments2;
        KotlinType kotlinType = KtDfaHelpersKt.getKotlinType((KtExpression)expr2);
        KtExpression receiver2 = expr2.getReceiverExpression();
        if (kotlinType != null && receiver2 instanceof KtSimpleNameExpression && ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)receiver2).resolve() instanceof KtClass && (arguments2 = kotlinType.getArguments()).size() == 1) {
            KotlinType kotlinType2 = ((TypeProjection)arguments2.get(0)).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"arguments[0].type");
            KotlinType kType = kotlinType2;
            PsiType kClassPsiType = KtDfaHelpersKt.toPsiType(kotlinType, (KtElement)expr2);
            if (kClassPsiType != null) {
                DfConstantType dfConstantType = DfTypes.referenceConstant((Object)kType, (PsiType)kClassPsiType);
                Intrinsics.checkNotNullExpressionValue((Object)dfConstantType, (String)"DfTypes.referenceConstant(kType, kClassPsiType)");
                DfType kClassConstant = (DfType)dfConstantType;
                this.addInstruction((Instruction)new PushValueInstruction(kClassConstant, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
                return;
            }
        }
        this.processExpression(receiver2);
        this.addInstruction((Instruction)new PopInstruction());
        this.addInstruction((Instruction)new PushValueInstruction(KtDfaHelpersKt.toDfType(kotlinType, (KtElement)expr2)));
    }

    private final void processAsExpression(KtBinaryExpressionWithTypeRHS expr2) {
        KtExpression ktExpression = expr2.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expr.left");
        KtExpression operand2 = ktExpression;
        KtTypeReference typeReference2 = expr2.getRight();
        DfType type2 = this.getTypeCheckDfType(typeReference2);
        KtSimpleNameExpression ktSimpleNameExpression = expr2.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expr.operationReference");
        KtSimpleNameExpression ref2 = ktSimpleNameExpression;
        if (Intrinsics.areEqual((Object)ref2.getText(), (Object)"as?") ^ true && Intrinsics.areEqual((Object)ref2.getText(), (Object)"as") ^ true) {
            this.broken = true;
            return;
        }
        this.processExpression(operand2);
        KotlinType operandType = KtDfaHelpersKt.getKotlinType(operand2);
        if (KtDfaHelpersKt.toDfType(operandType, (KtElement)expr2) instanceof DfPrimitiveType) {
            this.addInstruction((Instruction)new WrapDerivedVariableInstruction((DfType)DfTypes.NOT_NULL_OBJECT, (DerivedVariableDescriptor)SpecialField.UNBOX));
        }
        if (Intrinsics.areEqual((Object)ref2.getText(), (Object)"as?")) {
            DfaVariableValue dfaVariableValue = this.flow.createTempVariable((DfType)DfTypes.OBJECT_OR_NULL);
            Intrinsics.checkNotNullExpressionValue((Object)dfaVariableValue, (String)"flow.createTempVariable(DfTypes.OBJECT_OR_NULL)");
            DfaVariableValue tempVariable = dfaVariableValue;
            this.addInstruction((Instruction)new JvmAssignmentInstruction(null, tempVariable));
            this.addInstruction((Instruction)new PushValueInstruction(type2, null));
            this.addInstruction((Instruction)new InstanceofInstruction(null, false));
            ControlFlow.DeferredOffset offset2 = new ControlFlow.DeferredOffset();
            this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset2, (DfType)DfTypes.FALSE));
            KotlinAnchor.KotlinExpressionAnchor anchor = new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2);
            this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)tempVariable, (DfaAnchor)anchor));
            ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
            this.setOffset(offset2);
            this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.NULL, (DfaAnchor)anchor));
            this.setOffset(endOffset2);
        } else {
            KotlinType castType;
            DfaControlTransferValue transfer = this.trapTracker.maybeTransferValue("java.lang.ClassCastException");
            this.addInstruction((Instruction)new EnsureInstruction((UnsatisfiedConditionProblem)new KotlinProblem.KotlinCastProblem(operand2, (KtExpression)expr2), RelationType.IS, type2, transfer));
            if (typeReference2 != null && KtDfaHelpersKt.toDfType(castType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)typeReference2, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)typeReference2), (BodyResolveMode)BodyResolveMode.FULL)), (KtElement)typeReference2) instanceof DfPrimitiveType) {
                this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.UNBOX));
            }
        }
    }

    private final void processArrayAccess(KtArrayAccessExpression expr2, KtExpression storedValue) {
        KotlinType kotlinType;
        KtExpression arrayExpression = expr2.getArrayExpression();
        this.processExpression(arrayExpression);
        KtExpression ktExpression = arrayExpression;
        KotlinType curType = kotlinType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
        List list2 = expr2.getIndexExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expr.indexExpressions");
        List indexes = list2;
        for (KtExpression idx : indexes) {
            KotlinAnchor.KotlinExpressionAnchor anchor;
            boolean lastIndex;
            block23: {
                DfaControlTransferValue transfer;
                KotlinType indexType;
                block24: {
                    boolean bl;
                    block22: {
                        IntegerLiteralTypeConstructor constructor2;
                        this.processExpression(idx);
                        lastIndex = Intrinsics.areEqual((Object)idx, (Object)((KtExpression)CollectionsKt.last((List)indexes)));
                        anchor = lastIndex ? new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2) : null;
                        KtExpression ktExpression2 = idx;
                        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"idx");
                        KotlinType kotlinType2 = indexType = KtDfaHelpersKt.getKotlinType(ktExpression2);
                        Object object = kotlinType2 != null ? kotlinType2.getConstructor() : null;
                        if (!(object instanceof IntegerLiteralTypeConstructor)) {
                            object = null;
                        }
                        if ((constructor2 = (IntegerLiteralTypeConstructor)object) != null) {
                            indexType = constructor2.getApproximatedType();
                        }
                        if (indexType == null || !KtDfaHelpersKt.fqNameEquals(indexType, "kotlin.Int")) {
                            if (lastIndex && storedValue != null) {
                                this.processExpression(storedValue);
                                this.addInstruction((Instruction)new PopInstruction());
                            }
                            this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)anchor, 2));
                            this.addInstruction((Instruction)new FlushFieldsInstruction());
                            continue;
                        }
                        if (curType != null && KotlinBuiltIns.isArrayOrPrimitiveArray((KotlinType)curType)) {
                            KotlinType elementType;
                            if (KtDfaHelpersKt.canBeNull(indexType)) {
                                this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.UNBOX));
                            }
                            transfer = this.trapTracker.maybeTransferValue("java.lang.ArrayIndexOutOfBoundsException");
                            Intrinsics.checkNotNullExpressionValue((Object)PlatformKt.getBuiltIns((KtElement)expr2).getArrayElementType(curType), (String)"expr.builtIns.getArrayElementType(curType)");
                            if (lastIndex && storedValue != null) {
                                this.processExpression(storedValue);
                                this.addImplicitConversion(storedValue, KtDfaHelpersKt.getKotlinType(storedValue), KtDfaHelpersKt.getArrayElementType(curType, (KtElement)expr2));
                                this.addInstruction((Instruction)new ArrayStoreInstruction((DfaAnchor)anchor, (IndexOutOfBoundsProblem)new KotlinProblem.KotlinArrayIndexProblem((DerivedVariableDescriptor)SpecialField.ARRAY_LENGTH, idx), transfer, null));
                            } else {
                                this.addInstruction((Instruction)new ArrayAccessInstruction((DfaAnchor)anchor, (IndexOutOfBoundsProblem)new KotlinProblem.KotlinArrayIndexProblem((DerivedVariableDescriptor)SpecialField.ARRAY_LENGTH, idx), transfer, null));
                                this.addImplicitConversion((KtExpression)expr2, KtDfaHelpersKt.getArrayElementType(curType, (KtElement)expr2), elementType);
                            }
                            curType = elementType;
                            continue;
                        }
                        if (KotlinBuiltIns.isString((KotlinType)kotlinType)) {
                            if (KtDfaHelpersKt.canBeNull(indexType)) {
                                this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.UNBOX));
                            }
                            transfer = this.trapTracker.maybeTransferValue("java.lang.StringIndexOutOfBoundsException");
                            this.addInstruction((Instruction)new EnsureIndexInBoundsInstruction((IndexOutOfBoundsProblem)new KotlinProblem.KotlinArrayIndexProblem((DerivedVariableDescriptor)SpecialField.STRING_LENGTH, idx), transfer));
                            if (lastIndex && storedValue != null) {
                                this.processExpression(storedValue);
                                this.addInstruction((Instruction)new PopInstruction());
                            }
                            this.addInstruction((Instruction)new PushValueInstruction(DfTypes.typedObject((PsiType)((PsiType)PsiType.CHAR), (Nullability)Nullability.UNKNOWN), (DfaAnchor)anchor));
                            continue;
                        }
                        if (kotlinType == null) break block23;
                        if (KotlinBuiltIns.isListOrNullableList((KotlinType)kotlinType)) break block24;
                        Iterable $this$any$iv = TypeUtilsKt.supertypes((KotlinType)kotlinType);
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                KotlinType type2 = (KotlinType)element$iv;
                                boolean bl2 = false;
                                if (!KotlinBuiltIns.isListOrNullableList((KotlinType)type2)) continue;
                                bl = true;
                                break block22;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block23;
                }
                if (KtDfaHelpersKt.canBeNull(indexType)) {
                    this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.UNBOX));
                }
                transfer = this.trapTracker.maybeTransferValue("java.lang.IndexOutOfBoundsException");
                this.addInstruction((Instruction)new EnsureIndexInBoundsInstruction((IndexOutOfBoundsProblem)new KotlinProblem.KotlinArrayIndexProblem((DerivedVariableDescriptor)SpecialField.COLLECTION_SIZE, idx), transfer));
                if (lastIndex && storedValue != null) {
                    this.processExpression(storedValue);
                    this.addInstruction((Instruction)new PopInstruction());
                }
                this.pushUnknown();
                continue;
            }
            if (lastIndex && storedValue != null) {
                this.processExpression(storedValue);
                this.addInstruction((Instruction)new PopInstruction());
            }
            this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)anchor, 2));
            this.addInstruction((Instruction)new FlushFieldsInstruction());
        }
    }

    static /* synthetic */ void processArrayAccess$default(KtControlFlowBuilder ktControlFlowBuilder, KtArrayAccessExpression ktArrayAccessExpression, KtExpression ktExpression, int n, Object object) {
        if ((n & 2) != 0) {
            ktExpression = null;
        }
        ktControlFlowBuilder.processArrayAccess(ktArrayAccessExpression, ktExpression);
    }

    private final void processIsExpression(KtIsExpression expr2) {
        this.processExpression(expr2.getLeftHandSide());
        DfType type2 = this.getTypeCheckDfType(expr2.getTypeReference());
        if (Intrinsics.areEqual((Object)type2, (Object)DfType.TOP)) {
            this.pushUnknown();
        } else {
            this.addInstruction((Instruction)new PushValueInstruction(type2));
            if (expr2.isNegated()) {
                this.addInstruction((Instruction)new InstanceofInstruction(null, false));
                this.addInstruction((Instruction)new NotInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
            } else {
                this.addInstruction((Instruction)new InstanceofInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2), false));
            }
        }
    }

    private final void processStringTemplate(KtStringTemplateExpression expr2) {
        Object[] entries;
        boolean first2 = true;
        Object[] objectArray = expr2.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"expr.entries");
        Object[] objectArray2 = entries = objectArray;
        boolean bl = false;
        if (objectArray2.length == 0) {
            this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.constant((Object)"", (PsiType)((PsiType)this.stringType))));
            return;
        }
        KtStringTemplateEntry lastEntry = (KtStringTemplateEntry)ArraysKt.last((Object[])entries);
        for (Object entry : entries) {
            Object object = entry;
            if (object instanceof KtEscapeStringTemplateEntry) {
                this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.constant((Object)((KtEscapeStringTemplateEntry)entry).getUnescapedValue(), (PsiType)((PsiType)this.stringType))));
            } else if (object instanceof KtLiteralStringTemplateEntry) {
                this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.constant((Object)((KtLiteralStringTemplateEntry)entry).getText(), (PsiType)((PsiType)this.stringType))));
            } else if (object instanceof KtStringTemplateEntryWithExpression) {
                this.processExpression(((KtStringTemplateEntryWithExpression)entry).getExpression());
            } else {
                this.pushUnknown();
            }
            if (!first2) {
                KotlinAnchor.KotlinExpressionAnchor anchor = Intrinsics.areEqual((Object)entry, (Object)lastEntry) ? new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2) : null;
                this.addInstruction((Instruction)new StringConcatInstruction((DfaAnchor)anchor, (PsiType)this.stringType));
            }
            first2 = false;
        }
        if (entries.length == 1 && !(entries[0] instanceof KtLiteralStringTemplateEntry)) {
            this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.constant((Object)"", (PsiType)((PsiType)this.stringType))));
            this.addInstruction((Instruction)new StringConcatInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2), (PsiType)this.stringType));
        }
    }

    private final void processLambda(KtLambdaExpression expr2) {
        KtBlockExpression element3 = expr2.getBodyExpression();
        if (element3 != null) {
            this.processEscapes((KtExpression)element3);
            this.addInstruction((Instruction)new ClosureInstruction(CollectionsKt.listOf((Object)element3)));
        }
        this.pushUnknown();
    }

    private final void processEscapes(KtExpression expr2) {
        Sequence $this$filterIsInstance$iv;
        boolean bl = false;
        Set vars = new LinkedHashSet();
        Collection collection = this.factory.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"factory.values");
        Object object = CollectionsKt.asSequence((Iterable)collection);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processEscapes$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        $this$filterIsInstance$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)processEscapes.existingVars.1.INSTANCE), (Function1)processEscapes.existingVars.2.INSTANCE);
        $i$f$filterIsInstance = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processEscapes$$inlined$filterIsInstance$2.INSTANCE);
        if (sequence3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Set existingVars2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)sequence3, (Function1)processEscapes.existingVars.3.INSTANCE));
        PsiTreeUtil.processElements((PsiElement)((PsiElement)expr2), KtSimpleNameExpression.class, (PsiElementProcessor)new PsiElementProcessor(this, existingVars2, vars){
            final /* synthetic */ KtControlFlowBuilder this$0;
            final /* synthetic */ Set $existingVars;
            final /* synthetic */ Set $vars;

            public final boolean execute(@NotNull KtSimpleNameExpression ref2) {
                Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
                PsiElement target2 = ReferenceUtilsKt.getMainReference(ref2).resolve();
                if (target2 != null && CollectionsKt.contains((Iterable)this.$existingVars, (Object)target2)) {
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)this.$vars, (Object)KtVariableDescriptor.Companion.createFromSimpleName(this.this$0.getFactory(), (KtExpression)ref2));
                }
                return true;
            }
            {
                this.this$0 = ktControlFlowBuilder;
                this.$existingVars = set2;
                this.$vars = set3;
            }
        });
        object = vars;
        boolean bl2 = false;
        if (!object.isEmpty()) {
            this.addInstruction((Instruction)new EscapeInstruction(vars));
        }
    }

    private final void processCallExpression(KtCallExpression expr2, boolean qualifierOnStack) {
        ResolvedCall call = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)expr2), null, (int)1, null);
        int argCount = 0;
        argCount = call != null ? this.pushResolvedCallArguments((ResolvedCall<? extends CallableDescriptor>)call, expr2) : this.pushUnresolvedCallArguments(expr2);
        if (this.inlineKnownMethod(expr2, argCount, qualifierOnStack)) {
            return;
        }
        LambdaAndParameter lambda2 = KtDfaHelpersKt.getInlineableLambda(expr2);
        if (lambda2 != null) {
            if (qualifierOnStack && this.inlineKnownLambdaCall(expr2, lambda2.getLambda())) {
                return;
            }
            EventOccurrencesRange kind2 = this.getLambdaOccurrenceRange(expr2, lambda2.getDescriptor().getOriginal());
            this.inlineLambda(lambda2.getLambda(), kind2);
        } else {
            for (KtLambdaArgument lambdaArg : expr2.getLambdaArguments()) {
                this.processExpression((KtExpression)lambdaArg.getLambdaExpression());
                ++argCount;
            }
        }
        this.addCall((KtExpression)expr2, argCount, qualifierOnStack);
    }

    static /* synthetic */ void processCallExpression$default(KtControlFlowBuilder ktControlFlowBuilder, KtCallExpression ktCallExpression, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ktControlFlowBuilder.processCallExpression(ktCallExpression, bl);
    }

    private final int pushUnresolvedCallArguments(KtCallExpression expr2) {
        KtValueArgumentList ktValueArgumentList = expr2.getValueArgumentList();
        List args2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        int argCount = 0;
        if (args2 != null) {
            for (KtValueArgument arg : args2) {
                KtExpression argExpr = arg.getArgumentExpression();
                if (argExpr == null) continue;
                this.processExpression(argExpr);
                ++argCount;
            }
        }
        return argCount;
    }

    /*
     * WARNING - void declaration
     */
    private final int pushResolvedCallArguments(ResolvedCall<? extends CallableDescriptor> call, KtCallExpression expr2) {
        Map map2 = call.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"call.valueArguments");
        Map valueArguments2 = map2;
        int argCount = 0;
        Map map3 = valueArguments2;
        boolean bl = false;
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            ResolvedValueArgument resolvedValueArgument;
            ResolvedValueArgument resolvedValueArgument2 = resolvedValueArgument = iterator.next();
            boolean bl2 = false;
            map3 = (ValueParameterDescriptor)resolvedValueArgument2.getKey();
            resolvedValueArgument2 = resolvedValueArgument;
            bl2 = false;
            ResolvedValueArgument valueArg = (ResolvedValueArgument)resolvedValueArgument2.getValue();
            if ((resolvedValueArgument2 = valueArg) instanceof VarargValueArgument) {
                List arguments2;
                ValueArgument singleArg;
                Intrinsics.checkNotNullExpressionValue((Object)((VarargValueArgument)valueArg).getArguments(), (String)"valueArg.arguments");
                ValueArgument valueArgument = singleArg = (ValueArgument)CollectionsKt.singleOrNull((List)arguments2);
                if ((valueArgument != null ? valueArgument.getSpreadElement() : null) != null) {
                    this.processExpression(singleArg.getArgumentExpression());
                } else {
                    void descriptor2;
                    for (ValueArgument arg : arguments2) {
                        this.processExpression(arg.getArgumentExpression());
                    }
                    void v2 = descriptor2;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"descriptor");
                    this.addInstruction((Instruction)new FoldArrayInstruction(null, KtDfaHelpersKt.toDfType(v2.getType(), (KtElement)expr2), arguments2.size()));
                }
                ++argCount;
                continue;
            }
            if (resolvedValueArgument2 instanceof ExpressionValueArgument) {
                ValueArgument valueArgument = ((ExpressionValueArgument)valueArg).getValueArgument();
                if (valueArgument instanceof KtLambdaArgument) continue;
                ValueArgument valueArgument2 = valueArgument;
                this.processExpression((KtExpression)(valueArgument2 != null ? valueArgument2.getArgumentExpression() : null));
                ++argCount;
                continue;
            }
            this.pushUnknown();
            ++argCount;
        }
        return argCount;
    }

    private final boolean inlineKnownMethod(KtCallExpression expr2, int argCount, boolean qualifierOnStack) {
        if (argCount == 0 && qualifierOnStack) {
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)expr2), null, (int)1, null);
            if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                return false;
            }
            ResolvedCall descriptor2 = resolvedCall2;
            String string = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name.asString()");
            String name2 = string;
            if (Intrinsics.areEqual((Object)name2, (Object)"isEmpty") || Intrinsics.areEqual((Object)name2, (Object)"isNotEmpty")) {
                FqName containingPackage;
                Object object;
                DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
                DeclarationDescriptor containingDeclaration2 = declarationDescriptor;
                if (containingDeclaration2 instanceof PackageFragmentDescriptor) {
                    object = ((PackageFragmentDescriptor)containingDeclaration2).getFqName();
                } else {
                    DeclarationDescriptor declarationDescriptor2 = containingDeclaration2;
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                        declarationDescriptor2 = null;
                    }
                    ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor2;
                    object = classDescriptor != null ? DescriptorUtilKt.containingPackage((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor)) : null;
                }
                FqName fqName2 = containingPackage = object;
                if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)"kotlin.collections")) {
                    KotlinType kotlinType;
                    this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.COLLECTION_SIZE));
                    this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.intValue((int)0)));
                    this.addInstruction((Instruction)new BooleanBinaryInstruction(Intrinsics.areEqual((Object)name2, (Object)"isEmpty") ? RelationType.EQ : RelationType.NE, false, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
                    KotlinType kotlinType2 = kotlinType = KtDfaHelpersKt.getKotlinType((KtExpression)expr2);
                    if (kotlinType2 != null) {
                        if (kotlinType2.isMarkedNullable()) {
                            this.addInstruction((Instruction)new WrapDerivedVariableInstruction(KtDfaHelpersKt.toDfType(kotlinType, (KtElement)expr2), (DerivedVariableDescriptor)SpecialField.UNBOX));
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean inlineKnownLambdaCall(KtCallExpression expr2, KtLambdaExpression lambda2) {
        KtExpression receiver2;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)expr2), null, (int)1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor packageFragment2 = packageFragmentDescriptor;
        KtBlockExpression bodyExpression = lambda2.getBodyExpression();
        PsiElement psiElement2 = expr2.getParent();
        if (!(psiElement2 instanceof KtQualifiedExpression)) {
            psiElement2 = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)psiElement2;
        Object object = receiver2 = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (Intrinsics.areEqual((Object)packageFragment2.getFqName().asString(), (Object)"kotlin") && resolvedCall3.getValueArguments().size() == 1) {
            String string = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name.asString()");
            String name2 = string;
            if (Intrinsics.areEqual((Object)name2, (Object)"let") || Intrinsics.areEqual((Object)name2, (Object)"also") || Intrinsics.areEqual((Object)name2, (Object)"takeIf") || Intrinsics.areEqual((Object)name2, (Object)"takeUnless")) {
                Object object2;
                KotlinType receiverType2;
                DfaVariableValue dfaVariableValue = KtVariableDescriptor.Companion.getSingleLambdaParameter(this.factory, lambda2);
                if (dfaVariableValue == null) {
                    return false;
                }
                DfaVariableValue parameter = dfaVariableValue;
                KtExpression ktExpression = receiver2;
                Object object3 = receiverType2 = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
                if (expr2.getParent() instanceof KtSafeQualifiedExpression) {
                    KotlinType kotlinType = receiverType2;
                    object2 = kotlinType != null ? TypeUtilsKt.makeNotNullable((KotlinType)kotlinType) : null;
                } else {
                    object2 = receiverType2;
                }
                KotlinType argType = object2;
                this.addImplicitConversion(receiver2, argType);
                this.addInstruction((Instruction)new JvmAssignmentInstruction(null, parameter));
                switch (name2) {
                    case "let": {
                        this.addInstruction((Instruction)new PopInstruction());
                        KotlinType kotlinType = UtilsKt.resolveType((KtExpression)lambda2);
                        KotlinType lambdaResultType = kotlinType != null ? FunctionTypesKt.getReturnTypeFromFunctionType((KotlinType)kotlinType) : null;
                        DfaVariableValue dfaVariableValue2 = this.flow.createTempVariable(KtDfaHelpersKt.toDfType(lambdaResultType, (KtElement)expr2));
                        Intrinsics.checkNotNullExpressionValue((Object)dfaVariableValue2, (String)"flow.createTempVariable(\u2026esultType.toDfType(expr))");
                        DfaVariableValue result2 = dfaVariableValue2;
                        KtControlFlowBuilder this_$iv = this;
                        boolean $i$f$inlinedBlock = false;
                        this_$iv.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)((KtElement)lambda2)));
                        this_$iv.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this_$iv.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
                        boolean bl = false;
                        this.processExpression((KtExpression)bodyExpression);
                        this.flow.finishElement((PsiElement)lambda2.getFunctionLiteral());
                        this.addInstruction((Instruction)new JvmAssignmentInstruction(null, result2));
                        this.addInstruction((Instruction)new PopInstruction());
                        this_$iv.trapTracker.popTrap(InsideInlinedBlockTrap.class);
                        this_$iv.addInstruction((Instruction)new PopInstruction());
                        this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)result2, null));
                        this.addImplicitConversion((KtExpression)expr2, lambdaResultType, KtDfaHelpersKt.getKotlinType((KtExpression)expr2));
                        break;
                    }
                    case "also": {
                        KtControlFlowBuilder this_$iv = this;
                        boolean $i$f$inlinedBlock = false;
                        this_$iv.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)((KtElement)lambda2)));
                        this_$iv.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this_$iv.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
                        boolean bl = false;
                        this.processExpression((KtExpression)bodyExpression);
                        this.flow.finishElement((PsiElement)lambda2.getFunctionLiteral());
                        this.addInstruction((Instruction)new PopInstruction());
                        this_$iv.trapTracker.popTrap(InsideInlinedBlockTrap.class);
                        this_$iv.addInstruction((Instruction)new PopInstruction());
                        this.addImplicitConversion(receiver2, argType, KtDfaHelpersKt.getKotlinType((KtExpression)expr2));
                        this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
                        break;
                    }
                    case "takeUnless": 
                    case "takeIf": {
                        DfaVariableValue dfaVariableValue3 = this.flow.createTempVariable((DfType)DfTypes.BOOLEAN);
                        Intrinsics.checkNotNullExpressionValue((Object)dfaVariableValue3, (String)"flow.createTempVariable(DfTypes.BOOLEAN)");
                        DfaVariableValue result3 = dfaVariableValue3;
                        KtControlFlowBuilder this_$iv = this;
                        boolean $i$f$inlinedBlock = false;
                        this_$iv.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)((KtElement)lambda2)));
                        this_$iv.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this_$iv.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
                        boolean bl = false;
                        this.processExpression((KtExpression)bodyExpression);
                        this.flow.finishElement((PsiElement)lambda2.getFunctionLiteral());
                        this.addInstruction((Instruction)new JvmAssignmentInstruction(null, result3));
                        this.addInstruction((Instruction)new PopInstruction());
                        this_$iv.trapTracker.popTrap(InsideInlinedBlockTrap.class);
                        this_$iv.addInstruction((Instruction)new PopInstruction());
                        this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)result3, null));
                        ControlFlow.DeferredOffset offset2 = new ControlFlow.DeferredOffset();
                        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset2, (DfType)DfTypes.booleanValue((boolean)Intrinsics.areEqual((Object)name2, (Object)"takeIf"))));
                        this.addInstruction((Instruction)new PopInstruction());
                        this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.NULL));
                        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
                        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
                        this.setOffset(offset2);
                        this.addImplicitConversion(receiver2, argType, KtDfaHelpersKt.getKotlinType((KtExpression)expr2));
                        this.setOffset(endOffset2);
                        break;
                    }
                }
                this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final EventOccurrencesRange getLambdaOccurrenceRange(KtCallExpression expr2, ValueParameterDescriptor descriptor2) {
        ContractDescription contractDescription;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)expr2), null, (int)1, null);
        ContractDescription contractDescription2 = resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null && (resolvedCall2 = (AbstractContractProvider)resolvedCall2.getUserData((CallableDescriptor.UserDataKey)ContractProviderKey.INSTANCE)) != null ? resolvedCall2.getContractDescription() : (contractDescription = null);
        if (contractDescription != null) {
            CallsEffectDeclaration callEffect;
            Object v3;
            Object v2;
            block5: {
                void $this$singleOrNull$iv;
                Iterable iterable = contractDescription.getEffects();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    EffectDeclaration e = (EffectDeclaration)element$iv;
                    boolean bl = false;
                    if (!(e instanceof CallsEffectDeclaration && Intrinsics.areEqual((Object)((CallsEffectDeclaration)e).getVariableReference().getDescriptor(), (Object)descriptor2))) continue;
                    if (found$iv) {
                        v2 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = v3 = !found$iv ? null : single$iv;
            }
            if (!(v2 instanceof CallsEffectDeclaration)) {
                v3 = null;
            }
            if ((callEffect = (CallsEffectDeclaration)v3) != null) {
                return callEffect.getKind();
            }
        }
        return EventOccurrencesRange.UNKNOWN;
    }

    private final void inlineLambda(KtLambdaExpression lambda2, EventOccurrencesRange kind2) {
        this.addInstruction((Instruction)new FlushFieldsInstruction());
        ControlFlow.FixedOffset offset2 = new ControlFlow.FixedOffset(this.flow.getInstructionCount());
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        if (kind2 != EventOccurrencesRange.EXACTLY_ONCE && kind2 != EventOccurrencesRange.MORE_THAN_ONCE && kind2 != EventOccurrencesRange.AT_LEAST_ONCE) {
            this.pushUnknown();
            this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)endOffset2, (DfType)DfTypes.TRUE));
        }
        KtControlFlowBuilder this_$iv = this;
        boolean $i$f$inlinedBlock = false;
        this_$iv.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)((KtElement)lambda2)));
        this_$iv.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this_$iv.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
        boolean bl = false;
        KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambda.functionLiteral");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        KtBlockExpression bodyExpression = lambda2.getBodyExpression();
        if (bodyExpression != null) {
            DfaVariableValue singleParameter = KtVariableDescriptor.Companion.getSingleLambdaParameter(this.factory, lambda2);
            if (singleParameter != null) {
                this.addInstruction((Instruction)new FlushVariableInstruction(singleParameter));
            } else {
                Iterator iterator = lambda2.getValueParameters().iterator();
                while (iterator.hasNext()) {
                    KtParameter parameter;
                    KtParameter ktParameter = parameter = (KtParameter)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"parameter");
                    this.flushParameter(ktParameter);
                }
            }
        }
        this.processExpression((KtExpression)bodyExpression);
        this.flow.finishElement((PsiElement)functionLiteral);
        this.addInstruction((Instruction)new PopInstruction());
        this_$iv.trapTracker.popTrap(InsideInlinedBlockTrap.class);
        this_$iv.addInstruction((Instruction)new PopInstruction());
        this.setOffset(endOffset2);
        this.addInstruction((Instruction)new FlushFieldsInstruction());
        if (kind2 != EventOccurrencesRange.AT_MOST_ONCE && kind2 != EventOccurrencesRange.EXACTLY_ONCE) {
            this.pushUnknown();
            this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset2, (DfType)DfTypes.TRUE));
        }
    }

    private final void inlinedBlock(KtElement element3, Function0<Unit> fn) {
        int $i$f$inlinedBlock = 0;
        this.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)element3));
        this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
        fn.invoke();
        this.trapTracker.popTrap(InsideInlinedBlockTrap.class);
        this.addInstruction((Instruction)new PopInstruction());
    }

    private final void addCall(KtExpression expr2, int args2, boolean qualifierOnStack) {
        DfaControlTransferValue transfer = this.trapTracker.maybeTransferValue("java.lang.Throwable");
        this.addInstruction((Instruction)new KotlinFunctionCallInstruction(expr2, args2, qualifierOnStack, transfer));
    }

    static /* synthetic */ void addCall$default(KtControlFlowBuilder ktControlFlowBuilder, KtExpression ktExpression, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        ktControlFlowBuilder.addCall(ktExpression, n, bl);
    }

    private final void processQualifiedReferenceExpression(KtQualifiedExpression expr2) {
        KtExpression selector2;
        KtExpression receiver2 = expr2.getReceiverExpression();
        this.processExpression(receiver2);
        ControlFlow.DeferredOffset offset2 = new ControlFlow.DeferredOffset();
        if (expr2 instanceof KtSafeQualifiedExpression) {
            this.addInstruction((Instruction)new DupInstruction());
            this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset2, (DfType)DfTypes.NULL));
        }
        if (!this.pushJavaClassField(receiver2, selector2 = expr2.getSelectorExpression(), expr2)) {
            SpecialField specialField = this.findSpecialField(expr2);
            if (specialField != null) {
                this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)specialField));
                if (expr2 instanceof KtSafeQualifiedExpression) {
                    this.addInstruction((Instruction)new WrapDerivedVariableInstruction(KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType((KtExpression)expr2), (KtElement)expr2), (DerivedVariableDescriptor)SpecialField.UNBOX));
                }
            } else {
                KtExpression ktExpression = selector2;
                if (ktExpression instanceof KtCallExpression) {
                    this.processCallExpression((KtCallExpression)selector2, true);
                } else if (ktExpression instanceof KtSimpleNameExpression) {
                    this.processReferenceExpression((KtSimpleNameExpression)selector2, true);
                } else {
                    this.addInstruction((Instruction)new PopInstruction());
                    this.processExpression(selector2);
                }
            }
            this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
        }
        if (expr2 instanceof KtSafeQualifiedExpression) {
            ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
            this.setOffset(offset2);
            this.addInstruction((Instruction)new PopInstruction());
            this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.NULL, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
            this.setOffset(endOffset2);
        }
    }

    private final boolean pushJavaClassField(KtExpression receiver2, KtExpression selector2, KtQualifiedExpression expr2) {
        if (selector2 == null || !selector2.textMatches((CharSequence)"java")) {
            return false;
        }
        if (!KtDfaHelpersKt.fqNameEquals(KtDfaHelpersKt.getKotlinType(receiver2), "kotlin.reflect.KClass")) {
            return false;
        }
        KotlinType kotlinType = KtDfaHelpersKt.getKotlinType((KtExpression)expr2);
        if (kotlinType == null) {
            return false;
        }
        KotlinType kotlinType2 = kotlinType;
        PsiType psiType = KtDfaHelpersKt.toPsiType(kotlinType2, (KtElement)expr2);
        if (psiType == null) {
            return false;
        }
        PsiType classPsiType = psiType;
        if (!classPsiType.equalsToText("java.lang.Class")) {
            return false;
        }
        this.addInstruction((Instruction)new KotlinClassToJavaClassInstruction(new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2), classPsiType));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SpecialField findSpecialField(KotlinType type2) {
        SpecialField specialField;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    if (type2 == null) return null;
                    if (TypeUtilsKt.isEnum((KotlinType)type2)) {
                        specialField = SpecialField.ENUM_ORDINAL;
                        return specialField;
                    }
                    if (KotlinBuiltIns.isArray((KotlinType)type2) || KotlinBuiltIns.isPrimitiveArray((KotlinType)type2)) {
                        specialField = SpecialField.ARRAY_LENGTH;
                        return specialField;
                    }
                    if (KotlinBuiltIns.isCollectionOrNullableCollection((KotlinType)type2) || KotlinBuiltIns.isMapOrNullableMap((KotlinType)type2)) break block10;
                    Iterable $this$any$iv = TypeUtilsKt.supertypes((KotlinType)type2);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinType st = (KotlinType)element$iv;
                            boolean bl2 = false;
                            if (!(KotlinBuiltIns.isCollectionOrNullableCollection((KotlinType)st) || KotlinBuiltIns.isMapOrNullableMap((KotlinType)st))) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block11;
            }
            specialField = SpecialField.COLLECTION_SIZE;
            return specialField;
        }
        if (!KotlinBuiltIns.isStringOrNullableString((KotlinType)type2)) return null;
        specialField = SpecialField.STRING_LENGTH;
        return specialField;
    }

    private final SpecialField findSpecialField(KtQualifiedExpression expr2) {
        String string;
        KtExpression ktExpression = expr2.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selector2 = ktExpression;
        KtExpression receiver2 = expr2.getReceiverExpression();
        String selectorText = selector2.getText();
        if (Intrinsics.areEqual((Object)selectorText, (Object)"size") ^ true && Intrinsics.areEqual((Object)selectorText, (Object)"length") ^ true && Intrinsics.areEqual((Object)selectorText, (Object)"ordinal") ^ true) {
            return null;
        }
        SpecialField specialField = this.findSpecialField(KtDfaHelpersKt.getKotlinType(receiver2));
        if (specialField == null) {
            return null;
        }
        SpecialField field = specialField;
        if (field == SpecialField.ARRAY_LENGTH) {
            string = "size";
        } else {
            String string2 = field.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.toString()");
        }
        String expectedFieldName = string;
        if (Intrinsics.areEqual((Object)selectorText, (Object)expectedFieldName) ^ true) {
            return null;
        }
        return field;
    }

    private final void processPrefixExpression(KtPrefixExpression expr2) {
        KtExpression operand2 = expr2.getBaseExpression();
        this.processExpression(operand2);
        KotlinAnchor.KotlinExpressionAnchor anchor = new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2);
        if (operand2 != null) {
            DfType dfType = KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType(operand2), (KtElement)expr2);
            DfaVariableValue dfVar = KtVariableDescriptor.Companion.createFromQualified(this.factory, operand2);
            KtSimpleNameExpression ktSimpleNameExpression = expr2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expr.operationReference");
            String ref2 = ktSimpleNameExpression.getText();
            if (dfType instanceof DfIntegralType) {
                String string = ref2;
                if (string != null) {
                    switch (string) {
                        case "++": 
                        case "--": {
                            if (dfVar == null) break;
                            this.addInstruction((Instruction)new PushValueInstruction(((DfIntegralType)dfType).meetRange(LongRangeSet.point((long)1L))));
                            this.addInstruction((Instruction)new NumericBinaryInstruction(Intrinsics.areEqual((Object)ref2, (Object)"++") ? LongRangeBinOp.PLUS : LongRangeBinOp.MINUS, null));
                            this.addInstruction((Instruction)new JvmAssignmentInstruction((DfaAnchor)anchor, dfVar));
                            return;
                        }
                        case "+": {
                            return;
                        }
                        case "-": {
                            this.addInstruction((Instruction)new PushValueInstruction(((DfIntegralType)dfType).meetRange(LongRangeSet.point((long)0L))));
                            this.addInstruction((Instruction)new SwapInstruction());
                            this.addInstruction((Instruction)new NumericBinaryInstruction(LongRangeBinOp.MINUS, (DfaAnchor)anchor));
                            return;
                        }
                    }
                }
            }
            if (dfType instanceof DfBooleanType && Intrinsics.areEqual((Object)ref2, (Object)"!")) {
                this.addInstruction((Instruction)new NotInstruction((DfaAnchor)anchor));
                return;
            }
            if (dfVar != null && (Intrinsics.areEqual((Object)ref2, (Object)"++") || Intrinsics.areEqual((Object)ref2, (Object)"--"))) {
                this.addInstruction((Instruction)new FlushVariableInstruction(dfVar));
            }
        }
        this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)anchor, 1));
    }

    private final void processPostfixExpression(KtPostfixExpression expr2) {
        KtExpression operand2 = expr2.getBaseExpression();
        this.processExpression(operand2);
        KotlinAnchor.KotlinExpressionAnchor anchor = new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2);
        KtSimpleNameExpression ktSimpleNameExpression = expr2.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expr.operationReference");
        String ref2 = ktSimpleNameExpression.getText();
        if (Intrinsics.areEqual((Object)ref2, (Object)"++") || Intrinsics.areEqual((Object)ref2, (Object)"--")) {
            if (operand2 != null) {
                DfType dfType = KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType(operand2), (KtElement)expr2);
                DfaVariableValue dfVar = KtVariableDescriptor.Companion.createFromQualified(this.factory, operand2);
                if (dfVar != null) {
                    if (dfType instanceof DfIntegralType) {
                        this.addInstruction((Instruction)new DupInstruction());
                        this.addInstruction((Instruction)new PushValueInstruction(((DfIntegralType)dfType).meetRange(LongRangeSet.point((long)1L))));
                        this.addInstruction((Instruction)new NumericBinaryInstruction(Intrinsics.areEqual((Object)ref2, (Object)"++") ? LongRangeBinOp.PLUS : LongRangeBinOp.MINUS, null));
                        this.addInstruction((Instruction)new JvmAssignmentInstruction((DfaAnchor)anchor, dfVar));
                        this.addInstruction((Instruction)new PopInstruction());
                    } else {
                        this.addInstruction((Instruction)new FlushVariableInstruction(dfVar));
                    }
                } else {
                    this.addInstruction((Instruction)new FlushFieldsInstruction());
                }
            }
        } else if (Intrinsics.areEqual((Object)ref2, (Object)"!!")) {
            KotlinType operandType;
            DfaControlTransferValue transfer = this.trapTracker.maybeTransferValue("java.lang.NullPointerException");
            KtExpression ktExpression = operand2;
            KotlinType kotlinType = operandType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
            if (kotlinType != null) {
                if (KtDfaHelpersKt.canBeNull(kotlinType)) {
                    this.addInstruction((Instruction)new EnsureInstruction((UnsatisfiedConditionProblem)new KotlinProblem.KotlinNullCheckProblem(expr2), RelationType.NE, (DfType)DfTypes.NULL, transfer));
                    this.addImplicitConversion((KtExpression)expr2, operandType, KtDfaHelpersKt.getKotlinType((KtExpression)expr2));
                }
            }
        } else {
            this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)anchor, 1));
        }
    }

    private final void processDoWhileExpression(KtDoWhileExpression expr2) {
        KtControlFlowBuilder this_$iv = this;
        boolean $i$f$inlinedBlock = false;
        this_$iv.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)((KtElement)expr2)));
        this_$iv.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this_$iv.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
        boolean bl = false;
        ControlFlow.FixedOffset offset2 = new ControlFlow.FixedOffset(this.flow.getInstructionCount());
        this.processExpression(expr2.getBody());
        this.addInstruction((Instruction)new PopInstruction());
        this.processExpression(expr2.getCondition());
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset2, (DfType)DfTypes.TRUE));
        this.flow.finishElement((PsiElement)expr2);
        this_$iv.trapTracker.popTrap(InsideInlinedBlockTrap.class);
        this_$iv.addInstruction((Instruction)new PopInstruction());
        this.pushUnknown();
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr2));
    }

    private final void processWhileExpression(KtWhileExpression expr2) {
        KtControlFlowBuilder this_$iv = this;
        boolean $i$f$inlinedBlock = false;
        this_$iv.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)((KtElement)expr2)));
        this_$iv.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this_$iv.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
        boolean bl = false;
        ControlFlow.FixedOffset startOffset = new ControlFlow.FixedOffset(this.flow.getInstructionCount());
        KtExpression condition2 = expr2.getCondition();
        this.processExpression(condition2);
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)endOffset2, (DfType)DfTypes.FALSE, (PsiElement)condition2));
        this.processExpression(expr2.getBody());
        this.addInstruction((Instruction)new PopInstruction());
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)startOffset));
        this.setOffset(endOffset2);
        this.flow.finishElement((PsiElement)expr2);
        this_$iv.trapTracker.popTrap(InsideInlinedBlockTrap.class);
        this_$iv.addInstruction((Instruction)new PopInstruction());
        this.pushUnknown();
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr2));
    }

    private final void processForExpression(KtForExpression expr2) {
        KtControlFlowBuilder this_$iv = this;
        boolean $i$f$inlinedBlock = false;
        this_$iv.trapTracker.pushTrap((DfaControlTransferValue.Trap)new InsideInlinedBlockTrap((PsiElement)((KtElement)expr2)));
        this_$iv.addInstruction((Instruction)new JvmPushInstruction((DfaValue)this_$iv.getFactory().controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
        boolean bl = false;
        KtParameter parameter = expr2.getLoopParameter();
        if (parameter == null) {
            this.broken = true;
        } else {
            DfaVariableValue dfaVariableValue = this.factory.getVarFactory().createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)parameter));
            Intrinsics.checkNotNullExpressionValue((Object)dfaVariableValue, (String)"factory.varFactory.creat\u2026bleDescriptor(parameter))");
            DfaVariableValue parameterVar = dfaVariableValue;
            KotlinType parameterType = MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)parameter);
            Function0<Unit> pushLoopCondition = this.processForRange(expr2, parameterVar, parameterType);
            ControlFlow.FixedOffset startOffset = new ControlFlow.FixedOffset(this.flow.getInstructionCount());
            ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
            this.flushParameter(parameter);
            pushLoopCondition.invoke();
            this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)endOffset2, (DfType)DfTypes.FALSE));
            this.processExpression(expr2.getBody());
            this.addInstruction((Instruction)new PopInstruction());
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)startOffset));
            this.setOffset(endOffset2);
            this.flow.finishElement((PsiElement)expr2);
        }
        this_$iv.trapTracker.popTrap(InsideInlinedBlockTrap.class);
        this_$iv.addInstruction((Instruction)new PopInstruction());
        this.pushUnknown();
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr2));
    }

    private final void flushParameter(KtParameter parameter) {
        KtDestructuringDeclaration destructuringDeclaration = parameter.getDestructuringDeclaration();
        if (destructuringDeclaration != null) {
            for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                DfaVariableValue.Factory factory2 = this.factory.getVarFactory();
                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry;
                Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"entry");
                this.addInstruction((Instruction)new FlushVariableInstruction(factory2.createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)ktDestructuringDeclarationEntry))));
            }
        } else {
            this.addInstruction((Instruction)new FlushVariableInstruction(this.factory.getVarFactory().createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)parameter))));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Function0<Unit> processForRange(KtForExpression expr, DfaVariableValue parameterVar, KotlinType parameterType) {
        block13: {
            range = expr.getLoopRange();
            if (!(parameterVar.getDfType() instanceof DfIntegralType) || !(range instanceof KtBinaryExpression)) break block13;
            v0 = ((KtBinaryExpression)range).getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"range.operationReference");
            v1 = ref = v0.getText();
            if (v1 == null) ** GOTO lbl-1000
            var9_6 = v1;
            tmp = -1;
            switch (var9_6.hashCode()) {
                case 1472: {
                    if (!var9_6.equals("..")) break;
                    tmp = 1;
                    break;
                }
                case -1325887811: {
                    if (!var9_6.equals("downTo")) break;
                    tmp = 2;
                    break;
                }
                case 111443806: {
                    if (!var9_6.equals("until")) break;
                    tmp = 3;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v2 = TuplesKt.to((Object)RelationType.GE, (Object)RelationType.LE);
                    break;
                }
                case 3: {
                    v2 = TuplesKt.to((Object)RelationType.GE, (Object)RelationType.LT);
                    break;
                }
                case 2: {
                    v2 = TuplesKt.to((Object)RelationType.LE, (Object)RelationType.GE);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v2 = TuplesKt.to(null, null);
                }
            }
            var8_7 = v2;
            var6_8 = (RelationType)var8_7.component1();
            rightRelation = (RelationType)var8_7.component2();
            if (leftRelation != null && rightRelation != null) {
                left = ((KtBinaryExpression)range).getLeft();
                right = ((KtBinaryExpression)range).getRight();
                v3 = left;
                leftType = v3 != null ? KtDfaHelpersKt.getKotlinType(v3) : null;
                v4 = right;
                v5 /* !! */  = rightType = v4 != null ? KtDfaHelpersKt.getKotlinType(v4) : null;
                if (KtDfaHelpersKt.toDfType(leftType, (KtElement)range) instanceof DfIntegralType && KtDfaHelpersKt.toDfType(rightType, (KtElement)range) instanceof DfIntegralType) {
                    this.processExpression(left);
                    v6 = this.flow.createTempVariable(parameterVar.getDfType());
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"flow.createTempVariable(parameterVar.dfType)");
                    leftVar = v6;
                    this.addImplicitConversion(left, parameterType);
                    this.addInstruction((Instruction)new JvmAssignmentInstruction(null, leftVar));
                    this.addInstruction((Instruction)new PopInstruction());
                    this.processExpression(right);
                    v7 = this.flow.createTempVariable(parameterVar.getDfType());
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"flow.createTempVariable(parameterVar.dfType)");
                    rightVar = v7;
                    this.addImplicitConversion(right, parameterType);
                    this.addInstruction((Instruction)new JvmAssignmentInstruction(null, rightVar));
                    this.addInstruction((Instruction)new PopInstruction());
                    return (Function0)new Function0<Unit>(this, expr, parameterVar, leftVar, (RelationType)leftRelation, rightVar, rightRelation){
                        final /* synthetic */ KtControlFlowBuilder this$0;
                        final /* synthetic */ KtForExpression $expr;
                        final /* synthetic */ DfaVariableValue $parameterVar;
                        final /* synthetic */ DfaVariableValue $leftVar;
                        final /* synthetic */ RelationType $leftRelation;
                        final /* synthetic */ DfaVariableValue $rightVar;
                        final /* synthetic */ RelationType $rightRelation;

                        public final void invoke() {
                            KotlinAnchor.KotlinForVisitedAnchor forAnchor = new KotlinAnchor.KotlinForVisitedAnchor(this.$expr);
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new JvmPushInstruction((DfaValue)this.$parameterVar, null));
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new JvmPushInstruction((DfaValue)this.$leftVar, null));
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new BooleanBinaryInstruction(this.$leftRelation, false, null));
                            ControlFlow.DeferredOffset offset2 = new ControlFlow.DeferredOffset();
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset2, (DfType)DfTypes.FALSE));
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new JvmPushInstruction((DfaValue)this.$parameterVar, null));
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new JvmPushInstruction((DfaValue)this.$rightVar, null));
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new BooleanBinaryInstruction(this.$rightRelation, false, (DfaAnchor)forAnchor));
                            ControlFlow.DeferredOffset finalOffset = new ControlFlow.DeferredOffset();
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)finalOffset));
                            KtControlFlowBuilder.access$setOffset(this.this$0, offset2);
                            KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new PushValueInstruction((DfType)DfTypes.FALSE, (DfaAnchor)forAnchor));
                            KtControlFlowBuilder.access$setOffset(this.this$0, finalOffset);
                        }
                        {
                            this.this$0 = ktControlFlowBuilder;
                            this.$expr = ktForExpression;
                            this.$parameterVar = dfaVariableValue;
                            this.$leftVar = dfaVariableValue2;
                            this.$leftRelation = relationType;
                            this.$rightVar = dfaVariableValue3;
                            this.$rightRelation = relationType2;
                            super(0);
                        }
                    };
                }
            }
        }
        this.processExpression(range);
        if (range != null && (lengthField = this.findSpecialField(kotlinType = KtDfaHelpersKt.getKotlinType(range))) != null) {
            v8 = this.flow.createTempVariable(KtDfaHelpersKt.toDfType(kotlinType, (KtElement)range));
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"flow.createTempVariable(\u2026tlinType.toDfType(range))");
            collectionVar = v8;
            this.addInstruction((Instruction)new JvmAssignmentInstruction(null, collectionVar));
            this.addInstruction((Instruction)new PopInstruction());
            return (Function0)new Function0<Unit>(this, lengthField, collectionVar, expr){
                final /* synthetic */ KtControlFlowBuilder this$0;
                final /* synthetic */ SpecialField $lengthField;
                final /* synthetic */ DfaVariableValue $collectionVar;
                final /* synthetic */ KtForExpression $expr;

                public final void invoke() {
                    KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new JvmPushInstruction(this.$lengthField.createValue(this.this$0.getFactory(), (DfaValue)this.$collectionVar), null));
                    KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new PushValueInstruction((DfType)DfTypes.intValue((int)0)));
                    KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new BooleanBinaryInstruction(RelationType.GT, false, null));
                    KtControlFlowBuilder.access$pushUnknown(this.this$0);
                    KtControlFlowBuilder.access$addInstruction(this.this$0, (Instruction)new BooleanAndOrInstruction(false, (DfaAnchor)new KotlinAnchor.KotlinForVisitedAnchor(this.$expr)));
                }
                {
                    this.this$0 = ktControlFlowBuilder;
                    this.$lengthField = specialField;
                    this.$collectionVar = dfaVariableValue;
                    this.$expr = ktForExpression;
                    super(0);
                }
            };
        }
        this.addInstruction((Instruction)new PopInstruction());
        return (Function0)new Function0<Unit>(this){
            final /* synthetic */ KtControlFlowBuilder this$0;

            public final void invoke() {
                KtControlFlowBuilder.access$pushUnknown(this.this$0);
            }
            {
                this.this$0 = ktControlFlowBuilder;
                super(0);
            }
        };
    }

    private final void processBlock(KtBlockExpression expr2) {
        List list2 = expr2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expr.statements");
        List statements2 = list2;
        if (statements2.isEmpty()) {
            this.pushUnknown();
        } else {
            for (KtExpression child : statements2) {
                this.processExpression(child);
                if (Intrinsics.areEqual((Object)child, (Object)((KtExpression)CollectionsKt.last((List)statements2))) ^ true) {
                    this.addInstruction((Instruction)new PopInstruction());
                }
                if (!this.broken) continue;
                return;
            }
            this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr2));
        }
    }

    private final void processDeclaration(KtProperty variable2) {
        KtExpression initializer2 = variable2.getInitializer();
        if (initializer2 == null) {
            this.pushUnknown();
            return;
        }
        DfaVariableValue dfaVariableValue = this.factory.getVarFactory().createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)variable2));
        Intrinsics.checkNotNullExpressionValue((Object)dfaVariableValue, (String)"factory.varFactory.creat\u2026ableDescriptor(variable))");
        DfaVariableValue dfaVariable = dfaVariableValue;
        if (variable2.isLocal() && !variable2.isVar()) {
            KotlinType kotlinType = MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)variable2);
            if (kotlinType != null) {
                if (TypeUtilsKt.isBoolean((KotlinType)kotlinType)) {
                    ASTNode aSTNode = initializer2.getNode();
                    if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
                        this.pushUnknown();
                        return;
                    }
                }
            }
        }
        this.processExpression(initializer2);
        this.addImplicitConversion(initializer2, MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)variable2));
        this.addInstruction((Instruction)new JvmAssignmentInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)variable2), dfaVariable));
    }

    private final void processReturnExpression(KtReturnExpression expr2) {
        KtCallableDeclaration targetFunction;
        KtExpression returnedExpression = expr2.getReturnedExpression();
        this.processExpression(returnedExpression);
        if (expr2.getLabeledExpression() != null && (targetFunction = BindingContextUtilsKt.getTargetFunction((KtReturnExpression)expr2, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)expr2), (BodyResolveMode)BodyResolveMode.FULL))) != null && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)this.context), (PsiElement)((PsiElement)targetFunction), (boolean)true)) {
            InstructionTransfer transfer = null;
            if (returnedExpression != null) {
                DfaVariableValue dfaVariableValue = this.flow.createTempVariable(KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType(returnedExpression), (KtElement)expr2));
                Intrinsics.checkNotNullExpressionValue((Object)dfaVariableValue, (String)"flow.createTempVariable(\u2026linType().toDfType(expr))");
                DfaVariableValue retVar = dfaVariableValue;
                this.addInstruction((Instruction)new JvmAssignmentInstruction(null, retVar));
                transfer = KtControlFlowBuilder.createTransfer$default(this, (PsiElement)targetFunction, (PsiElement)targetFunction, (DfaValue)retVar, false, 8, null);
            } else {
                PsiElement psiElement2 = (PsiElement)targetFunction;
                PsiElement psiElement3 = (PsiElement)targetFunction;
                DfaTypeValue dfaTypeValue = this.factory.getUnknown();
                Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"factory.unknown");
                transfer = KtControlFlowBuilder.createTransfer$default(this, psiElement2, psiElement3, (DfaValue)dfaTypeValue, false, 8, null);
            }
            this.addInstruction((Instruction)new ControlTransferInstruction(this.factory.controlTransfer((DfaControlTransferValue.TransferTarget)transfer, this.trapTracker.getTrapsInsideElement((PsiElement)targetFunction))));
            return;
        }
        this.addInstruction((Instruction)new ReturnInstruction(this.factory, this.trapTracker.trapStack(), (PsiElement)expr2));
    }

    private final void controlTransfer(DfaControlTransferValue.TransferTarget target2, FList<DfaControlTransferValue.Trap> traps) {
        this.addInstruction((Instruction)new ControlTransferInstruction(this.factory.controlTransfer(target2, traps)));
    }

    /*
     * WARNING - void declaration
     */
    private final InstructionTransfer createTransfer(PsiElement exitedStatement, PsiElement blockToFlush, DfaValue resultValue, boolean exitBlock) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)blockToFlush, KtProperty.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"PsiTreeUtil.findChildren\u2026rty::class.java\n        )");
        Iterable iterable = collection;
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void property2;
            KtProperty ktProperty = (KtProperty)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = property2;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"property");
            KtVariableDescriptor ktVariableDescriptor = new KtVariableDescriptor((KtCallableDeclaration)v1);
            collection2.add(ktVariableDescriptor);
        }
        List varsToFlush = (List)destination$iv$iv;
        return new InstructionTransfer(this, exitBlock, resultValue, exitedStatement, varsToFlush, this.flow.getEndOffset(exitedStatement), varsToFlush){
            final /* synthetic */ KtControlFlowBuilder this$0;
            final /* synthetic */ boolean $exitBlock;
            final /* synthetic */ DfaValue $resultValue;
            final /* synthetic */ PsiElement $exitedStatement;
            final /* synthetic */ List $varsToFlush;

            @NotNull
            public List<DfaInstructionState> dispatch(@NotNull DfaMemoryState state2, @NotNull DataFlowInterpreter interpreter) {
                Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
                if (this.$exitBlock) {
                    DfaValue dfaValue = state2.pop();
                    Intrinsics.checkNotNullExpressionValue((Object)dfaValue, (String)"state.pop()");
                    DfaValue value2 = dfaValue;
                    boolean bl = value2 instanceof DfaControlTransferValue && ((DfaControlTransferValue)value2).getTarget() == DfaControlTransferValue.RETURN_TRANSFER;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Expected control transfer on stack; got " + value2;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
                state2.push(this.$resultValue);
                List list2 = super.dispatch(state2, interpreter);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"super.dispatch(state, interpreter)");
                return list2;
            }

            @NotNull
            public String toString() {
                return super.toString() + "; result = " + this.$resultValue;
            }
            {
                this.this$0 = this$0;
                this.$exitBlock = $captured_local_variable$1;
                this.$resultValue = $captured_local_variable$2;
                this.$exitedStatement = $captured_local_variable$3;
                this.$varsToFlush = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6);
            }
        };
    }

    static /* synthetic */ InstructionTransfer createTransfer$default(KtControlFlowBuilder ktControlFlowBuilder, PsiElement psiElement2, PsiElement psiElement3, DfaValue dfaValue, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return ktControlFlowBuilder.createTransfer(psiElement2, psiElement3, dfaValue, bl);
    }

    private final void processLabeledJumpExpression(KtExpressionWithLabel expr2) {
        KtLoopExpression targetLoop = CommonUtilsKt.targetLoop$default(expr2, null, 1, null);
        if (targetLoop == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)this.context), (PsiElement)((PsiElement)targetLoop), (boolean)false)) {
            this.addInstruction((Instruction)new ControlTransferInstruction(this.trapTracker.transferValue(DfaControlTransferValue.RETURN_TRANSFER)));
        } else {
            KtExpression ktExpression;
            if (expr2 instanceof KtBreakExpression) {
                ktExpression = (KtExpression)targetLoop;
            } else {
                KtExpression ktExpression2 = targetLoop.getBody();
                ktExpression = ktExpression2;
                Intrinsics.checkNotNull((Object)ktExpression2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"if (expr is KtBreakExpre\u2026op else targetLoop.body!!");
            KtExpression body2 = ktExpression;
            PsiElement psiElement2 = (PsiElement)body2;
            PsiElement psiElement3 = (PsiElement)body2;
            DfaTypeValue dfaTypeValue = this.factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"factory.unknown");
            DfaControlTransferValue dfaControlTransferValue = this.factory.controlTransfer((DfaControlTransferValue.TransferTarget)KtControlFlowBuilder.createTransfer$default(this, psiElement2, psiElement3, (DfaValue)dfaTypeValue, false, 8, null), this.trapTracker.getTrapsInsideElement((PsiElement)body2));
            Intrinsics.checkNotNullExpressionValue((Object)dfaControlTransferValue, (String)"factory.controlTransfer(\u2026TrapsInsideElement(body))");
            DfaControlTransferValue transfer = dfaControlTransferValue;
            this.addInstruction((Instruction)new ControlTransferInstruction(transfer));
        }
    }

    private final void processThrowExpression(KtThrowExpression expr2) {
        KtExpression exception = expr2.getThrownExpression();
        this.processExpression(exception);
        this.addInstruction((Instruction)new PopInstruction());
        if (exception != null) {
            PsiType psiType;
            KotlinType kotlinType = KtDfaHelpersKt.getKotlinType(exception);
            PsiType psiType2 = psiType = kotlinType != null ? KtDfaHelpersKt.toPsiType(kotlinType, (KtElement)expr2) : null;
            if (psiType != null) {
                ExceptionTransfer kind2 = new ExceptionTransfer(TypeConstraints.instanceOf((PsiType)psiType));
                this.addInstruction((Instruction)new ThrowInstruction(this.trapTracker.transferValue((DfaControlTransferValue.TransferTarget)kind2), (PsiElement)expr2));
                return;
            }
        }
        this.pushUnknown();
    }

    private final void processReferenceExpression(KtSimpleNameExpression expr2, boolean qualifierOnStack) {
        DfaVariableValue dfVar = KtVariableDescriptor.Companion.createFromSimpleName(this.factory, (KtExpression)expr2);
        if (dfVar != null) {
            PsiElement parent2;
            if (qualifierOnStack) {
                this.addInstruction((Instruction)new PopInstruction());
            }
            this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)dfVar, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
            KtExpression realExpr = (KtExpression)expr2;
            while ((parent2 = realExpr.getParent()) instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getSelectorExpression(), (Object)realExpr)) {
                realExpr = (KtExpression)parent2;
            }
            KotlinType exprType = KtDfaHelpersKt.getKotlinType(realExpr);
            VariableDescriptor variableDescriptor = dfVar.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)variableDescriptor, (String)"dfVar.descriptor");
            VariableDescriptor desc2 = variableDescriptor;
            KotlinType declaredType = desc2 instanceof KtVariableDescriptor ? MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)((KtVariableDescriptor)desc2).getVariable()) : (desc2 instanceof KtItVariableDescriptor ? ((KtItVariableDescriptor)desc2).getType() : null);
            this.addImplicitConversion((KtExpression)expr2, declaredType, exprType);
            return;
        }
        PsiElement target2 = ReferenceUtilsKt.getMainReference(expr2).resolve();
        DfType value2 = this.getReferenceValue((KtExpression)expr2, target2);
        if (value2 != null) {
            if (qualifierOnStack) {
                this.addInstruction((Instruction)new PopInstruction());
            }
            this.addInstruction((Instruction)new PushValueInstruction(value2, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
        } else {
            this.addCall((KtExpression)expr2, 0, qualifierOnStack);
        }
    }

    static /* synthetic */ void processReferenceExpression$default(KtControlFlowBuilder ktControlFlowBuilder, KtSimpleNameExpression ktSimpleNameExpression, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ktControlFlowBuilder.processReferenceExpression(ktSimpleNameExpression, bl);
    }

    private final DfType getReferenceValue(KtExpression expr2, PsiElement target2) {
        DfType dfType;
        PsiElement psiElement2 = target2;
        if (psiElement2 instanceof KtObjectDeclaration) {
            dfType = DfType.TOP;
        } else if (psiElement2 instanceof PsiClass) {
            dfType = DfType.TOP;
        } else if (psiElement2 instanceof PsiVariable) {
            Object constantValue = ((PsiVariable)target2).computeConstantValue();
            if (constantValue != null && !(constantValue instanceof Boolean)) {
                DfConstantType dfConstantType = DfTypes.constant((Object)constantValue, (PsiType)((PsiVariable)target2).getType());
                Intrinsics.checkNotNullExpressionValue((Object)dfConstantType, (String)"DfTypes.constant(constantValue, target.type)");
                dfType = (DfType)dfConstantType;
            } else {
                dfType = KtDfaHelpersKt.toDfType(KtDfaHelpersKt.getKotlinType(expr2), (KtElement)expr2);
            }
        } else if (psiElement2 instanceof KtEnumEntry) {
            PsiField enumConstant;
            PsiField[] enumClass;
            block13: {
                PsiField psiField;
                KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)target2));
                PsiField[] psiFieldArray = enumClass = ktClass2 != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass2)) : null;
                if (enumClass != null && (psiFieldArray = psiFieldArray.getFields()) != null) {
                    PsiField[] $this$firstOrNull$iv = psiFieldArray;
                    boolean $i$f$firstOrNull = false;
                    PsiField[] psiFieldArray2 = $this$firstOrNull$iv;
                    int n = psiFieldArray2.length;
                    for (int j = 0; j < n; ++j) {
                        PsiField element$iv;
                        PsiField f2 = element$iv = psiFieldArray2[j];
                        boolean bl = false;
                        if (!(f2 instanceof PsiEnumConstant && Intrinsics.areEqual((Object)((PsiEnumConstant)f2).getName(), (Object)((KtEnumEntry)target2).getName()))) continue;
                        psiField = element$iv;
                        break block13;
                    }
                    psiField = null;
                } else {
                    psiField = enumConstant = null;
                }
            }
            dfType = enumConstant != null ? (DfType)DfTypes.referenceConstant(enumConstant, (TypeConstraint)TypeConstraints.exactClass((PsiClass)((PsiClass)enumClass)).instanceOf()) : DfType.TOP;
        } else {
            dfType = null;
        }
        return dfType;
    }

    private final void processConstantExpression(KtConstantExpression expr2) {
        this.addInstruction((Instruction)new PushValueInstruction(KtDfaHelpersKt.getConstant(expr2), (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
    }

    private final void pushUnknown() {
        this.addInstruction((Instruction)new PushValueInstruction(DfType.TOP));
    }

    private final void processBinaryExpression(KtBinaryExpression expr2) {
        KtExpression left;
        KotlinType leftKtType;
        IElementType token;
        block11: {
            block12: {
                IElementType iElementType = expr2.getOperationToken();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expr.operationToken");
                token = iElementType;
                RelationType relation = KtDfaHelpersKt.relationFromToken(token);
                if (relation != null) {
                    this.processBinaryRelationExpression(expr2, relation, Intrinsics.areEqual((Object)token, (Object)KtTokens.EXCLEQ) || Intrinsics.areEqual((Object)token, (Object)KtTokens.EQEQ));
                    return;
                }
                KtExpression ktExpression = expr2.getLeft();
                Object object = leftKtType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
                if (token != KtTokens.PLUS) break block11;
                if (KotlinBuiltIns.isString((KotlinType)leftKtType)) break block12;
                KtExpression ktExpression2 = expr2.getRight();
                if (!KotlinBuiltIns.isString((KotlinType)(ktExpression2 != null ? KtDfaHelpersKt.getKotlinType(ktExpression2) : null))) break block11;
            }
            this.processExpression(expr2.getLeft());
            this.processExpression(expr2.getRight());
            this.addInstruction((Instruction)new StringConcatInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2), (PsiType)this.stringType));
            return;
        }
        KotlinType kotlinType = leftKtType;
        if ((kotlinType != null ? KtDfaHelpersKt.toDfType(kotlinType, (KtElement)expr2) : null) instanceof DfIntegralType) {
            KtOperationReferenceExpression ktOperationReferenceExpression = expr2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expr.operationReference");
            LongRangeBinOp mathOp = KtDfaHelpersKt.mathOpFromToken(ktOperationReferenceExpression);
            if (mathOp != null) {
                this.processMathExpression(expr2, mathOp);
                return;
            }
        }
        if (token == KtTokens.ANDAND || token == KtTokens.OROR) {
            this.processShortCircuitExpression(expr2, token == KtTokens.ANDAND);
            return;
        }
        if (ASSIGNMENT_TOKENS.contains(token)) {
            this.processAssignmentExpression(expr2);
            return;
        }
        if (token == KtTokens.ELVIS) {
            this.processNullSafeOperator(expr2);
            return;
        }
        if (token == KtTokens.IN_KEYWORD) {
            left = expr2.getLeft();
            this.processExpression(left);
            KtExpression ktExpression = left;
            this.processInCheck((KotlinType)(ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null), expr2.getRight(), new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2), false);
            return;
        }
        if (token == KtTokens.NOT_IN) {
            left = expr2.getLeft();
            this.processExpression(left);
            KtExpression ktExpression = left;
            this.processInCheck((KotlinType)(ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null), expr2.getRight(), new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2), true);
            return;
        }
        this.processExpression(expr2.getLeft());
        this.processExpression(expr2.getRight());
        KtControlFlowBuilder.addCall$default(this, (KtExpression)expr2, 2, false, 4, null);
    }

    private final void processInCheck(KotlinType kotlinType, KtExpression range, KotlinAnchor anchor, boolean negated) {
        if (kotlinType != null && (TypeUtilsKt.isInt((KotlinType)kotlinType) || TypeUtilsKt.isLong((KotlinType)kotlinType)) && range instanceof KtBinaryExpression) {
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)range).getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"range.operationReference");
            String ref2 = ktOperationReferenceExpression.getText();
            if (Intrinsics.areEqual((Object)ref2, (Object)"..") || Intrinsics.areEqual((Object)ref2, (Object)"until")) {
                KotlinType rightType2;
                KtExpression left = ((KtBinaryExpression)range).getLeft();
                KtExpression right2 = ((KtBinaryExpression)range).getRight();
                KtExpression ktExpression = left;
                KotlinType leftType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
                KtExpression ktExpression2 = right2;
                Object object = rightType2 = ktExpression2 != null ? KtDfaHelpersKt.getKotlinType(ktExpression2) : null;
                if (KtDfaHelpersKt.toDfType(leftType, (KtElement)range) instanceof DfIntegralType && KtDfaHelpersKt.toDfType(rightType2, (KtElement)range) instanceof DfIntegralType) {
                    RelationType relationType;
                    this.processExpression(left);
                    this.addImplicitConversion(left, kotlinType);
                    this.processExpression(right2);
                    this.addImplicitConversion(right2, kotlinType);
                    this.addInstruction((Instruction)new SpliceInstruction(3, new int[]{2, 0, 2, 1}));
                    this.addInstruction((Instruction)new BooleanBinaryInstruction(RelationType.GE, false, null));
                    ControlFlow.DeferredOffset offset2 = new ControlFlow.DeferredOffset();
                    this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset2, (DfType)DfTypes.FALSE));
                    RelationType relationType2 = relationType = Intrinsics.areEqual((Object)ref2, (Object)"until") ? RelationType.LT : RelationType.LE;
                    if (negated) {
                        RelationType relationType3 = relationType.getNegated();
                        Intrinsics.checkNotNullExpressionValue((Object)relationType3, (String)"relationType.negated");
                        relationType = relationType3;
                    }
                    this.addInstruction((Instruction)new BooleanBinaryInstruction(relationType, false, (DfaAnchor)anchor));
                    ControlFlow.DeferredOffset finalOffset = new ControlFlow.DeferredOffset();
                    this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)finalOffset));
                    this.setOffset(offset2);
                    this.addInstruction((Instruction)new SpliceInstruction(2, new int[0]));
                    this.addInstruction((Instruction)new PushValueInstruction((DfType)(negated ? DfTypes.TRUE : DfTypes.FALSE), (DfaAnchor)anchor));
                    this.setOffset(finalOffset);
                    return;
                }
            }
        }
        this.processExpression(range);
        this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)anchor, 2));
        this.addInstruction((Instruction)new FlushFieldsInstruction());
    }

    private final void processNullSafeOperator(KtBinaryExpression expr2) {
        KtExpression left = expr2.getLeft();
        this.processExpression(left);
        this.addInstruction((Instruction)new DupInstruction());
        ControlFlow.DeferredOffset offset2 = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)offset2, (DfType)DfTypes.NULL));
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        KtExpression ktExpression = left;
        this.addImplicitConversion((KtExpression)expr2, (KotlinType)(ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null), KtDfaHelpersKt.getKotlinType((KtExpression)expr2));
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
        this.setOffset(offset2);
        this.addInstruction((Instruction)new PopInstruction());
        this.processExpression(expr2.getRight());
        this.setOffset(endOffset2);
        this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
    }

    private final void processAssignmentExpression(KtBinaryExpression expr2) {
        KotlinType rightType2;
        KtExpression left = expr2.getLeft();
        KtExpression right2 = expr2.getRight();
        IElementType iElementType = expr2.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expr.operationToken");
        IElementType token = iElementType;
        if (left instanceof KtArrayAccessExpression && Intrinsics.areEqual((Object)token, (Object)KtTokens.EQ)) {
            this.processArrayAccess((KtArrayAccessExpression)left, right2);
            return;
        }
        DfaVariableValue dfVar = KtVariableDescriptor.Companion.createFromQualified(this.factory, left);
        KtExpression ktExpression = left;
        KotlinType leftType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
        KtExpression ktExpression2 = right2;
        Object object = rightType2 = ktExpression2 != null ? KtDfaHelpersKt.getKotlinType(ktExpression2) : null;
        if (dfVar == null) {
            this.processExpression(left);
            this.addInstruction((Instruction)new PopInstruction());
            this.processExpression(right2);
            this.addImplicitConversion(right2, leftType);
            this.addInstruction((Instruction)new FlushFieldsInstruction());
            return;
        }
        LongRangeBinOp mathOp = KtDfaHelpersKt.mathOpFromAssignmentToken(token);
        if (mathOp != null) {
            KotlinType resultType = this.balanceType(leftType, rightType2);
            this.processExpression(left);
            this.addImplicitConversion(left, resultType);
            this.processExpression(right2);
            this.addImplicitConversion(right2, resultType);
            this.addInstruction((Instruction)new NumericBinaryInstruction(mathOp, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
            this.addImplicitConversion(right2, resultType, leftType);
        } else {
            this.processExpression(right2);
            this.addImplicitConversion(right2, leftType);
        }
        this.addInstruction((Instruction)new JvmAssignmentInstruction((DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2), dfVar));
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr2));
    }

    private final void processShortCircuitExpression(KtBinaryExpression expr2, boolean and2) {
        KtExpression left = expr2.getLeft();
        KtExpression right2 = expr2.getRight();
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        this.processExpression(left);
        ControlFlow.DeferredOffset nextOffset = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)nextOffset, (DfType)DfTypes.booleanValue((boolean)and2), (PsiElement)left));
        KotlinAnchor.KotlinExpressionAnchor anchor = new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2);
        this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.booleanValue((!and2 ? 1 : 0) != 0), (DfaAnchor)anchor));
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
        this.setOffset(nextOffset);
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        this.processExpression(right2);
        this.setOffset(endOffset2);
        this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)anchor));
    }

    private final void processMathExpression(KtBinaryExpression expr2, LongRangeBinOp mathOp) {
        KtExpression left = expr2.getLeft();
        KtExpression right2 = expr2.getRight();
        KotlinType resultType = KtDfaHelpersKt.getKotlinType((KtExpression)expr2);
        this.processExpression(left);
        this.addImplicitConversion(left, resultType);
        this.processExpression(right2);
        if (!mathOp.isShift()) {
            this.addImplicitConversion(right2, resultType);
        }
        if ((mathOp == LongRangeBinOp.DIV || mathOp == LongRangeBinOp.MOD) && resultType != null && (TypeUtilsKt.isLong((KotlinType)resultType) || TypeUtilsKt.isInt((KotlinType)resultType))) {
            DfType dfType;
            DfaControlTransferValue transfer = this.trapTracker.maybeTransferValue("java.lang.ArithmeticException");
            if (TypeUtilsKt.isLong((KotlinType)resultType)) {
                DfLongConstantType dfLongConstantType = DfTypes.longValue((long)0L);
                Intrinsics.checkNotNullExpressionValue((Object)dfLongConstantType, (String)"DfTypes.longValue(0)");
                dfType = (DfType)dfLongConstantType;
            } else {
                DfIntConstantType dfIntConstantType = DfTypes.intValue((int)0);
                Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(0)");
                dfType = (DfType)dfIntConstantType;
            }
            DfType zero = dfType;
            this.addInstruction((Instruction)new EnsureInstruction(null, RelationType.NE, zero, transfer, true));
        }
        this.addInstruction((Instruction)new NumericBinaryInstruction(mathOp, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
    }

    private final void addImplicitConversion(KtExpression expression2, KotlinType expectedType) {
        KtExpression ktExpression = expression2;
        this.addImplicitConversion(expression2, (KotlinType)(ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null), expectedType);
    }

    private final void addImplicitConversion(KtExpression expression2, KotlinType actualType, KotlinType expectedType) {
        if (expression2 == null) {
            return;
        }
        if (actualType == null) {
            return;
        }
        if (expectedType == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)actualType, (Object)expectedType)) {
            return;
        }
        PsiType actualPsiType = KtDfaHelpersKt.toPsiType(actualType, (KtElement)expression2);
        PsiType expectedPsiType = KtDfaHelpersKt.toPsiType(expectedType, (KtElement)expression2);
        if (!(actualPsiType instanceof PsiPrimitiveType) && expectedPsiType instanceof PsiPrimitiveType) {
            this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.UNBOX));
        } else if (!(expectedPsiType instanceof PsiPrimitiveType) && actualPsiType instanceof PsiPrimitiveType) {
            PsiClassType boxedType = ((PsiPrimitiveType)actualPsiType).getBoxedType((PsiElement)expression2);
            DfType dfType = boxedType != null ? DfTypes.typedObject((PsiType)((PsiType)boxedType), (Nullability)Nullability.NOT_NULL) : (DfType)DfTypes.NOT_NULL_OBJECT;
            this.addInstruction((Instruction)new WrapDerivedVariableInstruction(KtDfaHelpersKt.toDfType(expectedType, (KtElement)expression2).meet(dfType), (DerivedVariableDescriptor)SpecialField.UNBOX));
        }
        if (actualPsiType instanceof PsiPrimitiveType && expectedPsiType instanceof PsiPrimitiveType) {
            this.addInstruction((Instruction)new PrimitiveConversionInstruction((PsiPrimitiveType)expectedPsiType, null));
        }
    }

    private final void processBinaryRelationExpression(KtBinaryExpression expr2, RelationType relation, boolean forceEqualityByContent) {
        KtExpression left = expr2.getLeft();
        KtExpression right2 = expr2.getRight();
        KtExpression ktExpression = left;
        KotlinType leftType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
        KtExpression ktExpression2 = right2;
        KotlinType rightType2 = ktExpression2 != null ? KtDfaHelpersKt.getKotlinType(ktExpression2) : null;
        this.processExpression(left);
        DfType leftDfType = KtDfaHelpersKt.toDfType(leftType, (KtElement)expr2);
        DfType rightDfType = KtDfaHelpersKt.toDfType(rightType2, (KtElement)expr2);
        if (relation == RelationType.EQ || relation == RelationType.NE || leftDfType instanceof DfPrimitiveType && rightDfType instanceof DfPrimitiveType) {
            KotlinType balancedType = this.balanceType(leftType, rightType2, forceEqualityByContent);
            this.addImplicitConversion(left, balancedType);
            this.processExpression(right2);
            this.addImplicitConversion(right2, balancedType);
            if (forceEqualityByContent && !this.mayCompareByContent(leftDfType, rightDfType)) {
                DfaControlTransferValue transfer = this.trapTracker.maybeTransferValue("java.lang.Throwable");
                this.addInstruction((Instruction)new KotlinEqualityInstruction((KtExpression)expr2, relation != RelationType.EQ, transfer));
            } else {
                this.addInstruction((Instruction)new BooleanBinaryInstruction(relation, forceEqualityByContent, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
            }
        } else {
            TypeConstraint typeConstraint = TypeConstraint.fromDfType((DfType)leftDfType);
            Intrinsics.checkNotNullExpressionValue((Object)typeConstraint, (String)"TypeConstraint.fromDfType(leftDfType)");
            TypeConstraint leftConstraint = typeConstraint;
            TypeConstraint typeConstraint2 = TypeConstraint.fromDfType((DfType)rightDfType);
            Intrinsics.checkNotNullExpressionValue((Object)typeConstraint2, (String)"TypeConstraint.fromDfType(rightDfType)");
            TypeConstraint rightConstraint = typeConstraint2;
            if (leftConstraint.isEnum() && rightConstraint.isEnum() && Intrinsics.areEqual((Object)leftConstraint.meet(rightConstraint), (Object)TypeConstraints.BOTTOM) ^ true) {
                this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.ENUM_ORDINAL));
                this.processExpression(right2);
                this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.ENUM_ORDINAL));
                this.addInstruction((Instruction)new BooleanBinaryInstruction(relation, forceEqualityByContent, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
            } else if (leftConstraint.isExact("java.lang.String") && rightConstraint.isExact("java.lang.String")) {
                this.processExpression(right2);
                this.addInstruction((Instruction)new BooleanBinaryInstruction(relation, forceEqualityByContent, (DfaAnchor)new KotlinAnchor.KotlinExpressionAnchor((KtExpression)expr2)));
            } else {
                this.processExpression(right2);
                KtControlFlowBuilder.addCall$default(this, (KtExpression)expr2, 2, false, 4, null);
            }
        }
    }

    private final boolean mayCompareByContent(DfType leftDfType, DfType rightDfType) {
        if (Intrinsics.areEqual((Object)leftDfType, (Object)DfTypes.NULL) || Intrinsics.areEqual((Object)rightDfType, (Object)DfTypes.NULL)) {
            return true;
        }
        if (leftDfType instanceof DfPrimitiveType || rightDfType instanceof DfPrimitiveType) {
            return true;
        }
        TypeConstraint typeConstraint = TypeConstraint.fromDfType((DfType)leftDfType);
        Intrinsics.checkNotNullExpressionValue((Object)typeConstraint, (String)"TypeConstraint.fromDfType(leftDfType)");
        TypeConstraint constraint = typeConstraint;
        if (constraint.isComparedByEquals() || constraint.isArray() || constraint.isEnum()) {
            return true;
        }
        if (!constraint.isExact()) {
            return false;
        }
        PsiClass psiClass2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)constraint.getPsiType(this.factory.getProject()));
        if (psiClass2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"PsiUtil.resolveClassInCl\u2026project)) ?: return false");
        PsiClass cls = psiClass2;
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature((String)"equals", (PsiType[])((PsiType[])new PsiClassType[]{TypeUtils.getObjectType((PsiElement)((PsiElement)this.context))}), (PsiTypeParameter[])new PsiTypeParameter[0], (PsiSubstitutor)PsiSubstitutor.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)methodSignature, (String)"MethodSignatureUtil.crea\u2026(), PsiSubstitutor.EMPTY)");
        MethodSignature equalsSignature = methodSignature;
        PsiMethod method = MethodSignatureUtil.findMethodBySignature((PsiClass)cls, (MethodSignature)equalsSignature, (boolean)true);
        PsiMethod psiMethod = method;
        return Intrinsics.areEqual((Object)(psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"java.lang.Object");
    }

    private final KotlinType balanceType(KotlinType leftType, KotlinType rightType2, boolean forceEqualityByContent) {
        return leftType == null || rightType2 == null ? null : (!forceEqualityByContent ? this.balanceType(leftType, rightType2) : (TypeUtilsKt.isSubtypeOf((KotlinType)leftType, (KotlinType)rightType2) ? rightType2 : (TypeUtilsKt.isSubtypeOf((KotlinType)rightType2, (KotlinType)leftType) ? leftType : null)));
    }

    private final KotlinType balanceType(KotlinType left, KotlinType right2) {
        if (left == null || right2 == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)left, (Object)right2)) {
            return left;
        }
        if (KtDfaHelpersKt.canBeNull(left) && !KtDfaHelpersKt.canBeNull(right2)) {
            return this.balanceType(TypeUtilsKt.makeNotNullable((KotlinType)left), right2);
        }
        if (!KtDfaHelpersKt.canBeNull(left) && KtDfaHelpersKt.canBeNull(right2)) {
            return this.balanceType(left, TypeUtilsKt.makeNotNullable((KotlinType)right2));
        }
        if (TypeUtilsKt.isDouble((KotlinType)left)) {
            return left;
        }
        if (TypeUtilsKt.isDouble((KotlinType)right2)) {
            return right2;
        }
        if (TypeUtilsKt.isFloat((KotlinType)left)) {
            return left;
        }
        if (TypeUtilsKt.isFloat((KotlinType)right2)) {
            return right2;
        }
        if (TypeUtilsKt.isLong((KotlinType)left)) {
            return left;
        }
        if (TypeUtilsKt.isLong((KotlinType)right2)) {
            return right2;
        }
        return null;
    }

    private final void addInstruction(Instruction inst) {
        this.flow.addInstruction(inst);
    }

    private final void setOffset(ControlFlow.DeferredOffset offset2) {
        offset2.setOffset(this.flow.getInstructionCount());
    }

    private final void processWhenExpression(KtWhenExpression expr2) {
        KtExpression subjectExpression = expr2.getSubjectExpression();
        DfaVariableValue dfVar = null;
        KotlinType kotlinType = null;
        if (subjectExpression == null) {
            dfVar = null;
            kotlinType = null;
        } else {
            this.processExpression(subjectExpression);
            KtProperty subjectVariable = expr2.getSubjectVariable();
            if (subjectVariable != null) {
                kotlinType = MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)subjectVariable);
                dfVar = this.factory.getVarFactory().createVariableValue((VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)subjectVariable));
            } else {
                kotlinType = KtDfaHelpersKt.getKotlinType(subjectExpression);
                dfVar = this.flow.createTempVariable(KtDfaHelpersKt.toDfType(kotlinType, (KtElement)expr2));
                this.addInstruction((Instruction)new JvmAssignmentInstruction(null, dfVar));
            }
            this.addInstruction((Instruction)new PopInstruction());
        }
        ControlFlow.DeferredOffset endOffset2 = new ControlFlow.DeferredOffset();
        Iterator iterator = expr2.getEntries().iterator();
        while (iterator.hasNext()) {
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = (KtWhenEntry)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"entry");
            if (ktWhenEntry.isElse()) {
                this.processExpression(entry.getExpression());
                this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
                continue;
            }
            ControlFlow.DeferredOffset branchStart = new ControlFlow.DeferredOffset();
            KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
            int n = ktWhenConditionArray.length;
            for (int j = 0; j < n; ++j) {
                KtWhenCondition condition2;
                KtWhenCondition ktWhenCondition = condition2 = ktWhenConditionArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenCondition, (String)"condition");
                this.processWhenCondition(dfVar, kotlinType, ktWhenCondition);
                this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)branchStart, (DfType)DfTypes.TRUE));
            }
            ControlFlow.DeferredOffset skipBranch = new ControlFlow.DeferredOffset();
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)skipBranch));
            this.setOffset(branchStart);
            this.processExpression(entry.getExpression());
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset2));
            this.setOffset(skipBranch);
        }
        this.pushUnknown();
        this.setOffset(endOffset2);
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)expr2));
    }

    private final void processWhenCondition(DfaVariableValue dfVar, KotlinType dfVarType, KtWhenCondition condition2) {
        KtWhenCondition ktWhenCondition = condition2;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            KotlinType exprType;
            KtExpression expr2 = ((KtWhenConditionWithExpression)condition2).getExpression();
            this.processExpression(expr2);
            KtExpression ktExpression = expr2;
            Object object = exprType = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
            if (dfVar != null) {
                KotlinType balancedType = this.balanceType(exprType, dfVarType, true);
                this.addImplicitConversion(expr2, exprType, balancedType);
                this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)dfVar, null));
                this.addImplicitConversion(null, dfVarType, balancedType);
                this.addInstruction((Instruction)new BooleanBinaryInstruction(RelationType.EQ, true, (DfaAnchor)new KotlinAnchor.KotlinWhenConditionAnchor(condition2)));
            } else {
                KotlinType kotlinType = exprType;
                if (kotlinType != null) {
                    if (KtDfaHelpersKt.canBeNull(kotlinType)) {
                        this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.UNBOX));
                    }
                }
            }
        } else if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            if (dfVar != null) {
                this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)dfVar, null));
                DfType type2 = this.getTypeCheckDfType(((KtWhenConditionIsPattern)condition2).getTypeReference());
                if (Intrinsics.areEqual((Object)type2, (Object)DfType.TOP)) {
                    this.pushUnknown();
                } else {
                    this.addInstruction((Instruction)new PushValueInstruction(type2));
                    if (((KtWhenConditionIsPattern)condition2).isNegated()) {
                        this.addInstruction((Instruction)new InstanceofInstruction(null, false));
                        this.addInstruction((Instruction)new NotInstruction((DfaAnchor)new KotlinAnchor.KotlinWhenConditionAnchor(condition2)));
                    } else {
                        this.addInstruction((Instruction)new InstanceofInstruction((DfaAnchor)new KotlinAnchor.KotlinWhenConditionAnchor(condition2), false));
                    }
                }
            } else {
                this.pushUnknown();
            }
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            if (dfVar != null) {
                this.addInstruction((Instruction)new JvmPushInstruction((DfaValue)dfVar, null));
            } else {
                this.pushUnknown();
            }
            this.processInCheck(dfVarType, ((KtWhenConditionInRange)condition2).getRangeExpression(), new KotlinAnchor.KotlinWhenConditionAnchor(condition2), ((KtWhenConditionInRange)condition2).isNegated());
        } else {
            this.broken = true;
        }
    }

    private final DfType getTypeCheckDfType(KtTypeReference typeReference2) {
        DfType dfType;
        if (typeReference2 == null) {
            DfType dfType2 = DfType.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"DfType.TOP");
            return dfType2;
        }
        KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)typeReference2, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)typeReference2), (BodyResolveMode)BodyResolveMode.FULL));
        DfType type2 = KtDfaHelpersKt.toDfType(kotlinType, (KtElement)typeReference2);
        if (type2 instanceof DfPrimitiveType) {
            KotlinType kotlinType2 = kotlinType;
            PsiType psiType = kotlinType2 != null ? KtDfaHelpersKt.toPsiType(kotlinType2, (KtElement)typeReference2) : null;
            if (!(psiType instanceof PsiPrimitiveType)) {
                psiType = null;
            }
            PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)psiType;
            PsiClassType boxedType = psiPrimitiveType != null ? psiPrimitiveType.getBoxedType((PsiElement)typeReference2) : null;
            DfType dfType3 = boxedType != null ? DfTypes.typedObject((PsiType)((PsiType)boxedType), (Nullability)Nullability.NOT_NULL) : DfType.TOP;
            dfType = dfType3;
            Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"if (boxedType != null) {\u2026 DfType.TOP\n            }");
        } else {
            dfType = type2;
        }
        return dfType;
    }

    private final void processIfExpression(KtIfExpression ifExpression2) {
        KtExpression condition2 = ifExpression2.getCondition();
        this.processExpression(condition2);
        KtExpression ktExpression = condition2;
        if (ktExpression != null && (ktExpression = KtDfaHelpersKt.getKotlinType(ktExpression)) != null) {
            if (KtDfaHelpersKt.canBeNull((KotlinType)ktExpression)) {
                this.addInstruction((Instruction)new UnwrapDerivedVariableInstruction((DerivedVariableDescriptor)SpecialField.UNBOX));
            }
        }
        ControlFlow.DeferredOffset skipThenOffset = new ControlFlow.DeferredOffset();
        KtExpression thenStatement = ifExpression2.getThen();
        KtExpression elseStatement = ifExpression2.getElse();
        KotlinType exprType = KtDfaHelpersKt.getKotlinType((KtExpression)ifExpression2);
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)skipThenOffset, (DfType)DfTypes.FALSE, (PsiElement)condition2));
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        this.processExpression(thenStatement);
        this.addImplicitConversion(thenStatement, exprType);
        ControlFlow.DeferredOffset skipElseOffset = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)skipElseOffset));
        this.setOffset(skipThenOffset);
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        this.processExpression(elseStatement);
        this.addImplicitConversion(elseStatement, exprType);
        this.setOffset(skipElseOffset);
        this.addInstruction((Instruction)new FinishElementInstruction((PsiElement)ifExpression2));
    }

    @NotNull
    public final DfaValueFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final KtExpression getContext() {
        return this.context;
    }

    public KtControlFlowBuilder(@NotNull DfaValueFactory factory2, @NotNull KtExpression context2) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.factory = factory2;
        this.context = context2;
        this.flow = new ControlFlow(this.factory, (PsiElement)this.context);
        this.trapTracker = new TrapTracker(this.factory, (PsiElement)this.context);
        PsiClassType psiClassType = PsiType.getJavaLangString((PsiManager)this.context.getManager(), (GlobalSearchScope)this.context.getResolveScope());
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"PsiType.getJavaLangStrin\u2026er, context.resolveScope)");
        this.stringType = psiClassType;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KtControlFlowBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.EQ, (IElementType)KtTokens.PLUSEQ, (IElementType)KtTokens.MINUSEQ, (IElementType)KtTokens.MULTEQ, (IElementType)KtTokens.DIVEQ, (IElementType)KtTokens.PERCEQ});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(KtTokens\u2026s.DIVEQ, KtTokens.PERCEQ)");
        ASSIGNMENT_TOKENS = tokenSet;
        unsupported = ConcurrentHashMap.newKeySet();
    }

    public static final /* synthetic */ void access$setOffset(KtControlFlowBuilder $this, ControlFlow.DeferredOffset offset2) {
        $this.setOffset(offset2);
    }

    public static final /* synthetic */ void access$pushUnknown(KtControlFlowBuilder $this) {
        $this.pushUnknown();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtControlFlowBuilder$KotlinCatchClauseDescriptor;", "Lcom/intellij/codeInspection/dataFlow/jvm/transfer/TryCatchTrap$CatchClauseDescriptor;", "clause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "(Lorg/jetbrains/kotlin/psi/KtCatchClause;)V", "getClause", "()Lorg/jetbrains/kotlin/psi/KtCatchClause;", "component1", "constraints", "", "Lcom/intellij/codeInspection/dataFlow/TypeConstraint;", "copy", "equals", "", "other", "", "hashCode", "", "parameter", "Lcom/intellij/codeInspection/dataFlow/value/VariableDescriptor;", "toString", "", "kotlin.idea"})
    public static final class KotlinCatchClauseDescriptor
    implements TryCatchTrap.CatchClauseDescriptor {
        @NotNull
        private final KtCatchClause clause;

        @Nullable
        public VariableDescriptor parameter() {
            KtParameter ktParameter = this.clause.getCatchParameter();
            if (ktParameter == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"clause.catchParameter ?: return null");
            KtParameter parameter = ktParameter;
            return (VariableDescriptor)new KtVariableDescriptor((KtCallableDeclaration)parameter);
        }

        @NotNull
        public List<TypeConstraint> constraints() {
            KtParameter ktParameter = this.clause.getCatchParameter();
            if (ktParameter == null) {
                boolean bl = false;
                return new ArrayList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"clause.catchParameter ?: return mutableListOf()");
            KtParameter parameter = ktParameter;
            Object[] objectArray = new TypeConstraint[1];
            TypeConstraint typeConstraint = TypeConstraint.fromDfType((DfType)KtDfaHelpersKt.toDfType(MoveKotlinMethodProcessorKt.type((KtNamedDeclaration)parameter), (KtElement)this.clause));
            Intrinsics.checkNotNullExpressionValue((Object)typeConstraint, (String)"TypeConstraint.fromDfTyp\u2026.type().toDfType(clause))");
            objectArray[0] = typeConstraint;
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }

        @NotNull
        public final KtCatchClause getClause() {
            return this.clause;
        }

        public KotlinCatchClauseDescriptor(@NotNull KtCatchClause clause) {
            Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
            this.clause = clause;
        }

        @NotNull
        public final KtCatchClause component1() {
            return this.clause;
        }

        @NotNull
        public final KotlinCatchClauseDescriptor copy(@NotNull KtCatchClause clause) {
            Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
            return new KotlinCatchClauseDescriptor(clause);
        }

        public static /* synthetic */ KotlinCatchClauseDescriptor copy$default(KotlinCatchClauseDescriptor kotlinCatchClauseDescriptor, KtCatchClause ktCatchClause, int n, Object object) {
            if ((n & 1) != 0) {
                ktCatchClause = kotlinCatchClauseDescriptor.clause;
            }
            return kotlinCatchClauseDescriptor.copy(ktCatchClause);
        }

        @NotNull
        public String toString() {
            return "KotlinCatchClauseDescriptor(clause=" + this.clause + ")";
        }

        public int hashCode() {
            KtCatchClause ktCatchClause = this.clause;
            return ktCatchClause != null ? ktCatchClause.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KotlinCatchClauseDescriptor)) break block3;
                    KotlinCatchClauseDescriptor kotlinCatchClauseDescriptor = (KotlinCatchClauseDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.clause, (Object)kotlinCatchClauseDescriptor.clause)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtControlFlowBuilder$Companion;", "", "()V", "ASSIGNMENT_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "unsupported", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

